/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.tasks;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.system.EntityWithParameterStorageContext;
import org.cyclos.entities.utils.EntityBackedParameterStorage;
import org.cyclos.entities.utils.QRecurringTaskExecution;
import org.cyclos.entities.utils.RecurringTaskExecution;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.RequestContext;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.system.InlineScriptBackgroundTask;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.system.ProfilingEntryType;
import org.cyclos.impl.system.ProfilingServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.AbstractTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.impl.utils.tasks.RecurringTask;
import org.cyclos.impl.utils.tasks.RecurringTaskHandlerImplementor;
import org.cyclos.model.messaging.ErrorLogType;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.RecurringTaskFirstExecution;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public abstract class AbstractRecurringTask
extends AbstractTask
implements RecurringTask {
    private static final Logger LOG = LogManager.getLogger(AbstractRecurringTask.class);
    private volatile boolean isRunning;
    @Autowired
    @Lazy
    private RecurringTaskHandlerImplementor recurringTaskHandler;
    @Autowired
    @Lazy
    private JacksonConfiguration jacksonConfiguration;
    @Autowired
    @Lazy
    private ApplicationHandler applicationHandler;
    @Autowired
    @Lazy
    protected BackgroundTaskHandler backgroundTaskHandler;
    @Autowired
    @Lazy
    private ProfilingServiceLocal profilingService;

    public RecurringTaskFirstExecution getFirstExecution() {
        return RecurringTaskFirstExecution.RANDOM;
    }

    public String getNotesForLogging() {
        return "";
    }

    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.EVERY_HOUR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        if (this.isRunning) {
            LOG.debug("Ignoring run request for '{}'. It's already running", (Object)this);
        } else {
            if (this.applicationHandler.isShuttingDown()) {
                return;
            }
            this.isRunning = true;
            try {
                ProfilingEntry profilingEntry;
                LOG.debug("Running recurring task '{}'", (Object)this);
                try {
                    this.recurringTaskHandler.onTaskStarted((RecurringTask)this);
                }
                catch (Exception exception) {
                    LOG.warn("Error updating the RecurringTaskExecution for '{}'", (Object)this.getClass().getName(), (Object)exception);
                }
                RequestContext requestContext = RequestContext.ensure();
                Pair pair = this.profilingService.newIfEnabled(ProfilingEntryType.BUILTIN_RECURRING_TASK, null);
                ProfilingEntry profilingEntry2 = profilingEntry = pair == null ? null : (ProfilingEntry)pair.getSecond();
                if (profilingEntry != null) {
                    profilingEntry.setName(this.getName());
                    profilingEntry.setTaskClassName(this.getClass().getName());
                }
                requestContext.setProfiling(pair);
                try {
                    this.doRun();
                }
                finally {
                    if (profilingEntry != null) {
                        this.profilingService.collect(profilingEntry, null);
                    }
                    RequestContext.remove();
                }
            }
            finally {
                this.isRunning = false;
                try {
                    this.recurringTaskHandler.onTaskFinished((RecurringTask)this);
                }
                catch (Exception exception) {
                    LOG.warn("Error updating the RecurringTaskExecution for '{}'", (Object)this.getClass().getName(), (Object)exception);
                }
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    protected void awakeMeAfter(TimeInterval timeInterval) {
        this.invokerHandler.runAsInCurrentOrNewTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            String string = String.format("recurringTaskHandler.scheduleAwake(%s)", this.getClass().getName());
            return this.backgroundTaskHandler.schedule((BackgroundTaskScheduling)InlineScriptBackgroundTask.scheduling(string).startAfter(DateHelper.add((Date)new Date(), (ITimeInterval)timeInterval)));
        });
    }

    protected abstract void doRun();

    @Override
    protected ErrorLogType getErrorLogType() {
        return ErrorLogType.RECURRING_TASK;
    }

    protected EntityBackedParameterStorage getStorage() {
        QRecurringTaskExecution qRecurringTaskExecution = QRecurringTaskExecution.recurringTaskExecution;
        RecurringTaskExecution recurringTaskExecution = (RecurringTaskExecution)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qRecurringTaskExecution}).where((Predicate)qRecurringTaskExecution.className.eq((Object)this.getClass().getName()))).requiredUniqueResult((Expression)qRecurringTaskExecution);
        return new EntityBackedParameterStorage(this.jacksonConfiguration.getObjectMapper(), (EntityWithParameterStorageContext)recurringTaskExecution);
    }

    @Override
    protected boolean isVerbose() {
        return ObjectHelper.isNotOneOf((Object)this.getRecurrence(), (Object[])new Object[]{RecurringTaskRecurrence.EVERY_DAY, RecurringTaskRecurrence.NEXT_DAY});
    }

    @Override
    protected String logName(String string) {
        return this.getName();
    }
}

