/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.sms;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.system.SmsOperationConfiguration;
import org.cyclos.entities.system.WithPasswordSmsOperationConfiguration;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.impl.banking.PaymentRequestServiceLocal;
import org.cyclos.impl.utils.sms.BaseSmsOperation;
import org.cyclos.impl.utils.sms.InboundSmsData;
import org.cyclos.impl.utils.sms.SmsOperationException;
import org.cyclos.impl.utils.sms.SmsParameterProcessor;
import org.cyclos.model.ValidationException;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.transactions.PaymentRequestActionDTO;
import org.cyclos.model.banking.transactions.PaymentRequestVO;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.security.Security;
import org.cyclos.services.banking.PaymentRequestService;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class DenyPaymentRequestSmsOperation
extends BaseSmsOperation {
    private static final Logger LOG = LogManager.getLogger(DenyPaymentRequestSmsOperation.class);
    @Autowired
    @Security
    private PaymentRequestService paymentRequestService;
    @Autowired
    private PaymentRequestServiceLocal paymentRequestServiceLocal;

    @Override
    protected void checkParametersCount(SmsOperationConfiguration smsOperationConfiguration, List<String> list) throws SmsOperationException {
        int n;
        WithPasswordSmsOperationConfiguration withPasswordSmsOperationConfiguration = (WithPasswordSmsOperationConfiguration)smsOperationConfiguration;
        boolean bl = withPasswordSmsOperationConfiguration.isUsePassword();
        int n2 = n = bl ? 2 : 1;
        if (CollectionHelper.size(list) < n) {
            throw new SmsOperationException((Object)BaseSmsOperation.BaseError.INVALID_PARAMETERS_COUNT.getMessageKey(), new Object[]{n, n});
        }
    }

    @Override
    protected void doExecute(SmsOperationConfiguration smsOperationConfiguration, MobilePhone mobilePhone, InboundSmsData inboundSmsData, SmsParameterProcessor smsParameterProcessor) throws SmsOperationException {
        LOG.debug(String.format("Executing SMS Deny payment request operation (user: %1$s, sms: %2$s)", mobilePhone.getUser().getUsername(), inboundSmsData));
        PaymentRequestActionDTO paymentRequestActionDTO = new PaymentRequestActionDTO();
        String string = smsParameterProcessor.nextString((Object)MessagingKeys.Notifications.SMS_DENY_PAYMENT_REQUEST_PARAMETER_REQUEST_NUMBER).toUpperCase();
        PaymentRequest paymentRequest = this.paymentRequestServiceLocal.getBySmsCode(string, mobilePhone.getUser().getUser());
        if (paymentRequest == null) {
            String string2 = this.message(BankingKeys.Transactions.PAYMENT_REQUEST_SMS_CODE_NOT_FOUND, string);
            throw new ValidationException(string2);
        }
        paymentRequestActionDTO.setPaymentRequest(new PaymentRequestVO(paymentRequest.getId()));
        this.paymentRequestService.deny(paymentRequestActionDTO);
        this.sendResponse(mobilePhone, this.message(MessagingKeys.Notifications.SMS_DENY_PAYMENT_REQUEST_RESPONSE, string));
    }

    @Override
    protected List<String> getHelpComponents(SmsOperationConfiguration smsOperationConfiguration) {
        WithPasswordSmsOperationConfiguration withPasswordSmsOperationConfiguration = (WithPasswordSmsOperationConfiguration)smsOperationConfiguration;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (withPasswordSmsOperationConfiguration.isUsePassword()) {
            PasswordType passwordType = smsOperationConfiguration.getChannelConfiguration().getAccessPassword();
            arrayList.add(this.dataTranslationHandler.getName((NamedEntity)passwordType));
        }
        arrayList.add(this.message(MessagingKeys.Notifications.SMS_DENY_PAYMENT_REQUEST_PARAMETER_REQUEST_NUMBER, new Object[0]));
        return arrayList;
    }
}

