/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.notifications;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.sun.mail.smtp.SMTPTransport;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.ConnectionAdapter;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.contentmanagement.EmailTemplate;
import org.cyclos.entities.contentmanagement.HasContentScript;
import org.cyclos.entities.messaging.MailContext;
import org.cyclos.entities.messaging.MailContextPriority;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.SmtpConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.messaging.NotificationSettingsServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.UserVariablesFunction;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.notifications.ApplyMailTemplateParams;
import org.cyclos.impl.utils.notifications.MailContent;
import org.cyclos.impl.utils.notifications.MailContentProducer;
import org.cyclos.impl.utils.notifications.MailHandlerImplementor;
import org.cyclos.impl.utils.notifications.MailProcessingBackgroundTask;
import org.cyclos.impl.utils.notifications.MailProcessingContext;
import org.cyclos.impl.utils.notifications.MailTemplateVariable;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.ValidationException;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.messaging.EmailSendingException;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.system.configurations.ConfigurationDTO;
import org.cyclos.model.system.configurations.SmtpSecurity;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.ParameterVO;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MutableObject;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailHandlerImpl
extends BaseNetworkedHandlerImpl
implements MailHandlerImplementor {
    private static final String MAIL_ALLOW_UTF8 = "mail.mime.allowutf8";
    private static final String MESSAGE_VAR = "{message}";
    private static final String TIMEOUT = "15000";
    private static final TimeInterval DELAY = new TimeInterval(Integer.valueOf(40), TimeField.MINUTES).freeze();
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;
    @Autowired
    private RichTextHandler richTextHandler;
    @Autowired
    private AlertServiceLocal alertService;
    @Autowired
    private JacksonConfiguration jacksonConfiguration;
    private Cache<Long, JavaMailSender> cache;
    @Autowired
    @Lazy
    private NotificationSettingsServiceLocal notificationSettingsService;

    private static InternetAddress addressOf(String string, String string2) {
        try {
            return new InternetAddress(string, string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String applyTemplate(ApplyMailTemplateParams applyMailTemplateParams) {
        return this.doApplyTemplate(applyMailTemplateParams);
    }

    public MailProcessingContext createMailProcessingContext(String string, String string2, String string3, String string4, ConfigurationAccessor configurationAccessor, FileInfo ... fileInfoArray) {
        String string5 = configurationAccessor.getEmailName();
        String string6 = configurationAccessor.getSmtpConfiguration().getFromAddress();
        return this.createMailProcessingContext(string5, string6, string, string2, string3, true, string4, null, null, configurationAccessor.getConfiguration(), this.getSessionData().getNetwork(), fileInfoArray);
    }

    public JavaMailSender getMailSender() {
        return this.getMailSender(this.getConfiguration());
    }

    public JavaMailSender getMailSender(Configuration configuration) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(configuration);
        return this.getMailSender(configurationAccessor);
    }

    public JavaMailSender getMailSender(ConfigurationAccessor configurationAccessor) {
        Configuration configuration = configurationAccessor.getConfigurationFor(ConfigurationDTO.SMTP_CONFIGURATION.getName());
        if (configuration == null) {
            return null;
        }
        JavaMailSender javaMailSender = (JavaMailSender)this.cache.get((Serializable)configuration.getId(), () -> this.doCreateMailSender(configurationAccessor));
        return javaMailSender;
    }

    public List<ParameterVO> getMailTemplateVariables() {
        return Stream.of(MailTemplateVariable.values()).map(mailTemplateVariable -> mailTemplateVariable.toParameter(this.translationHandler)).collect(Collectors.toList());
    }

    public MailProcessingContext preview(BasicUser basicUser, BasicUser basicUser2, MailContext mailContext, MailContentProducer mailContentProducer, FileInfo ... fileInfoArray) {
        return this.createMailProcessingContext(basicUser, basicUser2, mailContext, mailContentProducer, fileInfoArray);
    }

    public void send(BasicUser basicUser, BasicUser basicUser2, MailContext mailContext, MailContentProducer mailContentProducer, FileInfo ... fileInfoArray) {
        MailProcessingContext mailProcessingContext = this.createMailProcessingContext(basicUser, basicUser2, mailContext, mailContentProducer, fileInfoArray);
        MailContextPriority mailContextPriority = mailContext.getPriority();
        JavaMailSender javaMailSender = mailContextPriority == MailContextPriority.BACKGROUND ? null : (basicUser2 == null ? this.getMailSender() : this.getMailSender(this.configurationHandler.getAccessAccessor(basicUser2)));
        switch (mailContextPriority) {
            case SAME_TRANSACTION: {
                InvocationContext.ensure().addBeforeEndListener(() -> {
                    boolean bl = this.doSend(mailProcessingContext, javaMailSender);
                    if (!bl) {
                        throw new EmailSendingException();
                    }
                });
                break;
            }
            case CONCURRENT: {
                InvocationContext.ensure().addCommitListener(true, () -> this.invokerHandler.getExecutorService().submit(() -> {
                    boolean bl = this.doSend(mailProcessingContext, javaMailSender);
                    if (!bl) {
                        this.createBackgroundTask(mailProcessingContext, true);
                    }
                }));
                break;
            }
            case BACKGROUND: {
                this.createBackgroundTask(mailProcessingContext);
                break;
            }
            case IMMEDIATE: {
                boolean bl = this.doSend(mailProcessingContext, javaMailSender);
                if (bl) break;
                throw new EmailSendingException();
            }
        }
    }

    public void send(String string, String string2, String string3, String string4, FileInfo ... fileInfoArray) {
        ConfigurationAccessor configurationAccessor = this.getConfiguration();
        String string5 = configurationAccessor.getEmailName();
        String string6 = configurationAccessor.getSmtpConfiguration().getFromAddress();
        MailProcessingContext mailProcessingContext = this.createMailProcessingContext(string5, string6, string, string2, string3, true, string4, null, null, configurationAccessor.getConfiguration(), this.getSessionData().getNetwork(), fileInfoArray);
        this.createBackgroundTask(mailProcessingContext);
    }

    @Override
    public boolean sendNow(MailProcessingContext mailProcessingContext, JavaMailSender javaMailSender) {
        boolean bl = this.doSend(mailProcessingContext, javaMailSender);
        this.sleep();
        return bl;
    }

    protected final void createBackgroundTask(MailProcessingContext mailProcessingContext) {
        this.createBackgroundTask(mailProcessingContext, false);
    }

    protected void createBackgroundTask(MailProcessingContext mailProcessingContext, boolean bl) {
        if (mailProcessingContext != null) {
            CollectionHelper.orEmpty((List)mailProcessingContext.getAttachments()).forEach(fileInfo -> {
                try {
                    if (fileInfo.getContent().available() == 0) {
                        fileInfo.getContent().reOpen();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            try {
                this.backgroundTaskHandler.schedule((BackgroundTaskScheduling)MailProcessingBackgroundTask.scheduling(this.jacksonConfiguration.getObjectMapper(), mailProcessingContext).startAfter(bl ? DateHelper.add((Date)new Date(), (ITimeInterval)DELAY) : null));
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new IllegalStateException(jsonProcessingException);
            }
        }
    }

    protected MailProcessingContext createMailProcessingContext(BasicUser basicUser, BasicUser basicUser2, MailContext mailContext, MailContentProducer mailContentProducer, FileInfo ... fileInfoArray) {
        if (this.cyclosProperties.isSkipEmails()) {
            return null;
        }
        return (MailProcessingContext)this.invokerHandler.runAs(UserVariablesFunction.isPreview() ? this.getSessionData() : SessionDataFactory.user((BasicUser)basicUser2), () -> {
            Function function = this.profileFieldHandler.getUserVariablesFunction(basicUser2);
            MailContent mailContent = mailContentProducer.mailContent();
            String string = StringHelper.replaceVariables((String)mailContent.getSubject(), (Function)function);
            String string2 = mailContext == MailContext.NEW_EMAIL_VALIDATION ? basicUser2.getNewEmail() : basicUser2.getEmail();
            ApplyMailTemplateParams applyMailTemplateParams = new ApplyMailTemplateParams();
            applyMailTemplateParams.setSubject(string);
            applyMailTemplateParams.setMessage(mailContent.getBody());
            applyMailTemplateParams.setEmail(string2);
            applyMailTemplateParams.setTo(basicUser2);
            applyMailTemplateParams.setUnsubscribeType(mailContext == null ? null : mailContext.unsubscribeType());
            String string3 = this.doApplyTemplate(applyMailTemplateParams);
            String string4 = basicUser2.getName();
            Network network = basicUser2.getNetwork();
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser2);
            String string5 = configurationAccessor.getEmailName();
            String string6 = configurationAccessor.getSmtpConfiguration().getFromAddress();
            Configuration configuration = configurationAccessor.getConfiguration();
            String string7 = null;
            String string8 = null;
            if (!UserVariablesFunction.isPreview() && applyMailTemplateParams.getUnsubscribeType() != null) {
                string7 = this.notificationSettingsService.keyForEmailUnsubscribe(basicUser2, applyMailTemplateParams.getUnsubscribeType());
                string8 = configurationAccessor.getApiUrl();
            }
            return this.createMailProcessingContext(string5, string6, string4, string2, string, false, string3, string7, string8, configuration, network, fileInfoArray);
        });
    }

    private Boolean allowUtf8(JavaMailSenderImpl javaMailSenderImpl) {
        String string = (String)javaMailSenderImpl.getJavaMailProperties().get(MAIL_ALLOW_UTF8);
        return string == null ? null : Boolean.valueOf(string);
    }

    private MailProcessingContext createMailProcessingContext(String string, String string2, String string3, String string4, String string5, boolean bl, String string6, String string7, String string8, Configuration configuration, Network network, FileInfo ... fileInfoArray) {
        String string9;
        ApplyMailTemplateParams applyMailTemplateParams;
        if (this.cyclosProperties.isSkipEmails() || StringHelper.isBlank((Object)string2) || StringHelper.isBlank((Object)string5) || StringHelper.isBlank((Object)string4)) {
            return null;
        }
        if (bl) {
            applyMailTemplateParams = new ApplyMailTemplateParams();
            applyMailTemplateParams.setSubject(string5);
            applyMailTemplateParams.setMessage(string6);
            applyMailTemplateParams.setEmail(string4);
            string9 = this.doApplyTemplate(applyMailTemplateParams);
        } else {
            string9 = string6;
        }
        applyMailTemplateParams = new MailProcessingContext();
        applyMailTemplateParams.setFromName(string);
        applyMailTemplateParams.setFromEmail(string2);
        applyMailTemplateParams.setToName(string3);
        applyMailTemplateParams.setToEmail(string4);
        applyMailTemplateParams.setSubject(string5);
        applyMailTemplateParams.setBody(string9);
        applyMailTemplateParams.setConfigurationId(configuration.getId());
        applyMailTemplateParams.setNetworkId(SimpleEntity.id((SimpleEntity)network));
        applyMailTemplateParams.setKeyForEmailUnsubscribe(string7);
        applyMailTemplateParams.setApiUrl(string8);
        if (CollectionHelper.isNotEmpty((Object[])fileInfoArray)) {
            applyMailTemplateParams.setAttachments(Arrays.asList(fileInfoArray));
        }
        return applyMailTemplateParams;
    }

    private String doApplyTemplate(ApplyMailTemplateParams applyMailTemplateParams) {
        BasicUser basicUser = applyMailTemplateParams.getTo();
        return (String)this.invokerHandler.runAs(basicUser != null ? SessionDataFactory.user((BasicUser)basicUser) : this.getSessionData(), () -> {
            this.fillMissingFields(applyMailTemplateParams);
            return this.richTextHandler.newContentAccessor((HasContentScript)applyMailTemplateParams.getConfiguration().getEmailTemplate()).setUser(basicUser).setVariablesFunction(this.variablesFunction(applyMailTemplateParams)).process(applyMailTemplateParams.getTemplate());
        });
    }

    private JavaMailSenderImpl doCreateMailSender(final ConfigurationAccessor configurationAccessor) throws MessagingException {
        SmtpSecurity smtpSecurity;
        SmtpConfiguration smtpConfiguration = configurationAccessor.getSmtpConfiguration();
        String string = smtpConfiguration.getHost();
        if (StringHelper.isBlank((Object)string)) {
            throw new ValidationException(this.message(ContentManagementKeys.Emails.ERROR_SENDING, new Object[0]));
        }
        final MutableObject mutableObject = new MutableObject((Object)false);
        JavaMailSenderImpl javaMailSenderImpl = new JavaMailSenderImpl(){

            protected Transport getTransport(Session session) throws NoSuchProviderException {
                final Transport transport = super.getTransport(session);
                if (transport instanceof SMTPTransport) {
                    final Boolean bl = MailHandlerImpl.this.allowUtf8(this);
                    ConnectionAdapter connectionAdapter = new ConnectionAdapter(){

                        public void opened(ConnectionEvent connectionEvent) {
                            mutableObject.set((Object)((SMTPTransport)transport).supportsExtension("SMTPUTF8"));
                            if (bl != null && bl ^ (Boolean)mutableObject.get()) {
                                MailHandlerImpl.this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                                    MailHandlerImpl.this.cacheHandler.scheduleEvict(CacheType.MAIL_SENDERS, (Serializable)configurationAccessor.getConfiguration().getId());
                                    return null;
                                });
                            }
                            transport.removeConnectionListener((ConnectionListener)this);
                        }
                    };
                    transport.addConnectionListener((ConnectionListener)connectionAdapter);
                }
                return transport;
            }
        };
        String string2 = smtpConfiguration.getUser();
        javaMailSenderImpl.setHost(string);
        javaMailSenderImpl.setPort(smtpConfiguration.getPort().intValue());
        javaMailSenderImpl.setDefaultEncoding("UTF-8");
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.connectiontimeout", TIMEOUT);
        properties.setProperty("mail.smtp.timeout", TIMEOUT);
        properties.setProperty("mail.smtp.writetimeout", TIMEOUT);
        if (StringHelper.isNotBlank((Object)string2)) {
            properties.setProperty("mail.smtp.auth", "true");
            javaMailSenderImpl.setUsername(string2);
            javaMailSenderImpl.setPassword(smtpConfiguration.getPassword());
        }
        if ((smtpSecurity = smtpConfiguration.getSecurity()) == SmtpSecurity.STARTTLS) {
            properties.setProperty("mail.smtp.starttls.enable", "true");
        } else if (smtpSecurity == SmtpSecurity.SSL) {
            properties.setProperty("mail.smtp.ssl.enable", "true");
        }
        properties.setProperty("mail.smtp.ssl.trust", "*");
        javaMailSenderImpl.setJavaMailProperties(properties);
        try {
            javaMailSenderImpl.testConnection();
        }
        catch (Exception exception) {
            mutableObject.set((Object)false);
        }
        properties.setProperty(MAIL_ALLOW_UTF8, ((Boolean)mutableObject.get()).toString());
        javaMailSenderImpl.setJavaMailProperties(properties);
        return javaMailSenderImpl;
    }

    private boolean doSend(MailProcessingContext mailProcessingContext, JavaMailSender javaMailSender) {
        String string = mailProcessingContext.getSubject();
        String string2 = mailProcessingContext.getFromEmail();
        String string3 = mailProcessingContext.getToEmail();
        boolean bl = CollectionHelper.isNotEmpty((Iterable)mailProcessingContext.getAttachments());
        try {
            MimeMessage mimeMessage = javaMailSender.createMimeMessage();
            String string4 = this.getUnsubscribeListOneClick(mailProcessingContext);
            if (StringHelper.isNotBlank((Object)string4)) {
                mimeMessage.setHeader("List-Unsubscribe", string4);
                mimeMessage.setHeader("List-Unsubscribe-Post", "List-Unsubscribe=One-Click");
            }
            MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, bl, "UTF-8");
            mimeMessageHelper.setFrom(MailHandlerImpl.addressOf(string2, mailProcessingContext.getFromName()));
            mimeMessageHelper.setTo(MailHandlerImpl.addressOf(string3, mailProcessingContext.getToName()));
            mimeMessageHelper.setSubject(string);
            Object object = mailProcessingContext.getBody();
            if (!StringUtils.containsIgnoreCase((CharSequence)object, (CharSequence)"<html")) {
                object = "<!DOCTYPE html><html><head><title>" + string + "</title></head><body>" + (String)object + "</body></html>";
            }
            mimeMessageHelper.setText((String)object, true);
            if (bl) {
                mailProcessingContext.getAttachments().forEach(fileInfo -> {
                    try {
                        mimeMessageHelper.addAttachment(fileInfo.getName(), () -> ((FileInfo)fileInfo).getContent(), fileInfo.getContentType());
                    }
                    catch (Exception exception) {
                        throw new EmailSendingException("Couldn't attach file " + fileInfo.getName() + " to e-mail", (Throwable)exception);
                    }
                });
            }
            javaMailSender.send(mimeMessageHelper.getMimeMessage());
            return true;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder("Error sending e-mail");
            stringBuilder.append(", from: ").append(string2);
            stringBuilder.append(", to: ").append(string3);
            stringBuilder.append(", subject: ").append(string);
            this.getLogger().error(stringBuilder.toString(), (Throwable)exception);
            this.invokerHandler.submitAsInParallelTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                Network network = mailProcessingContext.getNetworkId() == null ? null : this.find(Network.class, mailProcessingContext.getNetworkId());
                this.invokerHandler.runAs(SessionDataFactory.system((Network)network), () -> this.alertService.create(SystemAlertType.EMAIL_SENDING_FAILED, new Object[]{string3, string}));
            });
            return false;
        }
    }

    private void fillMissingFields(ApplyMailTemplateParams applyMailTemplateParams) {
        String string;
        BasicUser basicUser = applyMailTemplateParams.getTo();
        if (applyMailTemplateParams.getConfiguration() == null) {
            applyMailTemplateParams.setConfiguration(this.getConfiguration());
        }
        if (StringHelper.isBlank((Object)(string = applyMailTemplateParams.getEmail())) && basicUser != null) {
            string = basicUser.getEmail();
        }
        if (applyMailTemplateParams.getTemplate() == null) {
            EmailTemplate emailTemplate = applyMailTemplateParams.getConfiguration().getEmailTemplate();
            applyMailTemplateParams.setTemplate(emailTemplate == null ? null : emailTemplate.getContent());
        }
        if (StringHelper.isBlank((Object)applyMailTemplateParams.getTemplate())) {
            applyMailTemplateParams.setTemplate(MESSAGE_VAR);
        } else if (!applyMailTemplateParams.getTemplate().contains(MESSAGE_VAR)) {
            this.getLogger().warn("E-mail template for configuration {} doesn't include the {} placeholder for the e-mail body. Appending the message on the end of the template.", (Object)applyMailTemplateParams.getConfiguration().getConfiguration().getName(), (Object)MESSAGE_VAR);
            applyMailTemplateParams.setTemplate(applyMailTemplateParams.getTemplate() + MESSAGE_VAR);
        }
    }

    private String getUnsubscribeListOneClick(MailProcessingContext mailProcessingContext) {
        if (StringHelper.isBlank((Object)mailProcessingContext.getKeyForEmailUnsubscribe())) {
            return null;
        }
        return String.format("<%s/email-unsubscribe/%s>", mailProcessingContext.getApiUrl(), mailProcessingContext.getKeyForEmailUnsubscribe());
    }

    @PostConstruct
    private void initialize() {
        this.cache = this.cacheHandler.getCache(CacheType.MAIL_SENDERS);
    }

    private void sleep() {
        int n = this.cyclosProperties.getMailSleepSeconds();
        if (n > 0) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private Function<String, Object> variablesFunction(ApplyMailTemplateParams applyMailTemplateParams) {
        return string -> {
            MailTemplateVariable mailTemplateVariable = MailTemplateVariable.variable((String)string);
            if (mailTemplateVariable != null) {
                switch (mailTemplateVariable) {
                    case SALUTATION: {
                        return StringHelper.replacePeriod((String)this.translationHandler.message(MessageFormat.HTML, applyMailTemplateParams.getTo() == null ? ContentManagementKeys.Emails.SALUTATION_ANONYMOUS : ContentManagementKeys.Emails.SALUTATION_USER, new Object[]{applyMailTemplateParams.getTo()}));
                    }
                    case UNSUBSCRIBE: {
                        if (applyMailTemplateParams.getUnsubscribeType() != null) {
                            String string2 = this.linkGeneratorHandler.emailUnsubscribe(applyMailTemplateParams.getUnsubscribeType(), applyMailTemplateParams.getTo());
                            return this.translationHandler.message(MessageFormat.HTML, ContentManagementKeys.Emails.UNSUBSCRIBE, new Object[]{string2});
                        }
                        return "";
                    }
                    case SENT_TO: {
                        return this.translationHandler.message(MessageFormat.HTML, ContentManagementKeys.Emails.SENT_TO, new Object[]{applyMailTemplateParams.getEmail()});
                    }
                    case NO_REPLY: {
                        return this.translationHandler.message(MessageFormat.HTML, ContentManagementKeys.Emails.NO_REPLY, new Object[]{applyMailTemplateParams.getConfiguration().getFullUrl()});
                    }
                    case SUBJECT: {
                        return applyMailTemplateParams.getSubject();
                    }
                    case MESSAGE: {
                        return applyMailTemplateParams.getMessage();
                    }
                    case EMAIL: {
                        return applyMailTemplateParams.getEmail();
                    }
                }
            }
            return null;
        };
    }
}

