/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cluster;

import com.google.common.cache.Cache;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MemberSelector;
import com.hazelcast.collection.IQueue;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.GcpConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.KubernetesConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.UrlXmlConfig;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.scheduledexecutor.DuplicateTaskException;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.scheduledexecutor.IScheduledFuture;
import com.hazelcast.scheduledexecutor.NamedTask;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.CyclosVersion;
import org.cyclos.bootstrap.CyclosPropertiesFactoryBean;
import org.cyclos.impl.ApplicationInitializationListener;
import org.cyclos.impl.ApplicationUpgradeInitializationListener;
import org.cyclos.impl.BaseApplicationInitializationListener;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.sql.DbLock;
import org.cyclos.impl.sql.DbLockHandler;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.ScriptHelper;
import org.cyclos.impl.system.SystemMonitorServiceLocal;
import org.cyclos.impl.utils.AbstractPushNotificationHandlerImpl;
import org.cyclos.impl.utils.BaseProfilingManagerImpl;
import org.cyclos.impl.utils.PushNotificationEventContext;
import org.cyclos.impl.utils.PushNotificationHandler;
import org.cyclos.impl.utils.PushNotificationHandlerImplementor;
import org.cyclos.impl.utils.PushNotificationSubscriptionMatcher;
import org.cyclos.impl.utils.ReplicatedStorage;
import org.cyclos.impl.utils.SerializableRunnable;
import org.cyclos.impl.utils.SharedStorage;
import org.cyclos.impl.utils.cache.CacheHandlerImplementor;
import org.cyclos.impl.utils.cache.CacheOperation;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.cache.GuavaCacheHandlerImpl;
import org.cyclos.impl.utils.cluster.AbstractClusterHandlerImpl;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.cluster.ClusterHostProfilingResult;
import org.cyclos.impl.utils.cluster.ClusterHostProfilingStats;
import org.cyclos.impl.utils.cluster.HazelcastSharedStorage;
import org.cyclos.impl.utils.cluster.MemberRunningTaskDescriptor;
import org.cyclos.impl.utils.cluster.ProfilingManager;
import org.cyclos.impl.utils.cluster.PushNotificationSubscription;
import org.cyclos.impl.utils.cluster.ReplicatedStorageType;
import org.cyclos.impl.utils.cluster.SharedStorageType;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.tasks.AbstractRecurringTaskHandlerImpl;
import org.cyclos.impl.utils.tasks.BackgroundTaskExecutionContext;
import org.cyclos.impl.utils.tasks.BackgroundTaskExecutionKey;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandlerImplementor;
import org.cyclos.impl.utils.tasks.RecurringTask;
import org.cyclos.impl.utils.tasks.RecurringTaskHandlerImplementor;
import org.cyclos.impl.utils.tasks.RunningTaskDescriptor;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.monitor.CacheQuery;
import org.cyclos.model.system.monitor.ClusterMemberData;
import org.cyclos.model.system.monitor.ServerData;
import org.cyclos.model.system.profiling.StartProfilingParams;
import org.cyclos.model.utils.CacheStatsVO;
import org.cyclos.model.utils.CacheVO;
import org.cyclos.model.utils.PushNotificationEvent;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.ExceptionHelper;
import org.cyclos.server.utils.XmlHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MutableObject;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class HazelcastClusterHandlerImpl
extends AbstractClusterHandlerImpl {
    private static DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final Logger LOG = LogManager.getLogger(HazelcastClusterHandlerImpl.class);
    private static final int RECURRING_TASK_MONITOR_INITIAL_DELAY_SEC = 1;
    private static final int RECURRING_TASK_MONITOR_PERIOD_SEC = 1;
    private static final String APPLICATION_CONTEXT_KEY = "applicationContext";
    private static final String CAN_RUN_RECURRING_TASKS_ATTR = "canRunRecurringTasks";
    private static final String BACKGROUND_TASK_THREADS_ATTR = "backgroundTaskThreads";
    private static final String STARTUP_TIME_ATTR = "startupTime";
    private static final String CYCLOS_VERSION_ATTR = "cyclosVersion";
    private static final String COMMIT_ID_ATTR = "commitId";
    private static final String RECURRING_TASK_SCHEDULED_EXECUTOR = "recurringTaskScheduledExecutor";
    private static final String BACKGROUND_TASK_QUEUE = "backgroundTaskQueue";
    private static final String SYSTEM_MONITOR_EXECUTOR = "systemMonitorExecutor";
    private static final String SHARED_STORAGE_PREFIX = "cyclos.map.sharedStorage.";
    private static final String REPLICATED_STORAGE_PREFIX = "cyclos.map.replicatedStorage.";
    private static final String CACHE_EVICT_TOPIC = "cyclos.topic.cacheEvict";
    private static final String REMOVE_BACKGROUND_EXECUTIONS_MAP = "cyclos.map.removeBackgroundExecutionsMap";
    private static final String BACKGROUND_EXECUTION_LOCKS_MAP = "cyclos.map.backgroundExecutionLocksMap";
    private static final String INITIALIZATIONS_MAP = "cyclos.map.initializations";
    private static final String AWAKE_RECURRING_TASKS_MAP = "cyclos.map.awakeRecurringTasks";
    private static final String DATABASE_LOCKED_KEY = "isRunning";
    private static final String SCHEDULED_TASKS_KEY = "scheduledTasks";
    private static final String KEEP_ALIVE_TASK = "keepAliveTask";
    private static final String SHUTDOWN = "shutdown";
    private static final String SUBSCRIPTIONS_BY_ID_MAP = "cyclos.map.subscriptionsById";
    private static final String USER_ID_BY_CLIENT_ID_MAP = "cyclos.map.userIdByClientId";
    private static final String CLOSE_AFTER_BY_ID_MAP = "cyclos.map.closeAfterById";
    private static final String MISSED_EVENTS_BY_ID_MULTIMAP = "cyclos.multimap.missedEventsById";
    private static final String PROFILING_REPLICATEDMAP = "cyclos.map.profiling";
    private static final String MEMBERS_BY_ID_MAP = "cyclos.map.membersById";
    private static final String PUSH_NOTIFICATIONS_EXECUTOR = "cyclos.executor.pushNotifications";
    private static final int PUSH_MAPS_MAX_IDLE_SECONDS = 3600;
    private HazelcastInstance instance;
    private Member member;
    private String configXml;
    private IMap<String, Boolean> initializationsMap;
    private IMap<Long, Integer> removeBackgroundExecutionsMap;
    private IMap<BackgroundTaskExecutionKey, Integer> backgroundExecutionLocksMap;
    private IQueue<BackgroundTaskExecutionContext> backgroundTaskQueue;
    private IExecutorService executorService;
    private ITopic<TreeMap<CacheType<? extends Serializable, ?>, CacheOperation>> cacheEvictTopic;
    private IMap<String, PushNotificationSubscription> subscriptionsById;
    private IMap<String, Long> userIdByClientId;
    private IMap<String, Long> closeAfterById;
    private MultiMap<String, PushNotificationEvent<?>> missedEventsById;
    private IMap<String, Member> membersById;
    private ReplicatedMap<String, Object> profilingMap;
    private IExecutorService pushNotificationsExecutor;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    private boolean isConsistencyAlreadyChecked;

    private static boolean canRunRecurringTasks(Member member) {
        return Boolean.parseBoolean(member.getAttribute(CAN_RUN_RECURRING_TASKS_ATTR));
    }

    private static Map<String, IScheduledFuture<?>> getAllScheduledTasks(IScheduledExecutorService iScheduledExecutorService) {
        HashMap hashMap = new HashMap();
        iScheduledExecutorService.getAllScheduledFutures().values().forEach(list -> list.forEach(iScheduledFuture -> hashMap.put(iScheduledFuture.getHandler().getTaskName(), (IScheduledFuture<?>)iScheduledFuture)));
        return hashMap;
    }

    private static String getHostId(Member member) {
        return member.getSocketAddress(EndpointQualifier.MEMBER).toString();
    }

    private static List<Member> getMembersForRecurringTasks(HazelcastInstance hazelcastInstance) {
        return hazelcastInstance.getCluster().getMembers().stream().filter(HazelcastClusterHandlerImpl::canRunRecurringTasks).collect(Collectors.toList());
    }

    private static MulticastConfig multicastConfig(Map<String, String> map) {
        MulticastConfig multicastConfig = new MulticastConfig();
        String string = map.get("CLUSTER_MULTICAST");
        boolean bl = StringHelper.isNotBlank((Object)string);
        multicastConfig.setEnabled(bl);
        if (bl) {
            multicastConfig.setMulticastGroup(StringUtils.substringBefore((String)string, (String)":"));
            multicastConfig.setMulticastPort(Integer.parseInt((String)ObjectHelper.defaultValue((Object)StringUtils.substringAfter((String)string, (String)":"), (Object)"54327")));
        }
        return multicastConfig;
    }

    public void checkConsistency() throws IllegalStateException {
        if (this.isConsistencyAlreadyChecked) {
            return;
        }
        Member member2 = this.instance.getCluster().getMembers().stream().filter(member -> !CyclosVersion.getCommitId().equals(member.getAttribute(COMMIT_ID_ATTR))).findAny().orElseGet(() -> null);
        try {
            if (member2 != null) {
                throw new IllegalStateException(String.format("Cannot join cluster due to Cyclos version mismatch. Cluster version: %s (%s), local member version %s (%s)", member2.getAttribute(CYCLOS_VERSION_ATTR), member2.getAttribute(COMMIT_ID_ATTR), CyclosVersion.get(), CyclosVersion.getCommitId()));
            }
        }
        finally {
            this.isConsistencyAlreadyChecked = true;
        }
    }

    public void clearCaches() {
        this.executeSystemMonitorTask(new ClearCachesSystemMonitorTask(), null, ClusterMemberData::new);
    }

    @PreDestroy
    public void destroy() {
        this.instance.getLifecycleService().shutdown();
    }

    public void finishBackgroundTaskExecution(BackgroundTaskExecutionContext backgroundTaskExecutionContext) {
        Map<Long, Integer> map = backgroundTaskExecutionContext.getExecutionIds().stream().collect(Collectors.toMap(l -> l, l -> 1));
        this.removeBackgroundExecutionsMap.setAll(map);
    }

    public Map<String, Integer> getBackgroundTaskExecutions() {
        List<TasksClusterMemberData> list2 = this.executeSystemMonitorTask(new GetBackgroundTaskExecutionsSystemMonitorTask(), HazelcastClusterHandlerImpl::canRunRecurringTasks, TasksClusterMemberData::new);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        list2.stream().map(TasksClusterMemberData::getRunningTasks).forEach(list -> list.forEach(runningTaskDescriptor -> hashMap.compute(runningTaskDescriptor.getTaskName(), (string, n) -> n == null ? 1 : n + 1)));
        return hashMap;
    }

    public List<CacheVO> getCachesInformation(CacheQuery cacheQuery) {
        CacheStatsSummaryHelper cacheStatsSummaryHelper = new CacheStatsSummaryHelper();
        List<CachesClusterMemberData> list = this.executeSystemMonitorTask(new GetCacheDataSystemMonitorTask(cacheQuery), null, CachesClusterMemberData::new);
        list.stream().filter(cachesClusterMemberData -> CollectionHelper.isNotEmpty(cachesClusterMemberData.getCaches())).forEach(cachesClusterMemberData -> cacheStatsSummaryHelper.add(cachesClusterMemberData.getCaches()));
        return cacheStatsSummaryHelper.summary();
    }

    public Map<String, List<CacheVO>> getCachesInformationByMember(CacheQuery cacheQuery) {
        return this.executeSystemMonitorTask(new GetCacheDataSystemMonitorTask(cacheQuery), null, CachesClusterMemberData::new).stream().collect(Collectors.toMap(ClusterMemberData::getMemberName, CachesClusterMemberData::getCaches));
    }

    public ClusterHandler.FinishedExecutionsHandler getFinishedBackgroundTaskExecutions() {
        return new AbstractClusterHandlerImpl.FinishedExecutionsHandlerImpl(new HashSet<Long>(this.removeBackgroundExecutionsMap.keySet()));
    }

    public Map<String, Object> getGlobal(String string) {
        Map map = this.executorService.submitToAllMembers((Callable)new GetGlobalTask(string));
        return map.entrySet().stream().map(entry -> {
            try {
                return Pair.create((Object)HazelcastClusterHandlerImpl.getHostId((Member)entry.getKey()), ((Future)entry.getValue()).get());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                ExceptionHelper.throwUnchecked((Throwable)exception);
            }
            return null;
        }).filter(pair -> pair != null && pair.getSecond() != null).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    public String getHostId() {
        return HazelcastClusterHandlerImpl.getHostId(this.member);
    }

    public String getMemberConfiguration() {
        return this.configXml;
    }

    public MemberRunningTaskDescriptor getMemberRunningTask(String string) {
        List<TasksClusterMemberData> list = this.executeSystemMonitorTask(new GetMemberRunningRecurringTaskSystemMonitorTask(string), HazelcastClusterHandlerImpl::canRunRecurringTasks, TasksClusterMemberData::new);
        List list2 = list.stream().filter(tasksClusterMemberData -> CollectionHelper.isNotEmpty(tasksClusterMemberData.getRunningTasks())).collect(Collectors.toList());
        if (list2.isEmpty()) {
            return null;
        }
        if (CollectionHelper.size(list2) == 1) {
            return new MemberRunningTaskDescriptor(((TasksClusterMemberData)((Object)list2.get(0))).getMemberName(), ((TasksClusterMemberData)((Object)list2.get(0))).getRunningTasks().get(0));
        }
        throw new IllegalStateException("Recurring task '" + string + " 'is being executed concurrently");
    }

    public List<ServerData> getMembersData() {
        return this.executeSystemMonitorTask(new GetMemberDataSystemMonitorTask(), null, ServerData::new);
    }

    public Map<String, MemberRunningTaskDescriptor> getRunningRecurringTasks() {
        List<TasksClusterMemberData> list = this.executeSystemMonitorTask(new GetRunningRecurringTasksSystemMonitorTask(), HazelcastClusterHandlerImpl::canRunRecurringTasks, TasksClusterMemberData::new);
        HashMap<String, MemberRunningTaskDescriptor> hashMap = new HashMap<String, MemberRunningTaskDescriptor>();
        list.stream().forEach(tasksClusterMemberData -> tasksClusterMemberData.getRunningTasks().forEach(runningTaskDescriptor -> {
            MemberRunningTaskDescriptor memberRunningTaskDescriptor = hashMap.put(runningTaskDescriptor.getTaskName(), new MemberRunningTaskDescriptor(tasksClusterMemberData.getMemberName(), runningTaskDescriptor));
            if (memberRunningTaskDescriptor != null && !memberRunningTaskDescriptor.getMemberName().equals(tasksClusterMemberData.getMemberName())) {
                throw new IllegalStateException("Recurring task '" + runningTaskDescriptor.getTaskName() + " 'is being executed concurrently");
            }
        }));
        return hashMap;
    }

    @Override
    @PostConstruct
    public void initialize() {
        ScheduledExecutorConfig scheduledExecutorConfig;
        JoinConfig joinConfig;
        Object object;
        UrlXmlConfig urlXmlConfig;
        URL uRL = this.getClass().getResource("/hazelcast.xml");
        if (uRL == null) {
            throw new IllegalStateException("Configuration file hazelcast.xml was not found");
        }
        try {
            urlXmlConfig = new UrlXmlConfig(uRL);
            object = XmlHelper.parse((InputStream)uRL.openStream());
            this.configXml = XmlHelper.export((Node)object.getDocumentElement());
            joinConfig = StringUtils.split((String)this.configXml, (String)System.lineSeparator());
            this.configXml = Stream.of(joinConfig).filter(string -> !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{string})).flatMap(string2 -> string2.contains("<hazelcast") ? Stream.of(StringUtils.split((String)string2, (String)" ")).map(string -> string.contains("<hazelcast") ? string : StringUtils.repeat((char)' ', (int)4) + string) : Stream.of(string2)).collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException | SAXException exception) {
            throw new IllegalStateException("Error parsing the Hazelcast configuration file", exception);
        }
        object = CyclosPropertiesFactoryBean.getClusterEnv();
        if (!object.isEmpty()) {
            joinConfig = new JoinConfig();
            joinConfig.setMulticastConfig(HazelcastClusterHandlerImpl.multicastConfig((Map<String, String>)object));
            joinConfig.setTcpIpConfig(this.tcpIpConfig((Map<String, String>)object));
            joinConfig.setAwsConfig(this.awsConfig((Map<String, String>)object));
            joinConfig.setGcpConfig(this.gcpConfig((Map<String, String>)object));
            joinConfig.setKubernetesConfig(this.k8sConfig((Map<String, String>)object));
            urlXmlConfig.getNetworkConfig().setJoin(joinConfig);
        }
        Arrays.asList(SUBSCRIPTIONS_BY_ID_MAP, USER_ID_BY_CLIENT_ID_MAP, MEMBERS_BY_ID_MAP, CLOSE_AFTER_BY_ID_MAP, MISSED_EVENTS_BY_ID_MULTIMAP).forEach(arg_0 -> HazelcastClusterHandlerImpl.lambda$initialize$19((Config)urlXmlConfig, arg_0));
        int n = this.cyclosProperties.getMaxRecurringTasks();
        if (n > 0) {
            scheduledExecutorConfig = urlXmlConfig.getScheduledExecutorConfig(RECURRING_TASK_SCHEDULED_EXECUTOR);
            scheduledExecutorConfig.setPoolSize(n);
        }
        urlXmlConfig.getUserContext().put(APPLICATION_CONTEXT_KEY, this.applicationContext);
        scheduledExecutorConfig = new MemberAttributeConfig();
        scheduledExecutorConfig.setAttribute(CAN_RUN_RECURRING_TASKS_ATTR, n > 0 ? "true" : "false");
        scheduledExecutorConfig.setAttribute(BACKGROUND_TASK_THREADS_ATTR, String.valueOf(this.cyclosProperties.getMaxBackgroundTasks()));
        scheduledExecutorConfig.setAttribute(STARTUP_TIME_ATTR, String.valueOf(System.currentTimeMillis()));
        scheduledExecutorConfig.setAttribute(CYCLOS_VERSION_ATTR, CyclosVersion.get());
        scheduledExecutorConfig.setAttribute(COMMIT_ID_ATTR, CyclosVersion.getCommitId());
        urlXmlConfig.setMemberAttributeConfig((MemberAttributeConfig)scheduledExecutorConfig);
        this.instance = Hazelcast.newHazelcastInstance((Config)urlXmlConfig);
        this.backgroundTaskQueue = this.instance.getQueue(BACKGROUND_TASK_QUEUE);
        this.executorService = this.instance.getExecutorService(SYSTEM_MONITOR_EXECUTOR);
        this.member = this.instance.getCluster().getLocalMember();
        this.initializationsMap = this.instance.getMap(INITIALIZATIONS_MAP);
        this.removeBackgroundExecutionsMap = this.instance.getMap(REMOVE_BACKGROUND_EXECUTIONS_MAP);
        this.backgroundExecutionLocksMap = this.instance.getMap(BACKGROUND_EXECUTION_LOCKS_MAP);
        this.cacheEvictTopic = this.instance.getReliableTopic(CACHE_EVICT_TOPIC);
        this.cacheEvictTopic.addMessageListener(this::onCacheEvictMessage);
        this.subscriptionsById = this.instance.getMap(SUBSCRIPTIONS_BY_ID_MAP);
        this.userIdByClientId = this.instance.getMap(USER_ID_BY_CLIENT_ID_MAP);
        this.closeAfterById = this.instance.getMap(CLOSE_AFTER_BY_ID_MAP);
        this.missedEventsById = this.instance.getMultiMap(MISSED_EVENTS_BY_ID_MULTIMAP);
        this.membersById = this.instance.getMap(MEMBERS_BY_ID_MAP);
        this.pushNotificationsExecutor = this.instance.getExecutorService(PUSH_NOTIFICATIONS_EXECUTOR);
        this.profilingMap = this.instance.getReplicatedMap(PROFILING_REPLICATEDMAP);
        super.initialize();
    }

    public boolean isAlive() {
        return this.instance.getLifecycleService().isRunning();
    }

    @Override
    public boolean isCausedByShutdown(Throwable throwable) {
        return super.isCausedByShutdown(throwable) || ExceptionUtils.indexOfType((Throwable)throwable, HazelcastInstanceNotActiveException.class) >= 0;
    }

    public boolean isCluster() {
        return true;
    }

    @Override
    public boolean runInitialization(ApplicationInitializationListener applicationInitializationListener) {
        return this.doRunInitialization((BaseApplicationInitializationListener)applicationInitializationListener);
    }

    @Override
    public boolean runUpgradeInitialization(ApplicationUpgradeInitializationListener applicationUpgradeInitializationListener) {
        return this.doRunInitialization((BaseApplicationInitializationListener)applicationUpgradeInitializationListener);
    }

    public void starTaskTimers() {
        this.recurringTaskHandler.scheduleTasks();
    }

    @Override
    protected <K, V> ReplicatedStorage<K, V> createReplicatedStorage(ReplicatedStorageType replicatedStorageType) {
        ReplicatedMap replicatedMap = this.instance.getReplicatedMap(REPLICATED_STORAGE_PREFIX + replicatedStorageType.name());
        return new HazelcastReplicatedStorage(replicatedMap);
    }

    @Override
    protected <K extends Serializable, V extends Serializable> SharedStorage<K, V> createSharedStorage(SharedStorageType<K, V> sharedStorageType) {
        IMap iMap = this.instance.getMap(SHARED_STORAGE_PREFIX + sharedStorageType.getName());
        return new HazelcastSharedStorage<K, V>(sharedStorageType, iMap);
    }

    @Override
    protected void dbAlreadyLocked(DbLock dbLock) {
        super.dbAlreadyLocked(dbLock);
        this.initializationsMap.lock((Object)DATABASE_LOCKED_KEY);
        try {
            this.initializationsMap.remove((Object)DATABASE_LOCKED_KEY);
        }
        finally {
            this.initializationsMap.unlock((Object)DATABASE_LOCKED_KEY);
        }
    }

    @Override
    protected void doRemoveFinishedBackgroundTaskExecutions(List<Long> list) {
        this.removeBackgroundExecutionsMap.removeAll((Predicate & Serializable)entry -> list.contains(entry.getKey()));
    }

    @Override
    protected BlockingQueue<BackgroundTaskExecutionContext> getBackgroundTaskQueue() {
        return this.backgroundTaskQueue;
    }

    @Override
    protected int getBackgroundTaskThreads() {
        return this.instance.getCluster().getMembers().stream().mapToInt(member -> (Integer)CoercionHelper.coerce(Integer.TYPE, (Object)member.getAttribute(BACKGROUND_TASK_THREADS_ATTR))).sum();
    }

    @Override
    protected CacheHandlerImplementor instantiateCacheHandler() {
        return new HazelcastCacheHandler(this.cacheEvictTopic);
    }

    @Override
    protected ProfilingManager instantiateProfilingManager() {
        return new HazelcastProfilingManager(this.profilingMap);
    }

    @Override
    protected PushNotificationHandler instantiatePushNotificationHandler() {
        return new HazelcastPushNotificationHandler();
    }

    @Override
    protected RecurringTaskHandlerImplementor instantiateRecurringTaskHandler() {
        return new HazelcastRecurringTaskHandler(this.instance, this.ignoreDbLock);
    }

    @Override
    protected void runBackgroundTask(BackgroundTaskExecutionContext backgroundTaskExecutionContext) {
        if (!this.backgroundExecutionLocksMap.tryLock((Object)backgroundTaskExecutionContext.getKey())) {
            return;
        }
        try {
            super.runBackgroundTask(backgroundTaskExecutionContext);
        }
        finally {
            this.backgroundExecutionLocksMap.unlock((Object)backgroundTaskExecutionContext.getKey());
        }
    }

    @Override
    protected boolean shouldEnsureDatabaseIsNotLocked() {
        this.initializationsMap.lock((Object)DATABASE_LOCKED_KEY);
        try {
            if (this.initializationsMap.containsKey((Object)DATABASE_LOCKED_KEY)) {
                boolean bl = false;
                return bl;
            }
            this.initializationsMap.set((Object)DATABASE_LOCKED_KEY, (Object)true);
            boolean bl = true;
            return bl;
        }
        finally {
            this.initializationsMap.unlock((Object)DATABASE_LOCKED_KEY);
        }
    }

    @Override
    protected boolean shouldUnlockDatabase() {
        boolean bl = this.initializationsMap.containsKey((Object)DATABASE_LOCKED_KEY);
        if (!bl) {
            return false;
        }
        ShutdownCallable shutdownCallable = new ShutdownCallable();
        MutableInt mutableInt = new MutableInt();
        this.databaseManager.doWithCyclosInstanceLock(() -> {
            Map map = this.executorService.submitToAllMembers((Callable)shutdownCallable);
            for (Future future : map.values()) {
                try {
                    Boolean bl = (Boolean)future.get();
                    if (!bl.booleanValue()) continue;
                    mutableInt.increment();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {}
            }
            this.instance.getUserContext().put(SHUTDOWN, true);
        });
        return mutableInt.intValue() == 1;
    }

    @PreDestroy
    protected void shutdown() {
        try {
            this.instance.shutdown();
        }
        catch (HazelcastInstanceNotActiveException hazelcastInstanceNotActiveException) {
            // empty catch block
        }
    }

    private AwsConfig awsConfig(Map<String, String> map) {
        AwsConfig awsConfig = new AwsConfig();
        String string = map.get("CLUSTER_AWS_TAG");
        boolean bl = StringHelper.isNotBlank((Object)string);
        awsConfig.setEnabled(bl);
        if (bl) {
            awsConfig.setProperty("tag-key", StringUtils.substringBefore((String)string, (String)":"));
            awsConfig.setProperty("tag-value", StringUtils.substringAfter((String)string, (String)":"));
        }
        return awsConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRunInitialization(BaseApplicationInitializationListener baseApplicationInitializationListener) {
        String string = baseApplicationInitializationListener.getInitializationId();
        this.initializationsMap.lock((Object)string);
        try {
            boolean bl = baseApplicationInitializationListener instanceof ApplicationUpgradeInitializationListener;
            boolean bl2 = Boolean.TRUE.equals(this.initializationsMap.get((Object)string));
            if (bl2) {
                LOG.debug("Not running " + (bl ? "upgrade " : "") + "initialization {} because some other node already did it", (Object)string);
                boolean bl3 = false;
                return bl3;
            }
            if (bl) {
                super.runUpgradeInitialization((ApplicationUpgradeInitializationListener)baseApplicationInitializationListener);
            } else {
                super.runInitialization((ApplicationInitializationListener)baseApplicationInitializationListener);
            }
            this.initializationsMap.set((Object)string, (Object)true);
            boolean bl4 = true;
            return bl4;
        }
        finally {
            this.initializationsMap.unlock((Object)string);
        }
    }

    private <R extends ClusterMemberData> List<R> executeSystemMonitorTask(Callable<R> callable, MemberSelector memberSelector, Supplier<R> supplier) {
        Map map;
        try {
            map = memberSelector == null ? this.executorService.submitToAllMembers(callable) : this.executorService.submitToMembers(callable, memberSelector);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            map = Collections.emptyMap();
        }
        TreeMap treeMap = new TreeMap((member, member2) -> HazelcastClusterHandlerImpl.getHostId(member).compareTo(HazelcastClusterHandlerImpl.getHostId(member2)));
        map.entrySet().stream().forEach(entry -> {
            try {
                treeMap.put((Member)entry.getKey(), ((Future)entry.getValue()).get());
            }
            catch (InterruptedException | ExecutionException exception) {
                treeMap.put((Member)entry.getKey(), exception instanceof ExecutionException ? exception.getCause() : exception);
            }
        });
        return treeMap.entrySet().stream().map(entry -> this.processSystemMonitorTaskResult((Map.Entry<Member, Object>)entry, supplier)).collect(Collectors.toList());
    }

    private GcpConfig gcpConfig(Map<String, String> map) {
        GcpConfig gcpConfig = new GcpConfig();
        String string = map.get("CLUSTER_GCP_LABEL");
        boolean bl = StringHelper.isNotBlank((Object)string);
        gcpConfig.setEnabled(bl);
        if (bl) {
            gcpConfig.setProperty("label", string);
        }
        return gcpConfig;
    }

    private KubernetesConfig k8sConfig(Map<String, String> map) {
        KubernetesConfig kubernetesConfig = new KubernetesConfig();
        String string = map.get("CLUSTER_K8S_DNS");
        boolean bl = StringHelper.isNotBlank((Object)string);
        kubernetesConfig.setEnabled(bl);
        if (bl) {
            kubernetesConfig.setProperty("service-dns", string);
        }
        return kubernetesConfig;
    }

    private void onCacheEvictMessage(Message<TreeMap<CacheType<? extends Serializable, ?>, CacheOperation>> message) {
        TreeMap treeMap = (TreeMap)message.getMessageObject();
        LOG.debug("Evicting caches {} because node {} published an evict event", (Object)treeMap, (Object)message.getPublishingMember());
        ((HazelcastCacheHandler)this.getCacheHandler()).applyLocally(treeMap);
    }

    private <R extends ClusterMemberData> R processSystemMonitorTaskResult(Map.Entry<Member, Object> entry, Supplier<R> supplier) {
        ClusterMemberData clusterMemberData;
        Object object = entry.getValue();
        if (object instanceof Exception) {
            Exception exception = (Exception)object;
            LOG.error("Error executing system monitor task: " + exception.getMessage(), (Throwable)exception);
            clusterMemberData = (ClusterMemberData)supplier.get();
            if (object instanceof InterruptedException) {
                clusterMemberData.setErrorMessage(this.translationHandler.message(SystemKeys.Monitor.ERROR_CAN_NOT_COLLECT_CLUSTER_MEMBER_DATA_INTERRUPTED, new Object[0]));
            } else {
                clusterMemberData.setErrorMessage(this.translationHandler.message(SystemKeys.Monitor.ERROR_CAN_NOT_COLLECT_CLUSTER_MEMBER_DATA, new Object[]{exception.getMessage()}));
            }
        } else {
            clusterMemberData = object == null ? (ClusterMemberData)supplier.get() : (ClusterMemberData)object;
        }
        clusterMemberData.setMemberName(HazelcastClusterHandlerImpl.getHostId(entry.getKey()));
        return (R)clusterMemberData;
    }

    private TcpIpConfig tcpIpConfig(Map<String, String> map) {
        TcpIpConfig tcpIpConfig = new TcpIpConfig();
        String string = map.get("CLUSTER_TCPIP");
        boolean bl = StringHelper.isNotBlank((Object)string);
        tcpIpConfig.setEnabled(bl);
        if (bl) {
            StringHelper.splitTrimming((String)string, (String)",").forEach(arg_0 -> ((TcpIpConfig)tcpIpConfig).addMember(arg_0));
        }
        return tcpIpConfig;
    }

    private static /* synthetic */ void lambda$initialize$19(Config config, String string) {
        config.addMapConfig(new MapConfig(string).setMaxIdleSeconds(3600));
    }

    private static class ClearCachesSystemMonitorTask
    extends BaseSystemMonitorTask<ClusterMemberData> {
        private static final long serialVersionUID = 1L;

        private ClearCachesSystemMonitorTask() {
        }

        @Override
        public ClusterMemberData call() throws Exception {
            return (ClusterMemberData)this.invokerHandler().runAs(SessionDataFactory.system(), () -> {
                this.cacheHandler().clearAll();
                return new ClusterMemberData();
            });
        }

        private CacheHandlerImplementor cacheHandler() {
            return (CacheHandlerImplementor)this.applicationContext.getBean(CacheHandlerImplementor.class);
        }
    }

    private static class GetBackgroundTaskExecutionsSystemMonitorTask
    extends BaseSystemMonitorTask<TasksClusterMemberData> {
        private static final long serialVersionUID = 1L;

        private GetBackgroundTaskExecutionsSystemMonitorTask() {
        }

        @Override
        public TasksClusterMemberData call() throws Exception {
            return (TasksClusterMemberData)((Object)this.invokerHandler().runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> {
                Set set;
                Set set2 = set = this.backgroundTaskHandler().getRunningTasks();
                synchronized (set2) {
                    return new TasksClusterMemberData(new ArrayList<RunningTaskDescriptor>(set));
                }
            }));
        }
    }

    private class CacheStatsSummaryHelper {
        private Map<String, CacheStatsByMemberData> merge = new HashMap<String, CacheStatsByMemberData>();

        private CacheStatsSummaryHelper() {
        }

        private CacheStatsSummaryHelper add(CacheVO cacheVO) {
            CacheStatsVO cacheStatsVO = cacheVO.getStats();
            this.merge.compute(cacheVO.getName(), (string, cacheStatsByMemberData) -> {
                long l = Long.parseLong(cacheStatsVO.getRequestCount());
                if (cacheStatsByMemberData == null) {
                    CacheStatsVO cacheStatsVO2 = new CacheStatsVO();
                    cacheStatsVO2.setEvictionCount(cacheStatsVO.getEvictionCount());
                    cacheStatsVO2.setRequestCount(cacheStatsVO.getRequestCount());
                    cacheStatsVO2.setSize(cacheStatsVO.getSize());
                    cacheStatsVO2.setHitRate(cacheStatsVO.getHitRate() * (double)l);
                    return CacheStatsByMemberData.create(cacheStatsVO2, l);
                }
                CacheStatsVO cacheStatsVO3 = cacheStatsByMemberData.stats;
                cacheStatsVO3.setEvictionCount(this.sum(cacheStatsVO3.getEvictionCount(), cacheStatsVO.getEvictionCount()));
                cacheStatsVO3.setRequestCount(this.sum(cacheStatsVO3.getRequestCount(), cacheStatsVO.getRequestCount()));
                cacheStatsVO3.setSize(this.sum(cacheStatsVO3.getSize(), cacheStatsVO.getSize()));
                cacheStatsVO3.setHitRate(cacheStatsVO3.getHitRate() + cacheStatsVO.getHitRate() * (double)l);
                cacheStatsByMemberData.requestCount += l;
                ++cacheStatsByMemberData.memberCount;
                return cacheStatsByMemberData;
            });
            return this;
        }

        private CacheStatsSummaryHelper add(List<CacheVO> list) {
            if (CollectionHelper.isEmpty(list)) {
                return this;
            }
            list.stream().forEach(this::add);
            return this;
        }

        private String sum(String string, String string2) {
            return String.valueOf(Long.parseLong(string) + Long.parseLong(string2));
        }

        private List<CacheVO> summary() {
            return this.merge.entrySet().stream().map(entry -> {
                CacheStatsByMemberData cacheStatsByMemberData = (CacheStatsByMemberData)entry.getValue();
                CacheStatsVO cacheStatsVO = cacheStatsByMemberData.stats;
                long l = cacheStatsByMemberData.requestCount;
                cacheStatsVO.setHitRate(cacheStatsVO.getHitRate() == 0.0 || l == 0L ? 0.0 : cacheStatsVO.getHitRate() / (double)l);
                long l2 = Long.parseLong(cacheStatsVO.getEvictionCount());
                if (l2 > 0L) {
                    cacheStatsVO.setEvictionCount(String.valueOf((long)Math.ceil((double)l2 / (double)cacheStatsByMemberData.memberCount)));
                }
                CacheVO cacheVO = new CacheVO();
                cacheVO.setName((String)entry.getKey());
                cacheVO.setStats(cacheStatsVO);
                return cacheVO;
            }).collect(Collectors.toList());
        }
    }

    private static class GetCacheDataSystemMonitorTask
    extends BaseSystemMonitorTask<CachesClusterMemberData> {
        private static final long serialVersionUID = 1L;
        private CacheQuery query;

        public GetCacheDataSystemMonitorTask(CacheQuery cacheQuery) {
            this.query = cacheQuery;
        }

        @Override
        public CachesClusterMemberData call() throws Exception {
            return (CachesClusterMemberData)((Object)this.invokerHandler().runAs(SessionDataFactory.system(), () -> {
                List list = this.systemMonitorService().listLocalCaches(this.query);
                return new CachesClusterMemberData(list);
            }));
        }
    }

    private static class GetGlobalTask
    extends BaseSystemMonitorTask<Object> {
        private static final long serialVersionUID = 1L;
        private final String key;

        public GetGlobalTask(String string) {
            this.key = string;
        }

        @Override
        public Object call() throws Exception {
            return ((ScriptHelper)this.applicationContext.getBean(ScriptHelper.class)).getGlobals().get(this.key);
        }
    }

    private static class GetMemberRunningRecurringTaskSystemMonitorTask
    extends BaseSystemMonitorTask<TasksClusterMemberData> {
        private static final long serialVersionUID = 1L;
        private String taskName;

        public GetMemberRunningRecurringTaskSystemMonitorTask(String string) {
            this.taskName = string;
        }

        @Override
        public TasksClusterMemberData call() throws Exception {
            return (TasksClusterMemberData)((Object)this.invokerHandler().runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> this.recurringTaskHandler().getRunningTasks().stream().filter(runningTaskDescriptor -> runningTaskDescriptor.getTaskName().equals(this.taskName)).map(TasksClusterMemberData::new).findAny().orElse(null)));
        }
    }

    private static class TasksClusterMemberData
    extends ClusterMemberData {
        private static final long serialVersionUID = 1L;
        private List<RunningTaskDescriptor> runningTasks;

        public TasksClusterMemberData() {
        }

        public TasksClusterMemberData(List<RunningTaskDescriptor> list) {
            this.runningTasks = list;
        }

        public TasksClusterMemberData(RunningTaskDescriptor runningTaskDescriptor) {
            this(new ArrayList<RunningTaskDescriptor>());
            this.runningTasks.add(runningTaskDescriptor);
        }

        public List<RunningTaskDescriptor> getRunningTasks() {
            return this.runningTasks;
        }
    }

    private static class GetMemberDataSystemMonitorTask
    extends BaseSystemMonitorTask<ServerData> {
        private static final long serialVersionUID = 1L;

        private GetMemberDataSystemMonitorTask() {
        }

        @Override
        public ServerData call() throws Exception {
            return (ServerData)this.invokerHandler().runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> {
                ServerData serverData = this.systemMonitorService().getServerData();
                long l = Long.parseLong(this.instance.getCluster().getLocalMember().getAttribute(HazelcastClusterHandlerImpl.STARTUP_TIME_ATTR));
                serverData.setUpSince(this.conversionHandler().toDateTime(new Date(l)));
                serverData.setUptimeInMillis(String.valueOf(System.currentTimeMillis() - l));
                return serverData;
            });
        }

        private ConversionHandler conversionHandler() {
            return (ConversionHandler)this.applicationContext.getBean(ConversionHandler.class);
        }
    }

    private static class GetRunningRecurringTasksSystemMonitorTask
    extends BaseSystemMonitorTask<TasksClusterMemberData> {
        private static final long serialVersionUID = 1L;

        private GetRunningRecurringTasksSystemMonitorTask() {
        }

        @Override
        public TasksClusterMemberData call() throws Exception {
            return (TasksClusterMemberData)((Object)this.invokerHandler().runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> {
                Set set = this.recurringTaskHandler().getRunningTasks();
                List<RunningTaskDescriptor> list = set.stream().collect(Collectors.toList());
                return new TasksClusterMemberData(list);
            }));
        }
    }

    private static class HazelcastReplicatedStorage<K, V>
    implements ReplicatedStorage<K, V> {
        private ReplicatedMap<K, V> replicatedMap;

        public HazelcastReplicatedStorage(ReplicatedMap<K, V> replicatedMap) {
            this.replicatedMap = replicatedMap;
        }

        public void clear() {
            this.replicatedMap.clear();
        }

        public V get(K k) {
            return (V)this.replicatedMap.get(k);
        }

        public void remove(K k) {
            this.replicatedMap.remove(k);
        }

        public void removeAll(Collection<K> collection) {
            if (CollectionHelper.isEmpty(collection)) {
                return;
            }
            collection.forEach(arg_0 -> this.replicatedMap.remove(arg_0));
        }

        public void set(K k, V v) {
            this.replicatedMap.put(k, v);
        }
    }

    private static class HazelcastCacheHandler
    extends GuavaCacheHandlerImpl {
        private ITopic<TreeMap<CacheType<? extends Serializable, ?>, CacheOperation>> cacheEvictTopic;

        public HazelcastCacheHandler(ITopic<TreeMap<CacheType<? extends Serializable, ?>, CacheOperation>> iTopic) {
            this.cacheEvictTopic = iTopic;
        }

        @Override
        public void apply(TreeMap<CacheType<? extends Serializable, ?>, CacheOperation> treeMap) {
            this.cacheEvictTopic.publish(treeMap);
        }

        private void applyLocally(TreeMap<CacheType<? extends Serializable, ?>, CacheOperation> treeMap) {
            super.apply(treeMap);
        }
    }

    private class HazelcastProfilingManager
    extends BaseProfilingManagerImpl {
        private static final String PARAMS = "params";
        private final ReplicatedMap<String, Object> map;

        public HazelcastProfilingManager(ReplicatedMap<String, Object> replicatedMap) {
            this.map = replicatedMap;
            replicatedMap.addEntryListener((EntryListener)new EntryAdapter<String, Object>(){

                public void entryAdded(EntryEvent<String, Object> entryEvent) {
                    HazelcastProfilingManager.this.profiling = new ClusterHostProfilingResult();
                }

                public void entryRemoved(EntryEvent<String, Object> entryEvent) {
                    HazelcastProfilingManager.this.profiling = null;
                }
            }, (Object)PARAMS);
        }

        public StartProfilingParams getStartParams() {
            return (StartProfilingParams)this.map.get((Object)PARAMS);
        }

        @Override
        protected Map<String, ClusterHostProfilingResult> doGetResultsByHost() {
            return this.collectFromMembers(new GetCurrentProfilingResultTask());
        }

        @Override
        protected Map<String, ClusterHostProfilingStats> doGetStatsByHost() {
            return this.collectFromMembers(new GetCurrentProfilingStatsTask());
        }

        @Override
        protected void storeStartParams(StartProfilingParams startProfilingParams) {
            if (startProfilingParams == null) {
                this.map.remove((Object)PARAMS);
            } else {
                this.map.put((Object)PARAMS, (Object)startProfilingParams);
            }
        }

        private <V> Map<String, V> collectFromMembers(Callable<V> callable) {
            Map map = HazelcastClusterHandlerImpl.this.executorService.submitToAllMembers(callable);
            HashMap hashMap = new HashMap();
            map.entrySet().forEach(entry -> {
                Object v = null;
                try {
                    v = ((Future)entry.getValue()).get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
                if (v != null) {
                    hashMap.put(HazelcastClusterHandlerImpl.getHostId((Member)entry.getKey()), v);
                }
            });
            return hashMap;
        }
    }

    private class HazelcastPushNotificationHandler
    extends AbstractPushNotificationHandlerImpl<PushNotificationSubscription> {
        private Cache<String, Consumer<PushNotificationEvent<?>>> listenersById;

        private HazelcastPushNotificationHandler() {
        }

        @Override
        public void close(String string) {
            PushNotificationSubscription pushNotificationSubscription = this.subscriptionForId(string);
            if (pushNotificationSubscription != null) {
                HazelcastClusterHandlerImpl.this.subscriptionsById.delete((Object)string);
                HazelcastClusterHandlerImpl.this.userIdByClientId.delete((Object)this.clientFromId(string));
                HazelcastClusterHandlerImpl.this.closeAfterById.delete((Object)string);
                HazelcastClusterHandlerImpl.this.missedEventsById.delete((Object)string);
                Member member = (Member)HazelcastClusterHandlerImpl.this.membersById.remove((Object)string);
                HazelcastClusterHandlerImpl.this.pushNotificationsExecutor.submitToMember((Callable)new InvalidateSubscriptionCallable(), member);
            }
        }

        public void doDispatch(PushNotificationSubscription pushNotificationSubscription, PushNotificationEvent<?> pushNotificationEvent) {
            String string = pushNotificationSubscription.getId();
            Member member = (Member)HazelcastClusterHandlerImpl.this.membersById.get((Object)string);
            if (member == null || member.localMember()) {
                Consumer consumer = (Consumer)this.listenersById.getIfPresent((Object)string);
                if (consumer != null) {
                    consumer.accept(pushNotificationEvent);
                }
            } else {
                DoDispatchSubscriptionCallable doDispatchSubscriptionCallable = new DoDispatchSubscriptionCallable(pushNotificationSubscription, pushNotificationEvent);
                HazelcastClusterHandlerImpl.this.pushNotificationsExecutor.submitToMember((Callable)doDispatchSubscriptionCallable, member);
            }
        }

        @PostConstruct
        public void initialize() {
            this.listenersById = this.newCache();
        }

        public void invalidate(String string) {
            this.listenersById.invalidate((Object)string);
        }

        @Override
        public PushNotificationSubscription subscriptionForClientId(String string) {
            Long l = (Long)HazelcastClusterHandlerImpl.this.userIdByClientId.get((Object)string);
            String string2 = this.idFromClientId(l, string);
            return this.subscriptionForId(string2);
        }

        @Override
        public PushNotificationSubscription subscriptionForId(String string) {
            return (PushNotificationSubscription)HazelcastClusterHandlerImpl.this.subscriptionsById.get((Object)string);
        }

        @Override
        protected void addMissedEvent(PushNotificationSubscription pushNotificationSubscription, PushNotificationEvent<?> pushNotificationEvent) {
            HazelcastClusterHandlerImpl.this.missedEventsById.put((Object)pushNotificationSubscription.getId(), pushNotificationEvent);
        }

        @Override
        protected void connect(PushNotificationSubscription pushNotificationSubscription, Consumer<PushNotificationEvent<?>> consumer) {
            String string = pushNotificationSubscription.getId();
            Member member = (Member)HazelcastClusterHandlerImpl.this.membersById.get((Object)string);
            if (member != null && !member.localMember()) {
                HazelcastClusterHandlerImpl.this.pushNotificationsExecutor.submitToMember((Callable)new InvalidateSubscriptionCallable(), member);
            }
            this.listenersById.put((Object)string, consumer);
            this.updateSharedState(pushNotificationSubscription);
        }

        @Override
        protected Long getCloseAfter(PushNotificationSubscription pushNotificationSubscription) {
            return (Long)HazelcastClusterHandlerImpl.this.closeAfterById.get((Object)pushNotificationSubscription.getId());
        }

        @Override
        protected AbstractPushNotificationHandlerImpl.SubscriptionMatchResult<PushNotificationSubscription> matchingSubscriptions(PushNotificationEventContext<?> pushNotificationEventContext) {
            Predicate & Serializable intersect = (Predicate & Serializable)entry -> ((PushNotificationSubscription)entry.getValue()).matches(pushNotificationEventContext);
            final Collection collection = HazelcastClusterHandlerImpl.this.subscriptionsById.values((Predicate)intersect);
            return new AbstractPushNotificationHandlerImpl.SubscriptionMatchResult<PushNotificationSubscription>(){

                @Override
                public Collection<PushNotificationSubscription> getMatches() {
                    return collection;
                }

                @Override
                public void publish(PushNotificationEvent<?> pushNotificationEvent) {
                    collection.forEach(pushNotificationSubscription -> HazelcastPushNotificationHandler.this.dispatch(pushNotificationSubscription, pushNotificationEvent));
                }
            };
        }

        @Override
        protected PushNotificationSubscription newSubscription(String string, String string2, PushNotificationSubscriptionMatcher pushNotificationSubscriptionMatcher) {
            return new PushNotificationSubscription(string, string2, pushNotificationSubscriptionMatcher);
        }

        @Override
        protected void reconnect(PushNotificationSubscription pushNotificationSubscription, Consumer<PushNotificationEvent<?>> consumer) {
            String string = pushNotificationSubscription.getId();
            Member member = (Member)HazelcastClusterHandlerImpl.this.membersById.get((Object)string);
            if (member == null) {
                this.connect(pushNotificationSubscription, consumer);
            } else {
                this.updateSharedState(pushNotificationSubscription);
                this.listenersById.put((Object)string, consumer);
                Collection collection = HazelcastClusterHandlerImpl.this.missedEventsById.remove((Object)string);
                if (CollectionHelper.isNotEmpty((Iterable)collection)) {
                    this.invokerHandler.getExecutorService().submit(() -> collection.forEach(consumer::accept));
                }
            }
        }

        @Override
        protected void setCloseAfter(PushNotificationSubscription pushNotificationSubscription, Long l) {
            String string = pushNotificationSubscription.getId();
            if (l == null) {
                HazelcastClusterHandlerImpl.this.closeAfterById.delete((Object)string);
            } else {
                HazelcastClusterHandlerImpl.this.closeAfterById.set((Object)string, (Object)l);
            }
        }

        private void updateSharedState(PushNotificationSubscription pushNotificationSubscription) {
            String string = pushNotificationSubscription.getId();
            HazelcastClusterHandlerImpl.this.subscriptionsById.put((Object)string, (Object)pushNotificationSubscription);
            HazelcastClusterHandlerImpl.this.membersById.put((Object)string, (Object)HazelcastClusterHandlerImpl.this.member);
        }
    }

    private static class HazelcastRecurringTaskHandler
    extends AbstractRecurringTaskHandlerImpl {
        private HazelcastInstance instance;
        private IMap<String, Integer> awakePollingTasksMap;
        private IScheduledExecutorService recurringTaskScheduledExecutor;
        private Timer timer;
        private boolean ignoreDbLock;

        public HazelcastRecurringTaskHandler(HazelcastInstance hazelcastInstance, boolean bl) {
            this.instance = hazelcastInstance;
            this.ignoreDbLock = bl;
            this.awakePollingTasksMap = hazelcastInstance.getMap(HazelcastClusterHandlerImpl.AWAKE_RECURRING_TASKS_MAP);
            this.recurringTaskScheduledExecutor = hazelcastInstance.getScheduledExecutorService(HazelcastClusterHandlerImpl.RECURRING_TASK_SCHEDULED_EXECUTOR);
        }

        public void awakeNow(RecurringTask recurringTask) {
            this.awakePollingTasksMap.setAsync((Object)recurringTask.getClass().getName(), (Object)1);
        }

        @PreDestroy
        public void destroy() {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }

        public Map<String, Long> getTaskDelays() {
            return HazelcastClusterHandlerImpl.getAllScheduledTasks(this.recurringTaskScheduledExecutor).entrySet().stream().filter(entry -> !((IScheduledFuture)entry.getValue()).isDone()).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((IScheduledFuture)entry.getValue()).getDelay(TimeUnit.SECONDS)));
        }

        public void scheduleTasks() {
            this.logTaskWorkersInfo();
            this.timer = new Timer("cy.hazelcast_task_monitor_check");
            this.timer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    IMap iMap = instance.getMap(HazelcastClusterHandlerImpl.INITIALIZATIONS_MAP);
                    boolean bl = iMap.tryLock((Object)HazelcastClusterHandlerImpl.SCHEDULED_TASKS_KEY);
                    try {
                        if (bl) {
                            String string = HazelcastClusterHandlerImpl.getHostId(instance.getCluster().getLocalMember());
                            LOG.debug("Running recurring task monitor in {}", (Object)string);
                            IScheduledExecutorService iScheduledExecutorService = instance.getScheduledExecutorService(HazelcastClusterHandlerImpl.RECURRING_TASK_SCHEDULED_EXECUTOR);
                            Map<String, IScheduledFuture<?>> map = HazelcastClusterHandlerImpl.getAllScheduledTasks(iScheduledExecutorService);
                            if (!ignoreDbLock) {
                                this.scheduleKeppAlive(map, iScheduledExecutorService);
                            }
                            if (cyclosProperties.getMaxRecurringTasks() > 0) {
                                this.scheduleRecurringTasks(map, iScheduledExecutorService);
                            }
                        } else {
                            LOG.debug("Another member is already running the recurring task monitor. Ignoring...");
                        }
                    }
                    catch (Exception exception) {
                        LOG.warn("Error scheduling recurring tasks and db lock keep-alive. Will attempt again in 1seconds", (Throwable)exception);
                    }
                    finally {
                        if (bl) {
                            iMap.unlock((Object)HazelcastClusterHandlerImpl.SCHEDULED_TASKS_KEY);
                        }
                    }
                }
            }, 1000L, 1000L);
        }

        private Member ensureAvailableMember(MutableObject<List<Member>> mutableObject, int n) throws NoAvailableMemberToRunRecurringTasksException {
            List list = (List)mutableObject.get();
            if (list == null) {
                mutableObject.set(HazelcastClusterHandlerImpl.getMembersForRecurringTasks(this.instance));
                list = (List)mutableObject.get();
                if (list.isEmpty()) {
                    throw new NoAvailableMemberToRunRecurringTasksException(n);
                }
            }
            return (Member)CollectionHelper.random((List)list);
        }

        private long ensureExecutionDelay(boolean bl, boolean bl2, RecurringTask recurringTask) {
            Date date = bl ? new Date() : (!bl2 ? this.getFirstExecution(recurringTask) : this.getNextExecution(recurringTask));
            return Duration.between(Instant.now(), date.toInstant()).abs().toMillis();
        }

        private void scheduleKeppAlive(Map<String, IScheduledFuture<?>> map, IScheduledExecutorService iScheduledExecutorService) {
            boolean bl;
            IScheduledFuture<?> iScheduledFuture = map.get(HazelcastClusterHandlerImpl.KEEP_ALIVE_TASK);
            boolean bl2 = iScheduledFuture != null;
            boolean bl3 = bl2 && iScheduledFuture.getDelay(TimeUnit.SECONDS) > 0L;
            boolean bl4 = bl = bl2 && !bl3 && !iScheduledFuture.isDone();
            if (!bl && !bl3) {
                if (iScheduledFuture != null) {
                    iScheduledFuture.dispose();
                }
            } else {
                LOG.debug("Ignoring keep-alive scheduling: waiting={}, running={} ", (Object)bl3, (Object)bl);
                return;
            }
            try {
                iScheduledExecutorService.scheduleOnMember((Runnable)((Object)new HazelcastDbLockKeepAliveTask()), this.instance.getCluster().getLocalMember(), 6L, TimeUnit.SECONDS);
            }
            catch (DuplicateTaskException duplicateTaskException) {
                LOG.debug("Keep-alive task already scheduled. Ignoring...");
            }
        }

        private void scheduleOnMember(IScheduledExecutorService iScheduledExecutorService, Member member, RecurringTask recurringTask, long l) {
            try {
                iScheduledExecutorService.scheduleOnMember((Runnable)((Object)new HazelcastRecurringTaskRunnable(recurringTask.getClass())), member, l, TimeUnit.MILLISECONDS);
            }
            catch (DuplicateTaskException duplicateTaskException) {
                LOG.debug("Recurring task '{}' already scheduled. Ignoring...", (Object)recurringTask.getName());
            }
        }

        private void scheduleRecurringTasks(Map<String, IScheduledFuture<?>> map, IScheduledExecutorService iScheduledExecutorService) {
            IMap iMap = this.instance.getMap(HazelcastClusterHandlerImpl.AWAKE_RECURRING_TASKS_MAP);
            try {
                MutableObject mutableObject = new MutableObject();
                Map<RecurringTask, Long> map2 = this.forEachTask(recurringTask -> {
                    String string = recurringTask.getClass().getName();
                    IScheduledFuture iScheduledFuture = (IScheduledFuture)map.get(string);
                    boolean bl = iScheduledFuture != null;
                    boolean bl2 = bl && iScheduledFuture.getDelay(TimeUnit.SECONDS) > 0L;
                    boolean bl3 = bl && !iScheduledFuture.isDone() && !bl2;
                    boolean bl4 = iMap.containsKey((Object)string);
                    if (!(bl3 || bl2 && !bl4)) {
                        Member member = this.ensureAvailableMember((MutableObject<List<Member>>)mutableObject, map.size());
                        long l = this.ensureExecutionDelay(bl4, bl, (RecurringTask)recurringTask);
                        if (bl) {
                            LOG.debug("Rescheduling task {} on member {} for run at {}. Task info: was waiting for execution={}, was awakened={}", (Object)string, (Object)member, (Object)DATE_FORMATTER.format(LocalDateTime.now().plus(l, ChronoUnit.MILLIS)), (Object)bl2, (Object)bl4);
                            iScheduledFuture.dispose();
                        }
                        if (bl4) {
                            iMap.delete((Object)string);
                        }
                        this.scheduleOnMember(iScheduledExecutorService, member, (RecurringTask)recurringTask, l);
                        return bl ? null : Long.valueOf(l);
                    }
                    return null;
                });
                if (!map2.values().stream().anyMatch(Objects::isNull)) {
                    this.logFirstExecution(map2);
                }
            }
            catch (NoAvailableMemberToRunRecurringTasksException noAvailableMemberToRunRecurringTasksException) {
                LOG.debug("No available members to run recurring tasks! Scheduled tasks: {}", (Object)noAvailableMemberToRunRecurringTasksException.scheduledTaks);
            }
            catch (Throwable throwable) {
                LOG.error("Error in recurring task monitor", throwable);
            }
        }
    }

    private static class ShutdownCallable
    extends BaseHazelcastInstanceAware
    implements Callable<Boolean>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ShutdownCallable() {
        }

        @Override
        public Boolean call() throws Exception {
            return !this.instance.getUserContext().containsKey(HazelcastClusterHandlerImpl.SHUTDOWN);
        }
    }

    private static class CachesClusterMemberData
    extends ClusterMemberData {
        private static final long serialVersionUID = 1L;
        private List<CacheVO> caches;

        public CachesClusterMemberData() {
        }

        public CachesClusterMemberData(List<CacheVO> list) {
            this.caches = list;
        }

        public List<CacheVO> getCaches() {
            return this.caches;
        }
    }

    private static class NoAvailableMemberToRunRecurringTasksException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private int scheduledTaks;

        public NoAvailableMemberToRunRecurringTasksException(int n) {
            this.scheduledTaks = n;
        }
    }

    private static class InvalidateSubscriptionCallable
    extends BaseHazelcastInstanceAware
    implements Callable<Void> {
        private static final long serialVersionUID = 1L;
        private String id;

        private InvalidateSubscriptionCallable() {
        }

        @Override
        public Void call() throws Exception {
            PushNotificationHandlerImplementor pushNotificationHandlerImplementor = this.pushNotificationHandler();
            pushNotificationHandlerImplementor.invalidate(this.id);
            return null;
        }
    }

    private static class HazelcastRecurringTaskRunnable
    extends BaseHazelcastInstanceAware
    implements SerializableRunnable,
    NamedTask {
        private static final long serialVersionUID = 1L;
        private Class<? extends RecurringTask> taskType;

        public HazelcastRecurringTaskRunnable(Class<? extends RecurringTask> clazz) {
            this.taskType = clazz;
        }

        public String getName() {
            return this.taskType.getName();
        }

        public void run() {
            RecurringTask recurringTask = this.recurringTaskHandler().getTask(this.taskType);
            LOG.debug("Running recurring task '{}'...", (Object)recurringTask.getName());
            recurringTask.run();
        }
    }

    private static class HazelcastDbLockKeepAliveTask
    extends BaseHazelcastInstanceAware
    implements SerializableRunnable,
    NamedTask {
        private static final long serialVersionUID = 1L;

        private HazelcastDbLockKeepAliveTask() {
        }

        public String getName() {
            return HazelcastClusterHandlerImpl.KEEP_ALIVE_TASK;
        }

        public void run() {
            this.dbLockHandler().keepalive(HazelcastClusterHandlerImpl.getHostId(this.instance.getCluster().getLocalMember()));
        }

        protected DbLockHandler dbLockHandler() {
            return ((NativeQueryHandler)this.applicationContext.getBean(NativeQueryHandler.class)).getDbLockHandler();
        }
    }

    private static class GetCurrentProfilingStatsTask
    extends BaseHazelcastInstanceAware
    implements Serializable,
    Callable<ClusterHostProfilingStats> {
        private static final long serialVersionUID = 1L;

        private GetCurrentProfilingStatsTask() {
        }

        @Override
        public ClusterHostProfilingStats call() throws Exception {
            return (ClusterHostProfilingStats)this.invokerHandler().runAs(SessionDataFactory.system(), () -> {
                HazelcastProfilingManager hazelcastProfilingManager = (HazelcastProfilingManager)((ClusterHandler)this.applicationContext.getBean(ClusterHandler.class)).getProfilingManager();
                ConversionHandler conversionHandler = (ConversionHandler)this.applicationContext.getBean(ConversionHandler.class);
                return (ClusterHostProfilingStats)conversionHandler.convert(ClusterHostProfilingStats.class, (Object)hazelcastProfilingManager.getProfiling());
            });
        }
    }

    private static class GetCurrentProfilingResultTask
    extends BaseHazelcastInstanceAware
    implements Serializable,
    Callable<ClusterHostProfilingResult> {
        private static final long serialVersionUID = 1L;

        private GetCurrentProfilingResultTask() {
        }

        @Override
        public ClusterHostProfilingResult call() throws Exception {
            return (ClusterHostProfilingResult)this.invokerHandler().runAs(SessionDataFactory.system(), () -> {
                HazelcastProfilingManager hazelcastProfilingManager = (HazelcastProfilingManager)((ClusterHandler)this.applicationContext.getBean(ClusterHandler.class)).getProfilingManager();
                return hazelcastProfilingManager.getProfiling();
            });
        }
    }

    private static class DoDispatchSubscriptionCallable
    extends BaseHazelcastInstanceAware
    implements Callable<Void> {
        private static final long serialVersionUID = 1L;
        private PushNotificationSubscription subscription;
        private PushNotificationEvent<?> event;

        public DoDispatchSubscriptionCallable(PushNotificationSubscription pushNotificationSubscription, PushNotificationEvent<?> pushNotificationEvent) {
            this.subscription = pushNotificationSubscription;
            this.event = pushNotificationEvent;
        }

        @Override
        public Void call() throws Exception {
            PushNotificationHandlerImplementor pushNotificationHandlerImplementor = this.pushNotificationHandler();
            pushNotificationHandlerImplementor.doDispatch(this.subscription, this.event);
            return null;
        }
    }

    private static class CacheStatsByMemberData {
        private CacheStatsVO stats;
        private long requestCount;
        private int memberCount;

        private CacheStatsByMemberData() {
        }

        public static CacheStatsByMemberData create(CacheStatsVO cacheStatsVO, long l) {
            CacheStatsByMemberData cacheStatsByMemberData = new CacheStatsByMemberData();
            cacheStatsByMemberData.requestCount = l;
            cacheStatsByMemberData.memberCount = 1;
            cacheStatsByMemberData.stats = cacheStatsVO;
            return cacheStatsByMemberData;
        }
    }

    private static abstract class BaseSystemMonitorTask<V>
    extends BaseHazelcastInstanceAware
    implements Serializable,
    Callable<V> {
        private static final long serialVersionUID = 1L;

        private BaseSystemMonitorTask() {
        }

        protected SystemMonitorServiceLocal systemMonitorService() {
            return (SystemMonitorServiceLocal)this.applicationContext.getBean(SystemMonitorServiceLocal.class);
        }
    }

    private static abstract class BaseHazelcastInstanceAware
    implements HazelcastInstanceAware,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected transient ApplicationContext applicationContext;
        protected transient HazelcastInstance instance;

        protected BaseHazelcastInstanceAware() {
        }

        public final void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.applicationContext = (ApplicationContext)hazelcastInstance.getUserContext().get(HazelcastClusterHandlerImpl.APPLICATION_CONTEXT_KEY);
            this.instance = hazelcastInstance;
        }

        protected BackgroundTaskHandlerImplementor backgroundTaskHandler() {
            return (BackgroundTaskHandlerImplementor)this.applicationContext.getBean(BackgroundTaskHandlerImplementor.class);
        }

        protected InvokerHandler invokerHandler() {
            return (InvokerHandler)this.applicationContext.getBean(InvokerHandler.class);
        }

        protected PushNotificationHandlerImplementor pushNotificationHandler() {
            return (PushNotificationHandlerImplementor)this.applicationContext.getBean(PushNotificationHandlerImplementor.class);
        }

        protected RecurringTaskHandlerImplementor recurringTaskHandler() {
            return (RecurringTaskHandlerImplementor)this.applicationContext.getBean(RecurringTaskHandlerImplementor.class);
        }
    }
}

