/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.cyclos.entities.contentmanagement.HasContentScript;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.DataTranslationPropertyMapping;
import org.cyclos.impl.messaging.ErrorLogServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationImageServiceLocal;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.ScriptHelper;
import org.cyclos.impl.utils.ContentProcessingAccessor;
import org.cyclos.impl.utils.HtmlSanitizerPolicy;
import org.cyclos.impl.utils.IdMask;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.impl.utils.thymeleaf.ThymeleafContext;
import org.cyclos.impl.utils.thymeleaf.ThymeleafTemplateEngine;
import org.cyclos.model.Bean;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.system.configurations.ConfigurationImageType;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.ExceptionHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.owasp.html.PolicyFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thymeleaf.exceptions.TemplateProcessingException;

@Component
public class RichTextHandlerImpl
extends BaseNetworkedHandlerImpl
implements RichTextHandler {
    private static final Pattern URL_PATTERN = Pattern.compile("(https?\\:\\/\\/([\\w|\\.|\\/|\\:]|\\?|\\=|\\&|\\#|\\;|\\-)+)", 2);
    private static final Pattern UNICODE_PATTERN = Pattern.compile("\\&\\#(\\d+)\\;");
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private RichTextHandler richTextHandler;
    @Autowired
    private ThymeleafTemplateEngine thymeleafTemplateEngine;
    @Autowired
    private ScriptHelper scriptHelper;
    @Autowired
    private ErrorLogServiceLocal errorLogService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private CustomScriptServiceLocal customScriptService;

    public String applyPropertyMapping(DataTranslationPropertyMapping dataTranslationPropertyMapping, String string, boolean bl) {
        if (bl) {
            if (!dataTranslationPropertyMapping.isPreventTrim()) {
                string = StringHelper.trimToNull((Object)string);
            }
            if (dataTranslationPropertyMapping.isRichText()) {
                return this.richTextHandler.sanitize(string);
            }
            return this.richTextHandler.escapeTags(string);
        }
        if (dataTranslationPropertyMapping.isRichText()) {
            return this.richTextHandler.replaceTagsByUrls(string);
        }
        return this.richTextHandler.unescapeTags(string);
    }

    public String escapeTags(String string) {
        return StringUtils.replace((String)string, (String)"<", (String)"< ");
    }

    public Map<String, Object> getBasicThymeleafBinding() {
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("sessionData", sessionData);
        hashMap.put("user", basicUser == null ? null : this.scriptHelper.wrap((Object)basicUser));
        hashMap.put("now", new Date());
        return hashMap;
    }

    public ContentProcessingAccessor newContentAccessor(HasContentScript hasContentScript) {
        return new ContentProcessingAccessorImpl(hasContentScript);
    }

    public String replaceTagsByUrls(String string) {
        return this.replaceTagsByUrls(string, null);
    }

    public String replaceTagsByUrls(String string, ConfigurationAccessor configurationAccessor) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (StringHelper.isBlank((Object)string)) {
            return string;
        }
        String string2 = this.getUrl(configurationAccessor);
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = TAG_PATTERN.matcher(string);
        while (matcher.find()) {
            String string3 = matcher.group(1);
            String string4 = this.urlForTag(string3, string2, configurationAccessor);
            if (string4 == null) continue;
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string4));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public String replaceUrlsByTags(String string) {
        return this.replaceUrlsByTags(string, null);
    }

    public String replaceUrlsByTags(String string, ConfigurationAccessor configurationAccessor) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (StringHelper.isBlank((Object)string)) {
            return string;
        }
        String string2 = this.getUrl(configurationAccessor);
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = URL_PATTERN.matcher(string);
        while (matcher.find()) {
            String string3;
            String string4 = matcher.group(1);
            if (string4.equals(string2) || !string4.endsWith("/") && (string4 + "/").equals(string2)) {
                matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement("#" + URLTag.ROOT.name() + "#"));
                continue;
            }
            if (!StringUtils.startsWithIgnoreCase((CharSequence)string4, (CharSequence)string2) || (string3 = this.tagForUrl(string2, string4)) == null) continue;
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string3));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public Map<String, Object> runContentHelperScript(HasContentScript hasContentScript, Object object, Property<?, ?> property) {
        Map map;
        if (hasContentScript != null && hasContentScript.getContentScript() != null && (map = (Map)this.customScriptService.newAccessor(hasContentScript.getContentScript(), hasContentScript.getContentScriptParameters()).bind("source", (Object)hasContentScript).bind("target", object).bind("property", (Object)(property == null ? null : property.getName())).run(Map.class)) != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    public String sanitize(String string) {
        return this.replaceUrlsByTags(this.doSanitize(string));
    }

    public boolean skipSanitization() {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(new Permission[]{Permission.SYSTEM_CONFIGURATION_MANAGE, Permission.SPECIFIC_CONFIGURATION_MANAGE, Permission.SPECIFIC_CONFIGURATION_MANAGE_CONTENT});
    }

    public String unescapeTags(String string) {
        return StringUtils.replace((String)string, (String)"< ", (String)"<");
    }

    private ThymeleafContext context(HasContentScript hasContentScript, Bean bean, Property<String, ?> property) {
        ThymeleafContext thymeleafContext = new ThymeleafContext();
        thymeleafContext.setVariables(this.getBasicThymeleafBinding());
        thymeleafContext.setVariables(this.runContentHelperScript(hasContentScript, bean, property));
        return thymeleafContext;
    }

    private String doSanitize(String string) {
        String string2;
        if (StringUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (StringHelper.isBlank((Object)string)) {
            return string;
        }
        if (this.skipSanitization()) {
            string2 = string;
        } else {
            SessionData sessionData = this.getSessionData();
            PolicyFactory policyFactory = sessionData.isAdmin() ? HtmlSanitizerPolicy.adminsPolicy() : HtmlSanitizerPolicy.usersPolicy();
            string2 = StringHelper.trimToNull((Object)policyFactory.sanitize(string));
        }
        return string2;
    }

    private String getUrl(ConfigurationAccessor configurationAccessor) {
        SessionData sessionData = this.getSessionData();
        String string = null;
        if (configurationAccessor == null || configurationAccessor == sessionData.getConfiguration()) {
            string = sessionData.getRequestData().getBaseUrl();
        }
        if (StringHelper.isBlank((Object)string) && configurationAccessor != null) {
            string = configurationAccessor.getFullUrl();
        }
        return string;
    }

    private String tagForUrl(String string, String string2) {
        for (URLTag uRLTag : URLTag.values()) {
            String string3;
            int n;
            String string4;
            int n2;
            String string5 = uRLTag.path();
            int n3 = n2 = string5 == null ? 0 : StringUtils.indexOfIgnoreCase((CharSequence)string2, (CharSequence)string5);
            if (string5 != null && n2 < 0) continue;
            if (string5 == null) {
                if (!string2.startsWith(string)) {
                    return string2;
                }
                String string6 = string2.substring(string.length());
                return "#" + uRLTag.name() + "#/" + StringUtils.removeStart((String)string6, (String)"/");
            }
            try {
                string4 = URLDecoder.decode(string2.substring(n2 + string5.length()).replace('\\', '/'), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException(unsupportedEncodingException);
            }
            StringBuffer stringBuffer = new StringBuffer();
            Matcher matcher = UNICODE_PATTERN.matcher(string4);
            while (matcher.find()) {
                try {
                    n = Integer.parseInt(matcher.group(1));
                    matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(String.valueOf((char)n)));
                }
                catch (Exception exception) {}
            }
            matcher.appendTail(stringBuffer);
            string4 = stringBuffer.toString();
            n = string4.indexOf(63);
            String string7 = string3 = n < 0 ? null : string4.substring(n + 1);
            if (n >= 0) {
                string4 = string4.substring(0, n);
            }
            return "#" + uRLTag.name() + ":" + uRLTag.tagParameters(StringUtils.split((String)string4, (char)'/'), string3) + "#";
        }
        return string2;
    }

    private String urlForTag(String string, String string2, ConfigurationAccessor configurationAccessor) {
        Object[] objectArray = string.replace("#", "").replace("#", "").split(":");
        if (objectArray.length > 0) {
            URLTag uRLTag;
            try {
                uRLTag = URLTag.valueOf(objectArray[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                uRLTag = null;
            }
            if (uRLTag == URLTag.ROOT) {
                return StringUtils.removeEnd((String)string2, (String)"/");
            }
            if (uRLTag != null) {
                String[] stringArray = (String[])ArrayUtils.subarray((Object[])objectArray, (int)1, (int)objectArray.length);
                String string3 = uRLTag.urlSuffix(stringArray, configurationAccessor == null ? null : configurationAccessor.getConfiguration(), this.applicationHandler.getIdMask());
                return string2 + uRLTag.path() + (string3 == null ? "" : string3);
            }
        }
        return string;
    }

    private class ContentProcessingAccessorImpl
    implements ContentProcessingAccessor {
        private final HasContentScript source;
        private BasicUser user;
        private Bean target;
        private Property<String, ?> property;
        private Function<String, Object> variablesFunction;
        private Map<String, Object> thymeleafBindings;

        private ContentProcessingAccessorImpl(HasContentScript hasContentScript) {
            this.source = hasContentScript;
        }

        public ContentProcessingAccessor addThymeleafBinding(String string, Object object) {
            return this.addThymeleafBindings(Collections.singletonMap(string, object));
        }

        public ContentProcessingAccessor addThymeleafBindings(Map<String, Object> map) {
            if (this.thymeleafBindings == null) {
                this.thymeleafBindings = new HashMap<String, Object>();
            }
            this.thymeleafBindings.putAll(map);
            return this;
        }

        public String process(String string) {
            SessionData sessionData = RichTextHandlerImpl.this.getSessionData();
            if (StringHelper.isThymeleaf((String)string)) {
                try {
                    ThymeleafContext thymeleafContext = RichTextHandlerImpl.this.context(this.source, this.target, this.property);
                    if (CollectionHelper.isNotEmpty(this.thymeleafBindings)) {
                        thymeleafContext.setVariables(this.thymeleafBindings);
                    }
                    string = RichTextHandlerImpl.this.thymeleafTemplateEngine.process(string, thymeleafContext);
                }
                catch (TemplateProcessingException templateProcessingException) {
                    TemplateProcessingException templateProcessingException2 = (TemplateProcessingException)ExceptionHelper.findCause((Throwable)templateProcessingException.getCause(), TemplateProcessingException.class);
                    String string2 = templateProcessingException2 == null || templateProcessingException2.getLine() == null ? "" : " (line " + templateProcessingException2.getLine() + ")";
                    String string3 = string;
                    RichTextHandlerImpl.this.invokerHandler.submitAsInParallelTransaction(sessionData, TransactionLevel.READ_WRITE, transactionStatus -> RichTextHandlerImpl.this.errorLogService.create("Thymeleaf" + string2, string3, ExceptionUtils.getStackTrace((Throwable)templateProcessingException), sessionData.getChannel(), sessionData.getLoggedBasicUser()));
                    string = RichTextHandlerImpl.this.message(ContentManagementKeys.StaticContents.ERROR_THYMELEAF, new Object[0]);
                }
            }
            if (this.variablesFunction != null) {
                string = StringHelper.replaceVariables((String)string, (boolean)true, this.variablesFunction);
            }
            if (this.user == null) {
                this.user = sessionData.getLoggedBasicUser();
            }
            string = StringHelper.replaceVariables((String)string, (Function)RichTextHandlerImpl.this.profileFieldHandler.getUserVariablesFunction(this.user));
            return RichTextHandlerImpl.this.replaceTagsByUrls(string, this.user == null ? sessionData.getConfiguration() : RichTextHandlerImpl.this.configurationHandler.getAccessor(this.user));
        }

        public ContentProcessingAccessor setConversionContext(Bean bean, Property<String, ?> property) {
            this.target = bean;
            this.property = property;
            return this;
        }

        public ContentProcessingAccessor setUser(BasicUser basicUser) {
            this.user = basicUser;
            return this;
        }

        public ContentProcessingAccessor setVariablesFunction(Function<String, Object> function) {
            this.variablesFunction = function;
            return this;
        }
    }

    public static enum URLTag {
        CURRENT_CONFIGURATION("/content/images/currentConfiguration/"){

            @Override
            public String tagParameters(String[] stringArray, String string) {
                return (String)CollectionHelper.first((Object[])stringArray);
            }

            @Override
            public String urlSuffix(String[] stringArray, Configuration configuration, IdMask idMask) {
                ConfigurationImageType configurationImageType;
                try {
                    configurationImageType = ConfigurationImageType.valueOf((String)((String)CollectionHelper.first((Object[])stringArray)));
                }
                catch (Exception exception) {
                    return null;
                }
                ConfigurationImageServiceLocal configurationImageServiceLocal = (ConfigurationImageServiceLocal)InvocationContext.bean(ConfigurationImageServiceLocal.class);
                String string = configurationImageServiceLocal.getCurrentUrl(configuration, configurationImageType);
                return StringUtils.substringAfterLast((String)string, (String)this.path());
            }
        }
        ,
        CONFIGURATION("/content/images/configuration/"),
        IMAGE("/content/images/"),
        USER("/content/images/"),
        USER_CUSTOM("/content/images/"),
        AD("/content/images/"),
        SYSTEM_CUSTOM("/content/images/"),
        ROOT(null);

        private final String path;

        private URLTag(String string2) {
            this.path = string2;
        }

        public String path() {
            return this.path;
        }

        public String tagParameters(String[] stringArray, String string) {
            return StringHelper.join((Object[])stringArray, (String)":");
        }

        public String urlSuffix(String[] stringArray, Configuration configuration, IdMask idMask) {
            return StringUtils.join((Object[])stringArray, (char)'/');
        }
    }
}

