/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.cyclos.server.utils.IOHelper;

public class CustomResourceBundleControl
extends ResourceBundle.Control {
    private static final CustomResourceBundleControl INSTANCE_NO_CACHE = new CustomResourceBundleControl(false);
    private static final CustomResourceBundleControl INSTANCE = new CustomResourceBundleControl(true);
    private final boolean disableCache;

    public static CustomResourceBundleControl getInstance(boolean bl) {
        return bl ? INSTANCE_NO_CACHE : INSTANCE;
    }

    private CustomResourceBundleControl(boolean bl) {
        this.disableCache = bl;
    }

    @Override
    public Locale getFallbackLocale(String string, Locale locale) {
        return null;
    }

    @Override
    public List<String> getFormats(String string) {
        return FORMAT_PROPERTIES;
    }

    @Override
    public long getTimeToLive(String string, Locale locale) {
        return this.disableCache ? -1L : super.getTimeToLive(string, locale);
    }

    @Override
    public boolean needsReload(String string, Locale locale, String string2, ClassLoader classLoader, ResourceBundle resourceBundle, long l) {
        if (this.disableCache) {
            return true;
        }
        return super.needsReload(string, locale, string2, classLoader, resourceBundle, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
        String string3 = this.toBundleName(string, locale);
        PropertyResourceBundle propertyResourceBundle = null;
        ClassLoader classLoader2 = classLoader;
        String string4 = this.toResourceName(string3, "properties");
        InputStream inputStream = classLoader2.getResourceAsStream(string4);
        if (inputStream != null) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            try {
                propertyResourceBundle = new PropertyResourceBundle(inputStreamReader);
            }
            catch (Throwable throwable) {
                IOHelper.close((Closeable[])new Closeable[]{inputStreamReader, inputStream});
                throw throwable;
            }
            IOHelper.close((Closeable[])new Closeable[]{inputStreamReader, inputStream});
        }
        return propertyResourceBundle;
    }
}

