/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cyclos.entities.users.Product;
import org.cyclos.impl.users.SinglePermissionHandlerImpl;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.users.products.ActiveProductsData;
import org.cyclos.model.users.products.ProductDTO;
import org.cyclos.model.users.products.ViewManageOperation;
import org.cyclos.utils.MessageKey;

public class ViewManagePermissionHandlerImpl<P extends Product, DTO extends ProductDTO, AD extends ActiveProductsData>
extends SinglePermissionHandlerImpl<ViewManageOperation, P, DTO, AD> {
    private final Permission viewPermission;
    private final Permission managePermission;

    public ViewManagePermissionHandlerImpl(Permission permission, Permission permission2, Property<ViewManageOperation, ? super DTO> property, Property<ViewManageOperation, ? super AD> property2, MessageKey messageKey) {
        super(property, property2, messageKey);
        this.viewPermission = permission;
        this.managePermission = permission2;
    }

    public ViewManageOperation getOperation(Permission permission) {
        return this.readOperation(Collections.singletonList(permission));
    }

    public List<Permission> getPermissions() {
        return Arrays.asList(this.viewPermission, this.managePermission);
    }

    @Override
    public ViewManageOperation getValue(P p) {
        return this.readOperation(p.getPermissions());
    }

    public void readPermissions(Collection<Permission> collection, AD AD) {
        ViewManageOperation viewManageOperation = this.readOperation(collection);
        AD.set(this.dataProperty, (Object)viewManageOperation);
    }

    public void readPermissions(Collection<Permission> collection, DTO DTO) {
        ViewManageOperation viewManageOperation = this.readOperation(collection);
        DTO.set(this.dtoProperty, (Object)viewManageOperation);
    }

    public void writePermissions(DTO DTO, Collection<Permission> collection) {
        ViewManageOperation viewManageOperation = (ViewManageOperation)DTO.get(this.dtoProperty);
        if (ViewManageOperation.isAccessible((ViewManageOperation)viewManageOperation)) {
            collection.add(this.viewPermission);
        } else {
            collection.remove(this.viewPermission);
        }
        if (viewManageOperation == ViewManageOperation.MANAGE) {
            collection.add(this.managePermission);
        } else {
            collection.remove(this.managePermission);
        }
    }

    private ViewManageOperation readOperation(Collection<Permission> collection) {
        if (collection.contains(this.managePermission)) {
            return ViewManageOperation.MANAGE;
        }
        if (collection.contains(this.viewPermission)) {
            return ViewManageOperation.VIEW;
        }
        return ViewManageOperation.NONE;
    }
}

