/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.google.common.collect.Sets;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.marketplace.QBasicAd;
import org.cyclos.entities.system.AddressConfiguration;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.users.AddressContactInfo;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.ContactInfo;
import org.cyclos.entities.users.ContactInfoField;
import org.cyclos.entities.users.ContactInfoFieldValue;
import org.cyclos.entities.users.GeoLocatedAddress;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.QContactInfoFieldValue;
import org.cyclos.entities.users.QUserAddress;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.search.UserSearchHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.LocalizationServiceLocal;
import org.cyclos.impl.users.ContactInfoFieldServiceLocal;
import org.cyclos.impl.users.ContactInfoServiceLocal;
import org.cyclos.impl.users.GoogleMapsGeocoder;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.UserAddressServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.UserAddressExtensionPointEvent;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.ModelWithCustomValues;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.addresses.AddressDTO;
import org.cyclos.model.users.addresses.AddressFields;
import org.cyclos.model.users.addresses.GeoLocatedAddressDTO;
import org.cyclos.model.users.addresses.IAddress;
import org.cyclos.model.users.addresses.ManageAddressConfirmationField;
import org.cyclos.model.users.addresses.UserAddressDTO;
import org.cyclos.model.users.addresses.UserAddressData;
import org.cyclos.model.users.addresses.UserAddressDataParams;
import org.cyclos.model.users.addresses.UserAddressListData;
import org.cyclos.model.users.addresses.UserAddressVO;
import org.cyclos.model.users.contactinfos.AddressContactInfoDTO;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.FieldVisibility;
import org.cyclos.model.utils.SearchByDistanceData;
import org.cyclos.utils.AddressHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.ValidationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserAddressServiceImpl
extends CRUDServiceImpl<UserAddress, QUserAddress, UserAddressDTO, UserAddressData, UserAddressDataParams>
implements UserAddressServiceLocal {
    private static final Object[] EXCLUDED_PROPERTIES = new Object[]{UserAddressDTO.CONTACT_INFO};
    @Autowired
    private LocalizationServiceLocal localizationService;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private UserSearchHandler userSearchHandler;
    @Autowired
    private GoogleMapsGeocoder geocoder;
    @Autowired
    private ContactInfoServiceLocal contactInfoService;
    @Autowired
    private ContactInfoFieldServiceLocal contactInfoFieldService;

    public UserAddressServiceImpl() {
        super(UserAddress.class, QUserAddress.userAddress, UserAddressDTO.class);
    }

    public void appendValidations(Validator validator, AddressDTO addressDTO, ConfigurationAccessor configurationAccessor, boolean bl) {
        if (bl && addressDTO instanceof GeoLocatedAddressDTO) {
            validator.property((Property)GeoLocatedAddressDTO.NAME, GeneralKeys.Ui.NAME).required();
        }
        Set set = configurationAccessor.getAddressConfiguration().getEnabledAddressFields();
        Set set2 = configurationAccessor.getAddressConfiguration().getRequiredAddressFields();
        for (AddressFields addressFields : set) {
            Property property = AddressHelper.getDTOPropertyForField((AddressFields)addressFields);
            MessageKey messageKey = AddressHelper.resolveKey((Collection)set, (AddressFields)addressFields);
            org.cyclos.impl.utils.validation.Property property2 = validator.property(property, messageKey);
            property2.maxWordSize(100);
            if (set2.contains(addressFields)) {
                property2.required();
            }
            if (addressFields != AddressFields.COUNTRY) continue;
            property2.anyOf((Collection)this.localizationService.getCountryCodes());
        }
    }

    public void cleanDisabledAddressFields(IAddress iAddress, ConfigurationAccessor configurationAccessor) {
        AddressConfiguration addressConfiguration = configurationAccessor.getAddressConfiguration();
        Set set = addressConfiguration.getEnabledAddressFields();
        Sets.SetView setView = Sets.difference((Set)Sets.newHashSet((Object[])AddressFields.values()), (Set)set);
        for (AddressFields addressFields : setView) {
            AddressHelper.setValue((AddressFields)addressFields, (IAddress)iAddress, null);
        }
    }

    public int count(User user) {
        if (user == null || user.isTransient()) {
            return 0;
        }
        return this.getBaseQuery(user, false).count(((QUserAddress)this.$).id);
    }

    public List<UserAddressVO> getAddresses(User user, boolean bl, boolean bl2) {
        DBQuery<?> dBQuery = this.from();
        dBQuery.where((Predicate)((QUserAddress)this.$).user().eq((Object)user));
        if (bl) {
            dBQuery.where((Predicate)((QUserAddress)this.$).hidden.eq(Boolean.valueOf(false)));
        }
        if (bl2) {
            dBQuery.where(new Predicate[]{((QUserAddress)this.$).location().latitude.isNotNull(), ((QUserAddress)this.$).location().longitude.isNotNull()});
        }
        dBQuery.orderBy(new OrderSpecifier[]{((QUserAddress)this.$).defaultAddress.desc(), ((QUserAddress)this.$).name.asc()});
        return dBQuery.list(UserAddressVO.class, (Expression)this.$);
    }

    public UserAddressListData getAddressListData(UserLocatorVO userLocatorVO) {
        SessionData sessionData = this.getSessionData();
        UserAddressListData userAddressListData = new UserAddressListData();
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        boolean bl = this.contactInfoService.canHaveContactInfos(user);
        Set set = this.profileFieldHandler.getFieldActions((BasicUser)user, (ProfileField)BasicProfileField.ADDRESS);
        boolean bl2 = set.contains(ProfileFieldAction.EDIT);
        boolean bl3 = set.contains(ProfileFieldAction.MANAGE_PRIVACY);
        userAddressListData.setAddresses(this.conversionHandler.convertList(UserAddressVO.class, this.listByUser(user)));
        userAddressListData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        userAddressListData.setCanCreateAddress(bl2 && !this.maxAddressesReached(user));
        userAddressListData.setContactInfoEnabled(bl);
        if (sessionData.manages((BasicUser)user)) {
            ProductAccessor productAccessor = this.productsHandler.getAccessor((BasicUser)user).product();
            userAddressListData.setMaxAddresses(Integer.valueOf(productAccessor.getMaxAddresses()));
        }
        userAddressListData.setManagesAddresses(bl2);
        userAddressListData.setEnablePrivacy(this.profileFieldHandler.enablePrivacy((BasicUser)user));
        userAddressListData.setCanManagePrivacy(bl3);
        userAddressListData.setAddressRequired(this.configurationHandler.getAccessor((BasicUser)user).isRequiredAddress());
        return userAddressListData;
    }

    public UserAddress getDefaultUserAddress(User user) throws FrameworkException {
        if (CollectionHelper.isNotEmpty((Iterable)user.getAddresses())) {
            for (UserAddress userAddress : user.getAddresses()) {
                if (!userAddress.isDefaultAddress()) continue;
                return userAddress;
            }
        }
        return null;
    }

    public SearchByDistanceData getSearchByDistanceData() throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        User user = sessionData.getLoggedUser();
        if (!configurationAccessor.isUseMap()) {
            return null;
        }
        SearchByDistanceData searchByDistanceData = (SearchByDistanceData)this.conversionHandler.convert(SearchByDistanceData.class, (Object)configurationAccessor);
        if (user != null) {
            searchByDistanceData.setAddresses(this.getAddresses(user, false, false));
        }
        if (user != null) {
            searchByDistanceData.setCanCreateAddresses(this.profileFieldHandler.isAllowed((BasicUser)user, (ProfileField)BasicProfileField.ADDRESS, ProfileFieldAction.EDIT) && sessionData.getProducts().product().getMaxAddresses() > 0 && (!user.isGlobal() || sessionData.getNetwork() == null));
        }
        return searchByDistanceData;
    }

    public Validator getValidator(AddressDTO addressDTO, Group group, boolean bl) {
        Validator validator = new Validator();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)group);
        this.appendValidations(validator, addressDTO, configurationAccessor, bl);
        return validator;
    }

    public List<UserAddress> listByUser(User user) {
        if (user == null || user.isTransient()) {
            return Collections.emptyList();
        }
        return ((DBQuery)this.getBaseQuery(user, true).orderBy(new OrderSpecifier[]{((QUserAddress)this.$).defaultAddress.desc(), ((QUserAddress)this.$).name.asc()})).list((Expression)this.$);
    }

    public void markAsDefault(Long l) throws FrameworkException {
        UserAddress userAddress = this.find(UserAddress.class, l);
        User user = userAddress.getUser();
        DBQuery<?> dBQuery = this.from();
        if (QueryHelper.useParameter((Object)user)) {
            dBQuery.where((Predicate)((QUserAddress)this.$).user().eq((Object)user));
        }
        List list = dBQuery.list(UserAddress.class, (Expression)this.$);
        for (UserAddress userAddress2 : list) {
            if (userAddress2.getId().equals(l)) {
                userAddress2.setDefaultAddress(true);
            } else {
                userAddress2.setDefaultAddress(false);
            }
            this.persist((IEntity)userAddress2);
        }
    }

    public boolean maxAddressesReached(User user) throws FrameworkException {
        int n = this.productsHandler.getAccessor((BasicUser)user).product().getMaxAddresses();
        return n <= user.getAddresses().size();
    }

    @Override
    public UserAddress newEntity(UserAddressDataParams userAddressDataParams) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)userAddressDataParams.getUser());
        Group group = (Group)this.conversionHandler.convert(Group.class, (Object)userAddressDataParams.getGroup());
        if (user == null) {
            user = new User(group);
        }
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        UserAddress userAddress = new UserAddress();
        userAddress.setUser(user);
        userAddress.setCity(configurationAccessor.getDefaultCity());
        userAddress.setCountry(configurationAccessor.getCountry());
        userAddress.setRegion(configurationAccessor.getDefaultRegion());
        userAddress.setHidden(configurationAccessor.getDefaultAddressPrivacy() == FieldVisibility.HIDDEN);
        if (userAddressDataParams.isSuggestAddressName()) {
            userAddress.setName(this.getDefaultAddressName(userAddress));
        }
        if (this.contactInfoService.canHaveContactInfos(user)) {
            AddressContactInfo addressContactInfo = new AddressContactInfo();
            addressContactInfo.setUser(user);
            addressContactInfo.setAddress(userAddress);
            userAddress.setContactInfo(addressContactInfo);
        }
        return userAddress;
    }

    public void removeAll(User user) {
        CloseableIterator closeableIterator = ((DBQuery)this.from().where((Predicate)((QUserAddress)this.$).user().eq((Object)user))).iterate((Expression)this.$);
        this.processBatch(closeableIterator, this::remove);
    }

    @Override
    public UserAddress toEntity(UserAddressDTO userAddressDTO) {
        UserAddress userAddress = (UserAddress)super.toEntity(userAddressDTO);
        AddressContactInfo addressContactInfo = userAddress.getContactInfo();
        AddressContactInfoDTO addressContactInfoDTO = userAddressDTO.getContactInfo();
        if (addressContactInfoDTO == null || !this.contactInfoService.canHaveContactInfos(userAddress.getUser())) {
            if (addressContactInfo != null) {
                userAddress.setContactInfo(null);
                this.remove(addressContactInfo);
            }
        } else if (addressContactInfoDTO != null) {
            if (addressContactInfo == null) {
                addressContactInfo = new AddressContactInfo(userAddress);
                userAddress.setContactInfo(addressContactInfo);
            } else if (addressContactInfo.getUser() == null || !addressContactInfo.getUser().equals((Object)userAddress.getUser())) {
                throw new IllegalActionException("Users don't match among address and contact info");
            }
            this.conversionHandler.fillExcluding((Object)addressContactInfoDTO, (Object)addressContactInfo, new Object[]{EntityDTO.ID, EntityDTO.VERSION, AddressContactInfoDTO.CUSTOM_VALUES});
            List list = this.contactInfoFieldService.listEnabled(userAddress.getUser());
            this.customFieldValueHandler.setCustomValues((SimpleEntity)addressContactInfo, (Collection)list, (Collection)list, (Collection)addressContactInfoDTO.getCustomValues());
        }
        return userAddress;
    }

    @Override
    protected void addCustomNameValidations(org.cyclos.impl.utils.validation.Property property, UserAddressDTO userAddressDTO) {
        property.maxWordSize(50);
    }

    @Override
    protected void doRemove(UserAddress userAddress, boolean bl) {
        AddressContactInfo addressContactInfo = userAddress.getContactInfo();
        if (addressContactInfo != null) {
            this.customFieldValueHandler.removeAll((EntityWithCustomValues)addressContactInfo);
            this.remove(addressContactInfo);
            userAddress.setContactInfo(null);
        }
        super.doRemove(userAddress, bl);
    }

    @Override
    protected UserAddressData getData(UserAddress userAddress) {
        User user = userAddress.getUser();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        UserAddressData userAddressData = new UserAddressData();
        userAddressData.setDto((EntityDTO)((UserAddressDTO)this.toDTO(userAddress)));
        userAddressData.setConfiguration(this.configurationService.toAddressConfiguration(configurationAccessor));
        Set set = this.profileFieldHandler.getFieldActions((BasicUser)user, (ProfileField)BasicProfileField.ADDRESS);
        boolean bl = set.contains(ProfileFieldAction.MANAGE_PRIVACY);
        userAddressData.setCanManagePrivacy(bl);
        userAddressData.setEditable(set.contains(ProfileFieldAction.EDIT));
        userAddressData.setEnablePrivacy(this.profileFieldHandler.enablePrivacy((BasicUser)user));
        userAddressData.setCanOnlySetPrivate(userAddressData.isEnablePrivacy() && !userAddressData.isEditable() && bl);
        userAddressData.setContactInfoEnabled(this.contactInfoService.canHaveContactInfos(user));
        if (userAddressData.isContactInfoEnabled()) {
            AddressContactInfo addressContactInfo = userAddress.getContactInfo();
            if (addressContactInfo == null) {
                addressContactInfo = new AddressContactInfo(userAddress);
                ((UserAddressDTO)userAddressData.getDto()).setContactInfo(new AddressContactInfoDTO());
            }
            List list = this.conversionHandler.convertList(CustomFieldDetailedVO.class, (Iterable)this.contactInfoFieldService.listEnabled(user));
            list.forEach(customFieldDetailedVO -> customFieldDetailedVO.setRequired(false));
            HashMap<String, AddressContactInfo> hashMap = new HashMap<String, AddressContactInfo>();
            hashMap.put("contactInfo", addressContactInfo);
            this.customFieldValueHandler.fillValuesFromScript(ContactInfoField.class, LoadValuesScriptFunction.ENTITY, hashMap, (Collection)list);
            userAddressData.setContactInfoFields(list);
            this.customFieldValueHandler.setDefaultValues(list, (ModelWithCustomValues)((UserAddressDTO)userAddressData.getDto()).getContactInfo());
            userAddressData.setPhoneConfiguration(this.configurationService.toPhoneConfiguration(configurationAccessor));
        }
        return userAddressData;
    }

    @Override
    protected CreateDeviceConfirmationParams getDeviceConfirmationParams(UserAddressDTO userAddressDTO, UserAddress userAddress, CRUDOperation cRUDOperation) {
        return ManageAddressConfirmationField.confirmation((String)(userAddressDTO != null ? userAddressDTO.getName() : userAddress.getName()));
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(UserAddressDTO userAddressDTO) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected void onAfterRemove(UserAddress userAddress) {
        userAddress.getUser().getAddresses().remove(userAddress);
        this.userSearchHandler.updateUserFields(userAddress.getUser());
    }

    @Override
    protected void onAfterSave(UserAddress userAddress, UserAddress userAddress2, Object object) {
        User user = userAddress.getUser();
        if (userAddress2 == null) {
            user.getAddresses().add(userAddress);
        }
        this.userSearchHandler.updateUserFields(user);
        if (userAddress.getContactInfo() != null) {
            this.customFieldValueHandler.processAfterSave((EntityWithCustomValues)userAddress.getContactInfo());
        }
    }

    @Override
    protected void onBeforeRemove(UserAddress userAddress) {
        User user = userAddress.getUser();
        Object object = user.getContactInfos().iterator();
        while (object.hasNext()) {
            ContactInfo contactInfo = (ContactInfo)object.next();
            if (!userAddress.equals((Object)contactInfo.getAddress())) continue;
            contactInfo.setAddress(null);
        }
        if (!user.isPurged()) {
            long l;
            if (this.profileFieldHandler.isEnabled((BasicUser)user, (ProfileField)BasicProfileField.ADDRESS) && (object = this.configurationHandler.getAccessor((BasicUser)user)).isRequiredAddress() && (l = this.getAddressCount(user)) <= 1L) {
                throw new ValidationException(new ValidationResult(this.translationHandler.message(UsersKeys.Addresses.CANNOT_DELETE, new Object[0])));
            }
            if (userAddress.isDefaultAddress()) {
                object = user.getAddresses();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    UserAddress userAddress2 = (UserAddress)iterator.next();
                    if (userAddress2.equals((Object)userAddress)) continue;
                    userAddress2.setDefaultAddress(true);
                    break;
                }
            }
        }
    }

    @Override
    protected Object onBeforeSave(UserAddress userAddress, UserAddress userAddress2) {
        long l;
        int n;
        User user = userAddress.getUser();
        if (!this.profileFieldHandler.enablePrivacy((BasicUser)user)) {
            userAddress.setHidden(true);
        }
        userAddress.setLastModified(new Date());
        if (userAddress.isTransient()) {
            n = this.productsHandler.getAccessor((BasicUser)user).product().getMaxAddresses();
            long l2 = this.getAddressCount(user);
            if (l2 >= (long)n) {
                throw new MaxItemsException(n);
            }
        }
        this.cleanDisabledAddressFields((IAddress)userAddress, this.configurationHandler.getAccessor((BasicUser)user));
        if (userAddress.isDefaultAddress()) {
            for (UserAddress userAddress3 : user.getAddresses()) {
                if (!userAddress3.isDefaultAddress() || userAddress3.equals((Object)userAddress)) continue;
                userAddress3.setDefaultAddress(false);
            }
        } else {
            n = 0;
            for (UserAddress userAddress4 : user.getAddresses()) {
                if (!userAddress4.isDefaultAddress() || userAddress4.equals((Object)userAddress)) continue;
                n = 1;
                break;
            }
            userAddress.setDefaultAddress(n == 0);
        }
        if (!userAddress.isLocated()) {
            try {
                GoogleMapsGeocoder.LocalizationStatus localizationStatus = this.geocoder.geocode((GeoLocatedAddress)userAddress);
                userAddress.setGeocodeFailed(localizationStatus == GoogleMapsGeocoder.LocalizationStatus.FAILED);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (userAddress.isTransient() && (l = this.getAddressCount(user)) == 0L) {
            userAddress.setDefaultAddress(true);
        }
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(UserAddressDTO userAddressDTO, UserAddress userAddress) {
        AddressContactInfo addressContactInfo = userAddress.getContactInfo();
        if (addressContactInfo != null) {
            for (ContactInfoFieldValue contactInfoFieldValue : addressContactInfo.getCustomValues()) {
                switch (contactInfoFieldValue.getField().getType()) {
                    case SINGLE_SELECTION: 
                    case MULTI_SELECTION: {
                        contactInfoFieldValue.getEnumeratedValues().size();
                        break;
                    }
                    case FILE: {
                        contactInfoFieldValue.getFileValues().size();
                        break;
                    }
                    case IMAGE: {
                        contactInfoFieldValue.getImageValues().size();
                        break;
                    }
                }
            }
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QUserAddress)this.$).user().network());
    }

    @Override
    protected ExtensionPointAccessor resolveExtensionPointAccessor(CRUDOperation cRUDOperation, UserAddress userAddress) {
        UserAddressExtensionPointEvent userAddressExtensionPointEvent;
        try {
            userAddressExtensionPointEvent = UserAddressExtensionPointEvent.valueOf((String)cRUDOperation.name());
        }
        catch (Exception exception) {
            return null;
        }
        return this.extensionPointService.newAccessor((ExtensionPointEvent)userAddressExtensionPointEvent, new ExtensionPointFilter(userAddress.getUser().getGroup())).attribute("address", (Object)userAddress);
    }

    @Override
    protected Validator resolveValidator(UserAddressDTO userAddressDTO) {
        Validator validator = new Validator();
        User user = userAddressDTO.isTransient() ? this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userAddressDTO.getUser()) : ((UserAddress)this.find(userAddressDTO.getId())).getUser();
        if (user != null) {
            this.appendValidations(validator, userAddressDTO, user);
        }
        return validator;
    }

    @Override
    protected boolean shouldCheckConfirmationPassword(UserAddress userAddress, CRUDOperation cRUDOperation) {
        return userAddress.getUser().equals((Object)this.getLoggedUser());
    }

    private void appendValidations(Validator validator, UserAddressDTO userAddressDTO, User user) {
        AddressContactInfoDTO addressContactInfoDTO;
        boolean bl;
        UserAddress userAddress;
        if (userAddressDTO.isPersistent()) {
            userAddress = (UserAddress)this.find(userAddressDTO.getId());
        } else {
            userAddress = new UserAddress();
            userAddress.setUser(user);
        }
        this.appendValidations(validator, (AddressDTO)userAddressDTO, this.configurationHandler.getAccessor((BasicUser)user), false);
        if (userAddressDTO.isLocated()) {
            validator.property((Property)UserAddressDTO.LOCATION, UsersKeys.Addresses.LOCATION).required().latLong();
        }
        QBasicAd qBasicAd = QBasicAd.basicAd;
        boolean bl2 = bl = userAddressDTO.isHidden() && ((DBQuery)this.from(new EntityPath[]{qBasicAd}).where((Predicate)qBasicAd.addresses.contains((Object)userAddress))).hasResults();
        if (bl) {
            validator.property((Property)UserAddressDTO.HIDDEN, GeneralKeys.Ui.FIELD_VISIBILITY).invalid(UsersKeys.Addresses.ERROR_CANNOT_HIDE);
        }
        if ((addressContactInfoDTO = userAddressDTO.getContactInfo()) != null) {
            AddressContactInfo addressContactInfo = addressContactInfoDTO.isPersistent() ? this.find(AddressContactInfo.class, addressContactInfoDTO.getId()) : new AddressContactInfo(userAddress);
            Validator validator2 = new Validator();
            validator.nested((Property)UserAddressDTO.CONTACT_INFO, validator2);
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
            validator2.property((Property)AddressContactInfoDTO.EMAIL, UsersKeys.ContactInfos.EMAIL).email();
            validator2.property((Property)AddressContactInfoDTO.MOBILE_PHONE, UsersKeys.ContactInfos.MOBILE_PHONE).phoneNumber(configurationAccessor, PhoneNature.MOBILE);
            validator2.property((Property)AddressContactInfoDTO.LAND_LINE_PHONE, UsersKeys.ContactInfos.LAND_LINE_PHONE).phoneNumber(configurationAccessor, PhoneNature.LANDLINE);
            org.cyclos.impl.utils.validation.Property property = validator2.property((Property)AddressContactInfoDTO.LAND_LINE_EXTENSION, UsersKeys.ContactInfos.LAND_LINE_EXTENSION);
            property.maxLength(6);
            if (StringHelper.isNotBlank((Object)addressContactInfoDTO.getLandLineExtension()) && StringHelper.isBlank((Object)addressContactInfoDTO.getLandLinePhone())) {
                property.invalid(UsersKeys.ContactInfos.ERROR_LAND_LINE_EXTENSION_NO_PHONE);
            }
            Map<String, AddressContactInfo> map = Collections.singletonMap("contactInfo", addressContactInfo);
            for (ContactInfoField contactInfoField : this.contactInfoFieldService.listEnabled(user)) {
                this.customFieldValueHandler.addValueValidationIgnoringRequired(validator2, (CustomField)contactInfoField, (EntityPathBase)QContactInfoFieldValue.contactInfoFieldValue, map);
            }
        }
    }

    private long getAddressCount(User user) {
        return ((DBQuery)this.from(this.$).where((Predicate)((QUserAddress)this.$).user().eq((Object)user))).count(((QUserAddress)this.$).id);
    }

    private DBQuery<?> getBaseQuery(User user, boolean bl) {
        DBQuery dBQuery = (DBQuery)this.from(this.$).where((Predicate)((QUserAddress)this.$).user().eq((Object)user));
        if (bl && !this.profileFieldHandler.canViewHidden((BasicUser)user)) {
            dBQuery.where((Predicate)((QUserAddress)this.$).hidden.isFalse());
        }
        return dBQuery;
    }

    private String getDefaultAddressName(UserAddress userAddress) {
        if (userAddress.getUser() == null) {
            return this.message(UsersKeys.Addresses.DEFAULT_ADDRESS_NAME, 1);
        }
        int n = this.count(userAddress.getUser());
        return this.message(UsersKeys.Addresses.DEFAULT_ADDRESS_NAME, n == 0 ? null : Integer.valueOf(n + 1)).trim();
    }
}

