/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.dsl.NumberPath;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.QBasePayment;
import org.cyclos.entities.banking.QPaymentTransferType;
import org.cyclos.impl.users.AbstractTransactionFeedbackRecurringTask;
import org.cyclos.impl.users.TransactionFeedbackServiceLocal;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransactionFeedbackExpiredRecurringTask
extends AbstractTransactionFeedbackRecurringTask {
    @Autowired
    private TransactionFeedbackServiceLocal transactionFeedbackService;

    public TransactionFeedbackExpiredRecurringTask() {
        super((NumberPath<Integer>)QPaymentTransferType.paymentTransferType.feedbackExpirationDays, QBasePayment.basePayment.feedbackExpirationNotified, false);
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.TRANSACTION_FEEDBACK_EXPIRED;
    }

    @Override
    protected void finish(BasePayment basePayment, Throwable throwable) throws Throwable {
        basePayment.setFeedbackExpirationNotified(Boolean.valueOf(true));
    }

    @Override
    protected void process(BasePayment basePayment) throws Throwable {
        this.transactionFeedbackService.createExpiredFeedback(basePayment);
    }
}

