/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserRecord;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.utils.conversion.ObjectConverter;
import org.cyclos.model.users.recordfields.RecordFieldAction;
import org.cyclos.model.users.records.RecordDTO;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecordDTOConverter
extends ObjectConverter<RecordDTO> {
    @Autowired
    private RecordFieldHandler recordFieldHandler;

    public RecordDTOConverter() {
        super(RecordDTO.class);
    }

    @Override
    protected void fill(Object object, RecordDTO recordDTO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        super.fill(object, recordDTO, objectArray, conversionContext);
        if (object instanceof Record) {
            List list;
            if (CollectionHelper.isEmpty((Iterable)recordDTO.getCustomValues())) {
                return;
            }
            Record record = (Record)object;
            if (object instanceof UserRecord) {
                UserRecord userRecord = (UserRecord)object;
                User user = userRecord.getUser();
                list = this.recordFieldHandler.getFieldsByAction((UserRecordType)userRecord.getType(), (BasicUser)user, RecordFieldAction.VIEW).stream().map(SimpleEntity::getId).collect(Collectors.toList());
            } else {
                list = this.recordFieldHandler.getSystemFieldsByAction((SystemRecordType)record.getType(), RecordFieldAction.VIEW).stream().map(SimpleEntity::getId).collect(Collectors.toList());
            }
            recordDTO.getCustomValues().removeIf(customFieldValueDTO -> !list.contains(customFieldValueDTO.getField().getId()));
        }
    }
}

