/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.BrokerProduct;
import org.cyclos.entities.users.IMemberOrBrokerProduct;
import org.cyclos.entities.users.IProduct;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.UserManagementProduct;
import org.cyclos.impl.users.AdminProductAccessor;
import org.cyclos.impl.users.BrokerProductAccessor;
import org.cyclos.impl.users.MemberOrBrokerProductAccessor;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.ProductsHandlerImpl;
import org.cyclos.impl.users.UserManagementProductAccessor;
import org.cyclos.utils.CollectionHelper;

public class ProductsAccessorImpl
implements ProductsAccessor {
    private final ProductsHandlerImpl handler;
    private final Map<ProductType, List<Product>> products;
    private final Map<UserAccountType, List<MemberProduct>> productsByAccountType;
    private Map<ProductType, Object> proxies = new EnumMap<ProductType, Object>(ProductType.class);
    private Map<UserAccountType, MemberProductAccessor> proxiesByAccountType = new HashMap<UserAccountType, MemberProductAccessor>();

    public ProductsAccessorImpl(ProductsHandlerImpl productsHandlerImpl, Collection<? extends Product> collection, Channel channel, PrincipalType principalType) {
        this.handler = productsHandlerImpl;
        Collection collection2 = channel != null || principalType != null ? (Collection)collection.stream().filter(product -> {
            if (channel != null && product.getChannelIds() != null && !("," + product.getChannelIds() + ",").contains("," + channel.getId() + ",")) {
                return false;
            }
            return principalType == null || product.getPrincipalTypeIds() == null || ("," + product.getPrincipalTypeIds() + ",").contains("," + principalType.getId() + ",");
        }).collect(Collectors.toList()) : collection;
        this.products = new EnumMap<ProductType, List<Product>>(ProductType.class);
        this.productsByAccountType = new HashMap<UserAccountType, List<MemberProduct>>();
        for (Product product2 : collection2) {
            ProductType productType2;
            EnumSet<ProductType> enumSet = ProductType.matching(product2);
            MemberProduct memberProduct = enumSet.iterator();
            while (memberProduct.hasNext()) {
                productType2 = (ProductType)((Object)memberProduct.next());
                this.products.computeIfAbsent(productType2, productType -> new LinkedList()).add(product2);
            }
            if (!(product2 instanceof MemberProduct) || (productType2 = (memberProduct = (MemberProduct)product2).getUserAccount()) == null) continue;
            this.productsByAccountType.computeIfAbsent((UserAccountType)productType2, userAccountType -> new LinkedList()).add(memberProduct);
        }
    }

    public AdminProductAccessor admin() {
        return (AdminProductAccessor)this.proxy(ProductType.ADMIN);
    }

    public BrokerProductAccessor broker() {
        return (BrokerProductAccessor)this.proxy(ProductType.BROKER);
    }

    public Collection<? extends Product> getProducts() {
        List<Product> list = this.products.get((Object)ProductType.PRODUCT);
        return CollectionHelper.isEmpty(list) ? Collections.emptyList() : Collections.unmodifiableCollection(list);
    }

    public MemberProductAccessor member() {
        return (MemberProductAccessor)this.proxy(ProductType.MEMBER);
    }

    public MemberProductAccessor member(UserAccountType userAccountType) {
        return this.proxy(userAccountType);
    }

    public MemberOrBrokerProductAccessor memberOrBroker() {
        return (MemberOrBrokerProductAccessor)this.proxy(ProductType.MEMBER_OR_BROKER);
    }

    public ProductAccessor product() {
        return this.proxy(ProductType.PRODUCT);
    }

    public UserManagementProductAccessor userManagement() {
        return (UserManagementProductAccessor)this.proxy(ProductType.USER_MANAGEMENT);
    }

    private <A extends ProductAccessor> A proxy(ProductType productType) {
        return (A)((ProductAccessor)this.proxies.computeIfAbsent(productType, productType2 -> this.handler.getProxy(productType.iface, (Collection<? extends Product>)this.products.get((Object)productType))));
    }

    private MemberProductAccessor proxy(UserAccountType userAccountType2) {
        return this.proxiesByAccountType.computeIfAbsent(userAccountType2, userAccountType -> (MemberProductAccessor)this.handler.getProxy(MemberProduct.class, (Collection<? extends Product>)this.productsByAccountType.get(userAccountType)));
    }

    private static enum ProductType {
        PRODUCT(Product.class),
        ADMIN(AdminProduct.class),
        MEMBER(MemberProduct.class),
        BROKER(BrokerProduct.class),
        USER_MANAGEMENT(UserManagementProduct.class),
        MEMBER_OR_BROKER(IMemberOrBrokerProduct.class);

        private final Class<? extends IProduct> iface;

        public static EnumSet<ProductType> matching(Product product) {
            EnumSet<ProductType> enumSet = EnumSet.of(PRODUCT);
            switch (product.getRole()) {
                case ADMIN: {
                    enumSet.add(ADMIN);
                    enumSet.add(USER_MANAGEMENT);
                    break;
                }
                case BROKER: {
                    enumSet.add(BROKER);
                    enumSet.add(USER_MANAGEMENT);
                    enumSet.add(MEMBER_OR_BROKER);
                    break;
                }
                case MEMBER: {
                    enumSet.add(MEMBER);
                    enumSet.add(MEMBER_OR_BROKER);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled product role for " + String.valueOf(product));
                }
            }
            return enumSet;
        }

        private ProductType(Class<? extends IProduct> clazz) {
            this.iface = clazz;
        }
    }
}

