/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.cyclos.entities.access.AccessClientPrincipalType;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.users.ContactCustomField;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProductMyAccessClient;
import org.cyclos.entities.users.ProductMyContactField;
import org.cyclos.entities.users.ProductMyProfileField;
import org.cyclos.entities.users.ProductMyRecordType;
import org.cyclos.entities.users.ProductQuickAccess;
import org.cyclos.entities.users.ProductTransferStatusFlow;
import org.cyclos.entities.users.ProductUserProfileField;
import org.cyclos.entities.users.QProduct;
import org.cyclos.entities.users.QuickAccess;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.PasswordTypeServiceLocal;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.banking.TransferStatusFlowServiceLocal;
import org.cyclos.impl.banking.VoucherConfigurationServiceLocal;
import org.cyclos.impl.users.BooleanPermissionHandlerImpl;
import org.cyclos.impl.users.CollectionPermissionHandlerImpl;
import org.cyclos.impl.users.ContactCustomFieldServiceLocal;
import org.cyclos.impl.users.EnumPermissionHandlerImpl;
import org.cyclos.impl.users.PermissionHandler;
import org.cyclos.impl.users.ProductConversionHandler;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.QuickAccessHandler;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.users.UserCustomFieldServiceLocal;
import org.cyclos.impl.users.ViewManagePermissionHandlerImpl;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.Role;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.access.principaltypes.AccessClientPrincipalTypeVO;
import org.cyclos.model.banking.transferfilters.TransferFilterWithAccountTypeVO;
import org.cyclos.model.banking.transferstatus.TransferStatusFlowVO;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.products.ActiveProductsData;
import org.cyclos.model.users.products.ActiveUserProductsData;
import org.cyclos.model.users.products.MyProductPasswordActionDTO;
import org.cyclos.model.users.products.ProductDTO;
import org.cyclos.model.users.products.ProductMyAccessClientDTO;
import org.cyclos.model.users.products.ProductMyContactFieldDTO;
import org.cyclos.model.users.products.ProductMyProfileFieldDTO;
import org.cyclos.model.users.products.ProductPasswordActionDTO;
import org.cyclos.model.users.products.ProductTransferStatusFlowDTO;
import org.cyclos.model.users.products.ProductUserProfileFieldDTO;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.products.UserProductPasswordActionDTO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.utils.QuickAccessDTO;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ProductConversionHandlerImpl<P extends Product, DTO extends ProductDTO, AD extends ActiveProductsData>
extends BaseNetworkedHandlerImpl
implements ProductConversionHandler<P, DTO, AD> {
    private final Class<P> entityType;
    private final Class<DTO> dtoType;
    private final Class<AD> activeDataType;
    private final List<PermissionHandler<DTO, AD>> permissionHandlers;
    private final Map<Property<?, ?>, String> propertyMapping;
    private final Map<Permission, String> additionalCollectionMapping;
    @Autowired
    protected ProductServiceLocal productService;
    @Autowired
    protected UserCustomFieldServiceLocal userCustomFieldService;
    @Autowired
    protected RecordFieldHandler recordFieldHandler;
    @Autowired
    protected PasswordTypeServiceLocal passwordTypeService;
    @Autowired
    protected TransferStatusFlowServiceLocal transferStatusFlowService;
    @Autowired
    protected RecordTypeServiceLocal recordTypeService;
    @Autowired
    protected PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    protected ContactCustomFieldServiceLocal contactCustomFieldService;
    @Autowired
    protected VoucherConfigurationServiceLocal voucherConfigurationService;
    @Autowired
    private QuickAccessHandler quickAccessHandler;

    public ProductConversionHandlerImpl(Class<P> clazz, Class<DTO> clazz2, Class<AD> clazz3) {
        this.entityType = clazz;
        this.dtoType = clazz2;
        this.activeDataType = clazz3;
        this.permissionHandlers = new ArrayList<PermissionHandler<DTO, AD>>();
        this.propertyMapping = new HashMap();
        this.additionalCollectionMapping = new HashMap<Permission, String>();
    }

    public void fill(Collection<Permission> collection, AD AD) {
        for (PermissionHandler<DTO, AD> permissionHandler : this.permissionHandlers) {
            permissionHandler.readPermissions(collection, AD);
        }
    }

    public Class<AD> getActiveDataType() {
        return this.activeDataType;
    }

    public String getAdditionalCollectionForPermission(Permission permission) {
        return this.additionalCollectionMapping.get(permission);
    }

    public Property<?, ?> getDtoCollectionProperty(Permission permission) {
        for (PermissionHandler<DTO, AD> permissionHandler : this.permissionHandlers) {
            CollectionPermissionHandlerImpl collectionPermissionHandlerImpl;
            if (!(permissionHandler instanceof CollectionPermissionHandlerImpl) || (collectionPermissionHandlerImpl = (CollectionPermissionHandlerImpl)permissionHandler).getPermissions().get(0) != permission) continue;
            return collectionPermissionHandlerImpl.getDTOProperty();
        }
        return null;
    }

    public Class<DTO> getDTOType() {
        return this.dtoType;
    }

    public Class<P> getEntityType() {
        return this.entityType;
    }

    public List<PermissionHandler<DTO, AD>> getPermissionHandlers() {
        return this.permissionHandlers;
    }

    public Collection<Permission> getPermissionsForProperty(Property<?, ?> property) {
        EnumSet<Permission> enumSet = EnumSet.noneOf(Permission.class);
        for (PermissionHandler<DTO, AD> permissionHandler : this.permissionHandlers) {
            if (!property.equals((Object)permissionHandler.getDTOProperty())) continue;
            enumSet.addAll(permissionHandler.getPermissions());
        }
        return enumSet;
    }

    public String getProductPropertyForDtoProperty(Property<?, ?> property) {
        String string = this.propertyMapping.get(property);
        return string == null ? property.getName() : string;
    }

    public void register(PermissionHandler<DTO, AD> permissionHandler) {
        this.permissionHandlers.add(permissionHandler);
    }

    @PostConstruct
    public void registerHandlers() {
        this.register(new EnumPermissionHandlerImpl<UserGroupAccessibility, P, DTO, AD>(Permission.USER_VISIBILITY_MAP_DIRECTORY, QProduct.product.userDirectoryOnGroups, (Property)ProductDTO.USER_DIRECTORY_ON_GROUPS, UsersKeys.Products.USER_DIRECTORY_ON_GROUPS){

            public void writePermissions(DTO DTO, Collection<Permission> collection) {
                boolean bl = DTO.getUserDirectoryOnGroups() != null && DTO.getUserDirectoryOnGroups() != UserGroupAccessibility.NONE;
                CollectionHelper.addOrRemove(collection, (Object)Permission.USER_VISIBILITY_MAP_DIRECTORY, (boolean)bl);
            }
        });
        this.register(new BooleanPermissionHandlerImpl(Permission.MY_AGREEMENT_LOG_VIEW, ProductDTO.MY_AGREEMENT_LOG, ActiveProductsData.MY_AGREEMENT_LOG, UsersKeys.Products.MY_AGREEMENT_LOG));
        this.register(new ViewManagePermissionHandlerImpl(Permission.MY_PRIVACY_SETTINGS_VIEW, Permission.MY_PRIVACY_SETTINGS_MANAGE, ProductDTO.MY_PRIVACY_SETTINGS, ActiveProductsData.MY_PRIVACY_SETTINGS, UsersKeys.Products.MY_PRIVACY_SETTINGS));
        this.register(new BooleanPermissionHandlerImpl(Permission.MY_OIDC_AUTHORIZATIONS_ENABLE, ProductDTO.MY_OIDC_AUTHORIZATIONS_ENABLE, ActiveProductsData.MY_OIDC_AUTHORIZATIONS_ENABLE, UsersKeys.Products.MY_OIDC_AUTHORIZATIONS_ENABLE));
        this.register(new BooleanPermissionHandlerImpl(Permission.MY_IDENTITY_PROVIDERS_ENABLE, ProductDTO.MY_IDENTITY_PROVIDERS_ENABLE, ActiveProductsData.MY_IDENTITY_PROVIDERS_ENABLE, UsersKeys.Products.MY_IDENTITY_PROVIDERS_ENABLE));
        this.register(new BooleanPermissionHandlerImpl(Permission.MY_CHANNELS_ACCESS_ENABLE, ProductDTO.MY_CHANNELS_ACCESS_ENABLE, ActiveUserProductsData.MY_CHANNELS_ACCESS_ENABLE, UsersKeys.Products.MY_CHANNELS_ACCESS_ENABLE));
        this.register(new BooleanPermissionHandlerImpl(Permission.MY_QUICK_ACCESS_SETTINGS_ENABLE, ProductDTO.MY_QUICK_ACCESS_SETTINGS_ENABLE, ActiveUserProductsData.MY_QUICK_ACCESS_SETTINGS_ENABLE, UsersKeys.Products.MY_QUICK_ACCESS_SETTINGS_ENABLE));
        this.register(new BooleanPermissionHandlerImpl(Permission.MY_CONTACTS_ENABLE, ProductDTO.MY_CONTACTS_ENABLE, ActiveUserProductsData.MY_CONTACTS_ENABLE, UsersKeys.Products.MY_CONTACTS_ENABLE));
        this.register(new BooleanPermissionHandlerImpl(Permission.USER_INVITE, ProductDTO.USER_INVITE, ActiveUserProductsData.USER_INVITE, UsersKeys.Products.USER_INVITE));
        this.register(new BooleanPermissionHandlerImpl(Permission.MY_NOTIFICATION_SETTINGS_ENABLE, ProductDTO.MY_NOTIFICATION_SETTINGS_ENABLE, ActiveUserProductsData.MY_NOTIFICATION_SETTINGS_ENABLE, UsersKeys.Products.MY_NOTIFICATION_SETTINGS_ENABLE));
        this.register(new PermissionHandler<DTO, AD>(){

            public Property<?, ? super ProductDTO> getDTOProperty() {
                return ProductDTO.PASSWORD_ACTIONS;
            }

            public MessageKey getKey() {
                return UsersKeys.Products.MY_PASSWORDS_MANAGE;
            }

            public List<Permission> getPermissions() {
                return Collections.singletonList(Permission.MY_PASSWORDS_MANAGE);
            }

            public void writePermissions(DTO DTO, Collection<Permission> collection) {
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_PASSWORDS_MANAGE, (boolean)ProductConversionHandlerImpl.this.hasPasswordActions(DTO.getPasswordActions()));
            }
        });
    }

    public DTO toDTO(P p) {
        Set set = p.getPermissions();
        ProductDTO productDTO = (ProductDTO)this.conversionHandler.convertExcluding(this.dtoType, p, new Object[]{ProductDTO.SIMPLE_USER_SEARCH_PROFILE_FIELDS});
        for (PermissionHandler<DTO, AD> permissionHandler : this.permissionHandlers) {
            permissionHandler.readPermissions((Collection)set, productDTO);
        }
        this.ensurePasswordActions(p, productDTO);
        this.ensureProfileFields(p, productDTO);
        this.ensureTransferStatusFlows(p, productDTO);
        this.ensureMyRecordTypes(p, productDTO);
        this.ensureMyAccessClients(p, productDTO);
        this.ensureMyContactFields(p, productDTO);
        return (DTO)productDTO;
    }

    public P toEntity(DTO DTO) {
        this.enssureDTOConsistency(DTO);
        Product product = (Product)this.conversionHandler.convertExcluding(this.entityType, DTO, new Object[]{ProductDTO.DEFAULT_QUICK_ACCESS});
        Set set = product.getPermissions();
        for (PermissionHandler<DTO, AD> object : this.permissionHandlers) {
            object.writePermissions(DTO, (Collection)set);
        }
        Role role = product.getRole();
        for (Permission permission : set) {
            if (permission.getRoles().contains(role)) continue;
            throw new PermissionDeniedException("Attempt to set a permission with incompatible role - permission: " + String.valueOf(permission) + " for a product with role: " + String.valueOf(role));
        }
        for (Map.Entry<Permission, String> entry : this.additionalCollectionMapping.entrySet()) {
            Collection collection = (Collection)InvocationContext.wrap((Object)product).getPropertyValue(entry.getValue());
            if (!CollectionHelper.isEmpty((Iterable)collection)) continue;
            set.remove(entry.getKey());
        }
        this.recordFieldHandler.toEntityProductRecordTypes(product, (Collection)product.getMyRecordTypes(), (Collection)DTO.getMyRecordTypeFields(), ProductMyRecordType.class);
        if (!set.contains(Permission.MY_CONTACTS_ENABLE)) {
            product.getMyContactFields().clear();
        }
        product.setSimpleUserSearchProfileFields(new HashSet(this.profileFieldHandler.toEntities((Collection)DTO.getSimpleUserSearchProfileFields())));
        this.setDefaultQuickAccess(product, CollectionHelper.orEmpty((Set)DTO.getDefaultQuickAccess()));
        return (P)product;
    }

    protected void enssureDTOConsistency(DTO DTO) {
    }

    protected Set<TransferTypeVO> filterPaymentTypes(Collection<TransferTypeVO> collection, Collection<? extends AccountType> collection2, Boolean bl, TransferTypeDirection ... transferTypeDirectionArray) {
        return CollectionHelper.orEmpty(collection).stream().filter(transferTypeVO -> {
            TransferType transferType = (TransferType)this.conversionHandler.convert(TransferType.class, transferTypeVO);
            if (!Arrays.asList(transferTypeDirectionArray).contains(transferType.getDirection())) {
                return false;
            }
            ArrayList<AccountType> arrayList = new ArrayList<AccountType>();
            if (bl == null || bl.booleanValue()) {
                arrayList.add(transferType.getFrom());
            }
            if (bl == null || !bl.booleanValue()) {
                arrayList.add(transferType.getTo());
            }
            return arrayList.stream().anyMatch(accountType -> collection2.contains(accountType));
        }).collect(Collectors.toSet());
    }

    protected Set<TransferTypeVO> filterPaymentTypesByFromAccount(Collection<TransferTypeVO> collection, Collection<? extends AccountType> collection2, TransferTypeDirection ... transferTypeDirectionArray) {
        return this.filterPaymentTypes(collection, collection2, true, transferTypeDirectionArray);
    }

    protected Set<TransferTypeVO> filterPaymentTypesByFromOrToAccount(Collection<TransferTypeVO> collection, Collection<? extends AccountType> collection2, TransferTypeDirection ... transferTypeDirectionArray) {
        return this.filterPaymentTypes(collection, collection2, null, transferTypeDirectionArray);
    }

    protected Set<TransferTypeVO> filterPaymentTypesByToAccount(Collection<TransferTypeVO> collection, Collection<? extends AccountType> collection2, TransferTypeDirection ... transferTypeDirectionArray) {
        return this.filterPaymentTypes(collection, collection2, false, transferTypeDirectionArray);
    }

    protected Set<TransferFilterWithAccountTypeVO> filterTransferFilters(Collection<TransferFilterWithAccountTypeVO> collection, Collection<? extends AccountType> collection2) {
        return CollectionHelper.orEmpty(collection).stream().filter(transferFilterWithAccountTypeVO -> collection2.contains(((TransferFilter)this.conversionHandler.convert(TransferFilter.class, transferFilterWithAccountTypeVO)).getAccountType())).collect(Collectors.toSet());
    }

    protected boolean hasPasswordActions(Set<? extends ProductPasswordActionDTO> set) {
        if (CollectionHelper.isNotEmpty(set)) {
            for (ProductPasswordActionDTO productPasswordActionDTO : set) {
                if (productPasswordActionDTO.isChange() || productPasswordActionDTO.isEnable() || productPasswordActionDTO.isUnblock()) {
                    return true;
                }
                if (!(productPasswordActionDTO instanceof UserProductPasswordActionDTO ? ((UserProductPasswordActionDTO)productPasswordActionDTO).isReset() : productPasswordActionDTO instanceof MyProductPasswordActionDTO && ((MyProductPasswordActionDTO)productPasswordActionDTO).isAtRegistration())) continue;
                return true;
            }
        }
        return false;
    }

    protected void registerAdditionalCollectionMapping(Permission permission, Path<?> path) {
        this.additionalCollectionMapping.put(permission, PropertyHelper.getPropertyName(path));
    }

    protected void registerCommonMemberOrBroker() {
    }

    protected void registerPropertyMapping(Property<?, ?> property, Path<?> path) {
        this.propertyMapping.put(property, PropertyHelper.getPropertyName(path));
    }

    private void ensureMyAccessClients(P p, DTO DTO) {
        DTO.setMyAccessClients(new ArrayList());
        List list = this.principalTypeService.listAccessClients();
        for (AccessClientPrincipalType accessClientPrincipalType : list) {
            ProductMyAccessClientDTO productMyAccessClientDTO = this.getProductMyAccessClientDTO(accessClientPrincipalType, p);
            if (productMyAccessClientDTO == null) {
                productMyAccessClientDTO = new ProductMyAccessClientDTO();
                productMyAccessClientDTO.setAccessClientType((AccessClientPrincipalTypeVO)this.conversionHandler.convert(AccessClientPrincipalTypeVO.class, (Object)accessClientPrincipalType));
            }
            DTO.getMyAccessClients().add(productMyAccessClientDTO);
        }
    }

    private void ensureMyContactFields(P p, DTO DTO) {
        DTO.setMyContactFields(new ArrayList());
        List list = this.contactCustomFieldService.listAll();
        for (ContactCustomField contactCustomField : list) {
            ProductMyContactFieldDTO productMyContactFieldDTO = this.getProductMyCustomFieldDTO(contactCustomField, p);
            if (productMyContactFieldDTO == null) {
                productMyContactFieldDTO = new ProductMyContactFieldDTO();
                productMyContactFieldDTO.setCustomField((CustomFieldVO)this.conversionHandler.convert(CustomFieldVO.class, (Object)contactCustomField));
            }
            DTO.getMyContactFields().add(productMyContactFieldDTO);
        }
    }

    private void ensureMyRecordTypes(P p, DTO DTO) {
        DTO.setMyRecordTypeFields(this.recordFieldHandler.getProductRecordFields(p, ProductMyRecordType.class));
    }

    private void ensurePasswordActions(P p, DTO DTO) {
        if (DTO.getPasswordActions() == null) {
            DTO.setPasswordActions(new HashSet());
        }
        this.ensurePasswordActions(p, DTO.getPasswordActions());
    }

    private void ensurePasswordActions(P p, Set<MyProductPasswordActionDTO> set) {
        List list = this.passwordTypeService.list();
        if (CollectionHelper.isNotEmpty((Iterable)list)) {
            for (PasswordTypeVO passwordTypeVO : list) {
                MyProductPasswordActionDTO myProductPasswordActionDTO;
                if (!passwordTypeVO.getPasswordMode().allowActions() || (myProductPasswordActionDTO = this.findPasswordDTO(set, passwordTypeVO)) != null) continue;
                myProductPasswordActionDTO = new MyProductPasswordActionDTO();
                myProductPasswordActionDTO.setPasswordType(passwordTypeVO);
                set.add(myProductPasswordActionDTO);
            }
        }
    }

    private void ensureProfileFields(P p, DTO DTO) {
        List list = this.profileFieldHandler.getAllProfileFields();
        DTO.setMyProfileFields(new ArrayList());
        DTO.setUserProfileFields(new ArrayList());
        for (ProfileField profileField : list) {
            ProductMyProfileFieldDTO productMyProfileFieldDTO = this.getProductMyProfileFieldDTO(profileField, p);
            if (productMyProfileFieldDTO == null) {
                productMyProfileFieldDTO = new ProductMyProfileFieldDTO();
                productMyProfileFieldDTO.setProfileField(this.profileFieldHandler.toVO(profileField));
            }
            DTO.getMyProfileFields().add(productMyProfileFieldDTO);
            ProductUserProfileFieldDTO productUserProfileFieldDTO = this.getProductUserProfileFieldDTO(profileField, p);
            if (productUserProfileFieldDTO == null) {
                productUserProfileFieldDTO = new ProductUserProfileFieldDTO();
                productUserProfileFieldDTO.setProfileField(this.profileFieldHandler.toVO(profileField));
            }
            DTO.getUserProfileFields().add(productUserProfileFieldDTO);
        }
        DTO.setSimpleUserSearchProfileFields(new HashSet(this.profileFieldHandler.toVOs((Collection)p.getSimpleUserSearchProfileFields())));
    }

    private void ensureTransferStatusFlows(P p, DTO DTO) {
        DTO.setTransferStatusFlows(new ArrayList());
        List list = this.transferStatusFlowService.listAll();
        for (TransferStatusFlow transferStatusFlow : list) {
            ProductTransferStatusFlowDTO productTransferStatusFlowDTO = this.getProductTransferStatusFlowDTO(transferStatusFlow, p);
            if (productTransferStatusFlowDTO == null) {
                productTransferStatusFlowDTO = new ProductTransferStatusFlowDTO();
                productTransferStatusFlowDTO.setFlow((TransferStatusFlowVO)this.conversionHandler.convert(TransferStatusFlowVO.class, (Object)transferStatusFlow));
            }
            DTO.getTransferStatusFlows().add(productTransferStatusFlowDTO);
        }
    }

    private MyProductPasswordActionDTO findPasswordDTO(Collection<MyProductPasswordActionDTO> collection, PasswordTypeVO passwordTypeVO) {
        for (MyProductPasswordActionDTO myProductPasswordActionDTO : collection) {
            if (!passwordTypeVO.getId().equals(myProductPasswordActionDTO.getPasswordType().getId())) continue;
            return myProductPasswordActionDTO;
        }
        return null;
    }

    private ProductMyAccessClientDTO getProductMyAccessClientDTO(AccessClientPrincipalType accessClientPrincipalType, P p) {
        for (ProductMyAccessClient productMyAccessClient : p.getMyAccessClients()) {
            if (!productMyAccessClient.getAccessClientType().equals((Object)accessClientPrincipalType)) continue;
            ProductMyAccessClientDTO productMyAccessClientDTO = (ProductMyAccessClientDTO)this.conversionHandler.convert(ProductMyAccessClientDTO.class, (Object)productMyAccessClient);
            if (!accessClientPrincipalType.isAllowManualCreation()) {
                productMyAccessClientDTO.setUnassign(false);
            }
            return productMyAccessClientDTO;
        }
        return null;
    }

    private ProductMyContactFieldDTO getProductMyCustomFieldDTO(ContactCustomField contactCustomField, P p) {
        for (ProductMyContactField productMyContactField : p.getMyContactFields()) {
            if (!productMyContactField.getCustomField().equals((Object)contactCustomField)) continue;
            return (ProductMyContactFieldDTO)this.conversionHandler.convert(ProductMyContactFieldDTO.class, (Object)productMyContactField);
        }
        return null;
    }

    private ProductMyProfileFieldDTO getProductMyProfileFieldDTO(ProfileField profileField, P p) {
        for (ProductMyProfileField productMyProfileField : p.getMyProfileFields()) {
            if (!profileField.equals((Object)productMyProfileField.getProfileField())) continue;
            return (ProductMyProfileFieldDTO)this.conversionHandler.convert(ProductMyProfileFieldDTO.class, (Object)productMyProfileField);
        }
        return null;
    }

    private ProductTransferStatusFlowDTO getProductTransferStatusFlowDTO(TransferStatusFlow transferStatusFlow, P p) {
        for (ProductTransferStatusFlow productTransferStatusFlow : p.getTransferStatusFlows()) {
            if (!productTransferStatusFlow.getFlow().equals((Object)transferStatusFlow)) continue;
            return (ProductTransferStatusFlowDTO)this.conversionHandler.convert(ProductTransferStatusFlowDTO.class, (Object)productTransferStatusFlow);
        }
        return null;
    }

    private ProductUserProfileFieldDTO getProductUserProfileFieldDTO(ProfileField profileField, P p) {
        for (ProductUserProfileField productUserProfileField : p.getUserProfileFields()) {
            if (!profileField.equals((Object)productUserProfileField.getProfileField())) continue;
            return (ProductUserProfileFieldDTO)this.conversionHandler.convert(ProductUserProfileFieldDTO.class, (Object)productUserProfileField);
        }
        return null;
    }

    private void setDefaultQuickAccess(P p, Set<QuickAccessDTO> set) {
        Set set2 = p.getDefaultQuickAccess();
        Set<ProductQuickAccess> set3 = set2.stream().filter(productQuickAccess -> !set.stream().anyMatch(quickAccessDTO -> this.quickAccessHandler.matches((QuickAccess)productQuickAccess, quickAccessDTO))).collect(Collectors.toSet());
        set2.removeAll(set3);
        set3.forEach(iEntity -> this.remove((IEntity)iEntity));
        set.stream().filter(quickAccessDTO -> !set2.stream().anyMatch(productQuickAccess -> this.quickAccessHandler.matches(quickAccessDTO, (QuickAccess)productQuickAccess))).filter(quickAccessDTO -> quickAccessDTO.getType().allows(p.getRole())).map(quickAccessDTO -> new ProductQuickAccess(p, quickAccessDTO.getType(), this.quickAccessHandler.toEntity(quickAccessDTO))).forEach(set2::add);
    }
}

