/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.PrivacyControl;
import org.cyclos.entities.users.ProfileFieldComparator;
import org.cyclos.entities.users.QProductUserProfileField;
import org.cyclos.entities.users.User;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.PrivacyControlServiceLocal;
import org.cyclos.impl.users.PrivacySettingsServiceLocal;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.users.privacycontrols.PrivacyControlDetailedVO;
import org.cyclos.model.users.privacycontrols.PrivacyControlVO;
import org.cyclos.model.users.privacysettings.PrivacySettingsDTO;
import org.cyclos.model.users.privacysettings.PrivacySettingsData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrivacySettingsServiceImpl
extends BaseServiceImpl
implements PrivacySettingsServiceLocal {
    @Autowired
    private PrivacyControlServiceLocal privacyControlService;

    public Set<PrivacyControl> getControls(User user) {
        if (user.isEnablePrivacyControl()) {
            return CollectionHelper.orEmpty((Set)user.getPrivacyControls());
        }
        return null;
    }

    public PrivacySettingsData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        SessionData sessionData = this.getSessionData();
        List list = this.privacyControlService.listAll().stream().filter(PrivacyControl::isEnabled).collect(Collectors.toList());
        HashSet hashSet = new HashSet(user.getPrivacyControls());
        list.stream().filter(PrivacyControl::isFieldsAlwaysVisible).forEach(hashSet::add);
        ArrayList arrayList = new ArrayList(configurationAccessor.getPrivacyControlledProfileFields());
        if (sessionData.isSelf((BasicUser)user)) {
            arrayList.retainAll(this.profileFieldHandler.getFieldsByAction((BasicUser)user, ProfileFieldAction.VIEW));
        } else {
            arrayList.retainAll(this.profileFieldHandler.getEnabledProfileFields((BasicUser)user));
            arrayList.retainAll(sessionData.getProducts().product().getUserProfileFields().keysSet((Path)QProductUserProfileField.productUserProfileField.visible));
        }
        arrayList.sort(ProfileFieldComparator.getInstance());
        PrivacySettingsDTO privacySettingsDTO = new PrivacySettingsDTO();
        privacySettingsDTO.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        privacySettingsDTO.setEnablePrivacyControl(user.isEnablePrivacyControl());
        privacySettingsDTO.setPrivacyControls(this.conversionHandler.convertSet(PrivacyControlVO.class, hashSet));
        PrivacySettingsData privacySettingsData = new PrivacySettingsData();
        privacySettingsData.setPrivacyControlledProfileFields(this.profileFieldHandler.toVOs(arrayList));
        privacySettingsData.setPrivacyControls(this.conversionHandler.convertList(PrivacyControlDetailedVO.class, list));
        privacySettingsData.setSetting(privacySettingsDTO);
        return privacySettingsData;
    }

    public void save(PrivacySettingsDTO privacySettingsDTO) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)privacySettingsDTO.getUser());
        user.setEnablePrivacyControl(privacySettingsDTO.isEnablePrivacyControl());
        user.setPrivacyControls(this.conversionHandler.convertSet(PrivacyControl.class, (Iterable)privacySettingsDTO.getPrivacyControls()));
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }
}

