/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cyclos.entities.users.QReference;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.Reference;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.EntityData;
import org.cyclos.model.ValidationException;
import org.cyclos.model.users.references.ReferenceDTO;
import org.cyclos.model.users.references.ReferenceEntryVO;
import org.cyclos.model.users.references.ReferenceLevel;
import org.cyclos.model.users.references.ReferencePeriodStatisticsVO;
import org.cyclos.model.users.references.ReferenceQuery;
import org.cyclos.model.users.references.ReferenceStatisticsParams;
import org.cyclos.model.users.references.ReferenceStatisticsVO;
import org.cyclos.model.users.references.ReferenceType;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;

public abstract class BaseReferenceServiceImpl<E extends Reference, A extends EntityPath<E>, DTO extends ReferenceDTO, VO extends ReferenceEntryVO, Q extends ReferenceQuery, D extends EntityData<DTO>, DP>
extends CRUDServiceImpl<E, A, DTO, D, DP> {
    private static final int MAX_STATS_PERIODS = 5;
    protected final Class<VO> entryVoClass;
    protected final QReference r;

    public BaseReferenceServiceImpl(Class<E> clazz, A a, QReference qReference, Class<DTO> clazz2, Class<VO> clazz3) {
        super(clazz, a, clazz2);
        this.entryVoClass = clazz3;
        this.r = qReference;
    }

    public int countReceived(User user) {
        return (int)((DBQuery)this.from(new EntityPath[]{this.r}).where((Predicate)this.r.to().eq((Object)user))).fetchCount();
    }

    public List<ReferenceLevel> getReferenceLevels() {
        EnumSet<ReferenceLevel> enumSet = EnumSet.complementOf(EnumSet.of(ReferenceLevel.NA));
        return new ArrayList<ReferenceLevel>(enumSet);
    }

    public ReferenceStatisticsVO getStatistics(ReferenceStatisticsParams referenceStatisticsParams) {
        ReferenceStatisticsVO referenceStatisticsVO;
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)referenceStatisticsParams.getOwner());
        ReferenceType referenceType = (ReferenceType)ObjectHelper.defaultValue((Object)referenceStatisticsParams.getReferenceType(), (Object)ReferenceType.RECEIVED);
        List<Object> list = this.conversionHandler.convertList(DatePeriod.class, (Iterable)referenceStatisticsParams.getPeriods());
        if (CollectionHelper.isEmpty((Iterable)list)) {
            referenceStatisticsVO = new DatePeriod(DateHelper.subtract((Date)new Date(), (TimeField)TimeField.DAYS, (int)30), null);
            list = Arrays.asList(null, referenceStatisticsVO);
        } else if (list.size() > 5) {
            list = list.subList(0, 5);
        }
        referenceStatisticsVO = new ReferenceStatisticsVO();
        referenceStatisticsVO.setOwner((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        referenceStatisticsVO.setPeriods(list.stream().map(datePeriod -> this.periodStatistics(user, referenceType, (DatePeriod)datePeriod)).collect(Collectors.toList()));
        return referenceStatisticsVO;
    }

    public void removeAll(User user) {
        QReference qReference = this.ref();
        this.delete((EntityPath<?>)qReference).where(new Predicate[]{qReference.from().eq((Object)user).or((Predicate)qReference.to().eq((Object)user))}).execute();
    }

    public Page<VO> search(Q q) {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)q.getOwner());
        Page page = this.createSearchQuery(q).page(q, (Expression)this.$);
        return PageImpl.transformed((Page)page, reference -> {
            VO VO = this.toSearchResultEntry(reference);
            ReferenceType referenceType = user.equals((Object)reference.getFrom()) ? ReferenceType.GIVEN : ReferenceType.RECEIVED;
            User user2 = referenceType == ReferenceType.GIVEN ? reference.getTo() : reference.getFrom();
            VO.setRelatedUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user2));
            VO.setReferenceType(referenceType);
            return VO;
        });
    }

    protected DBQuery<?> crateStatisticsQuery(User user, ReferenceType referenceType, DatePeriod datePeriod) {
        QUser qUser = referenceType == ReferenceType.GIVEN ? this.r.from() : this.r.to();
        DBQuery dBQuery = (DBQuery)((DBQuery)this.from(new EntityPath[]{this.r}).where(new Predicate[]{qUser.eq((Object)user), this.r.level.ne((Object)ReferenceLevel.NA), this.r.date.period(datePeriod)})).groupBy((Expression)this.r.level);
        return dBQuery;
    }

    protected DBQuery<?> createSearchQuery(Q q) {
        DatePeriodDTO datePeriodDTO;
        DBQuery<?> dBQuery = this.from();
        User user = (User)this.conversionHandler.convert(User.class, (Object)q.getOwner());
        User user2 = (User)this.conversionHandler.convert(User.class, (Object)q.getUser());
        if (user == null) {
            throw new ValidationException();
        }
        if (q.getReferenceType() != null) {
            dBQuery.where((Predicate)(q.getReferenceType() == ReferenceType.GIVEN ? this.r.from() : this.r.to()).eq((Object)user));
            if (user2 != null) {
                dBQuery.where((Predicate)(q.getReferenceType() == ReferenceType.GIVEN ? this.r.to() : this.r.from()).eq((Object)user2));
            }
        } else {
            dBQuery.where((Predicate)this.r.from().eq((Object)user).or((Predicate)this.r.to().eq((Object)user)));
            if (user2 != null) {
                dBQuery.where((Predicate)this.r.from().eq((Object)user2).or((Predicate)this.r.to().eq((Object)user2)));
            }
        }
        if ((datePeriodDTO = q.getPeriod()) != null) {
            dBQuery.where(this.r.date.period((DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)datePeriodDTO)));
        }
        if (CollectionHelper.isNotEmpty((Iterable)q.getLevels())) {
            dBQuery.where((Predicate)this.r.level.in((Collection)q.getLevels()));
        }
        dBQuery.orderBy(this.r.date.desc());
        return dBQuery;
    }

    protected abstract QReference ref();

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(this.ref().from().network());
    }

    protected VO toSearchResultEntry(E e) {
        return (VO)((ReferenceEntryVO)this.conversionHandler.convert(this.entryVoClass, e));
    }

    private ReferencePeriodStatisticsVO periodStatistics(User user, ReferenceType referenceType, DatePeriod datePeriod) {
        Map map = this.crateStatisticsQuery(user, referenceType, datePeriod).map((Expression)this.r.level, (Expression)this.r.count());
        EnumMap<ReferenceLevel, Integer> enumMap = new EnumMap<ReferenceLevel, Integer>(ReferenceLevel.class);
        int n = 0;
        float f = 0.0f;
        int n2 = 0;
        int n3 = 0;
        for (ReferenceLevel referenceLevel : this.getReferenceLevels()) {
            int n4 = ((Number)ObjectHelper.defaultValue((Object)((Number)map.get(referenceLevel)), (Object)0)).intValue();
            enumMap.put(referenceLevel, n4);
            n += n4;
            if (referenceLevel.isPositive()) {
                n2 += n4;
            } else if (referenceLevel.isNegative()) {
                n3 += n4;
            }
            f += (float)(n4 * referenceLevel.getPoints());
        }
        ReferencePeriodStatisticsVO referencePeriodStatisticsVO = new ReferencePeriodStatisticsVO();
        referencePeriodStatisticsVO.setPeriod((DatePeriodDTO)this.conversionHandler.convert(DatePeriodDTO.class, (Object)datePeriod));
        referencePeriodStatisticsVO.setCounts(enumMap);
        referencePeriodStatisticsVO.setTotal(n);
        referencePeriodStatisticsVO.setTotalNegative(n3);
        referencePeriodStatisticsVO.setTotalPositive(n2);
        referencePeriodStatisticsVO.setScore(f / (float)n);
        return referencePeriodStatisticsVO;
    }
}

