/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProductAssignmentLog;
import org.cyclos.entities.users.ProductOwner;
import org.cyclos.entities.users.User;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.users.BaseProductsOwnerServiceLocal;
import org.cyclos.impl.users.ConnectedUserServiceLocal;
import org.cyclos.impl.users.GroupsHandlerInternal;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.messaging.notifications.INotificationType;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.products.ActiveAdminProductsData;
import org.cyclos.model.users.products.ActiveProductsData;
import org.cyclos.model.users.products.ActiveUserProductsData;
import org.cyclos.model.users.products.AdminGroupAccessibility;
import org.cyclos.model.users.products.ProductAssignmentAction;
import org.cyclos.model.users.products.ProductAssignmentLogVO;
import org.cyclos.model.users.products.ProductVO;
import org.cyclos.model.users.products.ProductsCollections;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.products.UserProductNotificationDTO;
import org.cyclos.model.users.users.GroupFilterDefault;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseProductsOwnerServiceImpl<O extends ProductOwner, L extends ProductAssignmentLog<O>, VO extends EntityVO, D extends ProductsCollections>
extends BaseServiceImpl
implements BaseProductsOwnerServiceLocal<O, VO, D> {
    @Autowired
    private ProductServiceLocal productService;
    @Autowired
    private GroupsHandlerInternal groupsHandlerInternal;
    @Autowired
    private ConnectedUserServiceLocal connectedUserService;
    protected final Class<O> ownerClass;
    protected final Class<L> logClass;

    public BaseProductsOwnerServiceImpl(Class<O> clazz, Class<L> clazz2) {
        this.ownerClass = clazz;
        this.logClass = clazz2;
    }

    public boolean assign(ProductVO productVO, VO VO) throws FrameworkException {
        ProductOwner productOwner = (ProductOwner)this.conversionHandler.convert(this.ownerClass, VO);
        Product product = (Product)this.conversionHandler.convert(Product.class, (Object)productVO);
        this.validateAssign(productOwner, product);
        productOwner = (ProductOwner)this.find(this.ownerClass, productOwner.getId());
        boolean bl = productOwner.addProduct(product);
        if (!bl) {
            throw new EntityNotFoundException();
        }
        this.log(ProductAssignmentAction.ASSIGN, product, productOwner);
        this.addEntityLogs(productOwner, product, true);
        if (!this.isProductInHigherHierarchy(productOwner, product)) {
            this.onProductAssigned(productOwner, product);
            this.connectedUserService.notifySessionsOfPermissionChange(productOwner);
        }
        return true;
    }

    public ActiveProductsData getActiveProducts(VO VO, ChannelVO channelVO, PrincipalTypeVO principalTypeVO) throws EntityNotFoundException {
        Collection<ProductVO> collection;
        Object object;
        ProductOwner productOwner = (ProductOwner)this.conversionHandler.convert(this.ownerClass, VO);
        Channel channel = (Channel)this.conversionHandler.convert(Channel.class, (Object)channelVO);
        PrincipalType principalType = (PrincipalType)this.conversionHandler.convert(PrincipalType.class, (Object)principalTypeVO);
        List list = productOwner.getAllProductIds().stream().map(l -> this.find(Product.class, (Long)l)).collect(Collectors.toList());
        ProductsAccessor productsAccessor = this.productsHandler.getAccessorFor(list, channel, principalType);
        ActiveProductsData activeProductsData = this.productService.toActiveProduct(productsAccessor);
        activeProductsData.setProductsCollections(this.getData((VO)productOwner));
        activeProductsData.setCanAssign(this.isCanAssign(productOwner));
        BasicGroup basicGroup = null;
        if (productOwner instanceof BasicGroup) {
            basicGroup = (BasicGroup)productOwner;
            activeProductsData.setBasicGroup((BasicGroupVO)this.conversionHandler.convert(BasicGroupVO.class, (Object)basicGroup));
        } else if (productOwner instanceof User) {
            basicGroup = ((User)productOwner).getGroup();
            activeProductsData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)basicGroup));
        }
        activeProductsData.setAllUserGroupAccessibility(productsAccessor.product().getUserGroupAccessibility().contains(UserGroupAccessibility.ALL));
        Set set = this.groupsHandlerInternal.getAccessibleBasicGroups(false, basicGroup, productsAccessor);
        if (activeProductsData instanceof ActiveAdminProductsData) {
            set.removeIf(AdminGroup.class::isInstance);
        }
        activeProductsData.setUserGroupAccessibility(this.groupsHandler.viewFactory((Collection)set).basic().sorted());
        activeProductsData.setAllUserDirectoryOnGroups(productsAccessor.product().getUserDirectoryOnGroups().contains(UserGroupAccessibility.ALL));
        Set set2 = this.groupsHandlerInternal.getUserDirectoryOnGroups(basicGroup, productsAccessor);
        activeProductsData.setGroupsForUserDirectory(this.groupsHandler.viewFactory((Collection)set2).basic().sorted());
        if (activeProductsData instanceof ActiveUserProductsData) {
            object = (ActiveUserProductsData)activeProductsData;
            object.setAllSearchUsersOnGroups(productsAccessor.member().getSearchUsersOnGroups().contains(UserGroupAccessibility.ALL));
            collection = this.groupsHandlerInternal.getSearchOnGroups(false, basicGroup, productsAccessor);
            object.setGroupsForUserSearch(this.groupsHandler.viewFactory((Collection)collection).basic().sorted());
            object.setAllViewProfileOnGroups(productsAccessor.member().getViewProfileOnGroups().contains(UserGroupAccessibility.ALL));
            Set set3 = this.groupsHandlerInternal.getViewProfileOnGroups(basicGroup, productsAccessor);
            object.setGroupsForViewProfile(this.groupsHandler.viewFactory((Collection)set3).basic().sorted());
            object.setAllGroupFilterDefault(productsAccessor.member().getGroupFilterDefault().contains(GroupFilterDefault.ALL));
            if (!object.isAllGroupFilterDefault()) {
                Object object2 = this.groupsHandlerInternal.getDefaultGroupFilter(null, basicGroup, productsAccessor);
                object.setGroupFilterDefault(this.groupsHandler.viewFactory((Collection)object2).basic().sorted());
            }
            if (object.getNotifications() != null) {
                object.getNotifications().sort(Comparator.comparing(UserProductNotificationDTO::getType, INotificationType.COMPARATOR));
            }
        } else {
            object = (ActiveAdminProductsData)activeProductsData;
            object.setAllAdminGroupAccessibility(productsAccessor.admin().getAdminGroupAccessibility() == AdminGroupAccessibility.ALL);
        }
        object = new ArrayList();
        collection = new ArrayList();
        for (Object object2 : productsAccessor.getProducts()) {
            if (CollectionHelper.isNotEmpty((Iterable)object2.getChannels())) {
                object.add((ProductVO)this.conversionHandler.convert(ProductVO.class, object2));
            }
            if (!CollectionHelper.isNotEmpty((Iterable)object2.getPrincipalTypes())) continue;
            collection.add((ProductVO)this.conversionHandler.convert(ProductVO.class, object2));
        }
        activeProductsData.setChannelSpecificProducts((List)object);
        activeProductsData.setPrincipalTypeSpecificProducts((List)collection);
        return activeProductsData;
    }

    public final D getData(O o) {
        D d = this.getDataWithoutLogs(o);
        d.setLogs(this.getLogs(o));
        return d;
    }

    public final D getData(@NotNull VO VO) {
        ProductOwner productOwner = (ProductOwner)this.conversionHandler.convert(this.ownerClass, VO);
        return this.getData((VO)productOwner);
    }

    public final List<ProductAssignmentLogVO> getLogs(@NotNull VO VO) throws FrameworkException {
        ProductOwner productOwner = (ProductOwner)this.conversionHandler.convert(this.ownerClass, VO);
        return this.getLogs((O)productOwner);
    }

    public boolean unassign(ProductVO productVO, VO VO) throws FrameworkException {
        ProductOwner productOwner = (ProductOwner)this.conversionHandler.convert(this.ownerClass, VO);
        Product product = (Product)this.conversionHandler.convert(Product.class, (Object)productVO);
        this.validateUnAssign(productOwner, product);
        if (!productOwner.getProducts().contains(product)) {
            throw new IllegalActionException();
        }
        boolean bl = (productOwner = (ProductOwner)this.find(this.ownerClass, productOwner.getId())).removeProduct(product);
        if (!bl) {
            throw new EntityNotFoundException();
        }
        this.log(ProductAssignmentAction.UNASSIGN, product, productOwner);
        this.addEntityLogs(productOwner, product, false);
        if (!this.isProductInHigherHierarchy(productOwner, product)) {
            this.onProductUnassigned(productOwner, product);
            this.connectedUserService.notifySessionsOfPermissionChange(productOwner);
        }
        return true;
    }

    protected void addEntityLogs(O o, Product product, boolean bl) {
    }

    protected abstract D getDataWithoutLogs(O var1);

    protected abstract List<ProductAssignmentLogVO> getLogs(O var1);

    protected abstract boolean isCanAssign(O var1);

    protected boolean isProductInHigherHierarchy(O o, Product product) {
        SortedSet sortedSet = o.getProductIds();
        SortedSet sortedSet2 = o.getAllProductIds();
        return !sortedSet.contains(product.getId()) && sortedSet2.contains(product.getId());
    }

    protected final void log(ProductAssignmentAction productAssignmentAction, Product product, O o) {
        ProductAssignmentLog productAssignmentLog = (ProductAssignmentLog)ClassHelper.instantiate(this.logClass);
        productAssignmentLog.setAction(productAssignmentAction);
        productAssignmentLog.setProduct(product);
        productAssignmentLog.setOwner(o);
        productAssignmentLog.setBy(this.getLoggedUser());
        productAssignmentLog.setDate(new Date());
        this.persist((IEntity)productAssignmentLog);
    }

    protected abstract void onProductAssigned(O var1, Product var2);

    protected abstract void onProductUnassigned(O var1, Product var2);

    protected abstract void validateAssign(O var1, Product var2);

    protected abstract void validateUnAssign(O var1, Product var2);
}

