/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import org.cyclos.entities.marketplace.AdAddress;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.GeoLocatedAddress;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.UserAddressServiceLocal;
import org.cyclos.impl.utils.conversion.EntityVOConverter;
import org.cyclos.model.users.addresses.AddressVO;
import org.cyclos.model.users.addresses.IAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AddressVOConverter
extends EntityVOConverter<AddressVO> {
    @Autowired
    UserAddressServiceLocal addressService;

    public AddressVOConverter() {
        super(AddressVO.class);
    }

    @Override
    protected void fill(Object object, AddressVO addressVO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        if (object instanceof GeoLocatedAddress) {
            UserAddress userAddress;
            super.fill(object, addressVO, objectArray, conversionContext);
            User user = null;
            if (object instanceof UserAddress) {
                userAddress = (UserAddress)object;
                user = userAddress.getUser();
            } else if (object instanceof AdAddress) {
                userAddress = (AdAddress)object;
                user = userAddress.getAd().getOwner();
            }
            if (user != null) {
                userAddress = this.configurationHandler.getAccessor((BasicUser)user);
                this.addressService.cleanDisabledAddressFields((IAddress)addressVO, (ConfigurationAccessor)userAddress);
            }
        }
    }
}

