/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.NumberExpression;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.CyclosVersion;
import org.cyclos.archive.model.ArchivedInfo;
import org.cyclos.entities.DatabaseHistoryLog;
import org.cyclos.entities.QDatabaseHistoryLog;
import org.cyclos.entities.messaging.ErrorLog;
import org.cyclos.entities.messaging.QErrorLog;
import org.cyclos.entities.system.CustomBackgroundTask;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.QBackgroundTaskExecution;
import org.cyclos.entities.utils.QRecurringTaskExecution;
import org.cyclos.entities.utils.RecurringTaskExecution;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.ArchiveHandler;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.AccountBalanceClosingRecurringTask;
import org.cyclos.impl.sql.DatabaseVacuumInformation;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.CustomBackgroundTaskServiceLocal;
import org.cyclos.impl.system.LicenseServiceLocal;
import org.cyclos.impl.system.PDFReportHandler;
import org.cyclos.impl.system.ScriptHelper;
import org.cyclos.impl.system.SystemMonitorServiceLocal;
import org.cyclos.impl.system.SystemMonitorSnapshot;
import org.cyclos.impl.users.ConnectedUserServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.cluster.MemberRunningTaskDescriptor;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.tasks.BackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandlerImplementor;
import org.cyclos.impl.utils.tasks.RecurringTask;
import org.cyclos.impl.utils.tasks.RecurringTaskHandlerImplementor;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.banking.accounts.ArchivingInfoVO;
import org.cyclos.model.messaging.ErrorLogType;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.monitor.ApplicationProperty;
import org.cyclos.model.system.monitor.BackgroundTaskData;
import org.cyclos.model.system.monitor.BackgroundTaskQuery;
import org.cyclos.model.system.monitor.BackgroundTaskStatus;
import org.cyclos.model.system.monitor.BaseTaskData;
import org.cyclos.model.system.monitor.CacheOrderBy;
import org.cyclos.model.system.monitor.CacheQuery;
import org.cyclos.model.system.monitor.DatabaseUpgradeData;
import org.cyclos.model.system.monitor.DatabaseUpgradeQuery;
import org.cyclos.model.system.monitor.JavaRuntimeData;
import org.cyclos.model.system.monitor.RecurringTaskData;
import org.cyclos.model.system.monitor.RecurringTaskQuery;
import org.cyclos.model.system.monitor.ServerData;
import org.cyclos.model.system.monitor.SystemInformationData;
import org.cyclos.model.system.monitor.SystemMonitorExportResult;
import org.cyclos.model.utils.CacheVO;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.server.utils.RequestMetricsHandler;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;

@Service
public class SystemMonitorServiceImpl
extends BaseServiceImpl
implements SystemMonitorServiceLocal {
    private static final Comparator<BaseTaskData> BY_NAME_COMPARATOR = Comparator.comparing(BaseTaskData::getName, Comparator.naturalOrder());
    private static final Comparator<RecurringTaskData> BY_NEXT_EXECUTION_DATE_ASC_COMPARATOR = Comparator.comparing(RecurringTaskData::getNextExecution, Comparator.nullsFirst(Comparator.naturalOrder()));
    private static final Comparator<RecurringTaskData> BY_RECURRENCE_ASC_COMPARATOR = Comparator.comparing(RecurringTaskData::getRecurrence, Comparator.nullsFirst(Comparator.naturalOrder()));
    private static final Comparator<CacheVO> BY_HIT_RATE_ASC_COMPARATOR = Comparator.comparing(cacheVO -> cacheVO.getStats().getHitRate()).thenComparing(Comparator.comparing(cacheVO -> cacheVO.getStats().getRequestCount()));
    @Autowired
    private ClusterHandler clusterHandler;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    @Autowired
    private BackgroundTaskHandlerImplementor backgroundTaskHandler;
    @Autowired
    private RecurringTaskHandlerImplementor recurringTaskHandler;
    @Autowired
    private PDFReportHandler pdfReportHandler;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ConnectedUserServiceLocal connectedUsersService;
    @Autowired
    private CustomBackgroundTaskServiceLocal customBackgroundTaskService;
    private List<RecurringTask> allRecurringTasks = new ArrayList<RecurringTask>();
    private List<BackgroundTask> builtinBackgroundTasks = new ArrayList<BackgroundTask>();
    private boolean isRunningInContainer;
    @Autowired(required=false)
    private ServletContext servletContext;
    @Autowired
    private RequestMetricsHandler requestMetricsHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private LicenseServiceLocal licenseService;
    @Autowired
    protected CyclosProperties cyclosProperties;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private ArchiveHandler archiveHandler;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private ScriptHelper scriptHelper;

    public void archiveData() throws FrameworkException {
        this.invokerHandler.getExecutorService().submit(() -> this.archiveHandler.archive());
    }

    public void clearCache(String string) throws FrameworkException {
        if (string == null) {
            this.clusterHandler.clearCaches();
        } else {
            this.cacheHandler.scheduleClear(CacheType.getByName((String)string));
        }
    }

    public SystemMonitorExportResult export() throws FrameworkException {
        SystemMonitorSnapshot systemMonitorSnapshot = new SystemMonitorSnapshot();
        systemMonitorSnapshot.setSystemInformation(this.getSystemInformation(null));
        systemMonitorSnapshot.setBackgroundTasks(this.listBackgroundTasks(new BackgroundTaskQuery()));
        systemMonitorSnapshot.setRecurringTasks(this.listRecurringTasks(new RecurringTaskQuery()));
        systemMonitorSnapshot.setCaches(this.listCaches(new CacheQuery()));
        DatabaseUpgradeQuery databaseUpgradeQuery = new DatabaseUpgradeQuery();
        databaseUpgradeQuery.setUnlimited();
        systemMonitorSnapshot.setDatabaseUpgrades(this.searchDatabaseHistoryLogs(databaseUpgradeQuery).getPageItems());
        systemMonitorSnapshot.setErrorLogs(this.getLastErrorLogs(5));
        SystemMonitorExportResult systemMonitorExportResult = new SystemMonitorExportResult();
        systemMonitorExportResult.setReportContent(this.pdfReportHandler.systemMonitorReport(systemMonitorSnapshot));
        systemMonitorExportResult.setReportName(this.message(SystemKeys.Monitor.REPORT_NAME, this.getFormatter().format(new Date())));
        return systemMonitorExportResult;
    }

    public String formatTask(ErrorLogType errorLogType, String string) {
        Object object2;
        String string2 = null;
        List<RecurringTask> list = null;
        switch (errorLogType) {
            case BACKGROUND_TASK: {
                try {
                    object2 = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    object2 = null;
                }
                if (object2 != null) {
                    try {
                        CustomBackgroundTask customBackgroundTask = this.find(CustomBackgroundTask.class, (Long)object2);
                        string2 = customBackgroundTask.getName();
                    }
                    catch (EntityNotFoundException entityNotFoundException) {
                        // empty catch block
                    }
                }
                if (string2 != null) break;
                list = this.builtinBackgroundTasks;
                break;
            }
            case RECURRING_TASK: {
                list = this.allRecurringTasks;
                break;
            }
        }
        if (list != null) {
            try {
                object2 = list.stream().filter(object -> object.getClass().getName().equals(string)).findFirst().get();
                string2 = this.getFormatter().format(object2);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public ServerData getServerData() {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        Runtime runtime = Runtime.getRuntime();
        JavaRuntimeData javaRuntimeData = new JavaRuntimeData();
        javaRuntimeData.setUsedMemoryInBytes(String.valueOf(memoryMXBean.getHeapMemoryUsage().getUsed()));
        javaRuntimeData.setAvailableMemoryInBytes(String.valueOf(runtime.freeMemory()));
        javaRuntimeData.setTotalMemoryInBytes(String.valueOf(runtime.totalMemory()));
        long l = runtime.maxMemory();
        javaRuntimeData.setMaxMemoryInBytes(String.valueOf(Long.MAX_VALUE == l ? -1L : l));
        javaRuntimeData.setVersion(Runtime.version().toString());
        SystemInfo systemInfo = new SystemInfo();
        HardwareAbstractionLayer hardwareAbstractionLayer = systemInfo.getHardware();
        CentralProcessor centralProcessor = hardwareAbstractionLayer.getProcessor();
        ServerData serverData = new ServerData();
        serverData.setActiveRequests(Integer.valueOf(this.requestMetricsHandler.getRequestCount()));
        serverData.setScriptingGlobalsSize(Integer.valueOf(this.scriptHelper.getGlobals().size()));
        serverData.setPhysicalProcessorCount(Integer.valueOf(centralProcessor.getLogicalProcessorCount()));
        if (this.isRunningInContainer) {
            serverData.setAvailableProcessorCount(Integer.valueOf(runtime.availableProcessors()));
        }
        CentralProcessor.ProcessorIdentifier processorIdentifier = centralProcessor.getProcessorIdentifier();
        serverData.setProcessorName((String)ObjectHelper.defaultValue((Object)StringHelper.trimToNull((Object)processorIdentifier.getName()), (Object)processorIdentifier.getIdentifier()));
        GlobalMemory globalMemory = hardwareAbstractionLayer.getMemory();
        serverData.setAvailablePhysicalMemory(String.valueOf(globalMemory.getAvailable()));
        serverData.setTotalPhysicalMemory(String.valueOf(globalMemory.getTotal()));
        serverData.setApplicationVersion(CyclosVersion.get());
        serverData.setApplicationCommitId(CyclosVersion.getCommitId());
        double d = -1.0;
        if (operatingSystemMXBean instanceof com.sun.management.OperatingSystemMXBean) {
            d = ((com.sun.management.OperatingSystemMXBean)operatingSystemMXBean).getSystemCpuLoad();
        }
        if (d >= 0.0) {
            serverData.setCpuLoadAverage(Double.valueOf(BigDecimal.valueOf(d * 100.0).setScale(2, RoundingMode.HALF_UP).doubleValue()));
        }
        serverData.setOperatingSystem(operatingSystemMXBean.getVersion());
        serverData.setJavaRuntimeData(javaRuntimeData);
        serverData.setRunningRecurringTasks(Integer.valueOf(this.recurringTaskHandler.getRunningTasks().size()));
        serverData.setRunningBackgroundTasks(Integer.valueOf(this.backgroundTaskHandler.getRunningTasks().size()));
        serverData.setWebServer(this.servletContext == null ? null : this.servletContext.getServerInfo());
        serverData.setApplicationProperties(this.cyclosProperties.getCyclosProperties().entrySet().stream().map(entry -> {
            ApplicationProperty applicationProperty = new ApplicationProperty();
            applicationProperty.setName((String)entry.getKey());
            applicationProperty.setValue(PropertyHelper.isSecretProperty((String)((String)entry.getKey())) ? "****" : (String)entry.getValue());
            return applicationProperty;
        }).collect(Collectors.toList()));
        serverData.setClusterConfiguration(this.clusterHandler.getMemberConfiguration());
        this.setWarningMessages(serverData);
        return serverData;
    }

    public SystemInformationData getSystemInformation(List<String> list) {
        NativeQueryHandler.DatabaseInfo databaseInfo = this.nativeQueryHandler.getDatabaseInfo();
        boolean bl = CollectionHelper.isNotEmpty(list);
        SystemInformationData systemInformationData = new SystemInformationData();
        systemInformationData.setApplicationName(this.getConfiguration().getApplicationName());
        systemInformationData.setOrganizationName(this.licenseService.getBasicLicense().getOrganizationName());
        systemInformationData.setLastBalanceClosingDate(this.getLastAccountClosingDate());
        MemberRunningTaskDescriptor memberRunningTaskDescriptor = this.clusterHandler.getMemberRunningTask(AccountBalanceClosingRecurringTask.class.getName());
        systemInformationData.setBalanceRebuildRunner(memberRunningTaskDescriptor == null ? null : memberRunningTaskDescriptor.getMemberName());
        systemInformationData.setRunningBalanceRebuildStartDate(memberRunningTaskDescriptor == null ? null : this.conversionHandler.toDateTime(memberRunningTaskDescriptor.getTaskDescriptor().getStartDate()));
        systemInformationData.setRunningDbVacuumStartDate(this.conversionHandler.toDateTime(this.nativeQueryHandler.getRunningVacuumStart()));
        DatabaseVacuumInformation databaseVacuumInformation = this.nativeQueryHandler.getVacuumInfo();
        systemInformationData.setLastdbAutoVacuumDate(this.conversionHandler.toDateTime(databaseVacuumInformation.getLastAutoVacuumDate()));
        systemInformationData.setLastdbVacuumDate(this.conversionHandler.toDateTime(databaseVacuumInformation.getLastVacuumDate()));
        systemInformationData.setLastdbAutoAnalyzeDate(this.conversionHandler.toDateTime(databaseVacuumInformation.getLastAutoAnalyzeDate()));
        systemInformationData.setLastdbAnalyzeDate(this.conversionHandler.toDateTime(databaseVacuumInformation.getLastAnalyzeDate()));
        systemInformationData.setClusterMembers(this.clusterHandler.getMembersData());
        if (bl) {
            systemInformationData.getClusterMembers().stream().filter(serverData -> list.contains(serverData.getMemberName())).forEach(serverData -> {
                serverData.setApplicationProperties(null);
                serverData.setClusterConfiguration(null);
                serverData.setWarningMessages(Collections.emptyList());
            });
        }
        systemInformationData.setClustering(this.clusterHandler.isCluster());
        systemInformationData.setDatabaseName(databaseInfo.getProductName());
        systemInformationData.setDatabaseVersion(databaseInfo.getProductVersion());
        systemInformationData.setBackgroundTasksQueueCapacity(this.clusterHandler.getMaxBackgroundTaskCapacity());
        int n3 = this.clusterHandler.getBackgroundTasksQueueSize();
        systemInformationData.setBackgroundTasksQueueSize(n3);
        Integer n4 = this.clusterHandler.getBackgroundTaskExecutions().values().stream().reduce((n, n2) -> n + n2).orElse(0);
        systemInformationData.setRunningBackgroundTasks(n4.intValue());
        this.removeFinishedBackgroundTaskExecutions();
        QBackgroundTaskExecution qBackgroundTaskExecution = QBackgroundTaskExecution.backgroundTaskExecution;
        int n5 = this.from(new EntityPath[]{qBackgroundTaskExecution}).count(qBackgroundTaskExecution.id);
        systemInformationData.setScheduledBackgroundTasks(n5);
        systemInformationData.setConnectedUsers(this.connectedUsersService.countConnectedUsers(null, false));
        systemInformationData.setArchivingInfo(this.getArchivingInfo());
        if (!bl) {
            systemInformationData.setApplicationVersions(this.getApplicationVersions());
        }
        return systemInformationData;
    }

    @PostConstruct
    public void initialize() {
        this.applicationContext.getBeansOfType(RecurringTask.class).values().stream().forEach(this.allRecurringTasks::add);
        this.applicationContext.getBeansOfType(BackgroundTask.class).values().stream().forEach(this.builtinBackgroundTasks::add);
        try {
            File file = new File("/.dockerenv");
            File file2 = new File("/proc/1/cgroup");
            Predicate<String> predicate = string -> string.contains("/docker/") || string.contains("/ecs/") || string.contains("/lxc/");
            this.isRunningInContainer = ManagementFactory.getRuntimeMXBean().getName().startsWith("1@") || file.exists() || file2.exists() && Files.lines(file2.toPath()).anyMatch(predicate);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<DatabaseHistoryLog> listAllFailedDatabaseHistoryLogs() {
        QDatabaseHistoryLog qDatabaseHistoryLog = QDatabaseHistoryLog.databaseHistoryLog;
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{qDatabaseHistoryLog}).where((com.querydsl.core.types.Predicate)qDatabaseHistoryLog.error.isNotNull());
        return this.addOrderExpression(dBQuery, qDatabaseHistoryLog).list((Expression)qDatabaseHistoryLog);
    }

    public List<BackgroundTaskData> listBackgroundTasks(BackgroundTaskQuery backgroundTaskQuery) {
        this.removeFinishedBackgroundTaskExecutions();
        QBackgroundTaskExecution qBackgroundTaskExecution = QBackgroundTaskExecution.backgroundTaskExecution;
        Map map = ((DBQuery)this.from(new EntityPath[]{qBackgroundTaskExecution}).groupBy((Expression)qBackgroundTaskExecution.className)).map((Expression)qBackgroundTaskExecution.className, (Expression)qBackgroundTaskExecution.id.count());
        Map map2 = this.clusterHandler.getBackgroundTaskExecutions();
        BackgroundTaskStatus backgroundTaskStatus = backgroundTaskQuery.getStatus();
        return Stream.of(this.builtinBackgroundTasks, this.customBackgroundTaskService.listAll()).flatMap(Collection::stream).map(object -> this.toBackgroundTaskData(object, map, map2)).filter(backgroundTaskData -> backgroundTaskStatus == null || backgroundTaskStatus == backgroundTaskData.getStatus()).sorted(BY_NAME_COMPARATOR).collect(Collectors.toList());
    }

    public List<CacheVO> listCaches(CacheQuery cacheQuery) throws FrameworkException {
        CacheOrderBy cacheOrderBy = (CacheOrderBy)ObjectHelper.defaultValue((Object)cacheQuery.getOrderBy(), (Object)CacheOrderBy.NAME);
        Comparator<CacheVO> comparator = null;
        switch (cacheOrderBy) {
            case NAME: {
                comparator = Comparator.comparing(CacheVO::getName);
                break;
            }
            case HIT_RATE_ASC: 
            case HIT_RATE_DESC: {
                comparator = BY_HIT_RATE_ASC_COMPARATOR;
                break;
            }
            case SIZE_ASC: 
            case SIZE_DESC: {
                comparator = Comparator.comparing(cacheVO -> Long.parseLong(cacheVO.getStats().getSize()));
                break;
            }
            case REQUEST_COUNT_ASC: 
            case REQUEST_COUNT_DESC: {
                comparator = Comparator.comparing(cacheVO -> Long.parseLong(cacheVO.getStats().getRequestCount()));
            }
        }
        if (comparator != null && cacheOrderBy.isDescendendOrder()) {
            comparator = comparator.reversed();
        }
        return this.clusterHandler.getCachesInformation(cacheQuery).stream().sorted(comparator).collect(Collectors.toList());
    }

    public List<CacheVO> listLocalCaches(CacheQuery cacheQuery) {
        return CacheType.all().stream().map(arg_0 -> ((CacheHandler)this.cacheHandler).getCacheIfInitialized(arg_0)).filter(Objects::nonNull).filter(cache -> StringHelper.isBlank((Object)cacheQuery.getName()) || cache.getType().getName().toLowerCase().contains(cacheQuery.getName().toLowerCase())).filter(cache -> !cacheQuery.isOnlyEmpty() || Long.parseLong(cache.getStats().getSize()) == 0L).map(cache -> {
            CacheVO cacheVO = new CacheVO();
            cacheVO.setName(cache.getType().getName());
            cacheVO.setStats(cache.getStats());
            return cacheVO;
        }).collect(Collectors.toList());
    }

    public List<RecurringTaskData> listRecurringTasks(RecurringTaskQuery recurringTaskQuery) {
        boolean bl = recurringTaskQuery.isOnlyRunning();
        RecurringTaskRecurrence recurringTaskRecurrence = recurringTaskQuery.getRecurrence();
        ArrayList<RecurringTaskData> arrayList = new ArrayList<RecurringTaskData>();
        Map map = this.clusterHandler.getRunningRecurringTasks();
        Map map2 = this.recurringTaskHandler.getTaskDelays();
        QRecurringTaskExecution qRecurringTaskExecution = QRecurringTaskExecution.recurringTaskExecution;
        Map map3 = this.from(new EntityPath[]{qRecurringTaskExecution}).map((Expression)qRecurringTaskExecution.className, (Expression)qRecurringTaskExecution);
        FormatterImpl formatterImpl = this.getFormatter();
        this.allRecurringTasks.stream().filter(recurringTask -> !bl || map.containsKey(recurringTask.getClass().getName())).filter(recurringTask -> recurringTaskRecurrence == null || recurringTask.getRecurrence() == recurringTaskRecurrence).map(recurringTask -> {
            MemberRunningTaskDescriptor memberRunningTaskDescriptor = (MemberRunningTaskDescriptor)map.get(recurringTask.getClass().getName());
            String string = memberRunningTaskDescriptor == null ? null : memberRunningTaskDescriptor.getMemberName();
            Date date = memberRunningTaskDescriptor == null ? null : memberRunningTaskDescriptor.getTaskDescriptor().getStartDate();
            boolean bl = string != null;
            RecurringTaskExecution recurringTaskExecution = (RecurringTaskExecution)map3.get(recurringTask.getClass().getName());
            RecurringTaskData recurringTaskData = new RecurringTaskData();
            recurringTaskData.setType(recurringTask.getClass().getName());
            recurringTaskData.setRecurrence(recurringTask.getRecurrence());
            recurringTaskData.setName(formatterImpl.format((HasMessageKey)recurringTask));
            if (!bl) {
                Long l = (Long)map2.get(recurringTask.getClass().getName());
                recurringTaskData.setNextExecutionIsAlmostNow(l != null && l <= 2L);
                recurringTaskData.setNextExecution(l == null ? null : this.conversionHandler.toDateTime(new Date(System.currentTimeMillis() + (l + 1L) * 1000L)));
            }
            recurringTaskData.setRunningBy(string);
            recurringTaskData.setRunningSince(this.conversionHandler.toDateTime(date));
            recurringTaskData.setLastStartDate(this.conversionHandler.toDateTime(recurringTaskExecution.getLastStartDate()));
            if (recurringTaskExecution.getLastStartDate() != null && recurringTaskExecution.getLastEndDate() != null) {
                recurringTaskData.setElapsedTime(String.valueOf(recurringTaskExecution.getLastEndDate().getTime() - recurringTaskExecution.getLastStartDate().getTime()));
            }
            return recurringTaskData;
        }).forEach(arrayList::add);
        if (recurringTaskQuery.getOrderBy() != null) {
            switch (recurringTaskQuery.getOrderBy()) {
                case NAME: {
                    Collections.sort(arrayList, BY_NAME_COMPARATOR);
                    break;
                }
                case NEXT_EXECUTION_ASC: {
                    Collections.sort(arrayList, BY_NEXT_EXECUTION_DATE_ASC_COMPARATOR);
                    break;
                }
                case NEXT_EXECUTION_DESC: {
                    Collections.sort(arrayList, BY_NEXT_EXECUTION_DATE_ASC_COMPARATOR.reversed());
                    break;
                }
                case RECURRENCE_ASC: {
                    Collections.sort(arrayList, BY_RECURRENCE_ASC_COMPARATOR);
                    break;
                }
                case RECURRENCE_DESC: {
                    Collections.sort(arrayList, BY_RECURRENCE_ASC_COMPARATOR.reversed());
                }
            }
        }
        return arrayList;
    }

    public void rebuildClosedAccountBalances() throws FrameworkException {
        QRecurringTaskExecution qRecurringTaskExecution = QRecurringTaskExecution.recurringTaskExecution;
        this.update((EntityPath<?>)qRecurringTaskExecution).setNull((Path)qRecurringTaskExecution.context).where(new com.querydsl.core.types.Predicate[]{qRecurringTaskExecution.className.eq((Object)AccountBalanceClosingRecurringTask.class.getName())}).execute();
        this.recurringTaskHandler.scheduleAwake(AccountBalanceClosingRecurringTask.class);
    }

    public void scheduleExecution(String string) {
        Class clazz = this.applicationContext.getType(string);
        if (RecurringTask.class.isAssignableFrom(clazz)) {
            this.recurringTaskHandler.scheduleAwake(clazz);
            InvocationContext.get().addTransactionEndListener(false, true, bl -> {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
        }
    }

    public Page<DatabaseUpgradeData> searchDatabaseHistoryLogs(DatabaseUpgradeQuery databaseUpgradeQuery) throws FrameworkException {
        QDatabaseHistoryLog qDatabaseHistoryLog = QDatabaseHistoryLog.databaseHistoryLog;
        DBQuery<?> dBQuery = this.from(new EntityPath[]{qDatabaseHistoryLog});
        dBQuery.where((com.querydsl.core.types.Predicate)(databaseUpgradeQuery.isOnlyError() ? qDatabaseHistoryLog.error.isNotNull() : qDatabaseHistoryLog.id.isNotNull()));
        if (QueryHelper.useParameter((Object)databaseUpgradeQuery.getPeriod())) {
            dBQuery.where(qDatabaseHistoryLog.date.period((DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)databaseUpgradeQuery.getPeriod())));
        }
        if (QueryHelper.useParameter((Object)databaseUpgradeQuery.getApplicationVersion())) {
            dBQuery.where((com.querydsl.core.types.Predicate)qDatabaseHistoryLog.applicationVersion.eq((Object)databaseUpgradeQuery.getApplicationVersion()));
        }
        return this.addOrderExpression(dBQuery, qDatabaseHistoryLog).page(DatabaseUpgradeData.class, (QueryParameters)databaseUpgradeQuery, (Expression)qDatabaseHistoryLog);
    }

    public void vacuumDatabase() throws FrameworkException {
        this.invokerHandler.submitAsInParallelTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> this.nativeQueryHandler.vacuum());
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private <Q extends DBQuery<?>> Q addOrderExpression(Q q, QDatabaseHistoryLog qDatabaseHistoryLog) {
        NumberExpression numberExpression = qDatabaseHistoryLog.applicationVersion.substring(2).castToNum(Integer.class);
        return (Q)((DBQuery)q.orderBy(new OrderSpecifier[]{numberExpression.desc(), qDatabaseHistoryLog.databaseVersion.desc()}));
    }

    private int compareApplicationVersions(String string, String string2) {
        String string3 = StringUtils.split((String)string, (char)'.')[1];
        String string4 = StringUtils.split((String)string2, (char)'.')[1];
        return Integer.valueOf(string3).compareTo(Integer.valueOf(string4)) * -1;
    }

    private List<String> getApplicationVersions() {
        QDatabaseHistoryLog qDatabaseHistoryLog = QDatabaseHistoryLog.databaseHistoryLog;
        List list = ((DBQuery)this.from(new EntityPath[]{qDatabaseHistoryLog}).distinct()).list((Expression)qDatabaseHistoryLog.applicationVersion);
        return CollectionHelper.sort((Collection)list, this::compareApplicationVersions);
    }

    private ArchivingInfoVO getArchivingInfo() {
        if (this.cyclosProperties.getArchivingMonths() < 1) {
            return null;
        }
        ArchivingInfoVO archivingInfoVO = new ArchivingInfoVO();
        try {
            ArchivedInfo archivedInfo = this.archiveHandler.info();
            archivingInfoVO.setCyclosArchivingDate(this.conversionHandler.toDateTime(this.applicationHandler.getApplication().getArchivingDate()));
            archivingInfoVO.setCyclosArchivingFinished(this.applicationHandler.getApplication().isArchivingFinished());
            archivingInfoVO.setExternalArchivingDate((DateTime)this.conversionHandler.convert(DateTime.class, (Object)archivedInfo.getArchivingDate()));
            archivingInfoVO.setFirstTransferDate((DateTime)this.conversionHandler.convert(DateTime.class, (Object)archivedInfo.getMinTransferDate()));
            archivingInfoVO.setLastTransferDate((DateTime)this.conversionHandler.convert(DateTime.class, (Object)archivedInfo.getMaxTransferDate()));
            archivingInfoVO.setExternalArchivingRunning(archivedInfo.isRunning());
            archivingInfoVO.setRevision(archivedInfo.getRevision() == null ? this.message(SystemKeys.Monitor.SUMMARY_ARCHIVING_EXTERNAL_REVISION_UNKNOWN, new Object[0]) : archivedInfo.getRevision());
        }
        catch (Exception exception) {
            this.getLogger().error("Error connecting to the archive application to read the information", (Throwable)exception);
            archivingInfoVO.setErrorMessage(this.message(SystemKeys.Monitor.ERROR_CAN_NOT_GET_ARCHIVING_INFO, new Object[0]));
        }
        return archivingInfoVO;
    }

    private BackgroundTaskStatus getBackgroundTaskStatus(Integer n, Integer n2) {
        n = Objects.requireNonNullElse(n, 0);
        n2 = Objects.requireNonNullElse(n2, 0);
        if (n == 0 && n2 == 0) {
            return BackgroundTaskStatus.IDLE;
        }
        return n == 0 ? BackgroundTaskStatus.SCHEDULED : BackgroundTaskStatus.RUNNING;
    }

    private DateTime getLastAccountClosingDate() {
        QRecurringTaskExecution qRecurringTaskExecution = QRecurringTaskExecution.recurringTaskExecution;
        Date date = (Date)((DBQuery)this.from(new EntityPath[]{qRecurringTaskExecution}).where((com.querydsl.core.types.Predicate)qRecurringTaskExecution.className.eq((Object)AccountBalanceClosingRecurringTask.class.getName()))).select((Expression)qRecurringTaskExecution.lastEndDate).fetchFirst();
        return this.conversionHandler.toDateTime(date);
    }

    private List<ErrorLog> getLastErrorLogs(int n) {
        QErrorLog qErrorLog = QErrorLog.errorLog;
        Network network = this.getSessionData().getNetwork();
        return ((DBQuery)((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qErrorLog}).where((com.querydsl.core.types.Predicate)(network != null ? qErrorLog.network().eq((Object)network) : qErrorLog.id.isNotNull()))).orderBy(qErrorLog.date.desc())).limit((long)n)).list((Expression)qErrorLog);
    }

    private void removeFinishedBackgroundTaskExecutions() {
        Future<ClusterHandler.FinishedExecutionsHandler> future = this.invokerHandler.getExecutorService().submit(() -> ((ClusterHandler.FinishedExecutionsHandler)this.clusterHandler.getFinishedBackgroundTaskExecutions()).remove());
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new IllegalStateException(exception);
        }
    }

    private void setWarningMessages(ServerData serverData) {
        ArrayList<String> arrayList = new ArrayList<String>();
        serverData.setWarningMessages(arrayList);
        Integer n = this.cyclosProperties.getMaxPoolSize();
        if (n != null) {
            int n2 = this.cyclosProperties.getMaxRecurringTasks() + this.cyclosProperties.getMaxBackgroundTasks();
            if (n < n2) {
                arrayList.add(this.message(SystemKeys.Monitor.WARNINGS_INVALID_DB_POOL_SIZE, n, n2));
            }
        }
    }

    private BackgroundTaskData toBackgroundTaskData(Object object, Map<String, Long> map, Map<String, Integer> map2) {
        String string;
        String string2;
        Object object2;
        if (object instanceof BackgroundTask) {
            object2 = (BackgroundTask)object;
            string2 = object2.getClass().getName();
            string = this.message(object2.getMessageKey(), new Object[0]);
        } else if (object instanceof CustomBackgroundTask) {
            object2 = (CustomBackgroundTask)object;
            string2 = object2.getId().toString();
            string = object2.getName();
        } else {
            throw new IllegalStateException("Invalid input: " + String.valueOf(object));
        }
        object2 = map.get(string2);
        Integer n = map2.get(string2);
        n = Objects.requireNonNullElse(n, 0);
        object2 = Objects.requireNonNullElse(object2, 0L);
        BackgroundTaskData backgroundTaskData = new BackgroundTaskData();
        backgroundTaskData.setType(string2);
        backgroundTaskData.setName(string);
        backgroundTaskData.setRunningExecutions(n);
        backgroundTaskData.setScheduledExecutions(Integer.valueOf(Math.max(0, (int)((Long)object2 - (long)n.intValue()))));
        backgroundTaskData.setStatus(this.getBackgroundTaskStatus(backgroundTaskData.getRunningExecutions(), backgroundTaskData.getScheduledExecutions()));
        return backgroundTaskData;
    }
}

