/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.Language;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.Property;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.languages.LanguageDTO;
import org.cyclos.security.system.LanguageServiceSecurity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class LanguageEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<Language, LanguageDTO> {
    @Autowired
    @Lazy
    private LanguageServiceSecurity languageServiceSecurity;

    public Class<Language> getEntityClass() {
        return Language.class;
    }

    public EntityLogType getType() {
        return EntityLogType.LANGUAGE;
    }

    public EntityLogDescriptor<? extends LanguageDTO> resolveLogDescriptor(Language language) {
        return new EntityLogDescriptor(LanguageDTO.class).property(LanguageDTO.NAME, GeneralKeys.Ui.NAME).property(LanguageDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).property(LanguageDTO.INTERNAL_NAME, GeneralKeys.Ui.INTERNAL_NAME).property((Property)LanguageDTO.PARENT, SystemKeys.Languages.PARENT).property((Property)LanguageDTO.TEMPLATE, SystemKeys.Languages.TEMPLATE);
    }

    @Override
    protected Language getEntityToViewLog(long l) {
        Language language = this.find(Language.class, l);
        if (this.languageServiceSecurity.canPerformOperation((SimpleEntity)language, CRUDOperation.READ)) {
            return language;
        }
        return null;
    }
}

