/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimeExpression;
import java.util.Collection;
import org.cyclos.entities.system.CustomWizardExecution;
import org.cyclos.entities.system.QCustomWizardExecution;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.utils.notifications.IncompleteWizardRegistrationNotifyingBackgroundTask;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.impl.utils.tasks.EntityBatchRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IncompleteWizardRegistrationsNotifyingRecurringTask
extends EntityBatchRecurringTask<CustomWizardExecution> {
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;
    @Autowired
    private CustomWizardServiceLocal customWizardService;

    public IncompleteWizardRegistrationsNotifyingRecurringTask() {
        super(CustomWizardExecution.class);
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.NOTIFY_USERS_ON_INCOMPLETE_REGISTRATIONS;
    }

    @Override
    protected void finish(CustomWizardExecution customWizardExecution, Throwable throwable) throws Throwable {
        if (throwable == null) {
            customWizardExecution.setNotified(Boolean.valueOf(true));
        }
    }

    @Override
    protected Collection<Long> nextIds() throws Throwable {
        QCustomWizardExecution qCustomWizardExecution = QCustomWizardExecution.customWizardExecution;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qCustomWizardExecution}).where((Predicate)qCustomWizardExecution.date.addInterval((Expression)qCustomWizardExecution.wizard().incompleteRegistrationNotifyInterval()).before((Expression)DateTimeExpression.currentTimestamp()).and((Predicate)qCustomWizardExecution.notified.isNull().or((Predicate)qCustomWizardExecution.notified.isFalse())))).limit(200L)).list((Expression)qCustomWizardExecution.id);
    }

    @Override
    protected void process(CustomWizardExecution customWizardExecution) throws Throwable {
        String string = this.customWizardService.storage(customWizardExecution).getVerifiedEmail();
        if (string != null) {
            this.backgroundTaskHandler.schedule(IncompleteWizardRegistrationNotifyingBackgroundTask.scheduling(customWizardExecution));
        }
    }
}

