/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.google.common.collect.Sets;
import com.mysema.commons.lang.CloseableIterator;
import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.ImportedField;
import org.cyclos.entities.system.ImportedFile;
import org.cyclos.entities.system.ImportedImage;
import org.cyclos.entities.system.ImportedLine;
import org.cyclos.entities.system.ImportedLineValue;
import org.cyclos.entities.system.ImportedStoredFile;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QImportedFile;
import org.cyclos.entities.system.QImportedImage;
import org.cyclos.entities.system.QImportedLine;
import org.cyclos.entities.system.QImportedLineValue;
import org.cyclos.entities.system.QUserSpecificImportedFile;
import org.cyclos.entities.system.UserPaymentImportedFile;
import org.cyclos.entities.system.UserSendVouchersImportedFile;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.QBackgroundTaskExecution;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.ServiceInvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.messaging.ErrorLogServiceLocal;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.system.ImportBackgroundTask;
import org.cyclos.impl.system.ImportHandler;
import org.cyclos.impl.system.ImportHelper;
import org.cyclos.impl.system.ImportServiceLocal;
import org.cyclos.impl.system.ImportWithImageHandler;
import org.cyclos.impl.system.ImportedImageServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.Bean;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FileParsingException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.vouchertypes.VoucherTypeVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.ImportExtensionPointEvent;
import org.cyclos.model.system.imports.AdImportedFileDTO;
import org.cyclos.model.system.imports.GeneralReferenceImportedFileDTO;
import org.cyclos.model.system.imports.ImportPaymentsConfirmationField;
import org.cyclos.model.system.imports.ImportProgressVO;
import org.cyclos.model.system.imports.ImportSearchContext;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.system.imports.ImportUserPaymentsConfirmationField;
import org.cyclos.model.system.imports.ImportUserSendVouchersConfirmationField;
import org.cyclos.model.system.imports.ImportedFieldVO;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.system.imports.ImportedFileData;
import org.cyclos.model.system.imports.ImportedFileDataParams;
import org.cyclos.model.system.imports.ImportedFileQuery;
import org.cyclos.model.system.imports.ImportedFileSearchData;
import org.cyclos.model.system.imports.ImportedFileStatus;
import org.cyclos.model.system.imports.ImportedFileVO;
import org.cyclos.model.system.imports.ImportedLineDTO;
import org.cyclos.model.system.imports.ImportedLineData;
import org.cyclos.model.system.imports.ImportedLineQuery;
import org.cyclos.model.system.imports.ImportedLineSearchData;
import org.cyclos.model.system.imports.ImportedLineStatus;
import org.cyclos.model.system.imports.ImportedLineVO;
import org.cyclos.model.system.imports.PaymentImportedFileDTO;
import org.cyclos.model.system.imports.RecordImportedFileDTO;
import org.cyclos.model.system.imports.TokenImportedFileDTO;
import org.cyclos.model.system.imports.TransferImportedFileDTO;
import org.cyclos.model.system.imports.UserImportedFileDTO;
import org.cyclos.model.system.imports.UserPaymentImportedFileDTO;
import org.cyclos.model.system.imports.UserSendVouchersImportedFileDTO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.FieldSelector;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.ValidationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

@Service
public class ImportServiceImpl
extends CRUDServiceImpl<ImportedFile, QImportedFile, ImportedFileDTO, ImportedFileData, ImportedFileDataParams>
implements ImportServiceLocal {
    private static final String ZIP_EXTENSION = ".zip";
    private static final String CSV_EXTENSION = ".csv";
    private static final int LINES_TO_READ_PER_TRANSACTION = 5;
    private static final String IMAGE_PATH_SEPARATOR = ",";
    private static final BidiMap<Class<? extends ImportedFileDTO>, ImportType> DTO_TYPE_MAPPING = new DualHashBidiMap();
    private static final List<ImportedFileStatus> ARCHIVABLE_STATUSES;
    private static final QImportedLine l;
    private static final QImportedLineValue v;
    private static final QImportedImage i;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private ErrorLogServiceLocal errorLogService;
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;
    @Autowired
    protected InvokerHandler invokerHandler;
    @Autowired
    protected ServiceInvokerHandler serviceInvokerHandler;
    @Autowired
    private ImportedImageServiceLocal importedImageService;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;
    private Map<ImportType, ImportHandler<?, ?, ?, ?>> mappings;

    public ImportServiceImpl() {
        super(ImportedFile.class, QImportedFile.importedFile, ImportedFileDTO.class);
    }

    public boolean abort(Long l) {
        ImportedFile importedFile = (ImportedFile)this.find(l);
        if (ObjectHelper.isOneOf((Object)importedFile.getStatus(), (Object[])new Object[]{ImportedFileStatus.IMPORTING, ImportedFileStatus.READING_CSV, ImportedFileStatus.READING_ZIP})) {
            this.setStatusAndNotifyExtensionPoints(importedFile, ImportedFileStatus.ABORTED);
            return true;
        }
        return false;
    }

    public long archiveImports() {
        int n = this.cyclosProperties.getArchiveImportsDays();
        if (n <= 0) {
            return 0L;
        }
        Date date = DateHelper.subtract((Date)DateHelper.now(), (TimeField)TimeField.DAYS, (int)n);
        QImportedFile qImportedFile = QImportedFile.importedFile;
        CloseableIterator closeableIterator = ((DBQuery)this.from(new EntityPath[]{qImportedFile}).where(new com.querydsl.core.types.Predicate[]{qImportedFile.creationDate.lt((Comparable)date), qImportedFile.status.in(ARCHIVABLE_STATUSES), qImportedFile.permanent.isFalse()})).iterate((Expression)qImportedFile);
        return this.processBatch(closeableIterator, (T importedFile) -> {
            switch (importedFile.getStatus()) {
                case INTERNAL_ERROR: 
                case INVALID: 
                case READY: 
                case ABORTED: {
                    this.remove(importedFile);
                    break;
                }
                case IMPORTED: {
                    QImportedLineValue qImportedLineValue = QImportedLineValue.importedLineValue;
                    this.delete((EntityPath<?>)qImportedLineValue).where(new com.querydsl.core.types.Predicate[]{qImportedLineValue.importedLine().importedFile().eq(importedFile)}).execute();
                    this.delete((EntityPath<?>)l).where(new com.querydsl.core.types.Predicate[]{l.importedFile().eq(importedFile)}).execute();
                    this.updateImportedFileStatus((ImportedFile)importedFile, ImportedFileStatus.ARCHIVED);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        });
    }

    public ImportedLine findLine(Long l) throws EntityNotFoundException {
        return (ImportedLine)this.entityManagerHandler.find(ImportedLine.class, l);
    }

    public ImportedLineData getImportedLineData(Long l) {
        FieldSelector fieldSelector = this.getSessionData().getRequestData().getFields();
        ImportedLine importedLine = this.find(ImportedLine.class, l);
        ImportedFile importedFile = importedLine.getImportedFile();
        ImportedLineData importedLineData = (ImportedLineData)this.conversionHandler.convert(ImportedLineData.class, (Object)importedLine);
        if (importedFile.getStatus() == ImportedFileStatus.READY) {
            importedLineData.setEditable(true);
            importedLineData.setCanSkip(importedLine.getStatus() == ImportedLineStatus.READY);
            importedLineData.setCanInclude(importedLine.getStatus() == ImportedLineStatus.SKIPPED);
        }
        HashSet hashSet = Sets.newHashSet((Object[])new String[]{ImportedLineDTO.VALUES.getName()});
        fieldSelector.addExclude(ImportedLineData.FILE.getName(), (Collection)hashSet);
        fieldSelector.addExclude(ImportedLineData.FIELDS.getName(), (Collection)hashSet);
        ImportedLineDTO importedLineDTO = (ImportedLineDTO)this.conversionHandler.convertExcluding(ImportedLineDTO.class, (Object)importedLine, hashSet.toArray());
        importedLineDTO.setValues(importedLine.getValues().stream().sorted(Comparator.comparing(importedLineValue -> importedLineValue.getImportedField())).map(ImportedLineValue::getValue).collect(Collectors.toList()));
        importedLineData.setDto((EntityDTO)importedLineDTO);
        return importedLineData;
    }

    public ImportProgressVO getImportProgress(ImportedFile importedFile) {
        int n2;
        int n3;
        Map<ImportedLineStatus, Integer> map = this.countLines(importedFile);
        int n4 = map.get(ImportedLineStatus.READY);
        int n5 = map.get(ImportedLineStatus.VALIDATION_ERROR);
        int n6 = map.get(ImportedLineStatus.SKIPPED);
        int n7 = map.get(ImportedLineStatus.IMPORT_ERROR);
        int n8 = map.get(ImportedLineStatus.IMPORTED);
        switch (importedFile.getStatus()) {
            case IMPORTING: {
                n3 = n4 + n8;
                n2 = n8;
                break;
            }
            case READING_CSV: {
                n3 = (Integer)ObjectHelper.defaultValue((Object)importedFile.getStoredFile().getLinesCount(), (Object)0);
                n2 = map.values().stream().mapToInt(n -> n).sum();
                break;
            }
            case READING_ZIP: {
                n3 = (Integer)ObjectHelper.defaultValue((Object)importedFile.getStoredFile().getImagesCount(), (Object)0);
                n2 = this.countImages(importedFile);
                break;
            }
            default: {
                n2 = 1;
                n3 = 1;
            }
        }
        ImportProgressVO importProgressVO = new ImportProgressVO();
        importProgressVO.setProgress(n3 == 0 ? 0.0 : (double)n2 / (double)n3);
        importProgressVO.setLinesReady(n4);
        importProgressVO.setLinesValidationError(n5);
        importProgressVO.setLinesSkipped(n6);
        importProgressVO.setLinesImportError(n7);
        importProgressVO.setLinesImported(n8);
        return importProgressVO;
    }

    public ImportType getImportType(ImportedFileDTO importedFileDTO) {
        return (ImportType)DTO_TYPE_MAPPING.get(importedFileDTO.getClass());
    }

    public ImportedLineSearchData getLineSearchData(@NotNull Long l) throws FrameworkException {
        ImportedFile importedFile = (ImportedFile)this.find(l);
        ImportHandler<?, ?, ?, ?> importHandler = this.resolveHandler(importedFile.getImportType());
        ImportedLineSearchData importedLineSearchData = new ImportedLineSearchData();
        importedLineSearchData.setImportedFile((ImportedFileVO)this.conversionHandler.convert(ImportedFileVO.class, (Object)importedFile));
        importedLineSearchData.setFieldsInList(this.conversionHandler.convertList(ImportedFieldVO.class, (Iterable)importHandler.getFieldsInList(importedFile)));
        importedLineSearchData.setCanSkipOrInclude(importedFile.getStatus() == ImportedFileStatus.READY);
        ImportedLineQuery importedLineQuery = new ImportedLineQuery();
        importedLineQuery.setImportedFileId(l);
        importedLineSearchData.setQuery((QueryParameters)importedLineQuery);
        return importedLineSearchData;
    }

    public String getName(ImportedField importedField) {
        ImportHandler<?, ?, ?, ?> importHandler = this.resolveHandler(importedField.getImportedFile().getImportType());
        return importHandler.fieldName(importedField);
    }

    public ImportedFileSearchData getSearchData(ImportSearchContext importSearchContext, UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = null;
        if (importSearchContext.isUserSpecific()) {
            user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        }
        UserVO userVO = (UserVO)this.conversionHandler.convert(UserVO.class, (Object)user);
        ImportedFileSearchData importedFileSearchData = new ImportedFileSearchData();
        ImportedFileQuery importedFileQuery = (ImportedFileQuery)QueryHelper.newQuery(ImportedFileQuery.class);
        importedFileQuery.setContext(importSearchContext);
        importedFileQuery.setUser(userVO);
        importedFileSearchData.setQuery((QueryParameters)importedFileQuery);
        importedFileSearchData.setUser(userVO);
        return importedFileSearchData;
    }

    public List<ImportType> importsWithPermission(User user) {
        return Stream.of(ImportType.values()).filter(ImportType::isUserSpecific).filter(importType -> this.permission((BasicUser)user).my(new Permission[]{importType.getMyPermission()}).user(new Permission[]{importType.getUserViewPermission()}).granted()).collect(Collectors.toList());
    }

    @PostConstruct
    public void initialize() {
        this.mappings = this.getApplicationContext().getBeansOfType(ImportHandler.class).values().stream().collect(Collectors.toMap(ImportHandler::getImportType, importHandler -> importHandler));
        if (this.mappings.size() != ImportType.values().length) {
            throw new IllegalStateException("Some import type has no mapped handler");
        }
    }

    public void markAsSkipped(Long l, List<Long> list, boolean bl) {
        ImportedFile importedFile = (ImportedFile)this.find(l);
        if (importedFile.getStatus() != ImportedFileStatus.READY) {
            throw new IllegalActionException("Can only skip / include lines if file status is " + String.valueOf(ImportedFileStatus.READY));
        }
        ImportedLineStatus importedLineStatus = bl ? ImportedLineStatus.SKIPPED : ImportedLineStatus.READY;
        ImportedLineStatus importedLineStatus2 = bl ? ImportedLineStatus.READY : ImportedLineStatus.SKIPPED;
        this.update((EntityPath<?>)ImportServiceImpl.l).set((Path)ImportServiceImpl.l.status, (Object)importedLineStatus).where(new com.querydsl.core.types.Predicate[]{ImportServiceImpl.l.importedFile().id.eq((Object)l), ImportServiceImpl.l.id.in(list), ImportServiceImpl.l.status.eq((Object)importedLineStatus2)}).execute();
    }

    @Override
    public ImportedFile newEntity(ImportedFileDataParams importedFileDataParams) {
        User user;
        ImportType importType = importedFileDataParams == null ? null : importedFileDataParams.getImportType();
        boolean bl = importType == null ? false : importType.isUserSpecific();
        User user2 = user = bl ? this.userLocatorHandler.toUserOrCurrent((BasicUserVO)importedFileDataParams.getUser()) : null;
        if (importType == null || bl != (user != null)) {
            throw new ValidationException();
        }
        ImportHandler<?, ?, ?, ?> importHandler = this.resolveHandler(importType);
        return importHandler.newEntity(importedFileDataParams);
    }

    public void process(Long l) {
        ImportedFile importedFile = (ImportedFile)this.find(l);
        this.process(importedFile);
    }

    public long resumeImport(Long l) {
        Pair pair = (Pair)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> {
            ImportedFile importedFile = (ImportedFile)this.entityManagerHandler.find(ImportedFile.class, l);
            return (Pair)this.invokerHandler.runAs(SessionDataFactory.system((Network)importedFile.getNetwork()), () -> Pair.create((Object)importedFile, (Object)(importedFile.getBy() == null ? this.getSessionData() : SessionDataFactory.user((BasicUser)importedFile.getBy()))));
        });
        ImportedFile importedFile = (ImportedFile)pair.getFirst();
        SessionData sessionData = (SessionData)pair.getSecond();
        try {
            switch (importedFile.getStatus()) {
                case READING_ZIP: {
                    return this.readZipFile(importedFile, sessionData);
                }
                case READING_CSV: {
                    return this.readCSVFile(importedFile.getId(), importedFile.getImportType(), importedFile.getListSeparator().getChar(), sessionData);
                }
                case IMPORTING: {
                    return this.processImportedFile(importedFile.getId(), importedFile.getImportType(), sessionData);
                }
            }
            return 0L;
        }
        catch (Exception exception) {
            this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_WRITE, transactionStatus -> {
                ImportedFile importedFile = (ImportedFile)this.find(l);
                importedFile.setErrorMessage(this.message(SystemKeys.Imports.ERROR_INTERNAL_ERROR, new Object[0]));
                this.setStatusAndNotifyExtensionPoints(importedFile, ImportedFileStatus.INTERNAL_ERROR);
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                String string = stringWriter.toString();
                StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
                String string2 = ModelHelper.unqualifyInternalName((String)stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
                this.errorLogService.create(string2, String.format("{\"importedFileId\": %s}", l), string, null, null);
                return null;
            });
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }

    public void saveImportedLine(ImportedLineDTO importedLineDTO) {
        ImportedLine importedLine = this.find(ImportedLine.class, importedLineDTO.getId());
        ImportedFile importedFile = importedLine.getImportedFile();
        List list = importedFile.getFields();
        for (int i = 0; i < list.size(); ++i) {
            ImportedField importedField = (ImportedField)list.get(i);
            ImportedLineValue importedLineValue = importedLine.getImportedValue(importedField);
            if (importedLineValue == null) continue;
            importedLineValue.setValue((String)importedLineDTO.getValues().get(i));
        }
        ImportHandler<?, ?, ?, ?> importHandler = this.resolveHandler(importedFile.getImportType());
        importHandler.validateImportedLine(importedLine, null);
        this.validateImagePaths(importHandler, importedFile, importedLine);
        if (importedLine.getStatus() == ImportedLineStatus.VALIDATION_ERROR) {
            importedLine.setStatus(ImportedLineStatus.READY);
            importedLine.setErrorMessage(null);
        }
    }

    public Page<ImportedFileVO> search(ImportedFileQuery importedFileQuery) {
        QUserSpecificImportedFile qUserSpecificImportedFile;
        User user;
        DatePeriod datePeriod;
        DBQuery dBQuery = (DBQuery)this.from(this.$).orderBy(((QImportedFile)this.$).creationDate.desc());
        ImportSearchContext importSearchContext = importedFileQuery.getContext();
        if (importSearchContext != null) {
            dBQuery.where((com.querydsl.core.types.Predicate)((QImportedFile)this.$).instanceOfAny((Class[])this.resolveImportedFileClasses(importSearchContext.getImportTypes())));
        }
        if (QueryHelper.useParameter((Object)(datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)importedFileQuery.getCreationDate())))) {
            dBQuery.where(((QImportedFile)this.$).creationDate.period(datePeriod));
        }
        if (QueryHelper.useParameter((Object)importedFileQuery.getStatuses())) {
            dBQuery.where((com.querydsl.core.types.Predicate)((QImportedFile)this.$).status.in((Collection)importedFileQuery.getStatuses()));
        }
        if (QueryHelper.useParameter((Object)importedFileQuery.getImportTypes())) {
            dBQuery.where((com.querydsl.core.types.Predicate)((QImportedFile)this.$).instanceOfAny((Class[])this.resolveImportedFileClasses(importedFileQuery.getImportTypes())));
        }
        if ((user = (User)this.conversionHandler.convert(User.class, (Object)importedFileQuery.getUser())) != null) {
            qUserSpecificImportedFile = QUserSpecificImportedFile.userSpecificImportedFile;
            ((DBQuery)dBQuery.from((EntityPath)qUserSpecificImportedFile)).where((com.querydsl.core.types.Predicate)qUserSpecificImportedFile.id.eq((Expression)((QImportedFile)this.$).id));
            dBQuery.where((com.querydsl.core.types.Predicate)qUserSpecificImportedFile.user().eq((Object)user));
        }
        qUserSpecificImportedFile = this.conversionHandler.convertPage(ImportedFileVO.class, (Iterable)dBQuery.page((QueryParameters)importedFileQuery, (Expression)this.$));
        return qUserSpecificImportedFile;
    }

    public Page<ImportedLineVO> searchImportedLines(ImportedLineQuery importedLineQuery) {
        ImportHandler<?, ?, ?, ?> importHandler;
        ImportedFile importedFile = (ImportedFile)this.find(importedLineQuery.getImportedFileId());
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{l}).where((com.querydsl.core.types.Predicate)l.importedFile().eq((Object)importedFile));
        if (CollectionHelper.isNotEmpty((Iterable)importedLineQuery.getLineNumbers())) {
            dBQuery.where((com.querydsl.core.types.Predicate)ImportServiceImpl.l.lineNumber.in((Collection)importedLineQuery.getLineNumbers()));
        }
        if (StringHelper.isNotBlank((Object)importedLineQuery.getKeywords())) {
            importHandler = QImportedLineValue.importedLineValue;
            dBQuery.where((com.querydsl.core.types.Predicate)((DBQuery)this.subQuery(new EntityPath[]{importHandler}).where(new com.querydsl.core.types.Predicate[]{importHandler.importedLine().eq((Expression)l), importHandler.value.containsIgnoreCase(importedLineQuery.getKeywords())})).exists());
        }
        if (CollectionHelper.isNotEmpty((Iterable)importedLineQuery.getStatuses())) {
            dBQuery.where((com.querydsl.core.types.Predicate)ImportServiceImpl.l.status.in((Collection)importedLineQuery.getStatuses()));
        }
        dBQuery.orderBy(ImportServiceImpl.l.lineNumber.asc());
        dBQuery.distinct();
        importHandler = this.resolveHandler(importedFile.getImportType());
        List list = importHandler.getFieldsInList(importedFile);
        Page page = dBQuery.page((QueryParameters)importedLineQuery, (Expression)l);
        return PageImpl.transformed((Page)page, importedLine -> {
            ImportedLineVO importedLineVO = (ImportedLineVO)this.conversionHandler.convertExcluding(ImportedLineVO.class, importedLine, new Object[]{ImportedLineVO.VALUES});
            this.fillLineValues((ImportedLine)importedLine, list, importedLineVO);
            return importedLineVO;
        });
    }

    public Long upload(ImportedFileDTO importedFileDTO, SerializableInputStream serializableInputStream, String string) {
        ImportType importType = this.getImportType(importedFileDTO);
        ImportHandler<?, ?, ?, ?> importHandler = this.resolveHandler(importType);
        Validator validator = importHandler.resolveValidator(importedFileDTO);
        validator.property((Property)ImportedFileDTO.FILE_NAME, SystemKeys.Imports.FILE).required();
        this.validate(validator, importedFileDTO, "upload");
        ImportedFile importedFile = importHandler.newImportedFile(importedFileDTO);
        importedFile.setCreationDate(DateHelper.now());
        importedFile.setBy(this.getLoggedUser());
        importedFile.setChannel(this.getSessionData().getChannel());
        importedFile.setProcessAutomatically(importedFileDTO.isProcessAutomatically());
        importedFile.setPermanent(importedFileDTO.isPermanent());
        importedFile.setFileName(importedFileDTO.getFileName());
        importedFile.setDescription(importedFileDTO.getDescription());
        importedFile.setListSeparator(this.getSessionData().getConfiguration().getListSeparator());
        this.checkConfirmationPassword(importedFileDTO, importedFile, CRUDOperation.CREATE, string);
        ImportedStoredFile importedStoredFile = new ImportedStoredFile();
        File file = null;
        try {
            file = serializableInputStream.file();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException();
        }
        this.persist((IEntity)importedFile);
        importedStoredFile.setImportedFile(importedFile);
        importedStoredFile.setName(importedFileDTO.getFileName());
        importedStoredFile.setLength(Integer.valueOf((int)file.length()));
        if (importedFileDTO.getFileName().toLowerCase().endsWith(ZIP_EXTENSION)) {
            importedStoredFile.setContentType("application/zip");
            this.setStatusAndNotifyExtensionPoints(importedFile, ImportedFileStatus.READING_ZIP);
        } else {
            importedStoredFile.setContentType("text/csv");
            try {
                importedStoredFile.setLinesCount(Integer.valueOf(ImportHelper.countNumberOfLines(new FileInputStream(file))));
            }
            catch (Exception exception) {
                importedFile.setErrorMessage(exception.getMessage());
                this.setStatusAndNotifyExtensionPoints(importedFile, ImportedFileStatus.INTERNAL_ERROR);
                return importedFile.getId();
            }
            this.setStatusAndNotifyExtensionPoints(importedFile, ImportedFileStatus.READING_CSV);
        }
        this.storedFileHandler.save((StoredFile)importedStoredFile, serializableInputStream);
        importedFile.setStoredFile(importedStoredFile);
        this.backgroundTaskHandler.schedule(ImportBackgroundTask.scheduling(importedFile));
        return importedFile.getId();
    }

    @Override
    protected ImportedFileData getData(ImportedFile importedFile) {
        ImportHandler<?, ?, ?, ?> importHandler = this.resolveHandler(importedFile.getImportType());
        SessionData sessionData = this.getSessionData();
        FieldSelector fieldSelector = sessionData.getRequestData().getFields();
        ImportedFileData importedFileData = importHandler.getData(importedFile);
        importedFileData.setImportType(this.getImportType((ImportedFileDTO)importedFileData.getDto()));
        if (fieldSelector.includes(ImportedFileData.FIELDS.getName())) {
            importedFileData.setFields(this.conversionHandler.convertList(ImportedFieldVO.class, (Iterable)importedFile.getFields()));
        }
        if (importedFile.isPersistent()) {
            int n;
            if (fieldSelector.includes(ImportedFileData.PROGRESS.getName())) {
                importedFileData.setProgress(this.getImportProgress(importedFile));
            }
            if (fieldSelector.includes(ImportedFileData.IGNORED_FIELDS.getName())) {
                importedFileData.setIgnoredFields(importedFile.getIgnoredFields());
            }
            if (fieldSelector.includes(ImportedFileData.ARCHIVE_DATE.getName()) && !importedFile.isPermanent() && ARCHIVABLE_STATUSES.contains(importedFile.getStatus()) && (n = this.cyclosProperties.getArchiveImportsDays()) > 0) {
                Date date = DateHelper.add((Date)importedFile.getCreationDate(), (TimeField)TimeField.DAYS, (int)n);
                date = DateHelper.shiftToBegin((Date)date, (TimeZone)this.getConfiguration().getTimeZone());
                importedFileData.setArchiveDate(this.conversionHandler.toDateTime(date));
            }
            importedFileData.setCanProcess(importedFile.getStatus() == ImportedFileStatus.READY);
            importedFileData.setCanAbort(EnumSet.of(ImportedFileStatus.READING_CSV, ImportedFileStatus.READING_ZIP, ImportedFileStatus.IMPORTING).contains(importedFile.getStatus()));
        } else {
            importedFileData.setSeparator(sessionData.getConfiguration().getListSeparator().getValue());
        }
        return importedFileData;
    }

    @Override
    protected CreateDeviceConfirmationParams getDeviceConfirmationParams(ImportedFileDTO importedFileDTO, ImportedFile importedFile, CRUDOperation cRUDOperation) {
        switch (importedFile.getImportType()) {
            case PAYMENTS_IMPORT: {
                return ImportPaymentsConfirmationField.confirmation();
            }
            case USER_PAYMENTS_IMPORT: {
                UserPaymentImportedFileDTO userPaymentImportedFileDTO = (UserPaymentImportedFileDTO)importedFileDTO;
                UserPaymentImportedFile userPaymentImportedFile = (UserPaymentImportedFile)importedFile;
                TransferTypeVO transferTypeVO = userPaymentImportedFileDTO != null ? userPaymentImportedFileDTO.getPaymentType() : new TransferTypeVO(userPaymentImportedFile.getPaymentType().getId());
                return ImportUserPaymentsConfirmationField.confirmation((TransferTypeVO)transferTypeVO);
            }
            case USER_SEND_VOUCHERS_IMPORT: {
                UserSendVouchersImportedFileDTO userSendVouchersImportedFileDTO = (UserSendVouchersImportedFileDTO)importedFileDTO;
                UserSendVouchersImportedFile userSendVouchersImportedFile = (UserSendVouchersImportedFile)importedFile;
                VoucherTypeVO voucherTypeVO = userSendVouchersImportedFileDTO != null ? userSendVouchersImportedFileDTO.getVoucherType() : new VoucherTypeVO(userSendVouchersImportedFile.getVoucherType().getId());
                return ImportUserSendVouchersConfirmationField.confirmation((VoucherTypeVO)voucherTypeVO);
            }
        }
        return null;
    }

    @Override
    protected void onBeforeRemove(ImportedFile importedFile) {
        Set set = Stream.of(ImportedFileStatus.values()).map(importedFileStatus -> importedFile.getId() + IMAGE_PATH_SEPARATOR + String.valueOf(importedFileStatus)).collect(Collectors.toSet());
        QBackgroundTaskExecution qBackgroundTaskExecution = QBackgroundTaskExecution.backgroundTaskExecution;
        this.entityManagerHandler.delete((EntityPath)qBackgroundTaskExecution).where(new com.querydsl.core.types.Predicate[]{qBackgroundTaskExecution.className.eq((Object)ImportBackgroundTask.class.getName()), qBackgroundTaskExecution.context.in(set)}).execute();
        if (importedFile.getStoredFile() != null) {
            this.storedFileHandler.remove(importedFile.getStoredFile().getId().longValue());
        }
        this.importedImageService.removeAll((BaseEntity)importedFile);
        this.delete((EntityPath<?>)v).where(new com.querydsl.core.types.Predicate[]{v.importedLine().importedFile().eq((Object)importedFile)}).execute();
        this.delete((EntityPath<?>)l).where(new com.querydsl.core.types.Predicate[]{l.importedFile().eq((Object)importedFile)}).execute();
    }

    @Override
    protected Object onBeforeSave(ImportedFile importedFile, ImportedFile importedFile2) {
        if (importedFile.isTransient()) {
            throw new IllegalActionException("Use the upload(ImportedFileDTO, SerializedInputStream) method to create a new import");
        }
        return null;
    }

    protected void process(ImportedFile importedFile) {
        if (importedFile.getStatus() != ImportedFileStatus.READY) {
            throw new IllegalActionException("Cannot be processed with status " + String.valueOf(importedFile.getStatus()));
        }
        Integer n = this.countLines(importedFile).get(ImportedLineStatus.READY);
        if (n == 0) {
            this.setStatusAndNotifyExtensionPoints(importedFile, ImportedFileStatus.IMPORTED);
        } else {
            this.setStatusAndNotifyExtensionPoints(importedFile, ImportedFileStatus.IMPORTING);
            this.backgroundTaskHandler.schedule(ImportBackgroundTask.scheduling(importedFile));
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QImportedFile)this.$).network());
    }

    @Override
    protected Validator resolveValidator(ImportedFileDTO importedFileDTO) {
        Validator validator;
        ImportedFile importedFile;
        ImportType importType = this.getImportType(importedFileDTO);
        if (importType == null && importedFileDTO.isPersistent()) {
            importedFile = (ImportedFile)this.find(importedFileDTO.getId());
            importType = importedFile.getImportType();
            validator = (ImportedFileDTO)ClassHelper.instantiate((Class)((Class)DTO_TYPE_MAPPING.getKey((Object)importType)));
            importedFileDTO.copyPropertiesTo((Bean)validator);
            importedFileDTO = validator;
        }
        importedFile = this.resolveHandler(importType);
        validator = (Validator)ObjectHelper.defaultValue((Object)importedFile.resolveValidator(importedFileDTO), Validator::new);
        validator.property((Property)ImportedFileDTO.FILE_NAME, SystemKeys.Imports.FILE).required();
        return validator;
    }

    @Override
    protected boolean shouldCheckConfirmationPassword(ImportedFile importedFile, CRUDOperation cRUDOperation) {
        return cRUDOperation == CRUDOperation.CREATE && importedFile.getImportType().requiresConfirmationPassword();
    }

    private void copyContentToTempFile(Long l, SessionData sessionData, File file) {
        this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_ONLY_TRANSACTION, transactionStatus -> {
            ImportedFile importedFile = (ImportedFile)this.find(l);
            ImportedStoredFile importedStoredFile = importedFile.getStoredFile();
            try (SerializableInputStream serializableInputStream = this.storedFileHandler.getContent((StoredFile)importedStoredFile);){
                FileUtils.copyInputStreamToFile((InputStream)serializableInputStream, (File)file);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
            return importedStoredFile;
        });
    }

    private int countImages(ImportedFile importedFile) {
        return ((DBQuery)this.from(new EntityPath[]{i}).where((com.querydsl.core.types.Predicate)i.importedFile().eq((Object)importedFile))).count(ImportServiceImpl.i.id);
    }

    private Map<ImportedLineStatus, Integer> countLines(ImportedFile importedFile) {
        EnumMap<ImportedLineStatus, Integer> enumMap = new EnumMap<ImportedLineStatus, Integer>(ImportedLineStatus.class);
        if (importedFile.getLinesImported() != null) {
            enumMap.put(ImportedLineStatus.READY, (Integer)ObjectHelper.defaultValue((Object)importedFile.getLinesReady(), (Object)0));
            enumMap.put(ImportedLineStatus.VALIDATION_ERROR, (Integer)ObjectHelper.defaultValue((Object)importedFile.getLinesValidationError(), (Object)0));
            enumMap.put(ImportedLineStatus.SKIPPED, (Integer)ObjectHelper.defaultValue((Object)importedFile.getLinesSkipped(), (Object)0));
            enumMap.put(ImportedLineStatus.IMPORT_ERROR, (Integer)ObjectHelper.defaultValue((Object)importedFile.getLinesImportError(), (Object)0));
            enumMap.put(ImportedLineStatus.IMPORTED, (Integer)ObjectHelper.defaultValue((Object)importedFile.getLinesImported(), (Object)0));
        } else {
            Map map = ((DBQuery)((DBQuery)this.from(new EntityPath[]{l}).where((com.querydsl.core.types.Predicate)l.importedFile().eq((Object)importedFile))).groupBy((Expression)ImportServiceImpl.l.status)).map((Expression)ImportServiceImpl.l.status, (Expression)l.count());
            for (ImportedLineStatus importedLineStatus : ImportedLineStatus.values()) {
                enumMap.put(importedLineStatus, map.getOrDefault(importedLineStatus, 0L).intValue());
            }
        }
        return enumMap;
    }

    private void fillLineValues(ImportedLine importedLine, List<ImportedField> list, ImportedLineVO importedLineVO) {
        importedLineVO.setValues(list.stream().map(arg_0 -> ((ImportedLine)importedLine).getValue(arg_0)).collect(Collectors.toList()));
    }

    private List<ImportedImage> getImagesByPath(ImportedFile importedFile, String string2) {
        List list = StringHelper.splitTrimming((String)string2, (String)IMAGE_PATH_SEPARATOR);
        if (!list.isEmpty()) {
            List list2 = ((DBQuery)this.from(new EntityPath[]{i}).where(new com.querydsl.core.types.Predicate[]{i.importedFile().eq((Object)importedFile), ImportServiceImpl.i.name.in((Collection)list)})).list((Expression)i);
            return list.stream().map(string -> list2.stream().filter(importedImage -> importedImage.getName().equals(string)).findFirst().orElseThrow(() -> {
                String string2 = this.translationHandler.message(SystemKeys.Imports.ERROR_INVALID_IMAGE_PATH, new Object[]{string});
                return new ValidationException(new ValidationResult(string2));
            })).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void markLineAsError(SessionData sessionData, Long l, Exception exception, ExtensionPointAccessor extensionPointAccessor) {
        TransactionCallback transactionCallback = transactionStatus -> {
            ImportedLine importedLine = this.find(ImportedLine.class, l);
            importedLine.setStatus(ImportedLineStatus.IMPORT_ERROR);
            ImportHandler<?, ?, ?, ?> importHandler = this.resolveHandler(importedLine.getImportedFile().getImportType());
            importHandler.onImportError(importedLine, (Throwable)exception);
            extensionPointAccessor.attribute("error", (Object)exception).fireSaved();
            return null;
        };
        this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_WRITE, transactionCallback);
    }

    private void processImages(ImportHandler<?, ?, ?, ?> importHandler, ImportedFile importedFile, ImportedLine importedLine, SimpleEntity simpleEntity) {
        ImportWithImageHandler importWithImageHandler;
        ImportedField importedField;
        if (importHandler instanceof ImportWithImageHandler && (importedField = (importWithImageHandler = (ImportWithImageHandler)importHandler).getImagesField(importedFile)) != null) {
            String string = importedLine.getValue(importedField);
            List<ImportedImage> list = this.getImagesByPath(importedFile, string);
            importWithImageHandler.processImportedImages(simpleEntity, list);
        }
    }

    private long processImportedFile(Long l, ImportType importType, SessionData sessionData) {
        boolean bl = false;
        MutableObject mutableObject = new MutableObject();
        ImportHandler<?, ?, ?, ?> importHandler = this.resolveHandler(importType);
        MutableObject mutableObject2 = new MutableObject();
        TransactionCallback transactionCallback = transactionStatus -> {
            ImportedFile importedFile = (ImportedFile)this.find(l);
            if (importedFile.getStatus() != ImportedFileStatus.IMPORTING) {
                this.updateCounters(importedFile);
                return true;
            }
            ImportedLine importedLine = (ImportedLine)((DBQuery)((DBQuery)this.from(new EntityPath[]{ImportServiceImpl.l}).where(new com.querydsl.core.types.Predicate[]{ImportServiceImpl.l.importedFile().eq((Object)importedFile), ImportServiceImpl.l.status.eq((Object)ImportedLineStatus.READY)})).orderBy(ImportServiceImpl.l.lineNumber.asc())).singleResult((Expression)ImportServiceImpl.l);
            if (importedLine == null) {
                importedFile.setProcessingDate(DateHelper.now());
                this.setStatusAndNotifyExtensionPoints(importedFile, ImportedFileStatus.IMPORTED);
                this.importedImageService.removeAll((BaseEntity)importedFile);
                importHandler.finishImport(importedFile);
                return true;
            }
            if (mutableObject2.getValue() == null) {
                mutableObject2.setValue((Object)this.extensionPointService.newAccessor((ExtensionPointEvent)ImportExtensionPointEvent.LINE_PROCESSED, new ExtensionPointFilter(importType)));
            }
            ExtensionPointAccessor extensionPointAccessor = ((ExtensionPointAccessor)mutableObject2.getValue()).attribute("file", (Object)importedFile).attribute("line", (Object)importedLine).attribute("entity", null).attribute("error", null);
            extensionPointAccessor.fireValidated();
            Object object = importHandler.instantiateContext();
            SimpleEntity simpleEntity = null;
            try {
                simpleEntity = importHandler.processImportedLine(importedLine, object);
                importedLine = this.find(ImportedLine.class, importedLine.getId());
                importedFile = importedLine.getImportedFile();
                this.processImages(importHandler, importedFile, importedLine, simpleEntity);
                importedLine.setStatus(ImportedLineStatus.IMPORTED);
                importedLine.setImportedEntityId(simpleEntity.getId());
                extensionPointAccessor.attribute("entity", (Object)simpleEntity).fireSaved();
            }
            catch (Exception exception) {
                mutableObject.setValue((Object)importedLine.getId());
                throw exception;
            }
            return false;
        };
        long l2 = 0L;
        while (!bl) {
            mutableObject.setValue(null);
            try {
                bl = (Boolean)this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_WRITE, transactionCallback);
            }
            catch (Exception exception) {
                Long l3 = (Long)mutableObject.getValue();
                if (l3 == null) {
                    throw new IllegalStateException(exception);
                }
                this.markLineAsError(sessionData, l3, exception, (ExtensionPointAccessor)mutableObject2.getValue());
            }
            if (bl) continue;
            ++l2;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long processZipFile(File file, ImportedFile importedFile, SessionData sessionData, boolean bl) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        try {
            List list = CollectionHelper.asStream(zipFile.entries()).filter(zipEntry -> StringUtils.endsWithIgnoreCase((CharSequence)zipEntry.getName(), (CharSequence)CSV_EXTENSION)).collect(Collectors.toList());
            if (list.size() != 1) {
                this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_WRITE, transactionStatus -> {
                    importedFile.setErrorMessage(this.message(SystemKeys.Imports.INVALID_NUMBER_OF_CSV_FILES, new Object[0]));
                    this.setStatusAndNotifyExtensionPoints(importedFile, ImportedFileStatus.INVALID);
                    return null;
                });
                long l = 0L;
                return l;
            }
            ZipEntry zipEntry2 = (ZipEntry)list.get(0);
            List list2 = !bl ? null : CollectionHelper.asStream(zipFile.entries()).filter(zipEntry -> ServerImageHelper.ImageType.hasImageExtension((String)zipEntry.getName())).collect(Collectors.toList());
            List list3 = !bl ? null : (List)this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_ONLY, transactionStatus -> ((DBQuery)this.from(new EntityPath[]{i}).where((com.querydsl.core.types.Predicate)i.importedFile().eq((Object)importedFile))).list((Expression)ImportServiceImpl.i.name));
            this.readZipFileContent(importedFile.getId(), sessionData, zipFile, zipEntry2, list2, list3);
            long l = list2.size() + 1;
            return l;
        }
        finally {
            IOHelper.close((Closeable)zipFile);
        }
    }

    /*
     * Exception decompiling
     */
    private long readCSVFile(Long var1_1, ImportType var2_2, char var3_3, SessionData var4_4) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<ImportedField> readFields(Long l, SessionData sessionData, CSVReader cSVReader) throws IOException {
        return (List)this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_WRITE, transactionStatus -> {
            ImportedFile importedFile = (ImportedFile)this.find(l);
            if (importedFile.getFields().isEmpty()) {
                String[] stringArray;
                try {
                    stringArray = cSVReader.readNextSilently();
                }
                catch (IOException iOException) {
                    throw new FileParsingException((Throwable)iOException);
                }
                ImportHandler<?, ?, ?, ?> importHandler = this.resolveHandler(importedFile.getImportType());
                Predicate predicate = importHandler.getAllowedImportFieldsPredicate(importedFile);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = StringHelper.trimToNull((Object)stringArray[i]);
                    if (string == null) continue;
                    if (predicate.test(string)) {
                        Pair<String, String> pair = ImportHelper.extractCanonicalFieldAndId(stringArray[i]);
                        ImportedField importedField = new ImportedField();
                        importedField.setIndex(i);
                        importedField.setImportedFile(importedFile);
                        importedField.setFieldName((String)pair.getFirst());
                        importedField.setFieldId((String)pair.getSecond());
                        this.persist((IEntity)importedField);
                        importedFile.getFields().add(importedField);
                        continue;
                    }
                    arrayList.add(string);
                }
                importedFile.setIgnoredFields(arrayList);
                if (importedFile.getFields().isEmpty()) {
                    this.setStatusAndNotifyExtensionPoints(importedFile, ImportedFileStatus.INVALID);
                    importedFile.setErrorMessage(this.message(SystemKeys.Imports.ERROR_IMPORT_HEADERS_NOT_FOUND, new Object[0]));
                    return null;
                }
                Set set = importHandler.getMissingRequiredFields(importedFile, Arrays.asList(stringArray));
                if (!set.isEmpty()) {
                    this.setStatusAndNotifyExtensionPoints(importedFile, ImportedFileStatus.INVALID);
                    importedFile.setErrorMessage(this.message(SystemKeys.Imports.ERROR_MISSING_REQUIRED_IMPORT_HEADERS, StringHelper.join((Collection)set, (String)", ")));
                    return null;
                }
            }
            return importedFile.getFields();
        });
    }

    private ReadLineResult readLine(ImportedFile importedFile, MutableInt mutableInt, CSVReader cSVReader) {
        String[] stringArray;
        try {
            stringArray = cSVReader.readNext();
        }
        catch (CsvValidationException | IOException throwable) {
            throw new FileParsingException(throwable);
        }
        if (stringArray == null) {
            return ReadLineResult.EOF;
        }
        if (stringArray.length == 1 && StringHelper.trimToNull((Object)stringArray[0]) == null) {
            return ReadLineResult.EMPTY;
        }
        ImportedLine importedLine = new ImportedLine();
        importedLine.setStatus(ImportedLineStatus.READY);
        importedLine.setImportedFile(importedFile);
        importedLine.setLineNumber(Integer.valueOf(mutableInt.intValue()));
        this.persist((IEntity)importedLine);
        importedFile.getFields().forEach(importedField -> {
            ImportedLineValue importedLineValue = new ImportedLineValue();
            importedLineValue.setImportedField(importedField);
            importedLineValue.setImportedLine(importedLine);
            try {
                importedLineValue.setValue(StringHelper.trimToNull((Object)stringArray[importedField.getIndex()].trim()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.persist((IEntity)importedLineValue);
            importedLine.getValues().add(importedLineValue);
        });
        return ReadLineResult.of(importedLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readZipFile(ImportedFile importedFile, SessionData sessionData) throws IOException {
        ImportHandler<?, ?, ?, ?> importHandler = this.resolveHandler(importedFile.getImportType());
        File file = this.cyclosProperties.newTempFile("import" + importedFile.getId(), ZIP_EXTENSION);
        try {
            this.copyContentToTempFile(importedFile.getId(), sessionData, file);
            boolean bl = importHandler instanceof ImportWithImageHandler;
            long l = this.processZipFile(file, importedFile, sessionData, bl);
            return l;
        }
        finally {
            file.delete();
        }
    }

    private void readZipFileContent(Long l, SessionData sessionData, ZipFile zipFile, ZipEntry zipEntry, List<? extends ZipEntry> list, List<String> list2) {
        if (CollectionHelper.isNotEmpty(list)) {
            for (ZipEntry zipEntry2 : list) {
                Boolean bl;
                String string = zipEntry2.getName();
                if (list2.contains(string) || !(bl = (Boolean)this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_WRITE, transactionStatus -> {
                    ImportedFile importedFile = (ImportedFile)this.find(l);
                    if (importedFile.getStatus() != ImportedFileStatus.READING_ZIP) {
                        this.updateCounters(importedFile);
                        return true;
                    }
                    ServerImageHelper.ImageType imageType = ServerImageHelper.ImageType.getByFileName((String)zipEntry2.getName());
                    try (SerializableInputStream serializableInputStream = new SerializableInputStream(zipFile.getInputStream(zipEntry2));){
                        this.importedImageService.save((Object)new ImportedFileVO(l), string, serializableInputStream, imageType.getContentType());
                    }
                    catch (IOException iOException) {
                        throw new FileParsingException((Throwable)iOException);
                    }
                    return false;
                })).booleanValue()) continue;
                return;
            }
        }
        this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_WRITE, transactionStatus -> {
            ImportedFile importedFile = (ImportedFile)this.find(l);
            if (importedFile.getStatus() != ImportedFileStatus.READING_ZIP) {
                this.updateCounters(importedFile);
                return null;
            }
            ImportedStoredFile importedStoredFile = importedFile.getStoredFile();
            try (SerializableInputStream serializableInputStream = new SerializableInputStream(zipFile.getInputStream(zipEntry));){
                ImportedStoredFile importedStoredFile2 = new ImportedStoredFile();
                File file = serializableInputStream.forceCopyToFile();
                importedStoredFile2.setImportedFile(importedFile);
                importedStoredFile2.setName(zipEntry.getName());
                importedStoredFile2.setLength(Integer.valueOf((int)file.length()));
                importedStoredFile2.setContentType("text/csv");
                this.storedFileHandler.save((StoredFile)importedStoredFile2, serializableInputStream);
                importedFile.setStoredFile(importedStoredFile2);
            }
            catch (IOException iOException) {
                throw new FileParsingException((Throwable)iOException);
            }
            this.storedFileHandler.remove(importedStoredFile.getId().longValue());
            this.setStatusAndNotifyExtensionPoints(importedFile, ImportedFileStatus.READING_CSV);
            this.backgroundTaskHandler.schedule(ImportBackgroundTask.scheduling(importedFile));
            return null;
        });
    }

    private ImportHandler<?, ?, ?, ?> resolveHandler(ImportType importType) {
        return this.mappings.get(importType);
    }

    private Class<? extends ImportedFile>[] resolveImportedFileClasses(Collection<ImportType> collection) {
        Class[] classArray = new Class[collection.size()];
        Iterator<ImportType> iterator = collection.iterator();
        for (int i = 0; i < collection.size(); ++i) {
            ImportType importType = iterator.next();
            classArray[i] = this.resolveHandler(importType).getImportedFileClass();
        }
        return classArray;
    }

    private void setStatusAndNotifyExtensionPoints(ImportedFile importedFile, ImportedFileStatus importedFileStatus) {
        ImportedFileStatus importedFileStatus2 = importedFile.getStatus();
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)ImportExtensionPointEvent.FILE_STATUS_CHANGED, new ExtensionPointFilter(importedFile.getImportType())).attribute("file", (Object)importedFile).attribute("oldStatus", (Object)importedFileStatus2).attribute("newStatus", (Object)importedFileStatus);
        extensionPointAccessor.fireValidated();
        importedFile.setStatus(importedFileStatus);
        this.updateCounters(importedFile);
        extensionPointAccessor.fireSaved();
    }

    private void updateCounters(ImportedFile importedFile) {
        if (importedFile.getStatus().isFinal()) {
            importedFile.setLinesImported(null);
            importedFile.setLinesImportError(null);
            importedFile.setLinesReady(null);
            importedFile.setLinesSkipped(null);
            importedFile.setLinesValidationError(null);
            ImportProgressVO importProgressVO = this.getImportProgress(importedFile);
            importedFile.setLinesImported(Integer.valueOf(importProgressVO.getLinesImported()));
            importedFile.setLinesImportError(Integer.valueOf(importProgressVO.getLinesImportError()));
            importedFile.setLinesReady(Integer.valueOf(importProgressVO.getLinesReady()));
            importedFile.setLinesSkipped(Integer.valueOf(importProgressVO.getLinesSkipped()));
            importedFile.setLinesValidationError(Integer.valueOf(importProgressVO.getLinesValidationError()));
        }
    }

    private void updateImportedFileStatus(ImportedFile importedFile, ImportedFileStatus importedFileStatus) {
        QImportedFile qImportedFile = QImportedFile.importedFile;
        this.update((EntityPath<?>)qImportedFile).set((Path)qImportedFile.status, (Object)importedFileStatus).where(new com.querydsl.core.types.Predicate[]{qImportedFile.id.eq((Object)importedFile.getId())}).execute();
        this.refresh(importedFile);
    }

    private void validateImagePaths(ImportHandler<?, ?, ?, ?> importHandler, ImportedFile importedFile, ImportedLine importedLine) {
        ImportWithImageHandler importWithImageHandler;
        ImportedField importedField;
        if (importHandler instanceof ImportWithImageHandler && (importedField = (importWithImageHandler = (ImportWithImageHandler)importHandler).getImagesField(importedFile)) != null) {
            this.getImagesByPath(importedFile, importedLine.getValue(importedField));
        }
    }

    private /* synthetic */ Boolean lambda$readCSVFile$21(Long l, MutableObject mutableObject, ImportType importType, MutableInt mutableInt, CSVReader cSVReader, ImportHandler importHandler, Object object, TransactionStatus transactionStatus) {
        ImportedFile importedFile = this.find(ImportedFile.class, l);
        if (importedFile.getStatus() != ImportedFileStatus.READING_CSV) {
            this.updateCounters(importedFile);
            return true;
        }
        if (mutableObject.getValue() == null) {
            mutableObject.setValue((Object)this.extensionPointService.newAccessor((ExtensionPointEvent)ImportExtensionPointEvent.LINE_READ, new ExtensionPointFilter(importType)));
        }
        block10: for (int i = 0; i < 5; ++i) {
            mutableInt.increment();
            ReadLineResult readLineResult = this.readLine(importedFile, mutableInt, cSVReader);
            switch (readLineResult.getStatus().ordinal()) {
                case 1: {
                    continue block10;
                }
                case 2: {
                    this.setStatusAndNotifyExtensionPoints(importedFile, ImportedFileStatus.READY);
                    this.storedFileHandler.remove(importedFile.getStoredFile().getId().longValue());
                    importedFile.setStoredFile(null);
                    if (importedFile.isProcessAutomatically()) {
                        this.process(importedFile);
                    }
                    return true;
                }
                case 0: {
                    ImportedLine importedLine = readLineResult.getLine();
                    if (importedLine.getStatus() == ImportedLineStatus.READY) {
                        try {
                            importHandler.validateImportedLine(importedLine, object);
                            this.validateImagePaths(importHandler, importedFile, importedLine);
                        }
                        catch (ValidationException validationException) {
                            String string = validationException.getValidation().getFirstError();
                            if (StringHelper.isBlank((Object)string)) {
                                string = this.message(GeneralKeys.Errors.VALIDATION, new Object[0]);
                            }
                            importedLine.setStatus(ImportedLineStatus.VALIDATION_ERROR);
                            importedLine.setErrorMessage(string);
                        }
                        catch (PermissionDeniedException permissionDeniedException) {
                            importedLine.setStatus(ImportedLineStatus.VALIDATION_ERROR);
                            importedLine.setErrorMessage(this.message(GeneralKeys.Errors.PERMISSION_DENIED, new Object[0]));
                        }
                        catch (EntityNotFoundException entityNotFoundException) {
                            importedLine.setStatus(ImportedLineStatus.VALIDATION_ERROR);
                            importedLine.setErrorMessage(this.message(GeneralKeys.Errors.ENTITY_NOT_FOUND, entityNotFoundException.getEntityType()));
                        }
                        catch (Exception exception) {
                            importedLine.setStatus(ImportedLineStatus.VALIDATION_ERROR);
                            importedLine.setErrorMessage(ExceptionUtils.getStackTrace((Throwable)exception));
                        }
                    }
                    ExtensionPointAccessor extensionPointAccessor = ((ExtensionPointAccessor)mutableObject.getValue()).attribute("file", (Object)importedFile).attribute("line", (Object)importedLine);
                    extensionPointAccessor.fireValidated();
                    extensionPointAccessor.fireSaved();
                }
            }
        }
        return false;
    }

    private /* synthetic */ Integer lambda$readCSVFile$20(Long l, TransactionStatus transactionStatus) {
        return (Integer)((DBQuery)this.from(new EntityPath[]{ImportServiceImpl.l}).where((com.querydsl.core.types.Predicate)ImportServiceImpl.l.importedFile().id.eq((Object)l))).singleResult((Expression)ImportServiceImpl.l.lineNumber.max());
    }

    static {
        DTO_TYPE_MAPPING.put(UserImportedFileDTO.class, (Object)ImportType.USERS_IMPORT);
        DTO_TYPE_MAPPING.put(AdImportedFileDTO.class, (Object)ImportType.ADS_IMPORT);
        DTO_TYPE_MAPPING.put(RecordImportedFileDTO.class, (Object)ImportType.RECORDS_IMPORT);
        DTO_TYPE_MAPPING.put(GeneralReferenceImportedFileDTO.class, (Object)ImportType.GENERAL_REFERENCES_IMPORT);
        DTO_TYPE_MAPPING.put(PaymentImportedFileDTO.class, (Object)ImportType.PAYMENTS_IMPORT);
        DTO_TYPE_MAPPING.put(TransferImportedFileDTO.class, (Object)ImportType.TRANSFERS_IMPORT);
        DTO_TYPE_MAPPING.put(TokenImportedFileDTO.class, (Object)ImportType.TOKENS_IMPORT);
        DTO_TYPE_MAPPING.put(UserPaymentImportedFileDTO.class, (Object)ImportType.USER_PAYMENTS_IMPORT);
        DTO_TYPE_MAPPING.put(UserSendVouchersImportedFileDTO.class, (Object)ImportType.USER_SEND_VOUCHERS_IMPORT);
        if (DTO_TYPE_MAPPING.size() != ImportType.values().length) {
            throw new IllegalStateException("Some ImportedFileDTO was not mapped");
        }
        ARCHIVABLE_STATUSES = Arrays.asList(ImportedFileStatus.INTERNAL_ERROR, ImportedFileStatus.INVALID, ImportedFileStatus.READY, ImportedFileStatus.ABORTED, ImportedFileStatus.IMPORTED);
        l = QImportedLine.importedLine;
        v = QImportedLineValue.importedLineValue;
        i = QImportedImage.importedImage;
    }

    private static class ReadLineResult {
        public static final ReadLineResult EOF = new ReadLineResult(ReadLineStatus.EOF, null);
        public static final ReadLineResult EMPTY = new ReadLineResult(ReadLineStatus.EMPTY, null);
        private ReadLineStatus status;
        private ImportedLine line;

        public static ReadLineResult of(ImportedLine importedLine) {
            return new ReadLineResult(ReadLineStatus.LINE, importedLine);
        }

        private ReadLineResult(ReadLineStatus readLineStatus, ImportedLine importedLine) {
            this.status = readLineStatus;
            this.line = importedLine;
        }

        public ImportedLine getLine() {
            return this.line;
        }

        public ReadLineStatus getStatus() {
            return this.status;
        }
    }

    static enum ReadLineStatus {
        LINE,
        EMPTY,
        EOF;

    }
}

