/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.ExportFormat;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.Property;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.exportformats.ExportFormatDTO;
import org.cyclos.security.system.ExportFormatServiceSecurity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ExportFormatEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<ExportFormat, ExportFormatDTO> {
    @Autowired
    @Lazy
    private ExportFormatServiceSecurity exportFormatServiceSecurity;

    public Class<ExportFormat> getEntityClass() {
        return ExportFormat.class;
    }

    public EntityLogType getType() {
        return EntityLogType.EXPORT_FORMAT;
    }

    public EntityLogDescriptor<? extends ExportFormatDTO> resolveLogDescriptor(ExportFormat exportFormat) {
        return new EntityLogDescriptor(ExportFormatDTO.class).property(ExportFormatDTO.NAME, GeneralKeys.Ui.NAME).property(ExportFormatDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).property(ExportFormatDTO.INTERNAL_NAME, GeneralKeys.Ui.INTERNAL_NAME).property((Property)ExportFormatDTO.BINARY, SystemKeys.ExportFormats.BINARY).property((Property)ExportFormatDTO.CONTENT_TYPE, SystemKeys.ExportFormats.CONTENT_TYPE).property((Property)ExportFormatDTO.CONTEXTS, SystemKeys.ExportFormats.CONTEXTS).property((Property)ExportFormatDTO.ENABLED, SystemKeys.ExportFormats.ENABLED).property((Property)ExportFormatDTO.ENCODING, SystemKeys.ExportFormats.ENCODING).property((Property)ExportFormatDTO.FILE_EXTENSION, SystemKeys.ExportFormats.FILE_EXTENSION).property((Property)ExportFormatDTO.SCRIPT, SystemKeys.ExportFormats.SCRIPT).property((Property)ExportFormatDTO.SCRIPT_PARAMETERS, SystemKeys.ExportFormats.SCRIPT_PARAMETERS);
    }

    @Override
    protected ExportFormat getEntityToViewLog(long l) {
        ExportFormat exportFormat = this.find(ExportFormat.class, l);
        if (this.exportFormatServiceSecurity.canPerformOperation((SimpleEntity)exportFormat, CRUDOperation.READ)) {
            return exportFormat;
        }
        return null;
    }
}

