/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.DefaultUserImage;
import org.cyclos.entities.system.QDefaultUserImage;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.system.BaseImageServiceImpl;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.DefaultUserImageServiceLocal;
import org.cyclos.impl.system.TempImageServiceLocal;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.configurations.DefaultUserImageVO;
import org.cyclos.model.system.images.ImageNature;
import org.cyclos.server.utils.SerializableInputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultUserImageServiceImpl
extends BaseImageServiceImpl<DefaultUserImage, QDefaultUserImage, Long>
implements DefaultUserImageServiceLocal {
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private TempImageServiceLocal tempImageService;

    public DefaultUserImageServiceImpl() {
        super(ImageNature.DEFAULT_USER, DefaultUserImage.class, QDefaultUserImage.defaultUserImage);
    }

    @Override
    public DefaultUserImage find(Long l) {
        return (DefaultUserImage)this.rawEntityManagerHandler.find(DefaultUserImage.class, l);
    }

    public DefaultUserImageVO getImageVO(ConfigurationVO configurationVO) throws FrameworkException {
        ConfigurationAccessor configurationAccessor = configurationVO == null ? this.getConfiguration() : this.configurationHandler.getAccessor((Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO));
        return (DefaultUserImageVO)this.conversionHandler.convert(DefaultUserImageVO.class, (Object)configurationAccessor.getDefaultUserImage());
    }

    public Long importTempImage(Configuration configuration, TempImage tempImage) {
        if (configuration.getDefaultUserImage() != null) {
            this.storedFileHandler.remove(configuration.getDefaultUserImage().getId().longValue());
        }
        DefaultUserImage defaultUserImage = (DefaultUserImage)this.conversionHandler.convert(this.imageType, (Object)tempImage);
        defaultUserImage.setConfiguration(configuration);
        this.tempImageService.move(tempImage, (StoredFile)defaultUserImage);
        configuration.setDefaultUserImage(defaultUserImage);
        return defaultUserImage.getId();
    }

    public DefaultUserImageVO load(@NotNull Long l) throws FrameworkException {
        return (DefaultUserImageVO)this.conversionHandler.convert(DefaultUserImageVO.class, (Object)this.find(l));
    }

    @Override
    public DefaultUserImage newImage(Long l) {
        throw new UnsupportedOperationException("save() was overridden: this method is never invoked");
    }

    public DefaultUserImageVO save(Long l, String string, SerializableInputStream serializableInputStream, String string2) throws FrameworkException {
        throw new IllegalStateException("Must be saved by temp image");
    }

    protected void clearAccessorCache(DefaultUserImage defaultUserImage) {
        Long l = defaultUserImage.getConfiguration().getId();
        this.cacheHandler.schedulePartialEvict(CacheType.CONFIGURATION_ACCESSOR, (SerializablePredicate & Serializable)configurationAccessorCacheKey -> configurationAccessorCacheKey.matchesConfigurationAndMethod(l, "getDefaultUserImage"));
    }

    @Override
    protected void onAfterRemove(DefaultUserImage defaultUserImage) {
        this.clearAccessorCache(defaultUserImage);
    }

    @Override
    protected void onAfterSave(DefaultUserImage defaultUserImage) {
        this.clearAccessorCache(defaultUserImage);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QDefaultUserImage.defaultUserImage.configuration().network(), true);
    }
}

