/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.system.CustomField;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.system.BaseCustomFieldPossibleValueServiceLocal;
import org.cyclos.impl.utils.conversion.EntityVOConverter;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueQuery;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.stereotype.Component;

@Component
public class CustomFieldDetailedVOConverter
extends EntityVOConverter<CustomFieldDetailedVO> {
    private Map<Class<? extends CustomField<?, ?, ?>>, BaseCustomFieldPossibleValueServiceLocal<?, ?, ?>> servicesPerType;

    public CustomFieldDetailedVOConverter() {
        super(CustomFieldDetailedVO.class);
    }

    @PostConstruct
    public void initialize() {
        Map map = this.getApplicationContext().getBeansOfType(BaseCustomFieldPossibleValueServiceLocal.class);
        this.servicesPerType = new HashMap();
        for (BaseCustomFieldPossibleValueServiceLocal baseCustomFieldPossibleValueServiceLocal : map.values()) {
            this.servicesPerType.put(baseCustomFieldPossibleValueServiceLocal.getCustomFieldClass(), baseCustomFieldPossibleValueServiceLocal);
        }
    }

    @Override
    protected void fill(Object object, CustomFieldDetailedVO customFieldDetailedVO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        if (object instanceof CustomField) {
            CustomField customField = (CustomField)object;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (objectArray != null) {
                CollectionUtils.addAll(arrayList, (Object[])objectArray);
            }
            arrayList.add(CustomFieldDetailedVO.POSSIBLE_VALUES.getName());
            super.fill(object, customFieldDetailedVO, arrayList.toArray(), conversionContext);
            CustomFieldType customFieldType = customField.getType();
            if (customFieldType.isEnumerated()) {
                BaseCustomFieldPossibleValueServiceLocal<?, ?, ?> baseCustomFieldPossibleValueServiceLocal = this.servicesPerType.get(customField.getClass());
                if (baseCustomFieldPossibleValueServiceLocal == null) {
                    throw new IllegalStateException("No " + BaseCustomFieldPossibleValueServiceLocal.class.getSimpleName() + " found for cusom field type " + String.valueOf(customField.getClass()));
                }
                CustomFieldPossibleValueQuery customFieldPossibleValueQuery = new CustomFieldPossibleValueQuery();
                customFieldPossibleValueQuery.setField(new CustomFieldVO(customField.getId()));
                customFieldPossibleValueQuery.setUnlimited();
                List list = baseCustomFieldPossibleValueServiceLocal.search(customFieldPossibleValueQuery).getPageItems();
                customFieldDetailedVO.setPossibleValues(list);
            } else if (customFieldType == CustomFieldType.DATE && customField.isDefaultDateToday()) {
                customFieldDetailedVO.setDefaultDateValue(this.conversionHandler.toDateTime(new Date()));
            } else if (customFieldType == CustomFieldType.STRING && StringHelper.isNotBlank((Object)customFieldDetailedVO.getPattern())) {
                customFieldDetailedVO.setDefaultStringValue(MaskHelper.applyMask((String)customFieldDetailedVO.getPattern(), (String)customFieldDetailedVO.getDefaultStringValue()));
            }
        } else {
            super.fill(object, customFieldDetailedVO, objectArray, conversionContext);
        }
    }
}

