/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.ICSVWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.QCurrency;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ExportHandler;
import org.cyclos.impl.system.TabularExportHandlerImpl;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.model.system.exportformats.BuiltInExportFormat;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.server.utils.SerializableInputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CSVExportHandlerImpl
extends TabularExportHandlerImpl {
    @Autowired
    private CyclosProperties cyclosProperties;

    public BuiltInExportFormat getBuiltInFormat() {
        return BuiltInExportFormat.CSV;
    }

    @Override
    protected SerializableInputStream build(ExportHandler.ExportParameters exportParameters, List<TabularExportHandlerImpl.Column> list) {
        int n = list.size();
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        char c = configurationAccessor.getListSeparator().getValue().charAt(0);
        CSVParser cSVParser = new CSVParserBuilder().withSeparator(c).build();
        FormatterImpl formatterImpl = this.getFormatter(configurationAccessor);
        File file = this.cyclosProperties.newTempFile(exportParameters.getContext().name(), ".csv");
        try {
            List<String> list2 = list.stream().map(TabularExportHandlerImpl.Column::getName).collect(Collectors.toList());
            String[] stringArray = list2.toArray(new String[n]);
            DataIterator dataIterator = exportParameters.getEntities();
            try (ICSVWriter iCSVWriter = new CSVWriterBuilder((Writer)new PrintWriter(file)).withParser((ICSVParser)cSVParser).build();){
                iCSVWriter.writeNext(stringArray);
                this.processBatch(dataIterator, (T object) -> {
                    for (int i = 0; i < n; ++i) {
                        String string;
                        Object object2;
                        Object object3 = ((TabularExportHandlerImpl.Column)list.get(i)).getValue(object);
                        if (object3 instanceof CurrencyAmount) {
                            object2 = (CurrencyAmount)object3;
                            string = formatterImpl.format(object2.getAmount(), object2.getCurrency().getPrecision());
                        } else if (object3 instanceof BigDecimal) {
                            object2 = (BigDecimal)object3;
                            string = formatterImpl.format((BigDecimal)object2, ((BigDecimal)object2).scale());
                        } else if (object3 instanceof Currency) {
                            object2 = (Currency)object3;
                            string = this.getTranslatedValue((BaseEntity)object2, QCurrency.currency.symbol);
                        } else {
                            string = formatterImpl.format(object3);
                        }
                        stringArray[i] = string;
                    }
                    iCSVWriter.writeNext(stringArray);
                });
            }
            iCSVWriter = new SerializableInputStream(file);
            iCSVWriter.setPartialData(dataIterator.isPartialData());
            return iCSVWriter;
        }
        catch (IOException iOException) {
            file.delete();
            throw new UncheckedIOException("Error exporting file to CSV", iOException);
        }
    }
}

