/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import org.cyclos.entities.system.CustomField;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.PropertyLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.model.Property;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.fields.CustomFieldDTO;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.utils.IDecimalRange;
import org.cyclos.utils.Pair;
import org.springframework.stereotype.Component;

@Component
public abstract class BaseCustomFieldEntityLogHandlerImpl<CF extends CustomField, CFDTO extends CustomFieldDTO>
extends BaseEntityLogHandlerImpl<CF, CFDTO> {
    @Override
    public Pair<Object, Object> getValues(CF CF, CF CF2, PropertyLogDescriptor<CFDTO> propertyLogDescriptor) {
        if (CF.getType() != CustomFieldType.DECIMAL) {
            return null;
        }
        Pair pair = new Pair(null, null);
        FormatterImpl formatterImpl = this.getFormatter();
        if (propertyLogDescriptor.getAccess().getPropertyName().equals(CustomFieldDTO.DECIMAL_VALUE_RANGE.getName())) {
            pair.setFirst((Object)formatterImpl.format((IDecimalRange)CF.getDecimalValueRange(), CF.getDecimalDigits().intValue()));
            if (CF2 != null) {
                pair.setSecond((Object)formatterImpl.format((IDecimalRange)CF2.getDecimalValueRange(), CF2.getDecimalDigits().intValue()));
            }
        } else if (propertyLogDescriptor.getAccess().getPropertyName().equals(CustomFieldDTO.DEFAULT_DECIMAL_VALUE.getName())) {
            pair.setFirst((Object)formatterImpl.format(CF.getDefaultDecimalValue(), CF.getDecimalDigits().intValue()));
            if (CF2 != null) {
                pair.setSecond((Object)formatterImpl.format(CF2.getDefaultDecimalValue(), CF2.getDecimalDigits().intValue()));
            }
        } else {
            pair = null;
        }
        return pair;
    }

    public EntityLogDescriptor<CFDTO> resolveLogDescriptor(CF CF) {
        return new EntityLogDescriptor(this.resolveDtoType(CF)).property(CustomFieldDTO.NAME, GeneralKeys.Ui.NAME).property(CustomFieldDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).property(CustomFieldDTO.INTERNAL_NAME, GeneralKeys.Ui.INTERNAL_NAME).property((Property)CustomFieldDTO.ALL_SELECTED_LABEL, SystemKeys.Fields.ALL_SELECTED_LABEL).property((Property)CustomFieldDTO.ALLOWED_MIME_TYPES, SystemKeys.Fields.ALLOWED_MIME_TYPES).property((Property)CustomFieldDTO.CONTROL, SystemKeys.Fields.CONTROL).property((Property)CustomFieldDTO.DECIMAL_DIGITS, SystemKeys.Fields.DECIMAL_DIGITS).property((Property)CustomFieldDTO.DECIMAL_VALUE_RANGE, SystemKeys.Fields.VALUE_RANGE).property((Property)CustomFieldDTO.DEFAULT_BOOLEAN_VALUE, SystemKeys.Fields.DEFAULT_VALUE).property((Property)CustomFieldDTO.DEFAULT_DATE_TODAY, SystemKeys.Fields.DEFAULT_DATE_TODAY).property((Property)CustomFieldDTO.DEFAULT_DATE_VALUE, SystemKeys.Fields.DEFAULT_VALUE).property((Property)CustomFieldDTO.DEFAULT_DECIMAL_VALUE, SystemKeys.Fields.DEFAULT_VALUE).property((Property)CustomFieldDTO.DEFAULT_INTEGER_VALUE, SystemKeys.Fields.DEFAULT_VALUE).property((Property)CustomFieldDTO.DEFAULT_RICH_TEXT_VALUE, SystemKeys.Fields.DEFAULT_VALUE).property((Property)CustomFieldDTO.DEFAULT_STRING_VALUE, SystemKeys.Fields.DEFAULT_VALUE).property((Property)CustomFieldDTO.DEFAULT_TEXT_VALUE, SystemKeys.Fields.DEFAULT_VALUE).property((Property)CustomFieldDTO.EXPANDED_CATEGORIES, SystemKeys.Fields.EXPANDED_CATEGORIES).property((Property)CustomFieldDTO.IGNORE_SANITIZER, SystemKeys.Fields.IGNORE_SANITIZER).property((Property)CustomFieldDTO.INFORMATION_TEXT, SystemKeys.Fields.INFORMATION_TEXT).property((Property)CustomFieldDTO.INTEGER_VALUE_RANGE, SystemKeys.Fields.VALUE_RANGE).property((Property)CustomFieldDTO.LENGTH_CONSTRAINT, SystemKeys.Fields.LENGTH_CONSTRAINT).property((Property)CustomFieldDTO.LINKED_ENTITY_RECORD_TYPE, SystemKeys.Fields.LINKED_ENTITY_RECORD_TYPE).property((Property)CustomFieldDTO.LINKED_ENTITY_TYPE, SystemKeys.Fields.LINKED_ENTITY_TYPE).property((Property)CustomFieldDTO.LOAD_VALUES_SCRIPT, SystemKeys.Fields.LOAD_VALUES_SCRIPT).property((Property)CustomFieldDTO.LOAD_VALUES_SCRIPT_PARAMETERS, SystemKeys.Fields.LOAD_VALUES_SCRIPT_PARAMETERS).property((Property)CustomFieldDTO.MAX_FILES, SystemKeys.Fields.MAX_FILES).property((Property)CustomFieldDTO.MAX_WORD_SIZE, SystemKeys.Fields.MAX_WORD_SIZE).property((Property)CustomFieldDTO.OTHER_MIME_TYPES, SystemKeys.Fields.OTHER_MIME_TYPES).property((Property)CustomFieldDTO.PATTERN, SystemKeys.Fields.PATTERN).property((Property)CustomFieldDTO.REQUIRED, SystemKeys.Fields.REQUIRED).property((Property)CustomFieldDTO.SIZE, SystemKeys.Fields.SIZE).property((Property)CustomFieldDTO.STORAGE_DIRECTORY, SystemKeys.Fields.STORAGE_DIRECTORY).property((Property)CustomFieldDTO.UNIQUE, SystemKeys.Fields.UNIQUE).property((Property)CustomFieldDTO.VALIDATION_SCRIPT, SystemKeys.Fields.VALIDATION_SCRIPT).property((Property)CustomFieldDTO.VALIDATION_SCRIPT_PARAMETERS, SystemKeys.Fields.VALIDATION_SCRIPT_PARAMETERS).property((Property)CustomFieldDTO.VALUE_MATCH, SystemKeys.Fields.VALUE_MATCH).property((Property)CustomFieldDTO.SHOW_QR_CODE_SCAN, SystemKeys.Fields.SHOW_QR_CODE_SCAN).property((Property)CustomFieldDTO.TYPE, SystemKeys.Fields.TYPE).ignore((Property)CustomFieldDTO.NATURE);
    }

    protected abstract Class<CFDTO> resolveDtoType(CF var1);
}

