/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.system.ImportedFile;
import org.cyclos.entities.system.PaymentImportedFile;
import org.cyclos.entities.system.TransferImportedFile;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.system.BaseWithFieldsImportHandlerImpl;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.ValidationException;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.imports.BankingImportedFileDTO;
import org.cyclos.model.system.imports.BankingImportedFileData;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.TransactionImportField;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BankingImportHandlerImpl<IF extends ImportedFile, E extends SimpleEntity>
extends BaseWithFieldsImportHandlerImpl<TransactionCustomField, CustomFieldValueDTO, BankingImportedFileDTO, BankingImportedFileData, IF, E> {
    private static final String SYSTEM_ACCOUNT_OWNER_KEYWORD = SystemAccountOwner.instance().toString().toLowerCase();
    protected static final Set<String> REQUIRED_HEADERS = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new String[]{TransactionImportField.FROM.getName(), TransactionImportField.TO.getName(), TransactionImportField.TYPE.getName(), TransactionImportField.AMOUNT.getName()}));
    @Autowired
    protected TransactionServiceLocal transactionService;
    @Autowired
    protected TransactionCustomFieldServiceLocal transactionCustomFieldService;

    BankingImportHandlerImpl(ImportField[] importFieldArray) {
        super(TransactionCustomField.class, CustomFieldValueDTO.class, importFieldArray);
    }

    /*
     * WARNING - void declaration
     */
    public Predicate<String> getAllowedImportFieldsPredicate(IF IF) {
        void var3_6;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TransactionImportField transactionImportField : TransactionImportField.values()) {
            arrayList.add(transactionImportField.getName());
        }
        if (IF instanceof PaymentImportedFile) {
            arrayList.remove(TransactionImportField.DATE.getName());
        }
        if (IF instanceof TransferImportedFile) {
            arrayList.remove(TransactionImportField.FROM_NAME.getName());
            arrayList.remove(TransactionImportField.TO_NAME.getName());
        }
        if (IF.getBy() == null) {
            List list = this.transactionCustomFieldService.listAll();
        } else {
            List list = this.productsHandler.getAccessor((BasicUser)IF.getBy(), IF.getNetwork()).product().getVisibleTransactionFields();
        }
        arrayList.addAll(this.getImportFieldNames(var3_6));
        return string -> arrayList.contains(string);
    }

    public Set<String> getMissingRequiredFields(IF IF, List<String> list) {
        return Set.copyOf(CollectionUtils.subtract(REQUIRED_HEADERS, list));
    }

    public Object instantiateContext() {
        return null;
    }

    public Validator resolveValidator(BankingImportedFileDTO bankingImportedFileDTO) {
        return new Validator();
    }

    protected InternalAccountOwner parseAccountOwner(String string) {
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        if (string.toLowerCase().equals(SYSTEM_ACCOUNT_OWNER_KEYWORD)) {
            return SystemAccountOwner.instance();
        }
        return this.locateUser(string);
    }

    protected TransferType parseTransferType(String string) {
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        try {
            return (TransferType)this.entityManagerHandler.find(TransferType.class, string);
        }
        catch (Exception exception) {
            String string2 = this.translationHandler.message(SystemKeys.Imports.ERROR_INVALID_TRANSFER_TYPE, new Object[0]);
            throw new ValidationException(string2);
        }
    }
}

