/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.storage;

import java.io.Closeable;
import java.io.InputStream;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.storage.NoOpStoredFileContentAction;
import org.cyclos.impl.storage.SaveStoredFileContentAction;
import org.cyclos.impl.storage.StoredFileContentAction;
import org.cyclos.impl.storage.StoredFileContentManager;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.StoredFileException;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.springframework.beans.factory.annotation.Autowired;

public class DbStoredFileContentManagerImpl
implements StoredFileContentManager {
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    @Autowired
    private InvokerHandler invokerHandler;

    public SaveStoredFileContentAction copy(String string, Object object) throws StoredFileException, EntityNotFoundException {
        try {
            Long l = this.nativeQueryHandler.copyLargeObject(((Long)object).longValue());
            return new NoOpStoredFileContentAction(l, l.toString());
        }
        catch (Exception exception) {
            throw new StoredFileException(String.format("Error copying content with id %s", object), (Throwable)exception);
        }
    }

    public String getKey(StoredFile storedFile) throws StoredFileException {
        Object object = this.getMetadata(storedFile);
        return object == null ? null : object.toString();
    }

    public Object getMetadata(StoredFile storedFile) throws StoredFileException {
        try {
            return this.nativeQueryHandler.getObjectId(storedFile.getId().longValue());
        }
        catch (Exception exception) {
            throw new StoredFileException(String.format("Error retrieving metadata for %s", storedFile), (Throwable)exception);
        }
    }

    public boolean isStoredOnDB() {
        return true;
    }

    public SerializableInputStream open(Object object) {
        try {
            InputStream inputStream = this.nativeQueryHandler.openLargeObject(((Long)object).longValue());
            SerializableInputStream serializableInputStream = new SerializableInputStream(inputStream);
            serializableInputStream.forceCopyToFile();
            return serializableInputStream;
        }
        catch (Exception exception) {
            throw new StoredFileException(String.format("Error retrieving content with id %s", object), (Throwable)exception);
        }
    }

    public StoredFileContentAction remove(Object object) {
        if (object == null) {
            return null;
        }
        try {
            this.nativeQueryHandler.deleteLargeObject(((Long)object).longValue());
            return null;
        }
        catch (Exception exception) {
            throw new StoredFileException(String.format("Error deleting content with id %s", object), (Throwable)exception);
        }
    }

    public boolean requiresPersistentStoredFileToSetMetadata() {
        return true;
    }

    public void setMetadata(StoredFile storedFile, Object object) throws StoredFileException {
        try {
            this.nativeQueryHandler.setObjectId(storedFile.getId().longValue(), ((Long)object).longValue());
            storedFile.setMetadata(null);
        }
        catch (Exception exception) {
            throw new StoredFileException(String.format("Error setting metadata for id %s", storedFile.getId()), (Throwable)exception);
        }
    }

    public SaveStoredFileContentAction store(String string, SerializableInputStream serializableInputStream) {
        try {
            Long l = this.nativeQueryHandler.writeLargeObject((InputStream)serializableInputStream);
            NoOpStoredFileContentAction noOpStoredFileContentAction = new NoOpStoredFileContentAction(l, l.toString());
            return noOpStoredFileContentAction;
        }
        catch (Exception exception) {
            throw new StoredFileException("Error saving content", (Throwable)exception);
        }
        finally {
            IOHelper.close((Closeable)serializableInputStream);
        }
    }

    public boolean supportStorageDirectories() {
        return false;
    }

    public void testConnection() throws StoredFileException {
        try {
            this.invokerHandler.runAsInCurrentOrNewTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY_TRANSACTION, transactionStatus -> InvocationContext.ensure().getEntityManager().createNativeQuery("select 1").getResultList());
        }
        catch (Exception exception) {
            throw new StoredFileException("Error in database connection", (Throwable)exception);
        }
    }
}

