/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql.postgresql;

import com.querydsl.core.Tuple;
import com.querydsl.core.support.QueryBase;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.sql.SQLQuery;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.utils.queryextensions.CustomOperator;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.sql.postgresql.AbstractUserNativeQuery;
import org.cyclos.impl.sql.postgresql.NativeQuery;
import org.cyclos.impl.sql.postgresql.querytypes.SAccounts;
import org.cyclos.impl.sql.postgresql.querytypes.SPendingUserAccounts;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.model.banking.accounts.BalanceLevel;
import org.cyclos.model.banking.accounts.UserWithBalanceOrderBy;
import org.cyclos.model.banking.accounts.UserWithBalanceQuery;
import org.cyclos.model.banking.accounts.UserWithBalanceVO;
import org.cyclos.model.banking.accounts.UsersWithBalancesOverview;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.users.addresses.UserAddressResult;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.utils.AmountSummaryVO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.IntegerRangeDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.ObjectHelper;

public class UsersWithBalancesNativeQuery
extends AbstractUserNativeQuery<UserWithBalanceQuery, UserWithBalanceVO> {
    private NumberExpression<BigDecimal> balance;
    private StringExpression accountNumber;
    private StringExpression pendingAccountNumber;
    private DateTimeExpression<Date> negativeSince;
    private Expression<BigDecimal> sum;
    private Expression<Long> count;
    private Expression<Double> avg;
    private UserAccountType accountType;
    private CurrencyVO currency;
    private int decimalDigits;
    private Integer rangeMin;
    private Integer rangeMax;
    private List<MemberProduct> productsWithAccountType;

    public UsersWithBalancesNativeQuery(UserWithBalanceQuery userWithBalanceQuery) {
        super(UserWithBalanceVO.class, userWithBalanceQuery);
    }

    public UsersWithBalancesOverview getOverview() {
        AmountSummaryVO amountSummaryVO;
        UsersWithBalancesOverview usersWithBalancesOverview = new UsersWithBalancesOverview();
        ((UserWithBalanceQuery)this.params).setAddressResult(UserAddressResult.NO_ADDRESSES);
        this.initialize();
        if (this.rangeMin != null && this.rangeMax != null) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            int n = 0;
            Map<BalanceLevel, AmountSummaryVO> map = this.getRangeSummary();
            usersWithBalancesOverview.setOverviewByRange(map);
            for (AmountSummaryVO amountSummaryVO2 : map.values()) {
                bigDecimal = bigDecimal.add(amountSummaryVO2.getSum());
                n += amountSummaryVO2.getCount();
            }
            BigDecimal bigDecimal2 = BigDecimalHelper.round((BigDecimal)(n == 0 ? BigDecimal.ZERO : bigDecimal.divide(new BigDecimal(n), BigDecimalHelper.MATH_CONTEXT)), (int)this.decimalDigits);
            amountSummaryVO = ModelHelper.amountSummary((BigDecimal)bigDecimal, (BigDecimal)bigDecimal2, (int)n, (CurrencyVO)this.currency);
        } else {
            amountSummaryVO = this.getGeneralSummary();
        }
        usersWithBalancesOverview.setGeneralOverview(amountSummaryVO);
        return usersWithBalancesOverview;
    }

    @Override
    protected Expression<UserWithBalanceVO> doGetProjection(Integer n) {
        this.applyOrderBy();
        return new UserWithBalanceProjection();
    }

    @Override
    protected boolean handlesAccountJoin() {
        return true;
    }

    @Override
    protected List<Expression<?>> initializeQuery() {
        DatePeriodDTO datePeriodDTO;
        BigDecimal bigDecimal;
        List<Expression<?>> list = super.initializeQuery();
        this.initialize();
        SQLQuery<?> sQLQuery = this.getQuery();
        if (QueryHelper.useParameter((Object)((UserWithBalanceQuery)this.params).getUserStatus())) {
            sQLQuery.where((Predicate)this.u.status.in((Collection)((UserWithBalanceQuery)this.params).getUserStatus()));
        }
        this.acct = SAccounts.accounts;
        this.pacct = SPendingUserAccounts.pendingUserAccounts;
        ((SQLQuery)sQLQuery.leftJoin((EntityPath)this.acct)).on((Predicate)this.acct.userId.eq(this.u.id).and((Predicate)this.acct.accountTypeId.eq((Object)this.accountType.getId())));
        ((SQLQuery)sQLQuery.leftJoin((EntityPath)this.pacct)).on((Predicate)this.pacct.userId.eq(this.u.id).and((Predicate)this.pacct.accountTypeId.eq((Object)this.accountType.getId())));
        sQLQuery.where(UsersWithBalancesNativeQuery.apply(this.productService.productQuery(this.productsWithAccountType), this.u));
        this.balance = Expressions.numberOperation(BigDecimal.class, (Operator)CustomOperator.ACCOUNT_BALANCE1, (Expression[])new Expression[]{this.acct.id});
        this.sum = this.balance.sum().coalesce((Comparable[])new BigDecimal[]{BigDecimal.ZERO});
        this.count = this.balance.count();
        this.avg = this.balance.avg().coalesce((Comparable[])new Double[]{0.0});
        this.negativeSince = this.acct.negativeSince;
        this.accountNumber = this.acct.number;
        this.pendingAccountNumber = this.pacct.number;
        BigDecimal bigDecimal2 = ((UserWithBalanceQuery)this.params).getBalanceRange() == null ? null : ((UserWithBalanceQuery)this.params).getBalanceRange().getMin();
        BigDecimal bigDecimal3 = bigDecimal = ((UserWithBalanceQuery)this.params).getBalanceRange() == null ? null : ((UserWithBalanceQuery)this.params).getBalanceRange().getMax();
        if (bigDecimal2 != null) {
            sQLQuery.where((Predicate)this.balance.goe((Number)bigDecimal2));
        }
        if (bigDecimal != null) {
            sQLQuery.where((Predicate)this.balance.loe((Number)bigDecimal));
        }
        if ((datePeriodDTO = ((UserWithBalanceQuery)this.params).getNegativeSince()) != null && (datePeriodDTO.getBegin() != null || datePeriodDTO.getEnd() != null)) {
            this.filterByDatePeriod((QueryBase<?>)sQLQuery, datePeriodDTO, (DateTimeExpression<Date>)this.acct.negativeSince);
        }
        return list;
    }

    @Override
    protected void resetQuery() {
        super.resetQuery();
        this.acct = null;
    }

    @Override
    protected List<ProfileField> resolveProfileFieldsInList(SessionData sessionData) {
        if (Boolean.TRUE.equals(((UserWithBalanceQuery)this.params).getAttribute("export"))) {
            return this.profileFieldHandler.getProfileFieldsForExport();
        }
        return super.resolveProfileFieldsInList(sessionData);
    }

    private void applyOrderBy() {
        SQLQuery<?> sQLQuery = this.getQuery();
        UserWithBalanceOrderBy userWithBalanceOrderBy = (UserWithBalanceOrderBy)ObjectHelper.defaultValue((Object)((UserWithBalanceQuery)this.params).getOrderBy(), (Object)UserWithBalanceOrderBy.BALANCE_DESC);
        switch (userWithBalanceOrderBy) {
            case BALANCE_DESC: {
                sQLQuery.orderBy(this.balance.desc());
                break;
            }
            case BALANCE_ASC: {
                sQLQuery.orderBy(this.balance.asc());
                break;
            }
            case ALPHABETICALLY_ASC: 
            case ALPHABETICALLY_DESC: {
                boolean bl = userWithBalanceOrderBy == UserWithBalanceOrderBy.ALPHABETICALLY_DESC;
                this.applyAlphabeticOrderBy(sQLQuery, bl);
            }
        }
        sQLQuery.orderBy(this.u.id.asc());
    }

    private AmountSummaryVO getGeneralSummary() {
        this.getQuery();
        NativeQuery.JpaQueryResult jpaQueryResult = this.createJpaQuery((Expression<?>)Projections.tuple((Expression[])new Expression[]{this.sum, this.count, this.avg}), 0, 1);
        Tuple tuple = (Tuple)this.doSingleResult(jpaQueryResult);
        return this.getSummary(tuple);
    }

    private Map<BalanceLevel, AmountSummaryVO> getRangeSummary() {
        this.getQuery().groupBy((Expression)Expressions.template(Integer.class, (String)"1", (Object[])new Object[0]));
        StringExpression stringExpression = (StringExpression)new CaseBuilder().when((Predicate)this.balance.lt((Number)this.rangeMin)).then(BalanceLevel.LOW.name()).when((Predicate)this.balance.gt((Number)this.rangeMax)).then((Object)BalanceLevel.HIGH.name()).otherwise((Object)BalanceLevel.MEDIUM.name());
        EnumMap<BalanceLevel, AmountSummaryVO> enumMap = new EnumMap<BalanceLevel, AmountSummaryVO>(BalanceLevel.class);
        NativeQuery.JpaQueryResult jpaQueryResult = this.createJpaQuery((Expression<?>)Projections.tuple((Expression[])new Expression[]{stringExpression, this.sum, this.count, this.avg}), 0, BalanceLevel.values().length);
        this.doList(jpaQueryResult).forEach(tuple -> {
            BalanceLevel balanceLevel = BalanceLevel.valueOf((String)((String)tuple.get((Expression)stringExpression)));
            enumMap.put(balanceLevel, this.getSummary((Tuple)tuple));
        });
        for (BalanceLevel balanceLevel : BalanceLevel.values()) {
            if (enumMap.containsKey(balanceLevel)) continue;
            enumMap.put(balanceLevel, ModelHelper.amountSummary((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (int)0, (CurrencyVO)this.currency));
        }
        return enumMap;
    }

    private AmountSummaryVO getSummary(Tuple tuple) {
        BigDecimal bigDecimal = BigDecimalHelper.round((BigDecimal)((BigDecimal)tuple.get(this.sum)), (int)this.decimalDigits);
        BigDecimal bigDecimal2 = BigDecimalHelper.round((BigDecimal)new BigDecimal((Double)tuple.get(this.avg)), (int)this.decimalDigits);
        int n = ((Long)tuple.get(this.count)).intValue();
        return ModelHelper.amountSummary((BigDecimal)bigDecimal, (BigDecimal)bigDecimal2, (int)n, (CurrencyVO)this.currency);
    }

    private void initialize() {
        if (this.accountType != null) {
            return;
        }
        this.accountType = (UserAccountType)this.conversionHandler.convert(UserAccountType.class, (Object)((UserWithBalanceQuery)this.params).getAccountType());
        this.currency = (CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)this.accountType.getCurrency());
        this.decimalDigits = this.accountType.getCurrency().getPrecision();
        IntegerRangeDTO integerRangeDTO = ((UserWithBalanceQuery)this.params).getYellowBalanceRange();
        this.rangeMin = integerRangeDTO == null ? null : integerRangeDTO.getMin();
        this.rangeMax = integerRangeDTO == null ? null : integerRangeDTO.getMax();
        this.productsWithAccountType = this.productService.listByAccount(this.accountType);
    }

    protected class UserWithBalanceProjection
    extends AbstractUserNativeQuery.AbstractUserProjection {
        private static final long serialVersionUID = 1L;

        public UserWithBalanceProjection() {
            super(UsersWithBalancesNativeQuery.this);
            this.add(new Expression[]{UsersWithBalancesNativeQuery.this.balance});
            this.add(new Expression[]{UsersWithBalancesNativeQuery.this.negativeSince});
            if (!this.has((Expression)UsersWithBalancesNativeQuery.this.accountNumber)) {
                this.add(new Expression[]{UsersWithBalancesNativeQuery.this.accountNumber});
            }
            if (!this.has((Expression)UsersWithBalancesNativeQuery.this.pendingAccountNumber)) {
                this.add(new Expression[]{UsersWithBalancesNativeQuery.this.pendingAccountNumber});
            }
        }

        protected UserWithBalanceVO instantiate() {
            UserWithBalanceVO userWithBalanceVO = (UserWithBalanceVO)super.instantiate();
            ConfigurationAccessor configurationAccessor = this.getSessionData().getConfiguration();
            String string = configurationAccessor.getAccountNumberConfiguration() == null ? null : configurationAccessor.getAccountNumberConfiguration().getMask();
            BigDecimal bigDecimal = BigDecimalHelper.round((BigDecimal)((BigDecimal)this.get((Expression)UsersWithBalancesNativeQuery.this.balance)), (int)UsersWithBalancesNativeQuery.this.decimalDigits);
            if (userWithBalanceVO.getAccountNumber() == null) {
                userWithBalanceVO.setAccountNumber(MaskHelper.applyMask((String)string, (String)((String)ObjectHelper.defaultValue((Object)((String)this.get((Expression)UsersWithBalancesNativeQuery.this.accountNumber)), (Object)((String)this.get((Expression)UsersWithBalancesNativeQuery.this.pendingAccountNumber))))));
            }
            userWithBalanceVO.setBalance(bigDecimal);
            userWithBalanceVO.setNegativeSince(UsersWithBalancesNativeQuery.this.conversionHandler.toDateTime((Date)this.get((Expression)UsersWithBalancesNativeQuery.this.negativeSince)));
            int n = bigDecimal.intValue();
            BalanceLevel balanceLevel = null;
            if (UsersWithBalancesNativeQuery.this.rangeMin != null && UsersWithBalancesNativeQuery.this.rangeMax != null) {
                balanceLevel = n < UsersWithBalancesNativeQuery.this.rangeMin ? BalanceLevel.LOW : (n > UsersWithBalancesNativeQuery.this.rangeMax ? BalanceLevel.HIGH : BalanceLevel.MEDIUM);
            }
            userWithBalanceVO.setBalanceLevel(balanceLevel);
            return userWithBalanceVO;
        }
    }
}

