/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql.postgresql;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.Expression;
import java.math.BigDecimal;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountHandler;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.BuildInstallmentQueryParams;
import org.cyclos.impl.banking.BuildTransQueryParams;
import org.cyclos.impl.banking.InstallmentQueryHandler;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.search.InstallmentSearchHandler;
import org.cyclos.impl.sql.postgresql.BasePostgresqlEntitySearchHandlerImpl;
import org.cyclos.impl.sql.postgresql.PostgresqlSearchHandlerImpl;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.ImageHandler;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.banking.transactions.BaseInstallmentQuery;
import org.cyclos.model.banking.transactions.InstallmentOverviewQuery;
import org.cyclos.model.banking.transactions.InstallmentQuery;
import org.cyclos.model.banking.transactions.InstallmentResultVO;
import org.cyclos.model.banking.transactions.TransactionResultVO;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class PostgresqlInstallmentSearchHandlerImpl
extends BasePostgresqlEntitySearchHandlerImpl<Installment, InstallmentOverviewQuery, InstallmentResultVO>
implements InstallmentSearchHandler {
    @Autowired
    @Lazy
    private InstallmentQueryHandler installmentQueryHandler;
    @Autowired
    @Lazy
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    @Lazy
    private UserServiceLocal userService;
    @Autowired
    @Lazy
    protected DataTranslationHandler dataTranslationHandler;
    @Autowired
    @Lazy
    private TransactionCustomFieldServiceLocal transactionCustomFieldService;
    @Autowired
    @Lazy
    private ImageHandler imageHandler;
    @Autowired
    @Lazy
    private AccountHandler accountHandler;
    @Autowired
    @Lazy
    private AccountServiceLocal accountService;

    public PostgresqlInstallmentSearchHandlerImpl(PostgresqlSearchHandlerImpl postgresqlSearchHandlerImpl) {
        super(postgresqlSearchHandlerImpl);
    }

    public DataIterator<Installment> export(InstallmentQuery installmentQuery) {
        return this.doIterate((BaseInstallmentQuery)installmentQuery);
    }

    public DataIterator<Installment> exportEntities(InstallmentOverviewQuery installmentOverviewQuery) {
        return this.doIterate((BaseInstallmentQuery)installmentOverviewQuery);
    }

    @Deprecated
    public CloseableIterator<Installment> iterateEntities(InstallmentOverviewQuery installmentOverviewQuery) {
        return this.installmentQueryHandler.build((BuildTransQueryParams)new BuildInstallmentQueryParams((BaseInstallmentQuery)installmentOverviewQuery)).iterate((Expression)this.installmentQueryHandler.getInstallmentPath());
    }

    @Deprecated
    public CloseableIterator<Long> iterateIds(InstallmentOverviewQuery installmentOverviewQuery) {
        return this.installmentQueryHandler.build((BuildTransQueryParams)new BuildInstallmentQueryParams((BaseInstallmentQuery)installmentOverviewQuery)).iterate((Expression)this.installmentQueryHandler.getInstallmentPath().id);
    }

    public long reindex() {
        return 0L;
    }

    public Page<InstallmentResultVO> search(InstallmentOverviewQuery installmentOverviewQuery) {
        SessionData sessionData = InvocationContext.getSessionData();
        return PageImpl.transformed(this.doSearch((BaseInstallmentQuery)installmentOverviewQuery), installment -> this.toResult(sessionData, null, (Installment)installment, (AbstractTransQuery)installmentOverviewQuery));
    }

    public Page<Installment> searchEntities(InstallmentOverviewQuery installmentOverviewQuery) {
        return this.doSearch((BaseInstallmentQuery)installmentOverviewQuery);
    }

    public Page<InstallmentResultVO> searchInstallments(InstallmentQuery installmentQuery) {
        SessionData sessionData = InvocationContext.getSessionData();
        InternalAccountOwner internalAccountOwner = this.accountHandler.locate((AccountOwner)installmentQuery.getOwner()).getInternalAccountOwner();
        return PageImpl.transformed(this.doSearch((BaseInstallmentQuery)installmentQuery), installment -> this.toResult(sessionData, internalAccountOwner, (Installment)installment, (AbstractTransQuery)installmentQuery));
    }

    private DataIterator<Installment> doIterate(BaseInstallmentQuery baseInstallmentQuery) {
        return CloseableIteratorHelper.asDataIterator((CloseableIterator)this.installmentQueryHandler.build((BuildTransQueryParams)new BuildInstallmentQueryParams(baseInstallmentQuery)).iterate((Expression)this.installmentQueryHandler.getInstallmentPath()));
    }

    private Page<Installment> doSearch(BaseInstallmentQuery baseInstallmentQuery) {
        return this.installmentQueryHandler.build((BuildTransQueryParams)new BuildInstallmentQueryParams(baseInstallmentQuery)).page((QueryParameters)baseInstallmentQuery, (Expression)this.installmentQueryHandler.getInstallmentPath());
    }

    private InstallmentResultVO toResult(SessionData sessionData, InternalAccountOwner internalAccountOwner, Installment installment, AbstractTransQuery abstractTransQuery) {
        InstallmentResultVO installmentResultVO = (InstallmentResultVO)this.conversionHandler.convertExcluding(InstallmentResultVO.class, (Object)installment, new Object[]{InstallmentResultVO.TRANSACTION});
        TransactionResultVO transactionResultVO = this.searchHandler.transaction().toResult(sessionData, internalAccountOwner, (Transaction)installment.getTransaction(), abstractTransQuery);
        installmentResultVO.setTransaction(transactionResultVO);
        if (BigDecimalHelper.isNegative((BigDecimal)transactionResultVO.getAmount())) {
            installmentResultVO.setAmount(installmentResultVO.getAmount().negate());
        }
        return installmentResultVO;
    }
}

