/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql.postgresql;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.support.QueryBase;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Coalesce;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.jpa.QueryHandler;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLBindings;
import com.querydsl.sql.SQLQuery;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.AccountNumberConfiguration;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldPossibleValue;
import org.cyclos.entities.system.CustomFieldPossibleValueCategory;
import org.cyclos.entities.system.CustomFieldValue;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.ContactInfoField;
import org.cyclos.entities.users.ContactInfoFieldValue;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.entities.utils.IntegerRange;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.sql.postgresql.PostgresqlQueryHandlerImpl;
import org.cyclos.impl.sql.postgresql.querydsl.QuerydslConfiguration;
import org.cyclos.impl.sql.postgresql.querydsl.TsVector;
import org.cyclos.impl.sql.postgresql.querydsl.TsVectorExpression;
import org.cyclos.impl.sql.postgresql.querydsl.TsVectorPath;
import org.cyclos.impl.sql.postgresql.querytypes.SAccounts;
import org.cyclos.impl.sql.postgresql.querytypes.SAddresses;
import org.cyclos.impl.sql.postgresql.querytypes.SBaseDynaValues;
import org.cyclos.impl.sql.postgresql.querytypes.SBaseEnumValues;
import org.cyclos.impl.sql.postgresql.querytypes.SBaseFieldValues;
import org.cyclos.impl.sql.postgresql.querytypes.SContactInfoEnumValues;
import org.cyclos.impl.sql.postgresql.querytypes.SContactInfoFieldValues;
import org.cyclos.impl.sql.postgresql.querytypes.SContactInfos;
import org.cyclos.impl.sql.postgresql.querytypes.SPhones;
import org.cyclos.impl.sql.postgresql.querytypes.SStoredFiles;
import org.cyclos.impl.sql.postgresql.querytypes.STsQuery;
import org.cyclos.impl.sql.postgresql.querytypes.SUserCustomFieldValues;
import org.cyclos.impl.sql.postgresql.querytypes.SUserDynaValues;
import org.cyclos.impl.sql.postgresql.querytypes.SUserEnumValues;
import org.cyclos.impl.sql.postgresql.querytypes.SUsers;
import org.cyclos.impl.sql.postgresql.querytypes.SUsersProducts;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.ImageVOConverter;
import org.cyclos.impl.users.GroupsHandler;
import org.cyclos.impl.users.PhoneServiceLocal;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.ProfileFieldSearchContext;
import org.cyclos.impl.users.UserProductsQueryResult;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.SQLUserVisibilityApplier;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.CustomProjection;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.validations.EmailValidation;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.QueryParseException;
import org.cyclos.model.UnexpectedDataAccessException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.system.fields.BaseValueForSearchDTO;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.CustomFieldValueForSearchDTO;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.users.addresses.AddressFields;
import org.cyclos.model.users.addresses.AddressQueryField;
import org.cyclos.model.users.addresses.UserAddressVO;
import org.cyclos.model.users.contactinfos.AddressContactInfoVO;
import org.cyclos.model.users.users.AddressFieldValueForSearchDTO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicProfileFieldValueForSearchDTO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.DateWrapper;
import org.cyclos.model.utils.DistanceUnit;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.StoredFileNature;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.IDate;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class NativeQuery<Q extends QueryParameters, E extends SimpleEntity, P> {
    protected Class<E> entityType;
    protected Class<P> projectionType;
    protected Q params;
    private SQLQuery<?> query;
    private Map<CustomField<?, ?, ?>, SBaseFieldValues<?>> fieldValues = new HashMap();
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    protected ConversionHandler conversionHandler;
    @Autowired
    protected GroupsHandler groupsHandler;
    @Autowired
    protected ConfigurationHandler configurationHandler;
    @Autowired
    protected BeanHandler beanHandler;
    @Autowired
    protected ProfileFieldHandler profileFieldHandler;
    @Autowired
    protected PhoneServiceLocal phoneService;
    @Autowired
    protected TranslationHandler translationHandler;
    @Autowired
    protected UserServiceLocal userService;
    @Autowired
    protected PhoneNumberHandler phoneNumberHandler;
    private Logger logger;
    private FormatterImpl _formatter;
    @Autowired
    protected CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    protected JdbcTemplate jdbcTemplate;
    private SessionData sessionData;

    public static Predicate apply(UserProductsQueryResult userProductsQueryResult, SUsers sUsers) {
        Collection collection = userProductsQueryResult.getGroups();
        Collection collection2 = userProductsQueryResult.getProducts();
        if (CollectionHelper.isEmpty((Iterable)collection2)) {
            return sUsers.id.isNull();
        }
        SUsersProducts sUsersProducts = SUsersProducts.usersProducts;
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)new SQLQuery().from((Expression)sUsersProducts)).where(new Predicate[]{sUsersProducts.userId.eq(sUsers.id), sUsersProducts.productId.in((Collection)SimpleEntity.uniqueIds((Collection)collection2))});
        if (CollectionHelper.isEmpty((Iterable)collection)) {
            return sQLQuery.exists();
        }
        return sUsers.userGroupId.in((Collection)SimpleEntity.uniqueIds((Collection)collection)).or((Predicate)sQLQuery.exists());
    }

    public NativeQuery(Class<E> clazz, Class<P> clazz2, Q q) {
        this.entityType = clazz;
        this.projectionType = clazz2;
        this.params = q;
        QueryHelper.ensurePageData(q);
    }

    public int count() {
        SQLQuery sQLQuery = (SQLQuery)this.getQuery().clone();
        try {
            this.query.getMetadata().clearOrderBy();
            JpaQueryResult jpaQueryResult = this.createJpaQuery((Expression<?>)Expressions.stringTemplate((String)"count(*)", (Object[])new Object[0]), 0, 1);
            SQLException sQLException = jpaQueryResult.getJpaQuery();
            try {
                Number number = (Number)sQLException.getSingleResult();
                int n = number == null ? 0 : number.intValue();
                return n;
            }
            catch (RuntimeException runtimeException) {
                try {
                    SQLBindings sQLBindings = jpaQueryResult.getSqlBindings();
                    this.getLogger().error("Error executing count on query: [" + sQLBindings.getSQL() + "] with bind parameters: " + String.valueOf(sQLBindings.getNullFriendlyBindings()));
                    throw runtimeException;
                }
                catch (RuntimeException runtimeException2) {
                    sQLException = (SQLException)ExceptionUtils.throwableOfType((Throwable)runtimeException2, SQLException.class);
                    if (sQLException != null && sQLException.getMessage().contains("tsquery")) {
                        throw new QueryParseException();
                    }
                    throw runtimeException2;
                }
            }
        }
        finally {
            this.query = sQLQuery;
        }
    }

    public CloseableIterator<E> exportEntities() {
        return this.doExport(this.createJpaQueryForEntities(true));
    }

    public CloseableIterator<P> exportResults() {
        return this.doExport(this.createJpaQuery(true, this.getProjection(null)));
    }

    public SQLQuery<?> getQuery() {
        this.ensureQuery();
        return this.query;
    }

    @Deprecated
    public CloseableIterator<E> iterateEntities() {
        return this.exportEntities();
    }

    @Deprecated
    public CloseableIterator<Long> iterateIds() {
        RelationalPath<?> relationalPath = this.getMainEntityAlias();
        NumberExpression numberExpression = (NumberExpression)FieldHelper.get(relationalPath, (String)EntityModel.ID.getName());
        return this.doExport(this.createJpaQuery(true, (Expression<?>)numberExpression));
    }

    public Page<E> pageEntities() {
        return this.buildPage((n, n2, n3) -> {
            int n4 = n3;
            if (n == null && n3 < Integer.MAX_VALUE) {
                ++n4;
            }
            JpaQueryResult jpaQueryResult = this.createJpaQueryForEntities(n2, n4);
            return this.doList(jpaQueryResult);
        });
    }

    public Page<P> pageResults() {
        return this.buildPage((n, n2, n3) -> {
            Expression<P> expression = this.getProjection(n);
            int n4 = n3;
            if (n == null && n3 < Integer.MAX_VALUE) {
                ++n4;
            }
            JpaQueryResult jpaQueryResult = this.createJpaQuery(expression, n2, n4);
            List list = this.doList(jpaQueryResult);
            return list;
        });
    }

    public SQLUserVisibilityApplier visibility(NumberPath<Long> numberPath, NumberPath<Long> numberPath2) {
        return (SQLUserVisibilityApplier)this.beanHandler.autowire((Object)new SQLUserVisibilityApplier(this.getQuery(), numberPath, numberPath2));
    }

    protected <FV extends SBaseFieldValues<FV>, EV extends SBaseEnumValues<?>> void addOrderBy(Class<FV> clazz, Class<EV> clazz2, CustomField<?, ?, ?> customField, NumberPath<Long> numberPath, boolean bl) {
        if (!customField.getType().isSortable()) {
            return;
        }
        SQLQuery<?> sQLQuery = this.getQuery();
        FV FV = this.join(clazz, clazz2, customField, numberPath);
        switch (customField.getType()) {
            case BOOLEAN: {
                Coalesce coalesce = ((SBaseFieldValues)((Object)FV)).booleanValue.coalesce((Comparable[])new Boolean[]{false});
                sQLQuery.orderBy(bl ? coalesce.desc() : coalesce.asc());
                break;
            }
            case DATE: {
                sQLQuery.orderBy(bl ? ((SBaseFieldValues)((Object)FV)).dateValue.desc() : ((SBaseFieldValues)((Object)FV)).dateValue.asc());
                break;
            }
            case DECIMAL: {
                sQLQuery.orderBy(bl ? ((SBaseFieldValues)((Object)FV)).decimalValue.desc() : ((SBaseFieldValues)((Object)FV)).decimalValue.asc());
                break;
            }
            case INTEGER: {
                sQLQuery.orderBy(bl ? ((SBaseFieldValues)((Object)FV)).integerValue.desc() : ((SBaseFieldValues)((Object)FV)).integerValue.asc());
                break;
            }
            case DYNAMIC_SELECTION: 
            case TEXT: {
                sQLQuery.orderBy(bl ? ((SBaseFieldValues)((Object)FV)).textValue.desc() : ((SBaseFieldValues)((Object)FV)).textValue.asc());
                break;
            }
            case RICH_TEXT: {
                sQLQuery.orderBy(bl ? ((SBaseFieldValues)((Object)FV)).richTextValue.desc() : ((SBaseFieldValues)((Object)FV)).richTextValue.asc());
                break;
            }
            case SINGLE_SELECTION: {
                sQLQuery.orderBy(bl ? ((SBaseFieldValues)((Object)FV)).enumValueId.desc() : ((SBaseFieldValues)((Object)FV)).enumValueId.asc());
                break;
            }
            default: {
                sQLQuery.orderBy(bl ? ((SBaseFieldValues)((Object)FV)).stringValue.desc() : ((SBaseFieldValues)((Object)FV)).stringValue.asc());
            }
        }
    }

    protected Pair<TsVectorExpression, BooleanBuilder> appendUserProfileFieldKeywords(ProfileFieldSearchContext profileFieldSearchContext, String string, TsVectorExpression tsVectorExpression, SUsers sUsers, boolean bl) {
        RelationalPathBase relationalPathBase;
        Object object3;
        Object object2;
        List list = this.profileFieldHandler.getSearchFilters(profileFieldSearchContext, bl, null);
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        SessionData sessionData = this.getSessionData();
        boolean bl2 = sessionData.hasPermission(Permission.USERS_VIEW_HIDDEN_FIELDS);
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        if (list.contains(BasicProfileField.FULL_NAME)) {
            tsVectorExpression = tsVectorExpression.concatenate((Expression<TsVector>)sUsers.nameTsVector);
        }
        if (list.contains(BasicProfileField.LOGIN_NAME)) {
            booleanBuilder.or((Predicate)sUsers.username.equalsIgnoreCase(string));
        }
        if (list.contains(BasicProfileField.EMAIL) && StringHelper.isNotBlank((Object)string) && EmailValidation.isValid((String)string)) {
            if (bl2) {
                booleanBuilder.or((Predicate)sUsers.email.equalsIgnoreCase(string));
            } else {
                booleanBuilder.or((Predicate)sUsers.userHideEmail.isFalse().and((Predicate)sUsers.email.equalsIgnoreCase(string)));
            }
        }
        if (list.contains(BasicProfileField.ADDRESS)) {
            tsVectorExpression = tsVectorExpression.concatenate((Expression<TsVector>)TsVectorExpression.getAddressesTsVectors(sUsers.id, (Expression<Boolean>)Expressions.constant((Object)bl2)));
        }
        if (list.contains(BasicProfileField.PHONE) && (object2 = this.phoneNumberHandler.parse(string, configurationAccessor)) != null) {
            object3 = SPhones.phones;
            booleanBuilder.or((Predicate)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)object3)).where(new Predicate[]{object3.userId.eq(sUsers.id), object3.normalizedNumber.eq((Object)object2.toE164())})).exists());
        }
        if (list.contains(BasicProfileField.ACCOUNT_NUMBER) && (object2 = configurationAccessor.getAccountNumberConfiguration()) != null && object2.isEnabled() && StringHelper.isNotBlank((Object)(object3 = MaskHelper.removeMask((String)object2.getMask(), (String)string)))) {
            relationalPathBase = SAccounts.accounts;
            booleanBuilder.or((Predicate)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)relationalPathBase)).where(new Predicate[]{relationalPathBase.userId.eq(sUsers.id), relationalPathBase.number.equalsIgnoreCase((String)object3)})).exists());
        }
        for (Object object3 : this.profileFieldHandler.getCustomFields((Collection)list)) {
            if (!object3.getType().isSearchable()) continue;
            relationalPathBase = this.join((Class)SUserCustomFieldValues.class, (Class<? extends SBaseEnumValues<?>>)SUserEnumValues.class, (CustomField<?, ?, ?>)object3, sUsers.id);
            if (bl2) {
                tsVectorExpression = tsVectorExpression.concatenate((Expression<TsVector>)relationalPathBase.valueTsVector);
                continue;
            }
            tsVectorExpression = tsVectorExpression.concatenate((Expression<TsVector>)relationalPathBase.hidden.when((Object)true).then((Expression)TsVectorExpression.empty()).otherwise((Expression)relationalPathBase.valueTsVector));
        }
        return Pair.create((Object)((Object)tsVectorExpression), (Object)booleanBuilder);
    }

    protected void applyFullTextFilter(TsVectorExpression tsVectorExpression, STsQuery sTsQuery, BooleanBuilder booleanBuilder) {
        SQLQuery<?> sQLQuery = this.getQuery();
        if (tsVectorExpression != null && sTsQuery != null && booleanBuilder != null && booleanBuilder.hasValue()) {
            sQLQuery.where((Predicate)booleanBuilder.or(tsVectorExpression.matches(sTsQuery)));
        } else if (tsVectorExpression != null && sTsQuery != null) {
            sQLQuery.where(tsVectorExpression.matches(sTsQuery));
        } else if (booleanBuilder != null && booleanBuilder.hasValue()) {
            sQLQuery.where((Predicate)booleanBuilder);
        }
    }

    protected Collection<STsQuery> applyUserProfileFieldFilters(ProfileFieldSearchContext profileFieldSearchContext, SUsers sUsers, boolean bl, Set<BaseValueForSearchDTO> set, SAddresses sAddresses) {
        ArrayList<STsQuery> arrayList = new ArrayList<STsQuery>();
        SQLQuery<?> sQLQuery = this.getQuery();
        if (CollectionHelper.isNotEmpty(set)) {
            boolean bl2 = this.getSessionData().hasPermission(Permission.USERS_VIEW_HIDDEN_FIELDS);
            List list = this.profileFieldHandler.getSearchFilters(profileFieldSearchContext, bl, null);
            if (!list.contains(BasicProfileField.IMAGE)) {
                list.add(BasicProfileField.IMAGE);
            }
            for (BaseValueForSearchDTO baseValueForSearchDTO : set) {
                Object object;
                UserCustomField userCustomField;
                Pair<BooleanBuilder, STsQuery> pair;
                BasicProfileField basicProfileField = null;
                AddressQueryField addressQueryField = null;
                if (baseValueForSearchDTO instanceof BasicProfileFieldValueForSearchDTO) {
                    pair = (BasicProfileFieldValueForSearchDTO)baseValueForSearchDTO;
                    basicProfileField = pair.getField();
                } else if (baseValueForSearchDTO instanceof AddressFieldValueForSearchDTO) {
                    pair = (AddressFieldValueForSearchDTO)baseValueForSearchDTO;
                    basicProfileField = BasicProfileField.ADDRESS;
                    addressQueryField = pair.getAddressField();
                    if (addressQueryField == null) {
                        throw new ValidationException("Missing address field for search");
                    }
                } else if (baseValueForSearchDTO instanceof CustomFieldValueForSearchDTO) {
                    pair = (CustomFieldValueForSearchDTO)baseValueForSearchDTO;
                    basicProfileField = (ProfileField)this.conversionHandler.convert(UserCustomField.class, (Object)pair.getField());
                }
                if (basicProfileField == null) {
                    throw new EntityNotFoundException(ProfileField.class);
                }
                if (!list.contains(basicProfileField)) {
                    pair = basicProfileField instanceof UserCustomField ? ((UserCustomField)basicProfileField).getInternalName() : basicProfileField.getAlias();
                    throw new ValidationException("Invalid field for search: " + (String)pair);
                }
                if (!QueryHelper.useParameter((Object)baseValueForSearchDTO)) continue;
                pair = null;
                if (basicProfileField == BasicProfileField.ADDRESS && addressQueryField != null) {
                    pair = this.getAddressFieldQueryCondition(sUsers, (AddressFieldValueForSearchDTO)baseValueForSearchDTO, bl2, sAddresses);
                } else if (basicProfileField instanceof BasicProfileField) {
                    pair = this.getBasicFieldQueryCondition(sUsers, (BasicProfileFieldValueForSearchDTO)baseValueForSearchDTO, bl2, sAddresses);
                } else if (basicProfileField instanceof UserCustomField) {
                    userCustomField = (UserCustomField)basicProfileField;
                    object = (CustomFieldValueForSearchDTO)baseValueForSearchDTO;
                    pair = this.getCustomFieldQueryCondition((Class)SUserCustomFieldValues.class, (Class)SUserEnumValues.class, (Class)SUserDynaValues.class, sUsers.id, (CustomField<?, ?, ?>)userCustomField, (CustomFieldValueForSearchDTO)object, bl2);
                }
                if (pair == null) continue;
                userCustomField = (BooleanBuilder)pair.getFirst();
                if (userCustomField != null && userCustomField.hasValue()) {
                    sQLQuery.where((Predicate)userCustomField);
                }
                if ((object = (STsQuery)((Object)pair.getSecond())) == null) continue;
                arrayList.add((STsQuery)((Object)object));
            }
        }
        return arrayList;
    }

    protected JpaQueryResult createJpaQuery(Expression<?> expression) {
        return this.createJpaQuery(false, expression);
    }

    protected JpaQueryResult createJpaQuery(Expression<?> expression, int n, int n2) {
        return this.doCreateJpaQuery(expression, false, n, n2);
    }

    protected JpaQueryResult createJpaQueryForEntities() {
        return this.createJpaQueryForEntities(false);
    }

    protected JpaQueryResult createJpaQueryForEntities(boolean bl) {
        if (bl) {
            QueryHelper.applyExport(this.params);
        }
        return this.createJpaQueryForEntities(this.getOffset(), this.getLimit());
    }

    protected JpaQueryResult createJpaQueryForEntities(int n, int n2) {
        RelationalPath<?> relationalPath = this.getMainEntityAlias();
        return this.doCreateJpaQuery((Expression<?>)Expressions.stringTemplate((String)(String.valueOf(relationalPath) + ".*"), (Object[])new Object[0]), true, n, n2);
    }

    protected abstract RelationalPath<?> doGetMainEntityAlias();

    protected abstract Expression<P> doGetProjection(Integer var1);

    protected <R> List<R> doList(JpaQueryResult jpaQueryResult) {
        Query query = jpaQueryResult.getJpaQuery();
        try {
            return jpaQueryResult.applyToList(query.getResultList());
        }
        catch (RuntimeException runtimeException) {
            SQLBindings sQLBindings = jpaQueryResult.getSqlBindings();
            this.getLogger().error("Error executing page items query: [" + sQLBindings.getSQL() + "] with bind parameters: " + String.valueOf(sQLBindings.getNullFriendlyBindings()));
            throw runtimeException;
        }
    }

    protected <R> R doSingleResult(JpaQueryResult jpaQueryResult) {
        this.params.setCurrentPage(Integer.valueOf(0));
        this.params.setPageSize(Integer.valueOf(1));
        return (R)CollectionHelper.first(this.doList(jpaQueryResult));
    }

    protected <FV extends SBaseFieldValues<FV>> FV fieldValue(CustomField<?, ?, ?> customField, Class<FV> clazz) {
        SBaseFieldValues sBaseFieldValues = this.fieldValues.get(customField);
        if (sBaseFieldValues == null) {
            String string = clazz.getSimpleName().substring(1) + "_" + customField.getId();
            try {
                sBaseFieldValues = (SBaseFieldValues)((Object)clazz.getConstructor(String.class).newInstance(string));
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
            this.fieldValues.put(customField, sBaseFieldValues);
        }
        return (FV)((Object)sBaseFieldValues);
    }

    protected void filterByDatePeriod(DatePeriodDTO datePeriodDTO, DateTimeExpression<Date> dateTimeExpression) {
        this.filterByDatePeriod((QueryBase<?>)this.query, datePeriodDTO, dateTimeExpression);
    }

    protected void filterByDatePeriod(QueryBase<?> queryBase, DatePeriodDTO datePeriodDTO, DateTimeExpression<Date> dateTimeExpression) {
        DatePeriod datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)datePeriodDTO);
        if (datePeriod != null) {
            Date date;
            Date date2 = datePeriod.getBegin();
            if (date2 != null) {
                queryBase.where((Predicate)dateTimeExpression.goe((Comparable)date2));
            }
            if ((date = datePeriod.getEnd()) != null) {
                queryBase.where((Predicate)dateTimeExpression.lt((Comparable)date));
            }
        }
    }

    protected <FV extends SBaseFieldValues<FV>, EV extends SBaseEnumValues<?>, DV extends SBaseDynaValues<?>> Pair<BooleanBuilder, STsQuery> getCustomFieldQueryCondition(Class<FV> clazz, Class<EV> clazz2, Class<DV> clazz3, NumberPath<Long> numberPath, CustomField<?, ?, ?> customField, CustomFieldValueForSearchDTO customFieldValueForSearchDTO, boolean bl) {
        Object object;
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        Object object2 = this.customFieldValueHandler.getValueForSearch(customField, (Object)customFieldValueForSearchDTO, true);
        if (ObjectHelper.isEmpty((Object)object2)) {
            return null;
        }
        STsQuery sTsQuery = null;
        String string = "query_cf_" + customField.getId();
        FV FV = this.join(clazz, clazz2, customField, numberPath);
        switch (customField.getType()) {
            case RICH_TEXT: 
            case STRING: 
            case URL: 
            case TEXT: {
                object = (String)object2;
                if (customField.isExactMatch()) {
                    booleanBuilder.and((Predicate)((SBaseFieldValues)((Object)FV)).stringValue.equalsIgnoreCase((String)object));
                    break;
                }
                sTsQuery = STsQuery.of(string, (String)object);
                booleanBuilder.and(((SBaseFieldValues)((Object)FV)).valueTsVector.matches(sTsQuery));
                break;
            }
            case BOOLEAN: {
                object = (Boolean)object2;
                if (((Boolean)object).booleanValue()) {
                    booleanBuilder.and((Predicate)((SBaseFieldValues)((Object)FV)).booleanValue.isTrue());
                    break;
                }
                booleanBuilder.and((Predicate)((SBaseFieldValues)((Object)FV)).booleanValue.isFalse());
                break;
            }
            case DATE: {
                Date date;
                object = (DatePeriod)object2;
                Date date2 = object.getBegin();
                if (date2 != null) {
                    booleanBuilder.and((Predicate)((SBaseFieldValues)((Object)FV)).dateValue.goe((Comparable)date2));
                }
                if ((date = object.getEnd()) == null) break;
                booleanBuilder.and((Predicate)((SBaseFieldValues)((Object)FV)).dateValue.loe((Comparable)date));
                break;
            }
            case DECIMAL: {
                BigDecimal bigDecimal;
                object = (DecimalRange)object2;
                BigDecimal bigDecimal2 = object.getMin();
                if (bigDecimal2 != null) {
                    booleanBuilder.and((Predicate)((SBaseFieldValues)((Object)FV)).decimalValue.goe((Number)bigDecimal2));
                }
                if ((bigDecimal = object.getMax()) == null) break;
                booleanBuilder.and((Predicate)((SBaseFieldValues)((Object)FV)).decimalValue.loe((Number)bigDecimal));
                break;
            }
            case INTEGER: {
                Integer n;
                object = (IntegerRange)object2;
                Integer n2 = object.getMin();
                if (n2 != null) {
                    booleanBuilder.and((Predicate)((SBaseFieldValues)((Object)FV)).integerValue.goe((Number)n2));
                }
                if ((n = object.getMax()) == null) break;
                booleanBuilder.and((Predicate)((SBaseFieldValues)((Object)FV)).integerValue.loe((Number)n));
                break;
            }
            case SINGLE_SELECTION: {
                object = (Collection)object2;
                booleanBuilder.and((Predicate)((SBaseFieldValues)((Object)FV)).enumValueId.in((Collection)object));
                break;
            }
            case MULTI_SELECTION: {
                SBaseEnumValues sBaseEnumValues;
                object = (Collection)object2;
                FV = this.fieldValue(customField, clazz);
                try {
                    sBaseEnumValues = (SBaseEnumValues)((Object)clazz2.getConstructor(String.class).newInstance("ev_" + customField.getId()));
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
                SQLQuery sQLQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)sBaseEnumValues)).innerJoin(FV)).on((Predicate)sBaseEnumValues.ownerId.eq(((SBaseFieldValues)((Object)FV)).id))).where(new Predicate[]{((SBaseFieldValues)((Object)FV)).ownerId.eq(numberPath), sBaseEnumValues.possibleValueId.in((Collection)object)});
                if (FV instanceof SUserCustomFieldValues && !bl) {
                    SUserCustomFieldValues sUserCustomFieldValues = (SUserCustomFieldValues)((Object)FV);
                    sQLQuery.where((Predicate)sUserCustomFieldValues.hidden.isNull().or((Predicate)sUserCustomFieldValues.hidden.isFalse()));
                }
                booleanBuilder.and((Predicate)sQLQuery.exists());
                break;
            }
            case DYNAMIC_SELECTION: {
                if (object2 instanceof Collection) {
                    object = (Collection)object2;
                    booleanBuilder.and((Predicate)((SBaseFieldValues)((Object)FV)).stringValue.toLowerCase().in((Collection)object.stream().map(String::toLowerCase).collect(Collectors.toSet())));
                    break;
                }
                sTsQuery = STsQuery.of(string, (String)object2);
                booleanBuilder.and(((SBaseFieldValues)((Object)FV)).valueTsVector.matches(sTsQuery));
                break;
            }
            case DYNAMIC_MULTI_SELECTION: {
                if (object2 instanceof Collection) {
                    FV = this.fieldValue(customField, clazz);
                    try {
                        object = (SBaseDynaValues)((Object)clazz3.getConstructor(String.class).newInstance("dv_" + customField.getId()));
                    }
                    catch (Exception exception) {
                        throw new IllegalStateException(exception);
                    }
                    Collection collection = (Collection)object2;
                    SQLQuery sQLQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)object)).innerJoin(FV)).on((Predicate)((SBaseDynaValues)((Object)object)).ownerId.eq(((SBaseFieldValues)((Object)FV)).id))).where(new Predicate[]{((SBaseFieldValues)((Object)FV)).ownerId.eq(numberPath), ((SBaseDynaValues)((Object)object)).value.toLowerCase().in((Collection)collection.stream().map(String::toLowerCase).collect(Collectors.toSet()))});
                    if (FV instanceof SUserCustomFieldValues && !bl) {
                        SUserCustomFieldValues sUserCustomFieldValues = (SUserCustomFieldValues)((Object)FV);
                        sQLQuery.where((Predicate)sUserCustomFieldValues.hidden.isNull().or((Predicate)sUserCustomFieldValues.hidden.isFalse()));
                    }
                    booleanBuilder.and((Predicate)sQLQuery.exists());
                    break;
                }
                sTsQuery = STsQuery.of(string, (String)object2);
                booleanBuilder.and(((SBaseFieldValues)((Object)FV)).valueTsVector.matches(sTsQuery));
                break;
            }
            case LINKED_ENTITY: {
                object = (Collection)object2;
                booleanBuilder.and((Predicate)((SBaseFieldValues)((Object)FV)).linkedEntityId.in((Collection)object));
                break;
            }
            case FILE: 
            case IMAGE: {
                return null;
            }
        }
        if (booleanBuilder.hasValue() && !bl && FV instanceof SUserCustomFieldValues && customField.getType() != CustomFieldType.MULTI_SELECTION) {
            object = (SUserCustomFieldValues)((Object)FV);
            booleanBuilder.and((Predicate)((SUserCustomFieldValues)((Object)object)).hidden.isNull().or((Predicate)((SUserCustomFieldValues)((Object)object)).hidden.isFalse()));
        }
        return Pair.create((Object)booleanBuilder, sTsQuery);
    }

    protected <T extends SBaseFieldValues<T>> Pair<BooleanBuilder, STsQuery> getCustomFieldQueryCondition(Class<T> clazz, Class<? extends SBaseEnumValues<?>> clazz2, Class<? extends SBaseDynaValues<?>> clazz3, NumberPath<Long> numberPath, CustomField<?, ?, ?> customField, CustomFieldValueForSearchDTO customFieldValueForSearchDTO) {
        return this.getCustomFieldQueryCondition(clazz, clazz2, clazz3, numberPath, customField, customFieldValueForSearchDTO, true);
    }

    protected Map<CustomField<?, ?, ?>, SBaseFieldValues<?>> getFieldValues() {
        return this.fieldValues;
    }

    protected FormatterImpl getFormatter() {
        if (this._formatter == null) {
            this._formatter = this.conversionHandler.getFormatter();
        }
        return this._formatter;
    }

    protected int getLimit() {
        return this.params.getPageSize();
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = LogManager.getLogger(this.getClass());
        }
        return this.logger;
    }

    protected final RelationalPath<?> getMainEntityAlias() {
        this.ensureQuery();
        return this.doGetMainEntityAlias();
    }

    protected int getOffset() {
        return this.params.getCurrentPage() * this.params.getPageSize();
    }

    protected final Expression<P> getProjection(Integer n) {
        this.ensureQuery();
        return this.doGetProjection(n);
    }

    protected SessionData getSessionData() {
        if (this.sessionData == null) {
            this.sessionData = InvocationContext.getSessionData();
        }
        return this.sessionData;
    }

    protected abstract List<Expression<?>> initializeQuery();

    protected <T extends SBaseFieldValues<T>> T join(Class<T> clazz, Class<? extends SBaseEnumValues<?>> clazz2, CustomField<?, ?, ?> customField, NumberPath<Long> numberPath) {
        SQLQuery<?> sQLQuery = this.getQuery();
        Object t = this.fieldValue(customField, clazz);
        if (!sQLQuery.getMetadata().getJoins().stream().anyMatch(joinExpression -> joinExpression.getTarget() == t)) {
            ((SQLQuery)sQLQuery.leftJoin(t)).on((Predicate)((SBaseFieldValues)((Object)t)).ownerId.eq(numberPath).and((Predicate)((SBaseFieldValues)((Object)t)).fieldId.eq((Object)customField.getId())));
        }
        return t;
    }

    protected void resetQuery() {
        this.query = null;
        this.fieldValues.clear();
    }

    private <T> Page<T> buildPage(PageRunner<T> pageRunner) {
        Integer n = this.params.getPageSize();
        Integer n2 = this.params.getCurrentPage();
        ConfigurationAccessor configurationAccessor = this.getSessionData().getConfiguration();
        boolean bl = n == 0 ? false : this.params.isSkipTotalCount() || configurationAccessor.isSkipTotalCount();
        Integer n3 = bl ? null : Integer.valueOf(this.count());
        List<Object> list = new ArrayList();
        Integer n4 = null;
        if (n3 != null) {
            n4 = (int)Math.ceil((double)n3.intValue() / (double)n.intValue()) - 1;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n2 > n4) {
                n2 = n4;
            }
        }
        boolean bl2 = false;
        if (n > 0) {
            try {
                list = pageRunner.queryPageItems(n3, n2 * n, n);
                if (n3 == null) {
                    bl2 = CollectionHelper.size(list) > n;
                    list = list.subList(0, Math.min(n, list.size()));
                } else {
                    bl2 = n2 < n4;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new UnexpectedDataAccessException((Throwable)exception);
            }
        }
        return new PageImpl(list, n.intValue(), n2.intValue(), n3, bl2);
    }

    private JpaQueryResult createJpaQuery(boolean bl, Expression<?> expression) {
        if (bl) {
            QueryHelper.applyExport(this.params);
        }
        return this.createJpaQuery(expression, this.getOffset(), this.getLimit());
    }

    private JpaQueryResult doCreateJpaQuery(Expression<?> expression, boolean bl, int n, int n2) {
        if (this.query == null) {
            throw new IllegalStateException("Query not initialized");
        }
        this.query.select(expression);
        this.query.offset((long)n);
        this.query.limit((long)n2);
        SQLBindings sQLBindings = this.query.getSQL();
        EntityManager entityManager = this.rawEntityManagerHandler.getEntityManager();
        Query query = bl ? entityManager.createNativeQuery(sQLBindings.getSQL(), this.entityType) : entityManager.createNativeQuery(sQLBindings.getSQL());
        int n3 = 0;
        for (Object object : sQLBindings.getNullFriendlyBindings()) {
            if (object instanceof Enum) {
                object = ((Enum)object).name();
            }
            query.setParameter(++n3, object);
        }
        return new JpaQueryResult(query, sQLBindings, expression);
    }

    private <R> CloseableIterator<R> doExport(JpaQueryResult jpaQueryResult) {
        Query query = jpaQueryResult.getJpaQuery();
        QueryHandler queryHandler = PostgresqlQueryHandlerImpl.CustomTemplates.getInstance().getQueryHandler();
        try {
            FactoryExpression factoryExpression = (FactoryExpression)ObjectHelper.ifType(jpaQueryResult.getProjection(), FactoryExpression.class);
            return queryHandler.iterate(query, factoryExpression);
        }
        catch (RuntimeException runtimeException) {
            SQLBindings sQLBindings = jpaQueryResult.getSqlBindings();
            this.getLogger().error("Error executing iterator on query: [" + sQLBindings.getSQL() + "] with bind parameters: " + String.valueOf(sQLBindings.getNullFriendlyBindings()));
            throw runtimeException;
        }
    }

    private void ensureQuery() {
        if (this.query == null) {
            this.query = new SQLQuery(QuerydslConfiguration.get());
            List<Expression<?>> list = this.initializeQuery();
            CollectionHelper.orEmpty(list).forEach(arg_0 -> this.query.from(arg_0));
        }
    }

    private Pair<BooleanBuilder, STsQuery> getAddressFieldQueryCondition(SUsers sUsers, AddressFieldValueForSearchDTO addressFieldValueForSearchDTO, boolean bl, SAddresses sAddresses) {
        boolean bl2;
        String string = StringHelper.trimToNull((Object)addressFieldValueForSearchDTO.getStringValue());
        AddressQueryField addressQueryField = addressFieldValueForSearchDTO.getAddressField();
        if (string == null || addressQueryField == null) {
            return null;
        }
        boolean bl3 = bl2 = sAddresses != null;
        if (!bl2) {
            sAddresses = SAddresses.address;
        }
        TsVectorPath tsVectorPath = null;
        BooleanExpression booleanExpression = null;
        switch (addressQueryField) {
            case ADDRESS: {
                tsVectorPath = sAddresses.addressTsvector;
                break;
            }
            case NEIGHBORHOOD: {
                tsVectorPath = sAddresses.neighborhoodTsvector;
                break;
            }
            case CITY: {
                tsVectorPath = sAddresses.cityTsvector;
                break;
            }
            case REGION: {
                tsVectorPath = sAddresses.regionTsvector;
                break;
            }
            case COUNTRY: {
                booleanExpression = sAddresses.country.eq((Object)string.toUpperCase());
                break;
            }
            case PO_BOX: {
                booleanExpression = sAddresses.normalizedPoBox.eq((Object)string.replaceAll("\\W", "").toLowerCase());
                break;
            }
            case ZIP: {
                booleanExpression = sAddresses.normalizedZip.eq((Object)string.replaceAll("\\W", "").toLowerCase());
            }
        }
        STsQuery sTsQuery = null;
        if (tsVectorPath != null) {
            sTsQuery = STsQuery.of("query_address_" + addressQueryField.name(), string);
            booleanExpression = tsVectorPath.matches(sTsQuery);
        }
        if (booleanExpression == null) {
            return Pair.create((Object)null, null);
        }
        BooleanBuilder booleanBuilder = bl2 ? new BooleanBuilder((Predicate)booleanExpression) : new BooleanBuilder((Predicate)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)sAddresses)).where(new Predicate[]{sAddresses.userId.eq(sUsers.id), bl ? sAddresses.id.isNotNull() : sAddresses.hidden.isFalse(), booleanExpression})).exists());
        return Pair.create((Object)booleanBuilder, (Object)((Object)sTsQuery));
    }

    private Pair<BooleanBuilder, STsQuery> getBasicFieldQueryCondition(SUsers sUsers, BasicProfileFieldValueForSearchDTO basicProfileFieldValueForSearchDTO, boolean bl, SAddresses sAddresses) {
        BasicProfileField basicProfileField = basicProfileFieldValueForSearchDTO.getField();
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        String string = StringHelper.trimToNull((Object)basicProfileFieldValueForSearchDTO.getStringValue());
        STsQuery sTsQuery = null;
        String string2 = "query_basic_" + basicProfileField.name();
        switch (basicProfileField) {
            case LOGIN_NAME: {
                if (string == null) break;
                booleanBuilder.and((Predicate)sUsers.username.equalsIgnoreCase(string));
                break;
            }
            case FULL_NAME: {
                if (string == null) break;
                sTsQuery = STsQuery.of(string2, string);
                booleanBuilder.and(sUsers.nameTsVector.matches(sTsQuery));
                break;
            }
            case EMAIL: {
                if (string == null) break;
                if (bl) {
                    booleanBuilder.and((Predicate)sUsers.email.equalsIgnoreCase(string));
                    break;
                }
                booleanBuilder.and((Predicate)sUsers.userHideEmail.isFalse()).and((Predicate)sUsers.email.equalsIgnoreCase(string));
                break;
            }
            case ADDRESS: {
                if (string == null) break;
                sTsQuery = STsQuery.of(string2, string);
                if (sAddresses != null) {
                    booleanBuilder.and(sAddresses.fullTsvector.matches(sTsQuery));
                    break;
                }
                sAddresses = SAddresses.address;
                booleanBuilder.and((Predicate)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)sAddresses)).where(new Predicate[]{sAddresses.userId.eq(sUsers.id), bl ? sAddresses.id.isNotNull() : sAddresses.hidden.isFalse(), sAddresses.fullTsvector.matches(sTsQuery)})).exists());
                break;
            }
            case PHONE: {
                if (string == null) break;
                PhoneNumberDescriptor phoneNumberDescriptor = this.phoneNumberHandler.parse(string, this.getSessionData().getConfiguration());
                if (phoneNumberDescriptor == null) {
                    booleanBuilder.and((Predicate)sUsers.id.isNull());
                    break;
                }
                SPhones sPhones = SPhones.phones;
                booleanBuilder.and((Predicate)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)sPhones)).where(new Predicate[]{sPhones.userId.eq(sUsers.id), bl ? sPhones.id.isNotNull() : sPhones.hidden.isFalse(), sPhones.normalizedNumber.eq((Object)phoneNumberDescriptor.toE164())})).exists());
                break;
            }
            case IMAGE: {
                Boolean bl2 = basicProfileFieldValueForSearchDTO.getBooleanValue();
                if (bl2 == null && string != null) {
                    bl2 = Boolean.parseBoolean(string);
                }
                if (bl2 == null) break;
                SStoredFiles sStoredFiles = SStoredFiles.storedFiles;
                SQLQuery sQLQuery = (SQLQuery)((SQLQuery)new SQLQuery().from((Expression)sStoredFiles)).where(new Predicate[]{sStoredFiles.userId.eq(sUsers.id), sStoredFiles.nature.eq((Object)StoredFileNature.USER_IMAGE)});
                booleanBuilder.and((Predicate)(bl2 != false ? sQLQuery.exists() : sQLQuery.notExists()));
                break;
            }
            case ACCOUNT_NUMBER: {
                if (string == null) break;
                AccountNumberConfiguration accountNumberConfiguration = this.getSessionData().getConfiguration().getAccountNumberConfiguration();
                if (accountNumberConfiguration == null || !accountNumberConfiguration.isEnabled()) {
                    booleanBuilder.and((Predicate)sUsers.id.isNull());
                    break;
                }
                String string3 = MaskHelper.removeMask((String)accountNumberConfiguration.getMask(), (String)string);
                SAccounts sAccounts = SAccounts.accounts;
                booleanBuilder.and((Predicate)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)sAccounts)).where(new Predicate[]{sAccounts.userId.eq(sUsers.id), sAccounts.number.equalsIgnoreCase(string3)})).exists());
                break;
            }
        }
        return Pair.create((Object)booleanBuilder, sTsQuery);
    }

    protected static class JpaQueryResult {
        private Query jpaQuery;
        private SQLBindings sqlBindings;
        private Expression<?> projection;

        public JpaQueryResult(Query query, SQLBindings sQLBindings, Expression<?> expression) {
            this.jpaQuery = query;
            this.sqlBindings = sQLBindings;
            this.projection = expression;
        }

        public <R> List<R> applyToList(List<?> list) {
            if (CollectionHelper.isEmpty(list)) {
                return Collections.emptyList();
            }
            if (this.projection instanceof FactoryExpression) {
                list = list.stream().map(this::applyProjection).collect(Collectors.toList());
            }
            return list;
        }

        public <R> R applyToObject(Object object) {
            if (this.projection instanceof FactoryExpression) {
                return this.applyToObject(object);
            }
            return (R)object;
        }

        public Query getJpaQuery() {
            return this.jpaQuery;
        }

        public Expression<?> getProjection() {
            return this.projection;
        }

        public SQLBindings getSqlBindings() {
            return this.sqlBindings;
        }

        private <R> R applyProjection(Object object) {
            Object[] objectArray;
            FactoryExpression factoryExpression = (FactoryExpression)this.projection;
            if (object instanceof Object[]) {
                objectArray = (Object[])object;
            } else if (object instanceof Collection) {
                objectArray = ((Collection)object).toArray();
            } else {
                throw new IllegalStateException("Cannot extract Object[] from " + String.valueOf(object));
            }
            return (R)factoryExpression.newInstance(objectArray);
        }
    }

    private static interface PageRunner<T> {
        public List<T> queryPageItems(Integer var1, int var2, int var3);
    }

    protected static interface SQLQueryAction<T> {
        public T execute(SQLQuery<?> var1);
    }

    protected abstract class BaseProjection
    extends CustomProjection<P> {
        private static final long serialVersionUID = 1L;

        public BaseProjection() {
            super(NativeQuery.this.projectionType);
        }

        protected void addAddress(SAddresses sAddresses, SContactInfos sContactInfos, List<ContactInfoField> list) {
            this.add(new Expression[]{sAddresses.id, sAddresses.name, sAddresses.addressLine1, sAddresses.addressLine2, sAddresses.city, sAddresses.country, sAddresses.neighborhood, sAddresses.poBox, sAddresses.region, sAddresses.zip, sAddresses.defaultAddress, sAddresses.hidden, sAddresses.latitude, sAddresses.longitude, sAddresses.street, sAddresses.buildingNumber, sAddresses.complement});
            if (sContactInfos != null) {
                this.add(new Expression[]{sContactInfos.id, sContactInfos.email, sContactInfos.mobilePhone, sContactInfos.landLinePhone, sContactInfos.landLineExtension});
                for (ContactInfoField contactInfoField : CollectionHelper.orEmpty(list)) {
                    this.addCustomFieldValue((CustomField<?, ?, ?>)contactInfoField);
                }
            }
        }

        protected void addCustomFieldValue(CustomField<?, ?, ?> customField) {
            SBaseFieldValues<?> sBaseFieldValues = NativeQuery.this.fieldValues.get(customField);
            if (sBaseFieldValues != null) {
                this.add(new Expression[]{sBaseFieldValues.id});
                if (sBaseFieldValues instanceof SUserCustomFieldValues) {
                    this.add(new Expression[]{((SUserCustomFieldValues)sBaseFieldValues).hidden});
                }
            }
            switch (customField.getType()) {
                case BOOLEAN: {
                    this.add(new Expression[]{sBaseFieldValues.booleanValue});
                    break;
                }
                case DATE: {
                    this.add(new Expression[]{sBaseFieldValues.dateValue});
                    break;
                }
                case DECIMAL: {
                    this.add(new Expression[]{sBaseFieldValues.decimalValue});
                    break;
                }
                case DYNAMIC_SELECTION: {
                    this.add(new Expression[]{sBaseFieldValues.stringValue});
                    this.add(new Expression[]{sBaseFieldValues.textValue});
                    break;
                }
                case INTEGER: {
                    this.add(new Expression[]{sBaseFieldValues.integerValue});
                    break;
                }
                case LINKED_ENTITY: {
                    this.add(new Expression[]{sBaseFieldValues.linkedEntityId});
                    break;
                }
                case RICH_TEXT: {
                    this.add(new Expression[]{sBaseFieldValues.richTextValue});
                    break;
                }
                case STRING: 
                case URL: {
                    this.add(new Expression[]{sBaseFieldValues.stringValue});
                    break;
                }
                case TEXT: {
                    this.add(new Expression[]{sBaseFieldValues.textValue});
                    break;
                }
                case SINGLE_SELECTION: {
                    this.add(new Expression[]{sBaseFieldValues.enumValueId});
                    break;
                }
            }
        }

        protected void addImage(SStoredFiles sStoredFiles) {
            this.add(new Expression[]{sStoredFiles.id, sStoredFiles.name, sStoredFiles.convertedToJpeg, sStoredFiles.contentType, sStoredFiles.width, sStoredFiles.height, sStoredFiles.length, sStoredFiles.urlKey, sStoredFiles.lastModified});
        }

        protected void addUser(SUsers sUsers) {
            this.add(new Expression[]{sUsers.id, sUsers.displayForManagers, sUsers.displayForOthers, sUsers.brokerIds});
        }

        protected UserAddressVO buildAddress(SAddresses sAddresses, Long l, NumberExpression<BigDecimal> numberExpression, DistanceUnit distanceUnit, List<ContactInfoField> list, SContactInfos sContactInfos) {
            Long l2 = (Long)this.get((Expression)sAddresses.id);
            UserAddressVO userAddressVO = null;
            if (l2 != null) {
                BigDecimal bigDecimal;
                userAddressVO = new UserAddressVO();
                Group group = (Group)NativeQuery.this.rawEntityManagerHandler.find(Group.class, l);
                ConfigurationAccessor configurationAccessor = NativeQuery.this.configurationHandler.getAccessor((BasicGroup)group);
                Set set = configurationAccessor.getAddressConfiguration().getEnabledAddressFields();
                userAddressVO.setId((Long)this.get((Expression)sAddresses.id));
                userAddressVO.setName((String)this.get((Expression)sAddresses.name));
                if (set.contains(AddressFields.ADDRESS_LINE_1)) {
                    userAddressVO.setAddressLine1((String)this.get((Expression)sAddresses.addressLine1));
                }
                if (set.contains(AddressFields.ADDRESS_LINE_2)) {
                    userAddressVO.setAddressLine2((String)this.get((Expression)sAddresses.addressLine2));
                }
                if (set.contains(AddressFields.CITY)) {
                    userAddressVO.setCity((String)this.get((Expression)sAddresses.city));
                }
                if (set.contains(AddressFields.COUNTRY)) {
                    userAddressVO.setCountry((String)this.get((Expression)sAddresses.country));
                }
                if (set.contains(AddressFields.NEIGHBORHOOD)) {
                    userAddressVO.setNeighborhood((String)this.get((Expression)sAddresses.neighborhood));
                }
                if (set.contains(AddressFields.PO_BOX)) {
                    userAddressVO.setPoBox((String)this.get((Expression)sAddresses.poBox));
                }
                if (set.contains(AddressFields.REGION)) {
                    userAddressVO.setRegion((String)this.get((Expression)sAddresses.region));
                }
                if (set.contains(AddressFields.ZIP)) {
                    userAddressVO.setZip((String)this.get((Expression)sAddresses.zip));
                }
                if (set.contains(AddressFields.STREET)) {
                    userAddressVO.setStreet((String)this.get((Expression)sAddresses.street));
                }
                if (set.contains(AddressFields.BUILDING_NUMBER)) {
                    userAddressVO.setBuildingNumber((String)this.get((Expression)sAddresses.buildingNumber));
                }
                if (set.contains(AddressFields.COMPLEMENT)) {
                    userAddressVO.setComplement((String)this.get((Expression)sAddresses.complement));
                }
                userAddressVO.setDefaultAddress(Boolean.TRUE.equals(this.get((Expression)sAddresses.defaultAddress)));
                userAddressVO.setHidden(Boolean.TRUE.equals(this.get((Expression)sAddresses.hidden)));
                userAddressVO.setLocation(ModelHelper.latLong((BigDecimal)((BigDecimal)this.get((Expression)sAddresses.latitude)), (BigDecimal)((BigDecimal)this.get((Expression)sAddresses.longitude))));
                userAddressVO.setLocated(this.get((Expression)sAddresses.latitude) != null && this.get((Expression)sAddresses.longitude) != null);
                if (numberExpression != null) {
                    bigDecimal = (BigDecimal)this.get((Expression)numberExpression);
                    userAddressVO.setCurrentDistance(Double.valueOf(distanceUnit.fromMeters(bigDecimal.doubleValue())));
                }
                if (sContactInfos != null && this.get((Expression)sContactInfos.id) != null) {
                    bigDecimal = new AddressContactInfoVO();
                    userAddressVO.setContactInfo((AddressContactInfoVO)bigDecimal);
                    bigDecimal.setEmail((String)this.get((Expression)sContactInfos.email));
                    bigDecimal.setMobilePhone((String)this.get((Expression)sContactInfos.mobilePhone));
                    bigDecimal.setLandLinePhone((String)this.get((Expression)sContactInfos.landLinePhone));
                    bigDecimal.setLandLineExtension((String)this.get((Expression)sContactInfos.landLineExtension));
                    if (CollectionHelper.isNotEmpty(list)) {
                        ArrayList<CustomFieldValueVO> arrayList = new ArrayList<CustomFieldValueVO>();
                        bigDecimal.setCustomValues(arrayList);
                        for (ContactInfoField contactInfoField : list) {
                            CustomFieldValueVO customFieldValueVO = this.getCustomFieldValue(SContactInfoFieldValues.class, SContactInfoEnumValues.class, (Long)this.get((Expression)sContactInfos.id), ContactInfoFieldValue.class, contactInfoField);
                            if (customFieldValueVO == null) continue;
                            arrayList.add(customFieldValueVO);
                        }
                    }
                }
            }
            return userAddressVO;
        }

        protected <FV extends SBaseFieldValues<?>, EV extends SBaseEnumValues<?>, V extends CustomFieldValue<CF, C, PV, O>, CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, O extends SimpleEntity> CustomFieldValueVO getCustomFieldValue(Class<FV> clazz, Class<EV> clazz2, Long l, Class<V> clazz3, CF CF) {
            return this.getCustomFieldValue(clazz, clazz2, l, clazz3, CF, false);
        }

        protected <FV extends SBaseFieldValues<?>, EV extends SBaseEnumValues<?>, V extends CustomFieldValue<CF, C, PV, O>, CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, O extends SimpleEntity> CustomFieldValueVO getCustomFieldValue(Class<FV> clazz, Class<EV> clazz2, Long l, Class<V> clazz3, CF CF, boolean bl) {
            Object object;
            Object object2;
            FV FV = NativeQuery.this.fieldValue(CF, clazz);
            if (!bl && FV instanceof SUserCustomFieldValues && Boolean.TRUE.equals(object2 = (Boolean)this.get((Expression)((SUserCustomFieldValues)((Object)FV)).hidden))) {
                return null;
            }
            object2 = (CustomFieldValue)ClassHelper.instantiate(clazz3);
            object2.setField(CF);
            switch (CF.getType()) {
                case BOOLEAN: {
                    object = (Boolean)this.get((Expression)((SBaseFieldValues)((Object)FV)).booleanValue);
                    if (object == null) {
                        return null;
                    }
                    object2.setBooleanValue((Boolean)object);
                    break;
                }
                case DATE: {
                    object = (Date)this.get((Expression)((SBaseFieldValues)((Object)FV)).dateValue);
                    if (object == null) {
                        return null;
                    }
                    object2.setDateValue((IDate)DateWrapper.instance((Date)object));
                    break;
                }
                case DECIMAL: {
                    object = (BigDecimal)this.get((Expression)((SBaseFieldValues)((Object)FV)).decimalValue);
                    if (object == null) {
                        return null;
                    }
                    object2.setDecimalValue((BigDecimal)object);
                    break;
                }
                case DYNAMIC_SELECTION: {
                    object = (String)this.get((Expression)((SBaseFieldValues)((Object)FV)).stringValue);
                    String string = (String)ObjectHelper.defaultValue((Object)((String)this.get((Expression)((SBaseFieldValues)((Object)FV)).textValue)), (Object)object);
                    if (object == null) {
                        return null;
                    }
                    object2.setStringValue((String)object);
                    object2.setTextValue(string);
                    break;
                }
                case INTEGER: {
                    object = (Integer)this.get((Expression)((SBaseFieldValues)((Object)FV)).integerValue);
                    if (object == null) {
                        return null;
                    }
                    object2.setIntegerValue((Integer)object);
                    break;
                }
                case LINKED_ENTITY: {
                    object = (Long)this.get((Expression)((SBaseFieldValues)((Object)FV)).linkedEntityId);
                    if (object == null) {
                        return null;
                    }
                    object2.setLinkedEntityId((Long)object);
                    break;
                }
                case RICH_TEXT: {
                    object = (String)this.get((Expression)((SBaseFieldValues)((Object)FV)).richTextValue);
                    if (object == null) {
                        return null;
                    }
                    object2.setRichTextValue((String)object);
                    break;
                }
                case STRING: 
                case URL: {
                    object = (String)this.get((Expression)((SBaseFieldValues)((Object)FV)).stringValue);
                    if (object == null) {
                        return null;
                    }
                    object2.setStringValue((String)object);
                    break;
                }
                case TEXT: {
                    object = (String)this.get((Expression)((SBaseFieldValues)((Object)FV)).textValue);
                    if (object == null) {
                        return null;
                    }
                    object2.setTextValue((String)object);
                    break;
                }
                case SINGLE_SELECTION: {
                    object = (Long)this.get((Expression)((SBaseFieldValues)((Object)FV)).enumValueId);
                    if (object == null) {
                        return null;
                    }
                    CustomFieldPossibleValue customFieldPossibleValue = (CustomFieldPossibleValue)NativeQuery.this.rawEntityManagerHandler.find(CF.getPossibleValueClass(), (Long)object);
                    object2.setEnumeratedValue(customFieldPossibleValue);
                    break;
                }
                case MULTI_SELECTION: {
                    try {
                        object = (SBaseEnumValues)((Object)clazz2.getConstructor(String.class).newInstance("ev_" + CF.getId()));
                    }
                    catch (Exception exception) {
                        throw new IllegalStateException(exception);
                    }
                    ConnectionCallback connectionCallback = arg_0 -> this.lambda$getCustomFieldValue$1((SBaseEnumValues)((Object)object), FV, l, CF, arg_0);
                    object2.setEnumeratedValues((Set)NativeQuery.this.jdbcTemplate.execute(connectionCallback));
                    break;
                }
                case DYNAMIC_MULTI_SELECTION: 
                case FILE: 
                case IMAGE: {
                    return null;
                }
            }
            object = (CustomFieldValueVO)NativeQuery.this.conversionHandler.convert(CustomFieldValueVO.class, object2);
            if (CF.getType() != CustomFieldType.MULTI_SELECTION) {
                object.setId((Long)this.get((Expression)((SBaseFieldValues)((Object)FV)).id));
            }
            if (!CF.getType().isEnumerated()) {
                object.setEnumeratedValues(null);
            }
            return object;
        }

        protected ImageVO getImage(SStoredFiles sStoredFiles) {
            Long l = (Long)this.get((Expression)sStoredFiles.id);
            if (l != null) {
                ImageVO imageVO = new ImageVO();
                imageVO.setId(l);
                imageVO.setName((String)this.get((Expression)sStoredFiles.name));
                imageVO.setConvertedToJpeg(((Boolean)this.get((Expression)sStoredFiles.convertedToJpeg)).booleanValue());
                imageVO.setContentType((String)this.get((Expression)sStoredFiles.contentType));
                imageVO.setWidth(((Integer)this.get((Expression)sStoredFiles.width)).intValue());
                imageVO.setHeight(((Integer)this.get((Expression)sStoredFiles.height)).intValue());
                imageVO.setLength(((Integer)this.get((Expression)sStoredFiles.length)).intValue());
                imageVO.setKey(ImageVOConverter.getKey((String)this.get((Expression)sStoredFiles.urlKey), imageVO.getWidth(), imageVO.getHeight(), imageVO.getContentType()));
                Date date = (Date)this.get((Expression)sStoredFiles.lastModified);
                imageVO.setLastModified(NativeQuery.this.conversionHandler.toDateTime(date));
                imageVO.setLastModifiedInMillis(String.valueOf(date.getTime()));
                return imageVO;
            }
            return null;
        }

        private /* synthetic */ Set lambda$getCustomFieldValue$1(SBaseEnumValues sBaseEnumValues, SBaseFieldValues sBaseFieldValues, Long l2, CustomField customField, Connection connection) throws SQLException, DataAccessException {
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)new SQLQuery(connection, QuerydslConfiguration.get()).select(sBaseEnumValues.possibleValueId).from((Expression)sBaseEnumValues)).innerJoin((EntityPath)sBaseFieldValues)).on((Predicate)sBaseEnumValues.ownerId.eq(sBaseFieldValues.id))).where(new Predicate[]{sBaseFieldValues.ownerId.eq((Object)l2), sBaseFieldValues.fieldId.eq((Object)customField.getId())})).fetch().stream().map(l -> (CustomFieldPossibleValue)NativeQuery.this.rawEntityManagerHandler.find(customField.getPossibleValueClass(), l)).collect(Collectors.toSet());
        }
    }
}

