/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search.opensearch;

import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.users.GroupsHandler;
import org.cyclos.impl.users.ProductsHandler;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.persistence.EntityManagerHandler;
import org.cyclos.model.Property;
import org.cyclos.model.system.fields.HasValueMatch;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.utils.StringHelper;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptType;

public abstract class OpenSearchAccessor {
    public static final String TYPE_KEYWORD = "keyword";
    public static final String TYPE_FLOAT = "float";
    public static final String NETWORK = "network";
    public static final String CHANNEL = "channel";
    public static final String OTHER_BROKERS = "otherBrokers";
    public static final String OWNER = "owner";
    public static final String BROKER = "broker";
    public static final String GROUP = "group";
    public static final String USER = "user";
    public static final String BEGIN = "begin";
    public static final String END = "end";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String ZIP_PLAIN = "zipPlain";
    public static final String PO_BOX_PLAIN = "poBoxPlain";
    public static final String COUNTRY_NAME = "countryName";
    public static final String DISPLAY_FOR_MANAGERS = "displayForManagers";
    public static final String DISPLAY_FOR_OTHERS = "displayForOthers";
    public static final String HIDE_EMAIL = "hideEmail";
    public static final String HIDDEN_CUSTOM_PROFILE_FIELDS = "hiddenCustomProfileFields";
    public static final String HIDE_PREFERRED_PHONE = "hidePreferredPhone";
    public static final String USER_STATUS = "userStatus";
    public static final String ADDRESSES = "addresses";
    public static final String AD_ADDRESSES = "adAddresses";
    public static final String HAS_PROFILE_IMAGE = "hasProfileImage";
    public static final String NATURE = "nature";
    public static final String STATUS = "status";
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String KEYWORD = "keyword";
    private static final String INTEGER = "integer";
    private static final String IGNORED = "ignored";
    private static final String ID = "id";
    private static final String DECIMAL = "decimal";
    private static final String DATE = "date";
    private static final String BOOLEAN = "boolean";
    private static final String TEXT = "text";
    private ConversionHandler _conversionHandler;
    private EntityManagerHandler _entityManagerHandler;
    private CustomFieldValueHandler _customFieldValueHandler;
    private ProfileFieldHandler _profileFieldHandler;
    private GroupsHandler _groupsHandler;
    private AccountServiceLocal _accountService;
    private NativeQueryHandler _nativeQueryHandler;
    private ConfigurationHandler _configurationHandler;
    private ProductsHandler _productsHandler;
    private PhoneNumberHandler _phoneNumberHandler;

    public static Set<BuiltinLanguage> allLanguages(BasicUser basicUser) {
        ConfigurationAccessor configurationAccessor = basicUser != null ? ((ConfigurationHandler)InvocationContext.bean(ConfigurationHandler.class)).getAccessor(basicUser) : InvocationContext.getSessionData().getConfiguration();
        EnumSet<BuiltinLanguage> enumSet = EnumSet.noneOf(BuiltinLanguage.class);
        enumSet.add(configurationAccessor.getLanguage().getTemplate());
        configurationAccessor.getAllowedLanguages().stream().map(Language::getTemplate).forEach(enumSet::add);
        return enumSet;
    }

    public static String baseName(HasValueMatch hasValueMatch) {
        if (hasValueMatch instanceof CustomField) {
            CustomField customField = (CustomField)hasValueMatch;
            return StringHelper.camelize((String)customField.getNature().name()) + "Field$" + customField.getInternalName();
        }
        if (hasValueMatch instanceof BasicProfileField) {
            return OpenSearchAccessor.storedFieldName((BasicProfileField)hasValueMatch);
        }
        return null;
    }

    public static String booleanSuffix(String string) {
        return OpenSearchAccessor.suffix(string, BOOLEAN);
    }

    public static String dateSuffix(String string) {
        return OpenSearchAccessor.suffix(string, DATE);
    }

    public static String decimalSuffix(String string) {
        return OpenSearchAccessor.suffix(string, DECIMAL);
    }

    public static String exactMatchFieldName(CustomField<?, ?, ?> customField) {
        if (customField.getType().isString()) {
            return OpenSearchAccessor.keywordSuffix(OpenSearchAccessor.baseName(customField));
        }
        return OpenSearchAccessor.storedFieldName(customField);
    }

    public static String exactMatchFieldName(HasValueMatch hasValueMatch) {
        if (hasValueMatch instanceof BasicProfileField) {
            return OpenSearchAccessor.storedFieldName((BasicProfileField)hasValueMatch);
        }
        if (hasValueMatch instanceof CustomField) {
            return OpenSearchAccessor.exactMatchFieldName((CustomField)hasValueMatch);
        }
        return null;
    }

    public static String idSuffix(String string) {
        return OpenSearchAccessor.suffix(string, ID);
    }

    public static String ignoredSuffix(String string) {
        return OpenSearchAccessor.suffix(string, IGNORED);
    }

    public static String integerSuffix(String string) {
        return OpenSearchAccessor.suffix(string, INTEGER);
    }

    public static String keywordSuffix(String string) {
        return OpenSearchAccessor.suffix(string, "keyword");
    }

    public static Set<String> languageSuffixes(BasicUser basicUser) {
        Set<String> set = OpenSearchAccessor.allLanguages(basicUser).stream().map(BuiltinLanguage::getOpenSearchAnalyzer).filter(Objects::nonNull).collect(Collectors.toSet());
        set.add(TEXT);
        return set;
    }

    public static Script newScript(CharSequence charSequence, Map<String, Object> map) {
        return new Script(ScriptType.INLINE, "painless", charSequence.toString(), map);
    }

    public static String periodBegin(Property<?, ?> property) {
        return OpenSearchAccessor.periodBegin(property.getName());
    }

    public static String periodBegin(String string) {
        return string + ".begin";
    }

    public static String periodEnd(Property<?, ?> property) {
        return OpenSearchAccessor.periodEnd(property.getName());
    }

    public static String periodEnd(String string) {
        return string + ".end";
    }

    public static String privateSuffix(String string) {
        return OpenSearchAccessor.suffix(string, PRIVATE);
    }

    public static String publicSuffix(String string) {
        return OpenSearchAccessor.suffix(string, PUBLIC);
    }

    public static String sortFieldName(BasicProfileField basicProfileField) {
        if (basicProfileField == BasicProfileField.FULL_NAME) {
            return OpenSearchAccessor.suffix(StringHelper.camelize((String)basicProfileField.name()), "keyword");
        }
        return OpenSearchAccessor.storedFieldName(basicProfileField);
    }

    public static String sortFieldName(CustomField<?, ?, ?> customField) {
        if (!customField.getType().isSortable()) {
            return null;
        }
        if (customField.getType().isString()) {
            String string = OpenSearchAccessor.baseName(customField);
            return OpenSearchAccessor.keywordSuffix(string);
        }
        return OpenSearchAccessor.storedFieldName(customField);
    }

    public static String sortFieldName(HasValueMatch hasValueMatch) {
        if (hasValueMatch instanceof BasicProfileField) {
            return OpenSearchAccessor.sortFieldName((BasicProfileField)hasValueMatch);
        }
        if (hasValueMatch instanceof CustomField) {
            return OpenSearchAccessor.sortFieldName((CustomField)hasValueMatch);
        }
        return null;
    }

    public static String storedFieldName(BasicProfileField basicProfileField) {
        if (basicProfileField == BasicProfileField.IMAGE) {
            return HAS_PROFILE_IMAGE;
        }
        return StringHelper.camelize((String)basicProfileField.name());
    }

    public static String storedFieldName(CustomField<?, ?, ?> customField) {
        String string = OpenSearchAccessor.baseName(customField);
        switch (customField.getType()) {
            case BOOLEAN: {
                return OpenSearchAccessor.booleanSuffix(string);
            }
            case DATE: {
                return OpenSearchAccessor.dateSuffix(string);
            }
            case DECIMAL: {
                return OpenSearchAccessor.decimalSuffix(string);
            }
            case INTEGER: {
                return OpenSearchAccessor.integerSuffix(string);
            }
            case LINKED_ENTITY: 
            case MULTI_SELECTION: 
            case SINGLE_SELECTION: {
                return OpenSearchAccessor.idSuffix(string);
            }
            case STRING: 
            case URL: 
            case RICH_TEXT: 
            case TEXT: {
                return OpenSearchAccessor.ignoredSuffix(string);
            }
            case DYNAMIC_SELECTION: 
            case DYNAMIC_MULTI_SELECTION: {
                return OpenSearchAccessor.keywordSuffix(string);
            }
        }
        return null;
    }

    public static String storedFieldName(HasValueMatch hasValueMatch) {
        if (hasValueMatch instanceof BasicProfileField) {
            return OpenSearchAccessor.storedFieldName((BasicProfileField)hasValueMatch);
        }
        if (hasValueMatch instanceof CustomField) {
            return OpenSearchAccessor.storedFieldName((CustomField)hasValueMatch);
        }
        return null;
    }

    public static String storedFieldName(UserCustomField userCustomField) {
        return OpenSearchAccessor.storedFieldName(userCustomField);
    }

    public static String suffix(String string, String string2) {
        return string + "$" + string2;
    }

    public static String textSuffix(String string) {
        return OpenSearchAccessor.suffix(string, TEXT);
    }

    public PhoneNumberHandler getPhoneNumberHandler() {
        if (this._phoneNumberHandler == null) {
            this._phoneNumberHandler = (PhoneNumberHandler)InvocationContext.bean(PhoneNumberHandler.class);
        }
        return this._phoneNumberHandler;
    }

    protected AccountServiceLocal accountService() {
        if (this._accountService == null) {
            this._accountService = (AccountServiceLocal)InvocationContext.bean(AccountServiceLocal.class);
        }
        return this._accountService;
    }

    protected ConfigurationHandler configurationHandler() {
        if (this._configurationHandler == null) {
            this._configurationHandler = (ConfigurationHandler)InvocationContext.bean(ConfigurationHandler.class);
        }
        return this._configurationHandler;
    }

    protected ConversionHandler conversionHandler() {
        if (this._conversionHandler == null) {
            this._conversionHandler = (ConversionHandler)InvocationContext.bean(ConversionHandler.class);
        }
        return this._conversionHandler;
    }

    protected CustomFieldValueHandler customFieldValueHandler() {
        if (this._customFieldValueHandler == null) {
            this._customFieldValueHandler = (CustomFieldValueHandler)InvocationContext.bean(CustomFieldValueHandler.class);
        }
        return this._customFieldValueHandler;
    }

    protected EntityManagerHandler entityManagerHandler() {
        if (this._entityManagerHandler == null) {
            this._entityManagerHandler = (EntityManagerHandler)InvocationContext.bean(EntityManagerHandler.class);
        }
        return this._entityManagerHandler;
    }

    protected GroupsHandler groupsHandler() {
        if (this._groupsHandler == null) {
            this._groupsHandler = (GroupsHandler)InvocationContext.bean(GroupsHandler.class);
        }
        return this._groupsHandler;
    }

    protected NativeQueryHandler nativeQueryHandler() {
        if (this._nativeQueryHandler == null) {
            this._nativeQueryHandler = (NativeQueryHandler)InvocationContext.bean(NativeQueryHandler.class);
        }
        return this._nativeQueryHandler;
    }

    protected ProductsHandler productsHandler() {
        if (this._productsHandler == null) {
            this._productsHandler = (ProductsHandler)InvocationContext.bean(ProductsHandler.class);
        }
        return this._productsHandler;
    }

    protected ProfileFieldHandler profileFieldHandler() {
        if (this._profileFieldHandler == null) {
            this._profileFieldHandler = (ProfileFieldHandler)InvocationContext.bean(ProfileFieldHandler.class);
        }
        return this._profileFieldHandler;
    }
}

