/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search;

import java.util.function.Supplier;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.impl.banking.AccountHistoryEntry;
import org.cyclos.impl.search.DelegatingEntitySearchHandlerImpl;
import org.cyclos.impl.search.SearchHandler;
import org.cyclos.impl.search.TransferSearchHandler;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewQuery;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewStatusVO;
import org.cyclos.model.banking.accounts.AccountHistoryEntryVO;
import org.cyclos.model.banking.accounts.AccountHistoryOverviewEntryVO;
import org.cyclos.model.banking.accounts.AccountHistoryQuery;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class TransferSearchHandlerFactoryBean
extends AbstractFactoryBean<TransferSearchHandler> {
    @Autowired
    @Lazy
    private SearchHandler searchHandler;

    public Class<?> getObjectType() {
        return TransferSearchHandler.class;
    }

    protected TransferSearchHandler createInstance() throws Exception {
        return new DelegatingTransferSearchHandlerImpl(() -> ((SearchHandler)this.searchHandler).transfer());
    }

    private static class DelegatingTransferSearchHandlerImpl
    extends DelegatingEntitySearchHandlerImpl<Transfer, AccountHistoriesOverviewQuery, AccountHistoryOverviewEntryVO, TransferSearchHandler>
    implements TransferSearchHandler {
        public DelegatingTransferSearchHandlerImpl(Supplier<TransferSearchHandler> supplier) {
            super(supplier);
        }

        public DataIterator<AccountHistoryEntry> exportAccountHistory(AccountHistoryQuery accountHistoryQuery) {
            return ((TransferSearchHandler)this.delegate()).exportAccountHistory(accountHistoryQuery);
        }

        public AccountHistoriesOverviewStatusVO getStatus(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) {
            return ((TransferSearchHandler)this.delegate()).getStatus(accountHistoriesOverviewQuery);
        }

        public Page<AccountHistoryEntryVO> searchAccountHistory(AccountHistoryQuery accountHistoryQuery) {
            return ((TransferSearchHandler)this.delegate()).searchAccountHistory(accountHistoryQuery);
        }
    }
}

