/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.messaging;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.messaging.IncomingMessage;
import org.cyclos.entities.messaging.MailContext;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.messaging.MessageServiceLocal;
import org.cyclos.impl.messaging.NotificationSettingsServiceLocal;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.PushNotificationEventContext;
import org.cyclos.impl.utils.PushNotificationHandler;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.notifications.MailContentProducer;
import org.cyclos.impl.utils.notifications.MailHandler;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.model.access.Role;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.messaging.messages.IncomingMessageVO;
import org.cyclos.model.messaging.messages.MessageOwner;
import org.cyclos.model.messaging.messages.NewMessagePushNotificationData;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.users.products.ProductVO;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.PushNotificationEventType;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageProcessingBackgroundTask
extends AbstractBackgroundTask {
    @Autowired
    private MailHandler mailHandler;
    @Autowired
    private RichTextHandler richTextHandler;
    @Autowired
    private MessageServiceLocal messageService;
    @Autowired
    private ConversionHandler conversionHandler;
    @Autowired
    private ProductServiceLocal productService;
    @Autowired
    private NotificationSettingsServiceLocal notificationSettingsService;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private PushNotificationHandler pushNotificationHandler;

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.PROCESS_INCOMING_MESSAGE;
    }

    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        long l = Long.parseLong(string);
        return (Long)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            IncomingMessage incomingMessage = this.find(IncomingMessage.class, l);
            this.runInEntityNetwork((SimpleEntity)incomingMessage, () -> {
                this.process(incomingMessage);
                return null;
            });
            return 1L;
        });
    }

    private void process(IncomingMessage incomingMessage) {
        this.sendPushNotifications(incomingMessage);
        this.processBatch(this.notificationSettingsService.usersToForwardMessageIterator(incomingMessage), (T basicUser) -> {
            Object[] objectArray;
            MessageKey messageKey;
            String string = this.richTextHandler.replaceTagsByUrls(incomingMessage.getBody(), this.configurationHandler.getAccessor(basicUser));
            boolean bl = MessageOwner.SYSTEM == incomingMessage.getFromOwner();
            User user = null;
            if (bl) {
                messageKey = ContentManagementKeys.Emails.FORWARD_INTERNAL_MESSAGE_BODY_SYSTEM;
                objectArray = new Object[]{incomingMessage.getCategory(), string};
            } else {
                user = incomingMessage.getFromUser();
                messageKey = ContentManagementKeys.Emails.FORWARD_INTERNAL_MESSAGE_BODY_USER;
                objectArray = new Object[]{user, string};
            }
            this.mailHandler.send((BasicUser)user, basicUser, MailContext.FORWARD_INTERNAL_MESSAGE, (MailContentProducer)this.mailContentBuilder().subject(ContentManagementKeys.Emails.FORWARD_INTERNAL_MESSAGE_SUBJECT, new Object[]{incomingMessage.getSubject()}).replyTo(incomingMessage).body(messageKey, objectArray), new FileInfo[0]);
        });
    }

    private NewMessagePushNotificationData pushNotification(Long l, Long l2) {
        User user = this.find(User.class, l);
        IncomingMessage incomingMessage = this.find(IncomingMessage.class, l2);
        return (NewMessagePushNotificationData)this.invokerHandler.runAs(SessionDataFactory.user((BasicUser)user), () -> {
            NewMessagePushNotificationData newMessagePushNotificationData = new NewMessagePushNotificationData();
            newMessagePushNotificationData.setMessage((IncomingMessageVO)this.conversionHandler.convert(IncomingMessageVO.class, (Object)incomingMessage));
            newMessagePushNotificationData.setNewMessages(this.messageService.countNewMessages());
            newMessagePushNotificationData.setUnreadMessages(this.messageService.countUnreadMessages());
            return newMessagePushNotificationData;
        });
    }

    private void sendPushNotifications(IncomingMessage incomingMessage) {
        Set<Role> set;
        Set set2;
        Long l = incomingMessage.getId();
        Long l2 = SimpleEntity.id((SimpleEntity)incomingMessage.getNetwork());
        User user = incomingMessage.getOwner();
        if (user != null) {
            Long l4 = user.getId();
            PushNotificationEventContext pushNotificationEventContext = PushNotificationEventContext.user((PushNotificationEventType)PushNotificationEventType.NEW_MESSAGE, (Long)l4);
            this.pushNotificationHandler.publish(pushNotificationEventContext, l2, () -> this.pushNotification(l4, l));
        } else if (incomingMessage.getCategory() != null && !(set2 = this.productService.listByRoles(set = Collections.singleton(Role.ADMIN)).stream().map(product -> (AdminProduct)product).filter(adminProduct -> adminProduct.getViewMessagesSentToSysWithCat().contains(incomingMessage.getCategory())).collect(Collectors.toSet())).isEmpty()) {
            UserQuery userQuery = new UserQuery();
            userQuery.setRoles(set);
            userQuery.setUserStatus(Collections.singleton(UserStatus.ACTIVE));
            userQuery.setProducts(set2.stream().map(adminProduct -> new ProductVO(adminProduct.getId())).collect(Collectors.toSet()));
            this.processBatch(this.userService.iterateIds(userQuery), (T l3) -> {
                PushNotificationEventContext pushNotificationEventContext = PushNotificationEventContext.user((PushNotificationEventType)PushNotificationEventType.NEW_MESSAGE, (Long)l3);
                this.pushNotificationHandler.publish(pushNotificationEventContext, l2, () -> this.pushNotification((Long)l3, l));
            });
        }
    }
}

