/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.marketplace;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.marketplace.AdCustomFieldPossibleValue;
import org.cyclos.entities.marketplace.AdCustomFieldPossibleValueCategory;
import org.cyclos.entities.marketplace.AdWebShop;
import org.cyclos.entities.marketplace.Advertisement;
import org.cyclos.entities.marketplace.QAdCustomField;
import org.cyclos.entities.marketplace.QAdCustomFieldValue;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QMemberProduct;
import org.cyclos.entities.users.QProductMyAdField;
import org.cyclos.entities.users.QProductUserAdField;
import org.cyclos.entities.users.QUserManagementProduct;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.marketplace.AdCustomFieldPossibleValueCategoryServiceLocal;
import org.cyclos.impl.marketplace.AdCustomFieldPossibleValueServiceLocal;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.system.BaseCustomFieldPossibleValueCategoryServiceLocal;
import org.cyclos.impl.system.BaseCustomFieldServiceImpl;
import org.cyclos.impl.utils.BooleanProperties;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.ConstraintViolatedOnRemoveException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.marketplace.advertisements.AdWebShopDTO;
import org.cyclos.model.marketplace.advertisements.AdvertisementDTO;
import org.cyclos.model.marketplace.fields.AdCustomFieldActions;
import org.cyclos.model.marketplace.fields.AdCustomFieldDTO;
import org.cyclos.model.marketplace.fields.AdCustomFieldData;
import org.cyclos.model.marketplace.fields.AdCustomFieldSearchVisibility;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.products.ViewManageOperation;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.PropertyHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdCustomFieldServiceImpl
extends BaseCustomFieldServiceImpl<AdCustomField, AdCustomFieldPossibleValueCategory, AdCustomFieldPossibleValue, QAdCustomField, AdCustomFieldDTO, AdCustomFieldData, Void>
implements AdCustomFieldServiceLocal {
    @Autowired
    private AdCustomFieldPossibleValueServiceLocal adCustomFieldPossibleValueService;
    @Autowired
    private AdCustomFieldPossibleValueCategoryServiceLocal adCustomFieldPossibleValueCategoryService;
    @Autowired
    private CyclosProperties cyclosProperties;

    public AdCustomFieldServiceImpl() {
        super(AdCustomField.class, QAdCustomField.adCustomField, AdCustomFieldDTO.class, AdCustomFieldData.class);
    }

    public ViewManageOperation getOperation(AdCustomField adCustomField, User user) {
        SessionData sessionData = this.getSessionData();
        if (!this.isEnabled(adCustomField, user)) {
            return ViewManageOperation.NONE;
        }
        return this.getViewManageOperation(adCustomField, user, sessionData.getConfiguration().getAdFieldsVisibleToGuests());
    }

    public List<CustomFieldVO> list() {
        return this.conversionHandler.convertList(CustomFieldVO.class, this.listAll());
    }

    public List<AdCustomField> listAll() throws FrameworkException {
        return ((DBQuery)this.from().orderBy(((QAdCustomField)this.$).order.asc())).list((Expression)this.$);
    }

    public List<AdCustomField> listEnabled(User user) {
        ArrayList<AdCustomField> arrayList = new ArrayList<AdCustomField>(this.productsHandler.getAccessor((BasicUser)user).member().getMyAdFields().keysSet((Path)QProductMyAdField.productMyAdField.enable));
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<AdCustomField> listManagedFieldEnabledToOwner(User user) {
        return this.listFieldEnabledToOwner(user, true);
    }

    public List<AdCustomField> listVisible(User user, boolean bl) {
        ArrayList<AdCustomField> arrayList = new ArrayList<AdCustomField>();
        if (bl) {
            arrayList.addAll(this.getProducts().userManagement().getUserAdFields().keysSet((Path)QProductUserAdField.productUserAdField.view));
            if (user != null) {
                List<AdCustomField> list = this.listEnabled(user);
                arrayList.removeIf(adCustomField -> !list.contains(adCustomField));
            }
        } else if (this.isGuest()) {
            arrayList.addAll(this.getConfiguration().getAdFieldsVisibleToGuests());
        } else {
            arrayList.addAll(this.getProducts().member().getMyAdFields().keysSet((Path)QProductMyAdField.productMyAdField.view));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<AdCustomFieldActions> listVisibleActionsEnabledToOwner(User user) {
        List<AdCustomField> list = this.listEnabled(user);
        ArrayList<AdCustomFieldActions> arrayList = new ArrayList<AdCustomFieldActions>();
        List list2 = this.getConfiguration().getAdFieldsVisibleToGuests();
        for (AdCustomField adCustomField : list) {
            ViewManageOperation viewManageOperation = this.getViewManageOperation(adCustomField, user, list2);
            if (viewManageOperation == ViewManageOperation.NONE) continue;
            AdCustomFieldActions adCustomFieldActions = new AdCustomFieldActions();
            adCustomFieldActions.setCustomField((CustomFieldDetailedVO)this.conversionHandler.convert(CustomFieldDetailedVO.class, (Object)adCustomField));
            adCustomFieldActions.setView(viewManageOperation.view());
            adCustomFieldActions.setManage(viewManageOperation.manage());
            arrayList.add(adCustomFieldActions);
        }
        return arrayList;
    }

    public List<AdCustomField> listVisibleFieldEnabledToOwner(User user) {
        return this.listFieldEnabledToOwner(user, false);
    }

    @Override
    public AdCustomField newEntity(Void void_) {
        return new AdCustomField();
    }

    @Override
    protected void addCustomValidations(Validator validator, AdCustomFieldDTO adCustomFieldDTO) {
        validator.property((Property)AdCustomFieldDTO.SEARCH_VISIBILITY, MarketplaceKeys.Fields.SEARCH_VISIBILITY).required();
    }

    @Override
    protected AdCustomFieldData getData(AdCustomField adCustomField) {
        AdCustomFieldData adCustomFieldData = (AdCustomFieldData)super.getData(adCustomField);
        adCustomFieldData.setUsingOpenSearch(this.cyclosProperties.isUsingOpenSearch());
        return adCustomFieldData;
    }

    @Override
    protected Integer getMaxOrder(AdCustomField adCustomField) {
        return (Integer)this.from(this.$).singleResult((Expression)((QAdCustomField)this.$).order.max());
    }

    @Override
    protected BaseCustomFieldPossibleValueCategoryServiceLocal<AdCustomField, AdCustomFieldPossibleValueCategory, AdCustomFieldPossibleValue> getPossibleValueCategoryService() {
        return this.adCustomFieldPossibleValueCategoryService;
    }

    protected AdCustomFieldPossibleValueServiceLocal getPossibleValueService() {
        return this.adCustomFieldPossibleValueService;
    }

    @Override
    protected List<Class<?>> getPropertyClasses() {
        return Arrays.asList(AdvertisementDTO.class, AdWebShopDTO.class, Advertisement.class, AdWebShop.class);
    }

    @Override
    protected boolean isBinaryTypesAllowed() {
        return true;
    }

    @Override
    protected void onAfterRemove(AdCustomField adCustomField) {
        Long l = SimpleEntity.id((SimpleEntity)adCustomField.getNetwork());
        List list = PropertyHelper.getGetterNames((Path[])new Path[]{QMemberProduct.memberProduct.myAdFields, QUserManagementProduct.userManagementProduct.userAdFields});
        this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesNetworkAndMethod(l, (Collection)list));
    }

    @Override
    protected void onBeforeRemove(AdCustomField adCustomField) {
        QAdCustomFieldValue qAdCustomFieldValue = QAdCustomFieldValue.adCustomFieldValue;
        boolean bl = ((DBQuery)this.from(new EntityPath[]{qAdCustomFieldValue}).where((Predicate)qAdCustomFieldValue.field().eq((Object)adCustomField))).hasResults();
        QProductMyAdField qProductMyAdField = QProductMyAdField.productMyAdField;
        boolean bl2 = ((DBQuery)this.from(new EntityPath[]{qProductMyAdField}).where(new Predicate[]{qProductMyAdField.customField().eq((Object)adCustomField), qProductMyAdField.enable.isTrue()})).hasResults();
        if (bl && bl2) {
            throw new ConstraintViolatedOnRemoveException();
        }
    }

    @Override
    protected Object onBeforeSave(AdCustomField adCustomField, AdCustomField adCustomField2) {
        if (!adCustomField.getType().isAllowedToBeOnSearchFilters()) {
            adCustomField.setSearchVisibility(AdCustomFieldSearchVisibility.NONE);
        }
        return super.onBeforeSave(adCustomField, adCustomField2);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QAdCustomField)this.$).network());
    }

    private ViewManageOperation getViewManageOperation(AdCustomField adCustomField, User user, List<AdCustomField> list) {
        boolean bl = false;
        boolean bl2 = false;
        if (user.equals((Object)this.getLoggedUser())) {
            BooleanProperties booleanProperties = this.getProducts().member().getMyAdFields().get((Object)adCustomField);
            bl2 = booleanProperties.isSet((Path)QProductMyAdField.productMyAdField.view);
            bl = booleanProperties.isSet((Path)QProductMyAdField.productMyAdField.manage);
        } else if (this.isGuest()) {
            bl2 = list.contains(adCustomField);
            bl = false;
        } else if (this.isManagerOf((BasicUser)user)) {
            BooleanProperties booleanProperties = this.getProducts().userManagement().getUserAdFields().get((Object)adCustomField);
            bl2 = booleanProperties.isSet((Path)QProductUserAdField.productUserAdField.view);
            bl = booleanProperties.isSet((Path)QProductUserAdField.productUserAdField.manage);
        } else {
            BooleanProperties booleanProperties = this.getProducts().member().getMyAdFields().get((Object)adCustomField);
            bl2 = booleanProperties.isSet((Path)QProductMyAdField.productMyAdField.view);
            bl = false;
        }
        return ViewManageOperation.of((boolean)bl2, (boolean)bl);
    }

    private boolean isEnabled(AdCustomField adCustomField, User user) {
        return this.productsHandler.getAccessor((BasicUser)user).member().getMyAdFields().isSet((Object)adCustomField, (Path)QProductMyAdField.productMyAdField.enable);
    }

    private List<AdCustomField> listFieldEnabledToOwner(User user, boolean bl) {
        List list = this.getConfiguration().getAdFieldsVisibleToGuests();
        List<AdCustomField> list2 = this.listEnabled(user);
        list2.removeIf(adCustomField -> {
            ViewManageOperation viewManageOperation = this.getViewManageOperation((AdCustomField)adCustomField, user, list);
            return !(!bl ? viewManageOperation.view() : viewManageOperation.manage());
        });
        return list2;
    }
}

