/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.NumberPath;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.InternalTransaction;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QInternalTransaction;
import org.cyclos.entities.banking.QTransactionCustomFieldValue;
import org.cyclos.entities.banking.QVoucher;
import org.cyclos.entities.banking.QVoucherConfiguration;
import org.cyclos.entities.banking.QVoucherCustomFieldValue;
import org.cyclos.entities.banking.QVoucherPack;
import org.cyclos.entities.banking.QVoucherPackCustomFieldValue;
import org.cyclos.entities.banking.QVoucherTransaction;
import org.cyclos.entities.banking.QVoucherType;
import org.cyclos.entities.banking.SystemAccountType;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherChargeback;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.banking.VoucherCustomField;
import org.cyclos.entities.banking.VoucherCustomFieldValue;
import org.cyclos.entities.banking.VoucherPack;
import org.cyclos.entities.banking.VoucherPackAmountReservation;
import org.cyclos.entities.banking.VoucherPackCustomFieldValue;
import org.cyclos.entities.banking.VoucherRedeem;
import org.cyclos.entities.banking.VoucherTemplate;
import org.cyclos.entities.banking.VoucherTopUp;
import org.cyclos.entities.banking.VoucherTransaction;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.messaging.BaseSms;
import org.cyclos.entities.system.CaptchaConfiguration;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.system.ExportFormat;
import org.cyclos.entities.system.OutboundSmsConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.GroupSet;
import org.cyclos.entities.users.QGroup;
import org.cyclos.entities.users.QProductAdminVoucher;
import org.cyclos.entities.users.QProductMemberVoucher;
import org.cyclos.entities.users.QProductVoucher;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.entities.utils.queryextensions.DateQueryExtensions;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.FailedAction;
import org.cyclos.impl.access.FailedActionHandler;
import org.cyclos.impl.access.InitializationServiceLocal;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.PaymentServiceLocal;
import org.cyclos.impl.banking.TransactionAuthorizationServiceLocal;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.banking.TransferServiceLocal;
import org.cyclos.impl.banking.VoucherConfigurationServiceLocal;
import org.cyclos.impl.banking.VoucherCustomFieldServiceLocal;
import org.cyclos.impl.banking.VoucherDetailsOnPayment;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.banking.VoucherTransactionsVisibility;
import org.cyclos.impl.banking.VoucherTypeServiceLocal;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.system.CaptchaServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationImageServiceLocal;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.ExportFormatServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.system.LicenseHandler;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.impl.utils.BarcodeHandler;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.notifications.AccountNotificationsHandler;
import org.cyclos.impl.utils.notifications.MailHandler;
import org.cyclos.impl.utils.notifications.NotificationHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.sms.OutboundSmsHandler;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.GeneralValidation;
import org.cyclos.impl.utils.validation.Property;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.CaptchaValidation;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.model.Availability;
import org.cyclos.model.BasicProperty;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CaptchaInputDTO;
import org.cyclos.model.access.CaptchaResponseDTO;
import org.cyclos.model.access.CredentialType;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.InvalidPasswordException;
import org.cyclos.model.access.PasswordStatusException;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.PasswordStatus;
import org.cyclos.model.access.passwordtypes.PasswordInputMethod;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.model.access.passwordtypes.PasswordTypeDetailedVO;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.InsufficientBalanceException;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.accounts.AccountHistoryEntryVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.accounttypes.AccountTypeLimitType;
import org.cyclos.model.banking.authorizations.AuthorizationAction;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.PaymentPreviewVO;
import org.cyclos.model.banking.transactions.PaymentVO;
import org.cyclos.model.banking.transactions.PerformPaymentTypeData;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.banking.transfers.TransferActionDTO;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.vouchercategories.VoucherCategoryVO;
import org.cyclos.model.banking.voucherconfigurations.VoucherGenerationAmount;
import org.cyclos.model.banking.voucherconfigurations.VoucherGenerationStatus;
import org.cyclos.model.banking.voucherconfigurations.VoucherPinOnActivation;
import org.cyclos.model.banking.voucherconfigurations.VoucherPinUsage;
import org.cyclos.model.banking.vouchers.ActivateGiftVoucherDTO;
import org.cyclos.model.banking.vouchers.AssignVoucherDTO;
import org.cyclos.model.banking.vouchers.BaseBuyVouchersDTO;
import org.cyclos.model.banking.vouchers.BasicCreateVoucherData;
import org.cyclos.model.banking.vouchers.BasicVoucherData;
import org.cyclos.model.banking.vouchers.BasicVoucherQuery;
import org.cyclos.model.banking.vouchers.BuyVoucherData;
import org.cyclos.model.banking.vouchers.BuyVoucherPreviewVO;
import org.cyclos.model.banking.vouchers.BuyVouchersConfirmationField;
import org.cyclos.model.banking.vouchers.BuyVouchersDTO;
import org.cyclos.model.banking.vouchers.BuyingMaxAmountReachedForPeriodException;
import org.cyclos.model.banking.vouchers.BuyingMaxOpenAmountException;
import org.cyclos.model.banking.vouchers.BuyingNotAllowedForUserException;
import org.cyclos.model.banking.vouchers.CancelVoucherDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherExpirationDateDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherNotificationSettingsDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherPinDTO;
import org.cyclos.model.banking.vouchers.CreateVoucherDataParams;
import org.cyclos.model.banking.vouchers.CreateVouchersDTO;
import org.cyclos.model.banking.vouchers.GeneralVoucherQuery;
import org.cyclos.model.banking.vouchers.GeneralVouchersSearchData;
import org.cyclos.model.banking.vouchers.GenerateVouchersConfirmationField;
import org.cyclos.model.banking.vouchers.GenerateVouchersDTO;
import org.cyclos.model.banking.vouchers.GenerateVouchersData;
import org.cyclos.model.banking.vouchers.InitialVoucherUserData;
import org.cyclos.model.banking.vouchers.InsufficientVoucherBalanceException;
import org.cyclos.model.banking.vouchers.ManageVoucherConfirmationField;
import org.cyclos.model.banking.vouchers.MaxTotalOpenAmountException;
import org.cyclos.model.banking.vouchers.PerformVoucherTransactionDTO;
import org.cyclos.model.banking.vouchers.PerformVoucherTransactionData;
import org.cyclos.model.banking.vouchers.RedeemVoucherDTO;
import org.cyclos.model.banking.vouchers.RedeemVoucherData;
import org.cyclos.model.banking.vouchers.RedeemVoucherPreviewVO;
import org.cyclos.model.banking.vouchers.RedeemingNotAllowedForUserException;
import org.cyclos.model.banking.vouchers.RedeemingNotAllowedForVoucherException;
import org.cyclos.model.banking.vouchers.RedeemingNotAllowedTodayException;
import org.cyclos.model.banking.vouchers.RedeemingNotAllowedYetException;
import org.cyclos.model.banking.vouchers.RedeemingUserBlockedException;
import org.cyclos.model.banking.vouchers.SendVoucherConfirmationField;
import org.cyclos.model.banking.vouchers.SendVoucherDTO;
import org.cyclos.model.banking.vouchers.SimpleChangeVoucherNotificationSettingsDTO;
import org.cyclos.model.banking.vouchers.SimpleChangeVoucherPinDTO;
import org.cyclos.model.banking.vouchers.TopUpNotAllowedForVoucherException;
import org.cyclos.model.banking.vouchers.TopUpVoucherConfirmationField;
import org.cyclos.model.banking.vouchers.TopUpVoucherDTO;
import org.cyclos.model.banking.vouchers.TopUpVoucherData;
import org.cyclos.model.banking.vouchers.TopUpVoucherPreviewVO;
import org.cyclos.model.banking.vouchers.UnblockVoucherParams;
import org.cyclos.model.banking.vouchers.UserVoucherQuery;
import org.cyclos.model.banking.vouchers.UserVouchersSearchData;
import org.cyclos.model.banking.vouchers.VoucherAction;
import org.cyclos.model.banking.vouchers.VoucherActivationExpiredException;
import org.cyclos.model.banking.vouchers.VoucherAlreadyActivatedException;
import org.cyclos.model.banking.vouchers.VoucherBarcodeParams;
import org.cyclos.model.banking.vouchers.VoucherBuyingException;
import org.cyclos.model.banking.vouchers.VoucherCancelAction;
import org.cyclos.model.banking.vouchers.VoucherCreationType;
import org.cyclos.model.banking.vouchers.VoucherCustomFieldUsage;
import org.cyclos.model.banking.vouchers.VoucherData;
import org.cyclos.model.banking.vouchers.VoucherInfoData;
import org.cyclos.model.banking.vouchers.VoucherInfoTransactionsQuery;
import org.cyclos.model.banking.vouchers.VoucherInfoVO;
import org.cyclos.model.banking.vouchers.VoucherOrderBy;
import org.cyclos.model.banking.vouchers.VoucherPackWithIdsVO;
import org.cyclos.model.banking.vouchers.VoucherRedeemingException;
import org.cyclos.model.banking.vouchers.VoucherStatus;
import org.cyclos.model.banking.vouchers.VoucherTopUpException;
import org.cyclos.model.banking.vouchers.VoucherTransactionData;
import org.cyclos.model.banking.vouchers.VoucherTransactionDataParams;
import org.cyclos.model.banking.vouchers.VoucherTransactionNature;
import org.cyclos.model.banking.vouchers.VoucherTransactionPreviewVO;
import org.cyclos.model.banking.vouchers.VoucherTransactionResultVO;
import org.cyclos.model.banking.vouchers.VoucherTransactionVO;
import org.cyclos.model.banking.vouchers.VoucherTransactionsQuery;
import org.cyclos.model.banking.vouchers.VoucherTransactionsSearchData;
import org.cyclos.model.banking.vouchers.VoucherVO;
import org.cyclos.model.banking.vouchers.VouchersSummaryVO;
import org.cyclos.model.banking.vouchertypes.VoucherExpirationType;
import org.cyclos.model.banking.vouchertypes.VoucherRedeemRestrictTo;
import org.cyclos.model.banking.vouchertypes.VoucherTypeDetailedVO;
import org.cyclos.model.banking.vouchertypes.VoucherTypeVO;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.messaging.sms.OutboundSmsType;
import org.cyclos.model.system.configurations.ConfigurationImageType;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.VoucherExtensionPointEvent;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldValueForSearchDTO;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.system.images.ImageSize;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.model.users.phones.PhoneConfigurationData;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.LocateUserException;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.AmountSummaryVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.IIntegerRange;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.IntegerRangeDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.security.banking.VoucherServiceSecurity;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.TransformedCloseableIterator;
import org.cyclos.services.banking.TransactionService;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.TranslationMessageSpecification;
import org.cyclos.utils.WeekDay;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoucherServiceImpl
extends BaseServiceImpl
implements VoucherServiceLocal {
    private static final QVoucher $ = QVoucher.voucher;
    private static final QVoucherPack p = QVoucherPack.voucherPack;
    private static final QVoucherTransaction t = QVoucherTransaction.voucherTransaction;
    private static final QProductVoucher pv = QProductVoucher.productVoucher;
    private static final QProductAdminVoucher pav = QProductAdminVoucher.productAdminVoucher;
    private static final QProductMemberVoucher pmv = QProductMemberVoucher.productMemberVoucher;
    private static final int MAX_ATTEMPTS_TO_REDEEM = 20;
    private static final int PIN_ATTEMPTS = 5;
    private static final int MAX_INVALID_TOKEN_ATTEMPTS = 20;
    private static final TimeInterval MAX_INVALID_TOKEN_BLOCK_TIME = TimeInterval.ONE_HOUR;
    private static final String IGNORE_CONFIRMATION = "ignoreConfirmationPassword";
    @Autowired
    private VoucherConfigurationServiceLocal voucherConfigurationService;
    @Autowired
    private VoucherTypeServiceLocal voucherTypeService;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private CaptchaServiceLocal captchaService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private PaymentServiceLocal paymentService;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private BarcodeHandler barcodeHandler;
    @Autowired
    private FailedActionHandler failedActionHandler;
    @Autowired
    private LockHandler lockHandler;
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;
    @Autowired
    private NotificationHandler notificationHandler;
    @Autowired
    private OperatorServiceLocal operatorService;
    @Autowired
    private TransactionAuthorizationServiceLocal transactionAuthorizationService;
    @Autowired
    private ExportFormatServiceLocal exportFormatService;
    @Autowired
    private MailHandler mailHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;
    @Autowired
    private InitializationServiceLocal initializationService;
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private ConfigurationImageServiceLocal configurationImageService;
    @Autowired
    private VoucherCustomFieldServiceLocal voucherCustomFieldServiceLocal;
    @Autowired
    private OutboundSmsHandler outboundSmsHandler;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private LicenseHandler licenseHandler;
    @Autowired
    private VoucherServiceSecurity voucherServiceSecurity;
    @Autowired
    private TransferServiceLocal transferService;
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;

    public VoucherInfoVO activateGiftVoucher(@NotNull String string, ActivateGiftVoucherDTO activateGiftVoucherDTO) throws FrameworkException {
        SimpleChangeVoucherPinDTO simpleChangeVoucherPinDTO = activateGiftVoucherDTO.getPin();
        SimpleChangeVoucherNotificationSettingsDTO simpleChangeVoucherNotificationSettingsDTO = activateGiftVoucherDTO.getNotification();
        Voucher voucher = this.voucherForInfo(string);
        if (!voucher.isBlockedGift() || !this.usePin(voucher)) {
            throw new IllegalActionException();
        }
        this.validate(voucher, simpleChangeVoucherPinDTO, false);
        if (simpleChangeVoucherNotificationSettingsDTO != null) {
            this.validate(voucher, simpleChangeVoucherNotificationSettingsDTO);
        }
        voucher.setPin(simpleChangeVoucherPinDTO.getNewPin());
        voucher.setStatus(VoucherStatus.OPEN);
        if (simpleChangeVoucherNotificationSettingsDTO != null) {
            this.storeNotificationSettings(voucher, simpleChangeVoucherNotificationSettingsDTO);
        }
        return this.doGetInfo(voucher, voucher.getPin());
    }

    public void assign(@NotNull AssignVoucherDTO assignVoucherDTO) throws FrameworkException {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)assignVoucherDTO.getVoucher());
        if (!this.canAssign(voucher)) {
            throw new IllegalActionException();
        }
        User user = (User)this.conversionHandler.convert(User.class, (Object)assignVoucherDTO.getUser());
        this.assign(voucher, user, false, true);
    }

    public SerializableInputStream barcode(VoucherBarcodeParams voucherBarcodeParams) throws FrameworkException {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)voucherBarcodeParams.getVoucher());
        ImageSize imageSize = (ImageSize)ObjectHelper.defaultValue((Object)voucherBarcodeParams.getSize(), (Object)ImageSize.SMALL);
        return this.barcodeHandler.qrcode(voucher.getToken(), imageSize);
    }

    public void block(Voucher voucher) {
        if (!voucher.isOpen()) {
            throw new IllegalActionException("The voucher must be open to be blocked");
        }
        if (!this.usePin(voucher)) {
            throw new IllegalActionException("The voucher must use PIN in order to be blocked");
        }
        voucher.setStatus(VoucherStatus.BLOCKED);
    }

    public VoucherPackWithIdsVO buy(BuyVouchersDTO buyVouchersDTO) throws FrameworkException {
        return this.doBuyOrSend((BaseBuyVouchersDTO)buyVouchersDTO);
    }

    public void cancel(CancelVoucherDTO cancelVoucherDTO) throws FrameworkException {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)cancelVoucherDTO.getVoucher());
        if (this.cancelAction(voucher) == null) {
            throw new IllegalActionException("This voucher cannot be canceled");
        }
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(cancelVoucherDTO.getConfirmationPassword(), ManageVoucherConfirmationField.confirmation((VoucherVO)cancelVoucherDTO.getVoucher(), (VoucherAction)VoucherAction.CANCEL));
        VoucherPack voucherPack = voucher.getPack();
        boolean bl = false;
        VoucherCreationType voucherCreationType = voucherPack.getCreationType();
        if (voucherCreationType == VoucherCreationType.GENERATED) {
            this.doCancel(voucher, false, false);
        } else if (voucherCreationType == VoucherCreationType.BOUGHT) {
            if (voucherPack.getBuy().isPendingAuthorization()) {
                bl = true;
            } else if (voucherPack.getConfiguration().getRefundType() != null) {
                this.doCancel(voucher, false, false);
            } else {
                throw new IllegalActionException();
            }
        }
        if (bl) {
            this.cancelBuyPaymentAuthorization(voucher.getPack());
        }
    }

    public void changeExpirationDate(ChangeVoucherExpirationDateDTO changeVoucherExpirationDateDTO) {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)changeVoucherExpirationDateDTO.getVoucher());
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(changeVoucherExpirationDateDTO.getConfirmationPassword(), ManageVoucherConfirmationField.confirmation((VoucherVO)changeVoucherExpirationDateDTO.getVoucher(), (VoucherAction)VoucherAction.CHANGE_EXPIRATION_DATE));
        Validator validator = new Validator();
        validator.property((org.cyclos.model.Property)ChangeVoucherExpirationDateDTO.NEW_EXPIRATION_DATE, BankingKeys.Vouchers.NEW_EXPIRATION_DATE).required().futureDate();
        this.validate(validator, changeVoucherExpirationDateDTO, "changeExpirationDate");
        if (!this.canChangeExpirationDate(voucher)) {
            throw new IllegalActionException();
        }
        this.accountService.reReserveAmountIfNeeded(voucher);
        VoucherPack voucherPack = voucher.getPack();
        voucher.setStatus(voucherPack.getBuy() == null ? VoucherStatus.OPEN : this.getBoughtVoucherStatus(voucherPack));
        voucher.setExpirationDate(DateHelper.shiftToEnd((Date)this.toDate(changeVoucherExpirationDateDTO.getNewExpirationDate()), (TimeZone)this.getSessionData().getConfiguration().getTimeZone()));
        voucher.setExpirationDateComments(changeVoucherExpirationDateDTO.getExpirationDateComments());
        voucher.setExpirationNotified(false);
        User user = voucherPack.getBuyer();
        if (user != null) {
            this.notificationHandler.user((BasicUser)user).account().voucherExpirationDateChanged(voucher, voucher.getCurrencyAmount(), voucher.getType(), voucher.getExpirationDate());
        }
    }

    public void changeInfoNotificationSettings(String string, String string2, SimpleChangeVoucherNotificationSettingsDTO simpleChangeVoucherNotificationSettingsDTO) throws FrameworkException {
        Voucher voucher = this.voucherForInfo(string);
        if (!this.canChangeNotificationSettings(voucher)) {
            throw new IllegalActionException();
        }
        this.checkVoucherPin(voucher, null, string2);
        this.validate(voucher, simpleChangeVoucherNotificationSettingsDTO);
        this.storeNotificationSettings(voucher, simpleChangeVoucherNotificationSettingsDTO);
    }

    public void changeInfoPin(@NotNull String string, SimpleChangeVoucherPinDTO simpleChangeVoucherPinDTO) throws FrameworkException {
        Voucher voucher = this.voucherForInfo(string);
        if (!this.usePin(voucher)) {
            throw new IllegalActionException();
        }
        this.validate(voucher, simpleChangeVoucherPinDTO, true);
        this.checkVoucherPin(voucher, null, simpleChangeVoucherPinDTO.getOldPin());
        voucher.setPin(simpleChangeVoucherPinDTO.getNewPin());
    }

    public void changeNotificationSettings(ChangeVoucherNotificationSettingsDTO changeVoucherNotificationSettingsDTO) throws FrameworkException {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)changeVoucherNotificationSettingsDTO.getVoucher());
        if (!this.supportsNotifications(voucher)) {
            throw new IllegalActionException();
        }
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(changeVoucherNotificationSettingsDTO.getConfirmationPassword(), ManageVoucherConfirmationField.confirmation((VoucherVO)changeVoucherNotificationSettingsDTO.getVoucher(), (VoucherAction)VoucherAction.CHANGE_NOTIFICATION_SETTINGS));
        this.validate(voucher, (SimpleChangeVoucherNotificationSettingsDTO)changeVoucherNotificationSettingsDTO);
        this.storeNotificationSettings(voucher, (SimpleChangeVoucherNotificationSettingsDTO)changeVoucherNotificationSettingsDTO);
    }

    public void changePin(ChangeVoucherPinDTO changeVoucherPinDTO) throws FrameworkException {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)changeVoucherPinDTO.getVoucher());
        if (!this.usePin(voucher)) {
            throw new IllegalActionException();
        }
        boolean bl = this.requiresOldPinForChange(voucher);
        this.validate(voucher, (SimpleChangeVoucherPinDTO)changeVoucherPinDTO, bl);
        if (bl) {
            this.checkVoucherPin(voucher, null, changeVoucherPinDTO.getOldPin());
        } else {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(changeVoucherPinDTO.getConfirmationPassword(), ManageVoucherConfirmationField.confirmation((VoucherVO)changeVoucherPinDTO.getVoucher(), (VoucherAction)VoucherAction.CHANGE_PIN));
        }
        voucher.setPin(changeVoucherPinDTO.getNewPin());
    }

    public VoucherChargeback chargeback(Payment payment) {
        VoucherTransaction voucherTransaction = payment.getVoucherTransaction();
        if (voucherTransaction != null) {
            if (voucherTransaction instanceof VoucherChargeback) {
                throw new IllegalStateException("Voucher transaction is itself a chargeback");
            }
            if (voucherTransaction.getChargedBackBy() != null) {
                throw new IllegalStateException("Voucher transaction already charged back");
            }
            Voucher voucher2 = voucherTransaction.getVoucher();
            this.lockForTransaction(voucher2);
            VoucherChargeback voucherChargeback = new VoucherChargeback();
            voucherChargeback.setDate(new Date());
            voucherChargeback.setVoucher(voucher2);
            voucherChargeback.setBy(this.getLoggedBasicUser());
            voucherChargeback.setAmount(voucherTransaction.getAmount().negate());
            voucherChargeback.setUser(voucherTransaction.getUser());
            voucherChargeback.setChargebackOf(voucherTransaction);
            this.persist((IEntity)voucherChargeback);
            BigDecimal bigDecimal = voucher2.getBalance().add(voucherChargeback.getAmount());
            if (BigDecimalHelper.isNegative((BigDecimal)bigDecimal)) {
                InsufficientBalanceException insufficientBalanceException = new InsufficientBalanceException();
                insufficientBalanceException.setVoucher(true);
                throw insufficientBalanceException;
            }
            voucher2.setBalance(bigDecimal);
            if (voucherTransaction instanceof VoucherTopUp) {
                VoucherConfiguration voucherConfiguration = voucher2.getConfiguration();
                if (voucherConfiguration.getGenerationStatus() == VoucherGenerationStatus.INACTIVE && voucherConfiguration.getGenerationAmount() != VoucherGenerationAmount.DYNAMIC) {
                    this.doCancel(voucher2, true, true);
                }
            } else if (voucher2.getStatus() == VoucherStatus.REDEEMED) {
                voucher2.setStatus(VoucherStatus.OPEN);
            }
            voucherTransaction.setChargedBackBy(voucherChargeback);
            this.accountService.processReservationIfNeeded((VoucherTransaction)voucherChargeback);
            return voucherChargeback;
        }
        if (payment.getBoughtVoucherPack() != null) {
            payment.getBoughtVoucherPack().getVouchers().forEach(voucher -> {
                if (this.hasTransactions((Voucher)voucher)) {
                    throw new ValidationException(this.message(BankingKeys.Transactions.ACTION_CHARGEBACK_ERROR_USER_BOUGHT_VOUCHER, new Object[0]));
                }
                this.doCancel((Voucher)voucher, true, true);
            });
        }
        return null;
    }

    public int countTotalOpenVouchers() {
        return ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{$}).where((Predicate)VoucherServiceImpl.$.status.eq((Object)VoucherStatus.OPEN))).count(VoucherServiceImpl.$.id);
    }

    public void expire(Voucher voucher) throws FrameworkException {
        this.doExpire(voucher, false);
        VoucherPack voucherPack = voucher.getPack();
        if (voucher.hasCustomExpirationDate()) {
            if (voucher.isExpirationNotified()) {
                return;
            }
            voucher.setExpirationNotified(true);
        } else {
            if (voucherPack.isExpirationNotified()) {
                return;
            }
            voucherPack.setExpirationNotified(true);
        }
        if (this.supportsNotifications(voucher)) {
            Object object = this.ofAmount(voucher);
            this.notify(voucher, () -> this.message(ContentManagementKeys.Emails.VOUCHER_EXPIRED_SUBJECT, object), () -> this.message(ContentManagementKeys.Emails.VOUCHER_EXPIRED_MESSAGE, object), () -> this.message(MessagingKeys.Notifications.SMS_VOUCHER_EXPIRED, object));
        } else {
            this.notifyOwnerOrBuyer(voucher, accountNotificationsHandler -> accountNotificationsHandler.voucherExpired(voucher, voucher.getCurrencyAmount(), voucher.getType()));
        }
        if (voucherPack.isGenerated() && voucherPack.getAmount() != null) {
            int n = voucher.hasCustomExpirationDate() ? 1 : ((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.pack().eq((Object)voucherPack), VoucherServiceImpl.$.expirationDate.isNull()})).count(VoucherServiceImpl.$.id);
            this.notificationHandler.admin().generatedVouchersExpired(voucher, n);
        }
    }

    public void expireActivation(Voucher voucher) throws FrameworkException {
        this.doExpire(voucher, true);
    }

    public FileInfo exportTransaction(@NotNull ExportFormatVO exportFormatVO, @NotNull VoucherTransactionVO voucherTransactionVO) throws FrameworkException {
        VoucherTransaction voucherTransaction = (VoucherTransaction)this.conversionHandler.convert(VoucherTransaction.class, (Object)voucherTransactionVO);
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        return this.exportFormatService.exportSingle(exportFormat, ExportFormatContext.VOUCHER_TRANSACTION_DETAILS, (Object)voucherTransaction);
    }

    public FileInfo exportVoucher(@NotNull ExportFormatVO exportFormatVO, @NotNull VoucherVO voucherVO, boolean bl) throws FrameworkException {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)voucherVO);
        if (!this.canPrint(voucher)) {
            throw new IllegalActionException("Cannot export this voucher");
        }
        if (bl) {
            voucher.setPrinted(true);
        }
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        return this.exportFormatService.exportSingle(exportFormat, ExportFormatContext.VOUCHER_DETAILS, (Object)voucher);
    }

    public FileInfo exportVouchers(@NotNull ExportFormatVO exportFormatVO, @NotNull BasicVoucherQuery basicVoucherQuery, boolean bl) {
        Object object;
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        boolean bl2 = basicVoucherQuery instanceof GeneralVoucherQuery;
        HashMap hashMap = new HashMap();
        CloseableIterator<Voucher> closeableIterator = CloseableIteratorHelper.empty();
        if (this.exportFormatService.getPDF().equals((Object)exportFormat)) {
            object = ((DBQuery)this.createQuery(basicVoucherQuery, false).select((Expression)$.pack().type().template()).distinct()).fetch();
            HashMap<VoucherTemplate, CloseableIterator<Voucher>> hashMap2 = new HashMap<VoucherTemplate, CloseableIterator<Voucher>>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                VoucherTemplate voucherTemplate = (VoucherTemplate)iterator.next();
                CloseableIterator<Voucher> closeableIterator2 = ((DBQuery)this.createQuery(basicVoucherQuery).where((Predicate)$.pack().type().template().eq((Object)voucherTemplate))).export((Expression)$);
                closeableIterator2 = CloseableIteratorHelper.filtered((CloseableIterator)closeableIterator2, this::canPrint);
                if (bl) {
                    closeableIterator2 = this.markEachAsPrinted(closeableIterator2);
                }
                hashMap2.put(voucherTemplate, closeableIterator2);
            }
            hashMap.put("vouchersByTemplate", hashMap2);
        } else {
            closeableIterator = this.createQuery(basicVoucherQuery).export((Expression)$);
            if (bl) {
                closeableIterator = this.markEachAsPrinted(closeableIterator);
            }
        }
        object = bl2 ? ExportFormatContext.VOUCHERS_SEARCH : ExportFormatContext.USER_VOUCHERS_SEARCH;
        return this.exportFormatService.exportMultiple(exportFormat, (ExportFormatContext)object, (QueryParameters)basicVoucherQuery, CloseableIteratorHelper.asDataIterator(closeableIterator), hashMap);
    }

    public void fill(AccountHistoryEntryVO accountHistoryEntryVO, Long l, List<String> list, String string, VoucherTransactionNature voucherTransactionNature, Long l2) {
        Consumer<VoucherType> consumer = voucherType -> {
            String string = this.getAccountName((VoucherType)voucherType);
            if (string != null) {
                accountHistoryEntryVO.setRelatedName(string);
            }
        };
        if (l != null) {
            VoucherType voucherType2 = (VoucherType)this.rawEntityManagerHandler.find(VoucherType.class, l);
            accountHistoryEntryVO.setImage((ImageVO)this.conversionHandler.convert(ImageVO.class, (Object)voucherType2.getImage()));
            consumer.accept(voucherType2);
            accountHistoryEntryVO.setDescription(this.getBoughtDescription(voucherType2, string, list));
        } else if (voucherTransactionNature == VoucherTransactionNature.REDEEM) {
            VoucherType voucherType3 = (VoucherType)this.rawEntityManagerHandler.find(VoucherType.class, l2);
            accountHistoryEntryVO.setImage((ImageVO)this.conversionHandler.convert(ImageVO.class, (Object)voucherType3.getImage()));
            consumer.accept(voucherType3);
            accountHistoryEntryVO.setDescription(this.getRedeemDescription(voucherType3));
        } else if (voucherTransactionNature == VoucherTransactionNature.TOP_UP) {
            VoucherType voucherType4 = (VoucherType)this.rawEntityManagerHandler.find(VoucherType.class, l2);
            accountHistoryEntryVO.setImage((ImageVO)this.conversionHandler.convert(ImageVO.class, (Object)voucherType4.getImage()));
            consumer.accept(voucherType4);
            accountHistoryEntryVO.setDescription(this.getTopUpDescription(voucherType4));
        }
    }

    public Voucher findByToken(String string, Collection<VoucherConfiguration> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            throw new EntityNotFoundException(Voucher.class, string);
        }
        String string2 = "token:" + string;
        InvocationContext invocationContext = InvocationContext.ensure();
        Voucher voucher = (Voucher)invocationContext.getAttribute((Object)string2, () -> {
            Voucher voucher = null;
            for (VoucherConfiguration voucherConfiguration : collection) {
                String string2;
                try {
                    string2 = MaskHelper.removeAndValidateMask((String)voucherConfiguration.getMask(), (String)string);
                }
                catch (Exception exception) {
                    continue;
                }
                voucher = (Voucher)((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{VoucherServiceImpl.$.token.eq((Object)string2), $.pack().type().configuration().eq((Object)voucherConfiguration)})).singleResult((Expression)$);
                if (voucher == null) continue;
                break;
            }
            return voucher;
        });
        if (voucher == null) {
            throw new EntityNotFoundException(Voucher.class, string);
        }
        this.entityManagerHandler.checkAccess((IEntity)voucher);
        return voucher;
    }

    public String formatMobilePhone(Voucher voucher) {
        if (StringHelper.isBlank((Object)voucher.getMobilePhone())) {
            return null;
        }
        User user = (User)ObjectHelper.coalesce((Object[])new User[]{voucher.getOwnerOrBuyer(), voucher.getActivation() == null ? null : voucher.getActivation().getUser()});
        ConfigurationAccessor configurationAccessor = user == null ? this.getConfiguration() : this.configurationHandler.getAccessAccessor((BasicUser)user);
        PhoneNumberDescriptor phoneNumberDescriptor = this.phoneNumberHandler.parse(voucher.getMobilePhone(), configurationAccessor);
        return phoneNumberDescriptor == null ? voucher.getMobilePhone() : this.phoneNumberHandler.format(phoneNumberDescriptor, configurationAccessor);
    }

    public String formatToken(Voucher voucher) {
        if (voucher == null || !voucher.getConfiguration().isShowPlainToken()) {
            return null;
        }
        String string = voucher.getToken();
        string = MaskHelper.applyMask((String)voucher.getConfiguration().getMask(), (String)string);
        if (this.voucherServiceSecurity.shouldMaskToken(voucher)) {
            string = StringHelper.maskDigits((String)string, (int)4);
        }
        return string;
    }

    public List<VouchersSummaryVO> generalSearchSummary(GeneralVoucherQuery generalVoucherQuery) throws FrameworkException {
        DBQuery<?> dBQuery = this.createGeneralQuery(generalVoucherQuery, true);
        NumberPath numberPath = VoucherServiceImpl.p.type().configuration().currency().id;
        NumberExpression numberExpression = VoucherServiceImpl.$.id.count();
        NumberExpression numberExpression2 = Expressions.asNumber((Expression)VoucherServiceImpl.$.amount.coalesce(new Expression[]{VoucherServiceImpl.p.amount})).sum();
        NumberExpression numberExpression3 = VoucherServiceImpl.$.balance.sum();
        dBQuery.getMetadata().clearOrderBy();
        List list = ((DBQuery)((DBQuery)((DBQuery)dBQuery.offset(0L)).limit(Long.MAX_VALUE)).groupBy(new Expression[]{numberPath, VoucherServiceImpl.$.status})).list(new Expression[]{numberPath, VoucherServiceImpl.$.status, numberExpression, numberExpression2, numberExpression3});
        HashMap hashMap = new HashMap();
        ArrayList<VouchersSummaryVO> arrayList = new ArrayList<VouchersSummaryVO>();
        for (Tuple tuple : list) {
            EnumMap<VoucherStatus, AmountSummaryVO> enumMap;
            Currency currency = (Currency)this.entityManagerHandler.find(Currency.class, (Long)tuple.get((Expression)numberPath));
            CurrencyVO currencyVO = (CurrencyVO)hashMap.computeIfAbsent(currency, this.conversionHandler.convertingFunction(CurrencyVO.class, new Object[0]));
            VouchersSummaryVO vouchersSummaryVO2 = arrayList.stream().filter(vouchersSummaryVO -> vouchersSummaryVO.getCurrency().equals((Object)currencyVO)).findFirst().orElse(null);
            if (vouchersSummaryVO2 == null) {
                vouchersSummaryVO2 = new VouchersSummaryVO();
                vouchersSummaryVO2.setCurrency(currencyVO);
                arrayList.add(vouchersSummaryVO2);
            }
            if ((enumMap = vouchersSummaryVO2.getSummary()) == null) {
                enumMap = new EnumMap<VoucherStatus, AmountSummaryVO>(VoucherStatus.class);
                vouchersSummaryVO2.setSummary(enumMap);
            }
            VoucherStatus voucherStatus = (VoucherStatus)tuple.get((Expression)VoucherServiceImpl.$.status);
            int n = ((Long)tuple.get((Expression)numberExpression)).intValue();
            BigDecimal bigDecimal = BigDecimalHelper.zeroWhenNull((BigDecimal)((BigDecimal)tuple.get((Expression)(voucherStatus == VoucherStatus.OPEN ? numberExpression3 : numberExpression2))));
            BigDecimal bigDecimal2 = BigDecimalHelper.round((BigDecimal)(n == 0 ? BigDecimal.ZERO : bigDecimal.divide(new BigDecimal(n), BigDecimalHelper.MATH_CONTEXT)), (int)currency.getPrecision());
            AmountSummaryVO amountSummaryVO = ModelHelper.amountSummary((BigDecimal)bigDecimal, (BigDecimal)bigDecimal2, (int)n, (CurrencyVO)currencyVO);
            enumMap.put(voucherStatus, amountSummaryVO);
        }
        EnumSet<VoucherStatus> enumSet = EnumSet.allOf(VoucherStatus.class);
        if (CollectionHelper.isNotEmpty((Iterable)generalVoucherQuery.getStatuses())) {
            enumSet.retainAll(generalVoucherQuery.getStatuses());
        }
        arrayList.forEach(vouchersSummaryVO -> enumSet.forEach(voucherStatus2 -> vouchersSummaryVO.getSummary().computeIfAbsent(voucherStatus2, voucherStatus -> ModelHelper.emptyAmountSummary((CurrencyVO)vouchersSummaryVO.getCurrency()))));
        return arrayList;
    }

    public VoucherPackWithIdsVO generate(GenerateVouchersDTO generateVouchersDTO) throws FrameworkException {
        Currency currency;
        this.validate((CreateVouchersDTO)generateVouchersDTO, true);
        User user = (User)this.conversionHandler.convert(User.class, (Object)generateVouchersDTO.getOwner());
        VoucherType voucherType = (VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)generateVouchersDTO.getType());
        int n = generateVouchersDTO.getCount();
        VoucherGenerationStatus voucherGenerationStatus = voucherType.getConfiguration().getGenerationStatus();
        if (voucherGenerationStatus == VoucherGenerationStatus.ACTIVE) {
            currency = voucherType.getConfiguration().getCurrency();
            BigDecimal bigDecimal = BigDecimalHelper.round((BigDecimal)generateVouchersDTO.getAmount().multiply(new BigDecimal(n)), (int)currency.getPrecision());
            this.checkMaxTotalOpenAmount(voucherType, bigDecimal);
            this.licenseHandler.checkNewVouchers(n);
        }
        if (voucherGenerationStatus == VoucherGenerationStatus.INACTIVE) {
            user = null;
        }
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(generateVouchersDTO.getConfirmationPassword(), GenerateVouchersConfirmationField.confirmation((BigDecimal)generateVouchersDTO.getAmount(), (Integer)n, (VoucherTypeVO)new VoucherTypeVO(voucherType.getId())));
        currency = this.createPack((CreateVouchersDTO)generateVouchersDTO, null, null);
        return this.createVouchers((VoucherPack)currency, (CreateVouchersDTO)generateVouchersDTO, user);
    }

    public BuyVoucherData getBuyData(CreateVoucherDataParams createVoucherDataParams) throws FrameworkException {
        return this.doGetBuyOrSendData(createVoucherDataParams, VoucherCreationType.BOUGHT);
    }

    public VoucherData getData(Long l) throws FrameworkException {
        boolean bl;
        Object object;
        Object object2;
        VoucherTransactionsVisibility voucherTransactionsVisibility;
        Voucher voucher = this.find(Voucher.class, l);
        VoucherConfiguration voucherConfiguration = voucher.getConfiguration();
        VoucherData voucherData = new VoucherData();
        VoucherPack voucherPack = voucher.getPack();
        VoucherType voucherType = voucher.getType();
        this.fill((BasicVoucherData)voucherData, voucherPack);
        voucherData.setVoucher((VoucherVO)this.conversionHandler.convert(VoucherVO.class, (Object)voucher));
        SessionData sessionData = this.getSessionData();
        if (!(sessionData.isAdmin() || sessionData.isBrokerOf((BasicUser)voucherPack.getBuyer()) || sessionData.isBrokerOf((BasicUser)voucher.getOwner()))) {
            voucherData.getVoucher().getPack().setCreationType(null);
        }
        voucherData.setPinStatusForRedeem(voucher.getPinStatusForRedeem());
        if (this.showPinOnDetails(voucher)) {
            voucherData.setPin(voucher.getPin());
        }
        voucherData.setMobilePhone(this.formatMobilePhone(voucher));
        voucherData.setEnableNotifications(voucher.isEnableNotifications());
        Date date = voucherPack.getRedeemAfterDate();
        voucherData.setRedeemAfterDateReached(date == null || date.before(new Date()));
        voucherData.setShowQrCode(this.showQrCode(voucher));
        voucherData.setCancelAction(this.cancelAction(voucher));
        voucherData.setCanChangeExpirationDate(this.canChangeExpirationDate(voucher));
        voucherData.setCanAssign(this.canAssign(voucher));
        if (voucher.isOpen() || voucher.isBlocked()) {
            boolean bl2 = voucher.getPack().isSent();
            boolean bl3 = this.supportsNotifications(voucher);
            voucherData.setCanResendEmail(bl2);
            voucherData.setCanResendPin(!bl2 && bl3 && voucher.hasNotificationMedium());
            voucherData.setCanChangeNotificationSettings(bl3);
            voucherData.setPhoneConfiguration(this.getPhoneConfigurationIfSupported(voucher));
            voucherData.setCanUnblockPin(voucher.isPinBlocked());
            voucherData.setCanChangePin(this.usePin(voucher));
            voucherData.setRequireOldPinForChange(this.requiresOldPinForChange(voucher));
            if (voucherData.isCanChangePin()) {
                voucherData.setPinInput(this.pinInput(voucher));
            }
        }
        if (voucherData.getCancelAction() != null || voucherData.isCanChangeExpirationDate() || voucherData.isCanChangeNotificationSettings() || voucherData.isCanChangePin()) {
            voucherData.setConfirmationPasswordInput(this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput());
        }
        voucherData.setSendMessage(voucherPack.getSendMessage());
        voucherData.setBuy((PaymentVO)this.conversionHandler.convert(PaymentVO.class, (Object)voucherPack.getBuy()));
        Payment payment = voucher.getRefund();
        if (payment != null) {
            voucherData.setRefund((PaymentVO)this.conversionHandler.convert(PaymentVO.class, (Object)payment));
            voucherData.setRefundDate(this.conversionHandler.toDateTime(payment.getDate()));
        }
        if ((voucherTransactionsVisibility = this.voucherServiceSecurity.getTransactionVisibility(voucher)) != VoucherTransactionsVisibility.NONE) {
            if (!voucherType.isAllowPartialRedeems() && voucher.getStatus() == VoucherStatus.REDEEMED) {
                VoucherRedeem voucherRedeem = voucher.getSingleRedeem();
                object2 = this.getTransactionExcludes(voucherTransactionsVisibility);
                object = (VoucherTransactionVO)this.conversionHandler.convertExcluding(VoucherTransactionVO.class, (Object)voucherRedeem, object2);
                voucherData.setSingleRedeem((VoucherTransactionVO)object);
            } else {
                voucherData.setHasTransactions(this.hasTransactions(voucher));
            }
        }
        voucherData.setShowConfiguration((bl = sessionData.isAdmin()) && this.voucherConfigurationService.listVisible(null, false, false).size() > 1);
        voucherData.setShowType(bl);
        if (this.canPrint(voucher)) {
            object2 = this.exportFormatService.listByContext(ExportFormatContext.VOUCHER_DETAILS);
            voucherData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)object2));
        }
        object2 = this.voucherCustomFieldServiceLocal.listRelated(voucherType, voucher.getOwner());
        object = new ArrayList();
        ((ArrayList)object).addAll(this.conversionHandler.convertList(CustomFieldValueVO.class, (Iterable)voucherPack.getCustomValues().stream().filter(arg_0 -> VoucherServiceImpl.lambda$getData$11((List)object2, arg_0)).collect(Collectors.toList())));
        ((ArrayList)object).addAll(this.conversionHandler.convertList(CustomFieldValueVO.class, (Iterable)voucher.getCustomValues().stream().filter(arg_0 -> VoucherServiceImpl.lambda$getData$12((List)object2, arg_0)).collect(Collectors.toList())));
        voucherData.setCustomValues((List)object);
        voucherData.setTopUpEnabled(voucherConfiguration.getTopUpType() != null);
        return voucherData;
    }

    public VoucherDetailsOnPayment getDetailsOnPayment(Payment payment) {
        Object object;
        VoucherDetailsOnPayment voucherDetailsOnPayment = null;
        VoucherPack voucherPack = payment.getBoughtVoucherPack();
        if (voucherPack != null) {
            voucherDetailsOnPayment = new VoucherDetailsOnPayment();
            if (payment.isToSystem()) {
                voucherDetailsOnPayment.setToName(this.getAccountName(voucherPack.getType()));
            }
            object = CollectionHelper.sort((Collection)voucherPack.getVouchers(), Comparator.comparing(Voucher::getToken));
            voucherDetailsOnPayment.setBoughtVouchers(this.conversionHandler.convertList(VoucherVO.class, (Iterable)object));
            voucherDetailsOnPayment.setDescription(this.getBoughtDescription(voucherPack.getType(), voucherPack.getSentToEmail(), voucherPack.getVoucherTokens()));
        }
        if ((object = payment.getVoucherTransaction()) != null) {
            voucherDetailsOnPayment = new VoucherDetailsOnPayment();
            Voucher voucher = object.getVoucher();
            if (payment.isFromSystem()) {
                voucherDetailsOnPayment.setFromName(this.getAccountName(voucher.getType()));
            } else if (payment.isToSystem()) {
                voucherDetailsOnPayment.setToName(this.getAccountName(voucher.getType()));
            }
            VoucherTransactionResultVO voucherTransactionResultVO = (VoucherTransactionResultVO)this.conversionHandler.convert(VoucherTransactionResultVO.class, object);
            voucherDetailsOnPayment.setVoucherTransaction(voucherTransactionResultVO);
            if (object instanceof VoucherRedeem) {
                voucherDetailsOnPayment.setDescription(this.getRedeemDescription(voucher.getType()));
            } else if (object instanceof VoucherTopUp) {
                voucherDetailsOnPayment.setDescription(this.getTopUpDescription(voucher.getType()));
            }
        }
        return voucherDetailsOnPayment;
    }

    public GeneralVouchersSearchData getGeneralSearchData() throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        GeneralVouchersSearchData generalVouchersSearchData = new GeneralVouchersSearchData();
        List<VoucherConfiguration> list = this.resolveConfigurations(null, false, false);
        List list2 = this.voucherTypeService.listForSearchFilterByConfiguration(list);
        generalVouchersSearchData.setTypes(this.conversionHandler.convertList(VoucherTypeVO.class, (Iterable)list2));
        generalVouchersSearchData.setVoucherTopUpEnabled(this.isTopupEnabled(null));
        generalVouchersSearchData.setMask(this.resolveMask(list));
        generalVouchersSearchData.setUserGroups(this.groupsHandler.visibles().accessibles().basicUsers().sorted());
        generalVouchersSearchData.setImmediatelyFetchOverview(!sessionData.getConfiguration().isSkipTotalCount());
        generalVouchersSearchData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(ExportFormatContext.VOUCHERS_SEARCH)));
        generalVouchersSearchData.setFieldsForSearch(this.voucherCustomFieldServiceLocal.listVisible(null).stream().filter(VoucherCustomField::isShowInSearch).map(this.conversionHandler.convertingFunction(CustomFieldDetailedVO.class, new Object[0])).collect(Collectors.toList()));
        GeneralVoucherQuery generalVoucherQuery = (GeneralVoucherQuery)QueryHelper.newQuery(GeneralVoucherQuery.class);
        generalVoucherQuery.setOrderBy(VoucherOrderBy.CREATION_DATE_DESC);
        generalVoucherQuery.setCustomValues(this.customFieldValueHandler.resolveDefaultSearchValues((Collection)generalVouchersSearchData.getFieldsForSearch()));
        generalVouchersSearchData.setQuery((QueryParameters)generalVoucherQuery);
        return generalVouchersSearchData;
    }

    public GenerateVouchersData getGenerateData(CreateVoucherDataParams createVoucherDataParams) throws FrameworkException {
        User user = (User)this.conversionHandler.convert(User.class, (Object)createVoucherDataParams.getUser());
        GenerateVouchersData generateVouchersData = new GenerateVouchersData();
        generateVouchersData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        if (createVoucherDataParams.getType() != null) {
            VoucherType voucherType = (VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)createVoucherDataParams.getType());
            if (!voucherType.isEnabled()) {
                throw new IllegalActionException("The voucher type is disabled");
            }
            SystemAccountType systemAccountType = (SystemAccountType)voucherType.getConfiguration().getRedeemType().getFrom();
            GenerateVouchersDTO generateVouchersDTO = new GenerateVouchersDTO();
            generateVouchersDTO.setType((VoucherTypeVO)this.conversionHandler.convert(VoucherTypeVO.class, (Object)voucherType));
            this.fill((BasicVoucherData)generateVouchersData, voucherType);
            generateVouchersData.setDto(generateVouchersDTO);
            generateVouchersData.setAccount(this.accountService.toAccountWithStatus((Account)systemAccountType.getAccount(), null, null, false));
            generateVouchersData.setGenerationAmount(voucherType.getConfiguration().getGenerationAmount());
            generateVouchersData.setGenerationStatus(voucherType.getConfiguration().getGenerationStatus());
            generateVouchersData.setConfirmationPasswordInput(this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput());
            generateVouchersData.setCustomFields(this.resolveCustomFieldVOs(null, voucherType, VoucherCreationType.GENERATED, VoucherCustomFieldUsage.CREATION, user));
        } else {
            Set set = this.getProducts().admin().getVouchers().keysSet((Path)VoucherServiceImpl.pav.generate);
            List list = this.voucherTypeService.listEnabledByConfiguration((Collection)set, null);
            this.fillData((BasicCreateVoucherData)generateVouchersData, list);
        }
        return generateVouchersData;
    }

    public VoucherInfoVO getInfo(@NotNull String string, String string2) throws FrameworkException {
        Voucher voucher = this.voucherForInfo(string);
        return this.doGetInfo(voucher, string2);
    }

    public VoucherInfoData getInfoData() throws FrameworkException {
        return (VoucherInfoData)this.invokerHandler.runAs(SessionDataFactory.system(), () -> {
            VoucherInfoData voucherInfoData = new VoucherInfoData();
            ConfigurationAccessor configurationAccessor = this.getSessionData().getConfiguration();
            voucherInfoData.setInitializationData(this.initializationService.getBasicInitializationData());
            voucherInfoData.setResourceCacheKey(this.initializationService.getResourceCacheKey());
            BuiltinLanguage builtinLanguage = configurationAccessor.getLanguage().getTemplate();
            voucherInfoData.setLocale(LocaleHelper.mapLocale((BuiltinLanguage)builtinLanguage).toString());
            ConfigurationVO configurationVO = new ConfigurationVO(configurationAccessor.getConfiguration().getId());
            voucherInfoData.setApplicationLogo(this.configurationImageService.getImageVO(configurationVO, ConfigurationImageType.PAY_LOGO));
            voucherInfoData.setShortcutIcon(this.configurationImageService.getImageVO(configurationVO, ConfigurationImageType.SHORTCUT_ICON));
            Set set = this.voucherConfigurationService.listAll().stream().map(VoucherConfiguration::getMask).filter(Objects::nonNull).collect(Collectors.toSet());
            if (set.size() == 1) {
                voucherInfoData.setMask((String)CollectionHelper.first(set));
            }
            return voucherInfoData;
        });
    }

    public RedeemVoucherData getRedeemData(VoucherTransactionDataParams voucherTransactionDataParams) throws FrameworkException {
        User user = (User)this.conversionHandler.convert(User.class, (Object)voucherTransactionDataParams.getUser());
        Voucher voucher = this.findForRedeeming(voucherTransactionDataParams, user);
        RedeemVoucherData redeemVoucherData = new RedeemVoucherData();
        this.fill(VoucherTransactionNature.REDEEM, (PerformVoucherTransactionData)redeemVoucherData, voucher, user);
        if (voucher.getType().isAllowPartialRedeems()) {
            redeemVoucherData.setShouldPreview(true);
        }
        redeemVoucherData.setBuyer((UserVO)this.conversionHandler.convert(UserVO.class, (Object)voucher.getPack().getBuyer()));
        if (!voucher.getType().isHideBalanceInRedeem()) {
            redeemVoucherData.setBalance(BigDecimalHelper.round((BigDecimal)voucher.getBalance(), (int)voucher.getCurrency().getPrecision()));
        }
        if (!redeemVoucherData.isShouldPreview() && this.requiresPinForRedeem(voucher)) {
            redeemVoucherData.setPinInput(this.pinInput(voucher));
            User user2 = this.getVoucherUserToNotify(voucher);
            redeemVoucherData.setCanSendPin(StringHelper.isNotBlank((Object)voucher.getEmail()) || StringHelper.isNotBlank((Object)voucher.getMobilePhone()) || user2 != null && (user2.hasMobileEnabledForSMS() || StringHelper.isNotBlank((Object)user2.getEmail())));
        }
        return redeemVoucherData;
    }

    public InitialVoucherUserData getRedeemInitialData(UserLocatorVO userLocatorVO) throws FrameworkException {
        return this.getInitialUserData(userLocatorVO, VoucherServiceImpl.pv.redeem);
    }

    public BuyVoucherData getSendData(@NotNull CreateVoucherDataParams createVoucherDataParams) throws FrameworkException {
        return this.doGetBuyOrSendData(createVoucherDataParams, VoucherCreationType.SENT);
    }

    public TopUpVoucherData getTopUpData(@NotNull VoucherTransactionDataParams voucherTransactionDataParams) throws FrameworkException, VoucherTopUpException {
        User user = (User)this.conversionHandler.convert(User.class, (Object)voucherTransactionDataParams.getUser());
        Voucher voucher = this.findForTopUp(voucherTransactionDataParams, user);
        VoucherConfiguration voucherConfiguration = voucher.getConfiguration();
        TopUpVoucherData topUpVoucherData = new TopUpVoucherData();
        this.fill(VoucherTransactionNature.TOP_UP, (PerformVoucherTransactionData)topUpVoucherData, voucher, user);
        topUpVoucherData.setGenerationAmount(voucherConfiguration.getGenerationAmount());
        if (voucher.isInactive()) {
            topUpVoucherData.setPinOnActivation(voucherConfiguration.getPinOnActivation());
            boolean bl = topUpVoucherData.isShouldPreview() || topUpVoucherData.getPinOnActivation() != VoucherPinOnActivation.NONE;
            topUpVoucherData.setIsActivation(true);
            topUpVoucherData.setEmailInput(Availability.OPTIONAL);
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
            topUpVoucherData.setPhoneConfiguration(this.getPhoneConfigurationIfSupported(configurationAccessor));
            switch (topUpVoucherData.getPinOnActivation()) {
                case SEND: {
                    if (topUpVoucherData.getPhoneConfiguration() != null) break;
                    topUpVoucherData.setEmailInput(Availability.REQUIRED);
                    break;
                }
                case INPUT: {
                    topUpVoucherData.setPinInput(this.pinInput(voucher));
                    break;
                }
            }
            topUpVoucherData.setVoucherCustomFields(this.resolveCustomFieldVOs(voucher, voucher.getType(), null, VoucherCustomFieldUsage.ACTIVATION, user));
            if (!topUpVoucherData.getVoucherCustomFields().isEmpty()) {
                bl = true;
            }
            topUpVoucherData.setShouldPreview(bl);
        } else {
            topUpVoucherData.setEmailInput(Availability.DISABLED);
        }
        if (!topUpVoucherData.isShouldPreview()) {
            topUpVoucherData.setConfirmationPasswordInput(this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput());
        }
        return topUpVoucherData;
    }

    public InitialVoucherUserData getTopUpInitialData(UserLocatorVO userLocatorVO) throws FrameworkException {
        return this.getInitialUserData(userLocatorVO, VoucherServiceImpl.pv.topUp);
    }

    public VoucherTransactionData getTransactionData(Long l) throws FrameworkException {
        Object object;
        VoucherTransactionsVisibility voucherTransactionsVisibility;
        SessionData sessionData = this.getSessionData();
        VoucherTransaction voucherTransaction = this.find(VoucherTransaction.class, l);
        VoucherTransactionsVisibility voucherTransactionsVisibility2 = voucherTransactionsVisibility = sessionData.isLoggedIn() && sessionData.getLoggedUser().equals((Object)voucherTransaction.getUser()) ? VoucherTransactionsVisibility.FULL : this.voucherServiceSecurity.getTransactionVisibility(voucherTransaction.getVoucher());
        if (voucherTransactionsVisibility == VoucherTransactionsVisibility.NONE) {
            throw new EntityNotFoundException(VoucherTransaction.class, l);
        }
        Object[] objectArray = this.getTransactionExcludes(voucherTransactionsVisibility);
        VoucherTransactionData voucherTransactionData = new VoucherTransactionData();
        VoucherTransactionResultVO voucherTransactionResultVO = (VoucherTransactionResultVO)this.conversionHandler.convertExcluding(VoucherTransactionResultVO.class, (Object)voucherTransaction, objectArray);
        voucherTransactionResultVO.setAmount(voucherTransactionResultVO.getAmount().abs());
        voucherTransactionData.setVoucherTransaction(voucherTransactionResultVO);
        voucherTransactionData.setChargedBackBy((VoucherTransactionVO)this.conversionHandler.convert(VoucherTransactionVO.class, (Object)voucherTransaction.getChargedBackBy()));
        if (voucherTransaction instanceof VoucherChargeback) {
            object = (VoucherChargeback)voucherTransaction;
            voucherTransactionData.setChargebackOf((VoucherTransactionVO)this.conversionHandler.convert(VoucherTransactionVO.class, (Object)object.getChargebackOf()));
        }
        object = this.exportFormatService.listByContext(ExportFormatContext.VOUCHER_TRANSACTION_DETAILS);
        voucherTransactionData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)object));
        return voucherTransactionData;
    }

    public VoucherTransactionsSearchData getUserTransactionsSearchData(UserLocatorVO userLocatorVO) throws FrameworkException {
        List list;
        SessionData sessionData = this.getSessionData();
        VoucherTransactionsSearchData voucherTransactionsSearchData = new VoucherTransactionsSearchData();
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        if (sessionData.isAdmin()) {
            list = this.voucherConfigurationService.listVisible(user, true, false);
            List list2 = this.voucherTypeService.listForSearchFilterByConfiguration((Collection)list);
            voucherTransactionsSearchData.setTypes(this.conversionHandler.convertList(VoucherTypeVO.class, (Iterable)list2));
        }
        voucherTransactionsSearchData.setOperators(this.conversionHandler.convertList(OperatorVO.class, (Iterable)this.operatorService.list(user)));
        voucherTransactionsSearchData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        voucherTransactionsSearchData.setVoucherTopUpEnabled(this.isTopupEnabled(user));
        list = (VoucherTransactionsQuery)QueryHelper.newQuery(VoucherTransactionsQuery.class);
        list.setUser(new UserLocatorVO(user.getId()));
        voucherTransactionsSearchData.setQuery((QueryParameters)list);
        return voucherTransactionsSearchData;
    }

    public UserVouchersSearchData getUserVouchersSearchData(UserLocatorVO userLocatorVO) throws FrameworkException {
        List list;
        SessionData sessionData = this.getSessionData();
        UserVouchersSearchData userVouchersSearchData = new UserVouchersSearchData();
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        List list2 = this.voucherConfigurationService.listVisible(user, false, true);
        if (sessionData.isAdmin()) {
            list = this.voucherTypeService.listForSearchFilterByConfiguration((Collection)list2);
            userVouchersSearchData.setTypes(this.conversionHandler.convertList(VoucherTypeVO.class, (Iterable)list));
        }
        userVouchersSearchData.setMask(this.resolveMask(list2));
        userVouchersSearchData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        userVouchersSearchData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(ExportFormatContext.USER_VOUCHERS_SEARCH)));
        list = (UserVoucherQuery)QueryHelper.newQuery(UserVoucherQuery.class);
        list.setUser(new UserLocatorVO(user.getId()));
        list.setOrderBy(VoucherOrderBy.CREATION_DATE_DESC);
        EnumSet<VoucherStatus> enumSet = EnumSet.allOf(VoucherStatus.class);
        enumSet.removeIf(VoucherStatus::isFinal);
        list.setStatuses(enumSet);
        userVouchersSearchData.setQuery((QueryParameters)list);
        return userVouchersSearchData;
    }

    public boolean hasAmountReservation(Voucher voucher) {
        VoucherPackAmountReservation voucherPackAmountReservation = voucher.getPack().getAmountReservation();
        if (voucherPackAmountReservation != null) {
            return true;
        }
        return ((DBQuery)this.from(new EntityPath[]{t}).where(new Predicate[]{t.voucher().eq((Object)voucher), VoucherServiceImpl.t.amountReservations.isNotEmpty()})).hasResults();
    }

    @PostConstruct
    public void initialize() {
        EnumSet.allOf(AuthorizationAction.class).forEach(this::registerTransactionAuthorizationHandler);
    }

    public CloseableIterator<Voucher> iterateVouchers(VoucherPack voucherPack) {
        return ((DBQuery)this.from(new EntityPath[]{$}).where((Predicate)$.pack().eq((Object)voucherPack))).iterate((Expression)$);
    }

    public VoucherVO loadByToken(String string) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        User user = null;
        if (!sessionData.isUserManager()) {
            user = sessionData.getLoggedUser();
        }
        List<VoucherConfiguration> list = this.resolveConfigurations(user, true, true);
        Voucher voucher = this.findByToken(string, list);
        return (VoucherVO)this.conversionHandler.convert(VoucherVO.class, (Object)voucher);
    }

    public void notifyAboutToExpire(Voucher voucher) throws FrameworkException {
        VoucherPack voucherPack = voucher.getPack();
        if (voucher.hasCustomExpirationDate()) {
            if (voucher.isAboutToExpireNotified()) {
                return;
            }
            voucher.setAboutToExpireNotified(true);
        } else {
            if (voucherPack.isAboutToExpireNotified()) {
                return;
            }
            voucherPack.setAboutToExpireNotified(true);
        }
        Date date = voucher.getActualExpirationDate();
        if (this.supportsNotifications(voucher)) {
            Object object = this.ofAmount(voucher);
            this.notify(voucher, () -> this.message(ContentManagementKeys.Emails.VOUCHER_ABOUT_TO_EXPIRE_SUBJECT, object, date), () -> this.message(ContentManagementKeys.Emails.VOUCHER_ABOUT_TO_EXPIRE_MESSAGE, object, date), () -> this.message(MessagingKeys.Notifications.SMS_VOUCHER_ABOUT_TO_EXPIRE, object, date));
        } else {
            this.notifyOwnerOrBuyer(voucher, accountNotificationsHandler -> accountNotificationsHandler.voucherAboutToExpire(voucher, voucher.getCurrencyAmount(), voucher.getType(), date));
        }
        if (voucherPack.isGenerated() && voucherPack.getAmount() != null) {
            int n = voucher.hasCustomExpirationDate() ? 1 : ((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.pack().eq((Object)voucherPack), VoucherServiceImpl.$.expirationDate.isNull()})).count(VoucherServiceImpl.$.id);
            this.notificationHandler.admin().generatedVouchersAboutToExpire(voucher, n);
        }
    }

    public BuyVoucherPreviewVO previewBuy(@NotNull BuyVouchersDTO buyVouchersDTO) throws FrameworkException, VoucherBuyingException, MaxTotalOpenAmountException, TransferException {
        return this.doPreviewBuyOrSend((BaseBuyVouchersDTO)buyVouchersDTO);
    }

    public RedeemVoucherPreviewVO previewRedeem(@NotNull RedeemVoucherDTO redeemVoucherDTO) throws FrameworkException, VoucherRedeemingException {
        User user = (User)this.conversionHandler.convert(User.class, (Object)redeemVoucherDTO.getUser());
        Voucher voucher = this.findForRedeeming((VoucherTransactionDataParams)redeemVoucherDTO, user);
        BigDecimal bigDecimal = this.prepareRedeem(true, redeemVoucherDTO, user, voucher);
        RedeemVoucherPreviewVO redeemVoucherPreviewVO = new RedeemVoucherPreviewVO();
        this.fill((VoucherTransactionPreviewVO)redeemVoucherPreviewVO, voucher, user, bigDecimal, (PerformVoucherTransactionDTO)redeemVoucherDTO);
        redeemVoucherPreviewVO.setRedeem(redeemVoucherDTO);
        if (this.requiresPinForRedeem(voucher)) {
            redeemVoucherPreviewVO.setPinInput(this.pinInput(voucher));
            redeemVoucherPreviewVO.setCanSendPin(StringHelper.isNotBlank((Object)voucher.getMobilePhone()) || StringHelper.isNotBlank((Object)voucher.getEmail()));
        }
        return redeemVoucherPreviewVO;
    }

    public BuyVoucherPreviewVO previewSend(@NotNull SendVoucherDTO sendVoucherDTO) throws FrameworkException, VoucherBuyingException, MaxTotalOpenAmountException, TransferException {
        return this.doPreviewBuyOrSend((BaseBuyVouchersDTO)sendVoucherDTO);
    }

    public TopUpVoucherPreviewVO previewTopUp(@NotNull TopUpVoucherDTO topUpVoucherDTO) throws FrameworkException, VoucherTopUpException {
        ConfigurationAccessor configurationAccessor;
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)topUpVoucherDTO.getUser());
        if (user == null) {
            throw new IllegalActionException("No user for voucher top-up");
        }
        Voucher voucher = this.findForTopUp((VoucherTransactionDataParams)topUpVoucherDTO, user);
        VoucherConfiguration voucherConfiguration = voucher.getConfiguration();
        BigDecimal bigDecimal = this.prepareTopUp(true, topUpVoucherDTO, user, voucher);
        TopUpVoucherPreviewVO topUpVoucherPreviewVO = new TopUpVoucherPreviewVO();
        this.fill((VoucherTransactionPreviewVO)topUpVoucherPreviewVO, voucher, user, bigDecimal, (PerformVoucherTransactionDTO)topUpVoucherDTO);
        this.customFieldValueHandler.resolveValues(VoucherCustomField.class, (Collection)topUpVoucherDTO.getCustomValues());
        topUpVoucherPreviewVO.setTopUp(topUpVoucherDTO);
        topUpVoucherPreviewVO.setGenerationAmount(voucherConfiguration.getGenerationAmount());
        topUpVoucherPreviewVO.setPinOnActivation(voucherConfiguration.getPinOnActivation());
        if (topUpVoucherDTO.getMobilePhone() != null) {
            configurationAccessor = this.configurationHandler.getAccessAccessor((BasicUser)user);
            PhoneNumberDescriptor phoneNumberDescriptor = this.phoneNumberHandler.parse(topUpVoucherDTO.getMobilePhone(), configurationAccessor);
            topUpVoucherPreviewVO.setFormattedMobilePhone(phoneNumberDescriptor == null ? topUpVoucherDTO.getMobilePhone() : this.phoneNumberHandler.format(phoneNumberDescriptor, this.getConfiguration()));
        }
        topUpVoucherPreviewVO.setConfirmationPasswordInput(this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput());
        configurationAccessor = topUpVoucherDTO.getEmail() != null ? this.findOwner((PrincipalType)this.principalTypeService.getEmail(), topUpVoucherDTO.getEmail()) : (topUpVoucherDTO.getMobilePhone() != null ? this.findOwner((PrincipalType)this.principalTypeService.getMobilePhone(), topUpVoucherDTO.getMobilePhone()) : null);
        topUpVoucherPreviewVO.setOwner((UserVO)this.conversionHandler.convert(UserVO.class, (Object)configurationAccessor));
        return topUpVoucherPreviewVO;
    }

    public VoucherTransactionResultVO redeem(RedeemVoucherDTO redeemVoucherDTO) throws FrameworkException {
        User user = (User)this.conversionHandler.convert(User.class, (Object)redeemVoucherDTO.getUser());
        Voucher voucher = this.findForRedeeming((VoucherTransactionDataParams)redeemVoucherDTO, user);
        this.lockForTransaction(voucher);
        BigDecimal bigDecimal = this.prepareRedeem(false, redeemVoucherDTO, user, voucher);
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)VoucherExtensionPointEvent.REDEEM, new ExtensionPointFilter(voucher.getConfiguration()));
        extensionPointAccessor.attribute("voucher", (Object)voucher).attribute("user", (Object)user).attribute("redeemer", (Object)user).attribute("amount", (Object)bigDecimal);
        extensionPointAccessor.fireValidated();
        User user2 = null;
        switch (voucher.getType().getPaymentDestination()) {
            case REDEEMER: {
                user2 = user;
                break;
            }
            case FIXED_USER: {
                user2 = voucher.getType().getPaymentDestinationUser();
            }
        }
        VoucherRedeem voucherRedeem = new VoucherRedeem();
        voucherRedeem.setVoucher(voucher);
        voucherRedeem.setDate(new Date());
        voucherRedeem.setAmount(bigDecimal.negate());
        voucherRedeem.setUser(user);
        voucherRedeem.setBy(this.getLoggedBasicUser());
        this.persist((IEntity)voucherRedeem);
        this.accountService.processReservationIfNeeded((VoucherTransaction)voucherRedeem);
        Payment payment = this.paymentService.createForVoucherRedeeming(voucher, user2, bigDecimal, redeemVoucherDTO.getPaymentCustomValues());
        voucherRedeem.setTransaction((InternalTransaction)payment);
        voucher.setBalance(voucher.getBalance().subtract(bigDecimal));
        payment.setVoucherTransaction((VoucherTransaction)voucherRedeem);
        voucher.getTransactions().add(voucherRedeem);
        if (voucher.getAmount() != null && BigDecimalHelper.isZero((BigDecimal)voucher.getBalance())) {
            voucher.setStatus(VoucherStatus.REDEEMED);
        }
        CurrencyAmount currencyAmount = voucherRedeem.getCurrencyAmount().abs();
        if (this.supportsNotifications(voucher)) {
            this.notify(voucher, () -> this.message(ContentManagementKeys.Emails.VOUCHER_REDEEM_SUBJECT, currencyAmount), () -> this.message(ContentManagementKeys.Emails.VOUCHER_REDEEM_MESSAGE, currencyAmount, this.ofAmount(voucher), user) + (voucher.getStatus() == VoucherStatus.REDEEMED ? this.message(ContentManagementKeys.Emails.VOUCHER_REDEEM_EMPTY, new Object[0]) : this.message(ContentManagementKeys.Emails.VOUCHER_BALANCE, voucher.getBalanceCurrencyAmount())), () -> this.message(MessagingKeys.Notifications.SMS_VOUCHER_REDEEM, currencyAmount, voucher.getBalance(), user));
        } else {
            this.notifyOwnerOrBuyer(voucher, accountNotificationsHandler -> accountNotificationsHandler.voucherRedeem(voucherRedeem, currencyAmount, user));
        }
        extensionPointAccessor.fireSaved();
        VoucherTransactionResultVO voucherTransactionResultVO = (VoucherTransactionResultVO)this.conversionHandler.convert(VoucherTransactionResultVO.class, (Object)voucherRedeem);
        voucherTransactionResultVO.setAmount(voucherTransactionResultVO.getAmount().abs());
        return voucherTransactionResultVO;
    }

    public void resendEmail(@NotNull VoucherVO voucherVO) throws FrameworkException {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)voucherVO);
        if (!voucher.getPack().isSent() || !voucher.isOpen()) {
            throw new IllegalActionException();
        }
        this.sendEmail(voucher.getPack());
    }

    public List<String> resendPin(@NotNull String string, CaptchaResponseDTO captchaResponseDTO) {
        CaptchaConfiguration captchaConfiguration = this.getSessionData().getConfiguration().getCaptchaConfiguration();
        Validator validator = new Validator();
        validator.general((GeneralValidation)new CaptchaValidation(captchaConfiguration));
        this.validate(validator, captchaResponseDTO, "resendPin");
        Voucher voucher = this.voucherForInfo(string);
        this.captchaService.removeInternalCaptcha(captchaConfiguration, captchaResponseDTO);
        return this.sendPin(voucher, false);
    }

    public List<String> resendPinForRedeem(@NotNull String string, UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        VoucherTransactionDataParams voucherTransactionDataParams = new VoucherTransactionDataParams();
        voucherTransactionDataParams.setUser(new UserLocatorVO(user.getId()));
        voucherTransactionDataParams.setToken(string);
        Voucher voucher = this.findForRedeeming(voucherTransactionDataParams, user);
        return this.sendPin(voucher, false);
    }

    public Page<VoucherVO> searchGeneral(@NotNull GeneralVoucherQuery generalVoucherQuery) throws FrameworkException {
        return this.createGeneralQuery(generalVoucherQuery, true).page(VoucherVO.class, (QueryParameters)generalVoucherQuery, (Expression)$);
    }

    public Page<VoucherTransactionVO> searchInfoTransactions(@NotNull VoucherInfoTransactionsQuery voucherInfoTransactionsQuery, String string) throws FrameworkException {
        Voucher voucher = this.voucherForInfo(voucherInfoTransactionsQuery.getToken());
        this.checkVoucherPin(voucher, null, string);
        ArrayList<BasicProperty> arrayList = new ArrayList<BasicProperty>();
        arrayList.add(VoucherTransactionVO.TRANSACTION);
        if (Boolean.TRUE.equals(voucher.getPack().getGift())) {
            arrayList.add(VoucherTransactionVO.USER);
            arrayList.add(VoucherTransactionVO.BY);
        }
        Page page = ((DBQuery)((DBQuery)this.from(new EntityPath[]{t}).where((Predicate)t.voucher().eq((Object)voucher))).orderBy(VoucherServiceImpl.t.date.desc())).page((QueryParameters)voucherInfoTransactionsQuery, (Expression)t);
        return PageImpl.transformed((Page)page, voucherTransaction -> (VoucherTransactionVO)this.conversionHandler.convertExcluding(VoucherTransactionVO.class, voucherTransaction, arrayList.toArray()));
    }

    public Page<VoucherTransactionResultVO> searchTransactions(@NotNull VoucherTransactionsQuery voucherTransactionsQuery) throws FrameworkException {
        Set set;
        User user;
        QInternalTransaction qInternalTransaction = QInternalTransaction.internalTransaction;
        DBQuery dBQuery = ((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{t}).join((EntityPath)t.voucher(), (Path)$)).join((EntityPath)$.pack(), (Path)p)).leftJoin((EntityPath)t.transaction(), (Path)qInternalTransaction)).innerFetchHint(new Path[]{t, t.voucher(), t.voucher().pack()}).leftFetchHint(new Path[]{t, t.transaction()});
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)voucherTransactionsQuery.getVoucher());
        if (voucher != null) {
            dBQuery.where((Predicate)t.voucher().eq((Object)voucher));
        } else {
            user = this.resolveConfigurations(null, true, false);
            if (user.isEmpty()) {
                dBQuery.where((Predicate)VoucherServiceImpl.t.id.isNull());
            } else {
                dBQuery.where((Predicate)p.type().configuration().in(user));
            }
        }
        if (CollectionHelper.isNotEmpty((Iterable)voucherTransactionsQuery.getNatures())) {
            dBQuery.where((Predicate)VoucherServiceImpl.t.nature.in((Collection)voucherTransactionsQuery.getNatures()));
        }
        if ((user = (User)this.conversionHandler.convert(User.class, (Object)voucherTransactionsQuery.getUser())) != null) {
            dBQuery.where((Predicate)t.user().eq((Object)user));
        }
        if (!(set = this.conversionHandler.convertSet(VoucherType.class, (Iterable)voucherTransactionsQuery.getTypes())).isEmpty()) {
            dBQuery.where((Predicate)p.type().in((Collection)set));
        }
        DecimalRange decimalRange = (DecimalRange)this.conversionHandler.convert(DecimalRange.class, (Object)voucherTransactionsQuery.getAmountRange());
        dBQuery.where(VoucherServiceImpl.t.amount.range(decimalRange));
        DatePeriod datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)voucherTransactionsQuery.getDatePeriod());
        dBQuery.where(VoucherServiceImpl.t.date.period(datePeriod));
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)voucherTransactionsQuery.getBy());
        if (basicUser != null) {
            dBQuery.where((Predicate)t.by().eq((Object)basicUser));
        }
        dBQuery.orderBy(VoucherServiceImpl.t.date.desc());
        Page page = dBQuery.page((QueryParameters)voucherTransactionsQuery, (Expression)t);
        ArrayList<BasicProperty> arrayList = new ArrayList<BasicProperty>();
        if (voucher != null && Boolean.TRUE.equals(voucher.getPack().getGift()) && !this.getSessionData().isManagerOf((BasicUser)voucher.getPack().getBuyer())) {
            arrayList.add(VoucherTransactionVO.TRANSACTION);
            arrayList.add(VoucherTransactionVO.USER);
            arrayList.add(VoucherTransactionVO.BY);
        }
        return PageImpl.transformed((Page)page, voucherTransaction -> (VoucherTransactionResultVO)this.conversionHandler.convertExcluding(VoucherTransactionResultVO.class, voucherTransaction, arrayList.toArray()));
    }

    public Page<VoucherVO> searchUser(@NotNull UserVoucherQuery userVoucherQuery) throws FrameworkException {
        return this.createUserQuery(userVoucherQuery, true).page(VoucherVO.class, (QueryParameters)userVoucherQuery, (Expression)$);
    }

    public VoucherPackWithIdsVO send(@NotNull SendVoucherDTO sendVoucherDTO) throws FrameworkException, VoucherBuyingException, MaxTotalOpenAmountException, TransferException {
        sendVoucherDTO.setCount(Integer.valueOf(1));
        VoucherPackWithIdsVO voucherPackWithIdsVO = this.doBuyOrSend((BaseBuyVouchersDTO)sendVoucherDTO);
        VoucherPack voucherPack = (VoucherPack)this.conversionHandler.convert(VoucherPack.class, (Object)voucherPackWithIdsVO);
        if (!voucherPack.getBuy().isPendingAuthorization()) {
            this.sendEmail(voucherPack);
        }
        return voucherPackWithIdsVO;
    }

    public Voucher sendByImport(SendVoucherDTO sendVoucherDTO) {
        sendVoucherDTO.setAttribute(IGNORE_CONFIRMATION, (Object)true);
        VoucherPackWithIdsVO voucherPackWithIdsVO = this.send(sendVoucherDTO);
        return this.find(Voucher.class, (Long)CollectionHelper.first((Iterable)voucherPackWithIdsVO.getVoucherIds()));
    }

    public boolean showPinOnDetails(Voucher voucher) {
        if (!this.usePin(voucher)) {
            return false;
        }
        VoucherPack voucherPack = voucher.getPack();
        return !voucherPack.isSent() && voucher.getConfiguration().getPinOnActivation() == VoucherPinOnActivation.NONE && (!Boolean.TRUE.equals(voucherPack.getGift()) || !voucherPack.getBuyer().equals((Object)this.getSessionData().getLoggedUser()));
    }

    public boolean showQrCode(Voucher voucher) {
        return voucher.getConfiguration().isShowQrCode() && voucher.getStatus().isShowQrCode() && !this.voucherServiceSecurity.shouldMaskToken(voucher);
    }

    public VoucherTransactionResultVO topUp(@NotNull TopUpVoucherDTO topUpVoucherDTO) throws FrameworkException, VoucherTopUpException, TransferException {
        Object object;
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)topUpVoucherDTO.getUser());
        if (user == null) {
            throw new IllegalActionException("No user for voucher top-up");
        }
        Voucher voucher = this.findForTopUp((VoucherTransactionDataParams)topUpVoucherDTO, user);
        VoucherType voucherType = voucher.getType();
        VoucherConfiguration voucherConfiguration = voucher.getConfiguration();
        BigDecimal bigDecimal = this.prepareTopUp(false, topUpVoucherDTO, user, voucher);
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(topUpVoucherDTO.getConfirmationPassword(), TopUpVoucherConfirmationField.confirmation((VoucherTypeVO)new VoucherTypeVO(voucherType.getId()), (BigDecimal)bigDecimal));
        this.checkMaxTotalOpenAmount(voucherType, bigDecimal);
        this.lockForTransaction(voucher);
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)VoucherExtensionPointEvent.TOP_UP, new ExtensionPointFilter(voucherConfiguration)).attribute("voucher", (Object)voucher).attribute("user", (Object)user).attribute("amount", (Object)topUpVoucherDTO.getAmount());
        extensionPointAccessor.fireValidated();
        boolean bl = voucher.getStatus() == VoucherStatus.INACTIVE;
        Payment payment = this.paymentService.createForVoucherTopUp(voucher, user, bigDecimal, topUpVoucherDTO.getPaymentCustomValues());
        if (payment.isPendingAuthorization()) {
            throw new ValidationException("Top-up with payment authorization is not supported");
        }
        VoucherTopUp voucherTopUp = new VoucherTopUp();
        voucherTopUp.setVoucher(voucher);
        voucherTopUp.setDate(new Date());
        voucherTopUp.setAmount(bigDecimal);
        voucherTopUp.setUser(user);
        voucherTopUp.setBy(this.getLoggedBasicUser());
        voucherTopUp.setTransaction((InternalTransaction)payment);
        this.persist((IEntity)voucherTopUp);
        voucher.setBalance(voucher.getBalance().add(bigDecimal));
        payment.setVoucherTransaction((VoucherTransaction)voucherTopUp);
        voucher.getTransactions().add(voucherTopUp);
        if (bl) {
            VoucherPinOnActivation voucherPinOnActivation;
            boolean bl2;
            User user2;
            this.licenseHandler.checkNewVouchers(1);
            if (voucherConfiguration.getGenerationAmount() == VoucherGenerationAmount.ACTIVATION) {
                voucher.setAmount(bigDecimal);
            }
            voucher.setStatus(VoucherStatus.OPEN);
            if (voucherType.getExpirationType() == VoucherExpirationType.INTERVAL) {
                voucher.setExpirationDate(DateHelper.add((Date)new Date(), (ITimeInterval)voucherType.getExpirationInterval()));
            }
            object = this.resolveCustomFields(voucherType, null, VoucherCustomFieldUsage.ACTIVATION, false, null);
            List list = this.getSessionData().getProducts().product().getVisibleVoucherFields();
            this.customFieldValueHandler.setCustomValues((SimpleEntity)voucher, (Collection)object, (Collection)list, (Collection)topUpVoucherDTO.getCustomValues());
            this.customFieldValueHandler.processAfterSave((EntityWithCustomValues)voucher);
            voucher.setActivation(voucherTopUp);
            voucher.setEmail(topUpVoucherDTO.getEmail());
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
            voucher.setMobilePhone(this.phoneNumberHandler.tryNormalize(topUpVoucherDTO.getMobilePhone(), configurationAccessor));
            voucher.setEnableNotifications(StringHelper.areNotAllBlanks((Object[])new Object[]{voucher.getEmail(), voucher.getMobilePhone()}));
            User user3 = voucher.getEmail() != null ? this.findOwner((PrincipalType)this.principalTypeService.getEmail(), voucher.getEmail()) : (user2 = voucher.getMobilePhone() != null ? this.findOwner((PrincipalType)this.principalTypeService.getMobilePhone(), voucher.getMobilePhone()) : null);
            if (user2 != null) {
                this.assign(voucher, user2, true, true);
            }
            boolean bl3 = bl2 = (voucherPinOnActivation = voucherConfiguration.getPinOnActivation()) == VoucherPinOnActivation.INPUT && StringHelper.isNotBlank((Object)topUpVoucherDTO.getPin());
            if (bl2) {
                voucher.setPin(topUpVoucherDTO.getPin());
            } else if (voucherConfiguration.getPinUsage().isEnabled()) {
                this.generatePin(voucher);
            }
            if (voucherPinOnActivation != VoucherPinOnActivation.NONE && !bl2) {
                this.sendPin(voucher, true);
            } else {
                Date date = voucher.getActualExpirationDate();
                Object object2 = this.ofAmount(voucher);
                this.doNotify(voucher, () -> this.message(ContentManagementKeys.Emails.VOUCHER_ACTIVATION_SUBJECT_NO_PIN, object2), () -> this.message(ContentManagementKeys.Emails.VOUCHER_ACTIVATION_MESSAGE_NO_PIN, object2, user, date) + this.infoLink(voucher), () -> this.message(MessagingKeys.Notifications.SMS_VOUCHER_ACTIVATION, object2, date));
            }
        }
        this.accountService.processReservationIfNeeded((VoucherTransaction)voucherTopUp);
        extensionPointAccessor.fireSaved();
        if (!bl) {
            object = voucherTopUp.getCurrencyAmount();
            if (this.supportsNotifications(voucher)) {
                this.notify(voucher, () -> this.lambda$topUp$27((CurrencyAmount)object), () -> this.lambda$topUp$28((CurrencyAmount)object, user, voucher), () -> this.lambda$topUp$29((CurrencyAmount)object, voucher, user));
            } else {
                this.notifyOwnerOrBuyer(voucher, arg_0 -> VoucherServiceImpl.lambda$topUp$30(voucherTopUp, (CurrencyAmount)object, user, arg_0));
            }
        }
        return (VoucherTransactionResultVO)this.conversionHandler.convert(VoucherTransactionResultVO.class, (Object)voucherTopUp);
    }

    public void unblock(@NotNull UnblockVoucherParams unblockVoucherParams) throws FrameworkException, VoucherTopUpException {
        Voucher voucher = this.voucherForInfo(unblockVoucherParams.getToken());
        this.checkVoucherPin(voucher, null, unblockVoucherParams.getPin());
        this.licenseHandler.checkNewVouchers(1);
        this.lockForTransaction(voucher);
        if (!voucher.isBlocked()) {
            throw new IllegalActionException("The voucher is not blocked");
        }
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)VoucherExtensionPointEvent.UNBLOCK, new ExtensionPointFilter(voucher.getConfiguration())).attribute("voucher", (Object)voucher);
        extensionPointAccessor.fireValidated();
        if (!this.isBacked(voucher)) {
            this.accountService.reserveAmountForUnblocking(voucher);
            voucher.setBalance(voucher.getAmount());
        }
        voucher.setStatus(VoucherStatus.OPEN);
        extensionPointAccessor.fireSaved();
    }

    public void unblockPin(@NotNull VoucherVO voucherVO) throws FrameworkException {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)voucherVO);
        if (!voucher.isPinBlocked()) {
            throw new IllegalActionException("The voucher PIN is not blocked");
        }
        voucher.setPinBlockedUntil(null);
    }

    public boolean usePin(Voucher voucher) {
        return StringHelper.isNotBlank((Object)voucher.getPin()) && ObjectHelper.defaultValue((Object)voucher.getConfiguration().getPinUsage(), (Object)VoucherPinUsage.NEVER) != VoucherPinUsage.NEVER;
    }

    public void validate(SendVoucherDTO sendVoucherDTO) {
        this.validate((CreateVouchersDTO)sendVoucherDTO, false);
    }

    protected VoucherInfoVO doGetInfo(Voucher voucher, String string) {
        Object[] objectArray;
        VoucherTransaction voucherTransaction;
        VoucherTransactionsVisibility voucherTransactionsVisibility;
        VoucherInfoVO voucherInfoVO = new VoucherInfoVO();
        String string2 = voucher.getConfiguration().getMask();
        VoucherType voucherType = voucher.getType();
        voucherInfoVO.setToken(MaskHelper.applyMask((String)string2, (String)voucher.getToken()));
        voucherInfoVO.setStatus(voucher.getStatus());
        boolean bl = this.usePin(voucher);
        if (bl) {
            if (voucher.isBlockedGift()) {
                voucherInfoVO.setPinInput(this.pinInput(voucher));
                voucherInfoVO.setBlockedGiftBy(voucher.getPack().getBuyer().getDisplayForOthers());
                voucherInfoVO.setPhoneConfiguration(this.getPhoneConfigurationIfSupported(voucher));
                return voucherInfoVO;
            }
            if ((string = StringHelper.trimToNull((Object)string)) == null) {
                voucherInfoVO.setPinInput(this.pinInput(voucher));
                Pair<CaptchaInputDTO, List<SendMedium>> pair = this.forgotPinInfo(voucher);
                voucherInfoVO.setForgotPinCaptchaInput((CaptchaInputDTO)pair.getFirst());
                voucherInfoVO.setForgotPinSendMediums((List)pair.getSecond());
                return voucherInfoVO;
            }
            this.checkVoucherPin(voucher, null, string);
        }
        VoucherPack voucherPack = voucher.getPack();
        voucherInfoVO.setType((VoucherTypeVO)this.conversionHandler.convert(VoucherTypeVO.class, (Object)voucherPack.getType()));
        voucherInfoVO.setCreationDate(this.conversionHandler.toDateTime(voucherPack.getCreationDate()));
        voucherInfoVO.setCreationType(voucherPack.getCreationType());
        voucherInfoVO.setCanChangePin(bl);
        if (voucherInfoVO.isCanChangePin()) {
            voucherInfoVO.setPinInput(this.pinInput(voucher));
        }
        voucherInfoVO.setCanChangeNotificationSettings(this.canChangeNotificationSettings(voucher));
        voucherInfoVO.setEnableNotifications(voucher.isEnableNotifications());
        if (!bl) {
            voucherInfoVO.setEmail(StringHelper.maskEmail((String)voucher.getEmail()));
            voucherInfoVO.setMobilePhone(StringHelper.maskPhone((String)this.formatMobilePhone(voucher)));
        } else {
            voucherInfoVO.setEmail(voucher.getEmail());
            voucherInfoVO.setMobilePhone(this.formatMobilePhone(voucher));
        }
        voucherInfoVO.setPhoneConfiguration(this.getPhoneConfigurationIfSupported(voucher));
        voucherInfoVO.setAmount((BigDecimal)ObjectHelper.defaultValue((Object)voucher.getAmount(), (Object)voucherPack.getAmount()));
        voucherInfoVO.setBalance(voucher.getBalance());
        voucherInfoVO.setExpirationDate(this.conversionHandler.toDateTime((Date)ObjectHelper.defaultValue((Object)voucher.getExpirationDate(), (Object)voucherPack.getExpirationDate())));
        Date date = voucherPack.getRedeemAfterDate();
        voucherInfoVO.setRedeemAfterDate(this.conversionHandler.toDateTime(date));
        voucherInfoVO.setRedeemAfterDateReached(date == null ? true : date.before(new Date()));
        voucherInfoVO.setRedeemOnWeekDays(CollectionHelper.sort((Collection)voucherPack.getRedeemOnWeekDays()));
        if (voucherPack.isBought() && Boolean.FALSE.equals(voucherPack.getGift())) {
            voucherInfoVO.setPersonal(voucherPack.getBuyer().getDisplayForOthers());
        }
        if ((voucherTransactionsVisibility = this.voucherServiceSecurity.getTransactionVisibility(voucher)) != VoucherTransactionsVisibility.NONE) {
            if (!voucherType.isAllowPartialRedeems() && voucher.getStatus() == VoucherStatus.REDEEMED) {
                voucherTransaction = (VoucherTransaction)CollectionHelper.first((Iterable)voucher.getTransactions());
                objectArray = this.getTransactionExcludes(voucherTransactionsVisibility);
                VoucherTransactionVO voucherTransactionVO = (VoucherTransactionVO)this.conversionHandler.convertExcluding(VoucherTransactionVO.class, (Object)voucherTransaction, objectArray);
                voucherInfoVO.setSingleRedeem(voucherTransactionVO);
            } else {
                voucherInfoVO.setHasTransactions(((DBQuery)this.from(new EntityPath[]{t}).where((Predicate)t.voucher().eq((Object)voucher))).hasResults());
            }
        }
        voucherTransaction = voucherType.getCustomFields().stream().filter(VoucherCustomField::isShowInVoucherInformation).sorted().collect(Collectors.toList());
        objectArray = new ArrayList();
        objectArray.addAll(this.conversionHandler.convertList(CustomFieldValueVO.class, (Iterable)voucherPack.getCustomValues().stream().filter(arg_0 -> VoucherServiceImpl.lambda$doGetInfo$31((List)voucherTransaction, arg_0)).collect(Collectors.toList())));
        objectArray.addAll(this.conversionHandler.convertList(CustomFieldValueVO.class, (Iterable)voucher.getCustomValues().stream().filter(arg_0 -> VoucherServiceImpl.lambda$doGetInfo$32((List)voucherTransaction, arg_0)).collect(Collectors.toList())));
        voucherInfoVO.setCustomValues((List)objectArray);
        return voucherInfoVO;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register($.pack().type().configuration().currency().network());
        networkPathRegistry.register(p.type().configuration().currency().network());
    }

    private boolean allowBuying(VoucherType voucherType, User user) {
        if (!voucherType.isEnabled() || !voucherType.isAllowBuying()) {
            return false;
        }
        Set set = voucherType.getBuyAllowedGroups();
        if (CollectionHelper.isNotEmpty((Iterable)set)) {
            Group group = user.getGroup();
            GroupSet groupSet = group instanceof UserGroup ? ((UserGroup)group).getGroupSet() : null;
            return set.contains(group) || set.contains(groupSet);
        }
        return true;
    }

    private void assign(Voucher voucher, User user, boolean bl, boolean bl2) {
        if (user == null) {
            return;
        }
        BooleanPropertiesHolder booleanPropertiesHolder = this.productsHandler.getAccessor((BasicUser)user).member().getVouchers();
        QProductMemberVoucher qProductMemberVoucher = QProductMemberVoucher.productMemberVoucher;
        boolean bl3 = booleanPropertiesHolder.isSet((Object)voucher.getConfiguration(), (Path)qProductMemberVoucher.enable);
        if (!bl3) {
            if (bl) {
                return;
            }
            throw new ValidationException(this.message(BankingKeys.Vouchers.ERROR_ASSIGN_DISABLED, new Object[0]));
        }
        voucher.setOwner(user);
        if (bl2) {
            this.notificationHandler.user((BasicUser)user).account().voucherAssigned(voucher, voucher.getCurrencyAmount(), voucher.getType(), voucher.getActualExpirationDate());
        }
    }

    private boolean canAssign(Voucher voucher) {
        return voucher != null && voucher.isOpen() && voucher.getPack().isGenerated() && !voucher.isAssigned();
    }

    private VoucherCancelAction cancelAction(Voucher voucher) {
        VoucherPack voucherPack;
        if (!(voucher.isOpen() || voucher.isPending() || voucher.isExpired())) {
            return null;
        }
        BigDecimal bigDecimal = voucher.getAmount();
        if (voucher.getPack().isSent() || bigDecimal != null && !bigDecimal.equals(voucher.getBalance())) {
            return null;
        }
        if (voucher.getConfiguration().getGenerationAmount().allowTopUp() && voucher.getActivation() != null && this.transactionCount(voucher) == 1 && (voucherPack = (Payment)ObjectHelper.ifType((Object)voucher.getActivation().getTransaction(), Payment.class)) != null && voucherPack.getTransfer() != null && ((Boolean)this.invokerHandler.runAs(SessionDataFactory.system(), () -> this.lambda$cancelAction$33((Payment)voucherPack))).booleanValue()) {
            return VoucherCancelAction.CANCEL_AND_CHARGEBACK;
        }
        voucherPack = voucher.getPack();
        if (voucherPack.isGenerated()) {
            return VoucherCancelAction.CANCEL_GENERATED;
        }
        if (!voucherPack.getBuy().isAuthorized()) {
            return BigDecimalHelper.areEquals((BigDecimal)voucher.getCurrencyAmount().getAmount(), (BigDecimal)voucherPack.getTotalAmount()) ? VoucherCancelAction.CANCEL_PENDING_SINGLE : VoucherCancelAction.CANCEL_PENDING_PACK;
        }
        return voucherPack.getConfiguration().getRefundType() == null ? null : VoucherCancelAction.CANCEL_AND_REFUND;
    }

    private void cancelBuyPaymentAuthorization(VoucherPack voucherPack) {
        Payment payment = voucherPack.getBuy();
        if (payment != null && payment.isPendingAuthorization()) {
            this.transactionAuthorizationService.cancel((BasePayment)payment, this.message(BankingKeys.Vouchers.PAYMENT_CANCELED_BY_VOUCHER, new Object[0]));
        }
    }

    private boolean canChangeExpirationDate(Voucher voucher) {
        return voucher.isOpen() || voucher.isPending() || voucher.isExpired();
    }

    private boolean canChangeNotificationSettings(Voucher voucher) {
        return this.usePin(voucher) && voucher.isOpen() && this.supportsNotifications(voucher);
    }

    private boolean canPrint(Voucher voucher) {
        return !voucher.getStatus().isFinal() && !this.voucherServiceSecurity.shouldMaskToken(voucher);
    }

    private void checkEnabledForBuying(VoucherType voucherType) {
        if (!voucherType.isEnabled() || !voucherType.isAllowBuying()) {
            throw new IllegalActionException("This voucher type doesn't allow buying");
        }
    }

    private void checkMaxTotalOpenAmount(VoucherType voucherType, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = voucherType.getMaxTotalOpenAmount();
        if (BigDecimalHelper.isPositive((BigDecimal)bigDecimal2)) {
            this.lockHandler.lock(LockType.VOUCHER_TYPE.key(voucherType.getId()));
            BigDecimal bigDecimal3 = BigDecimalHelper.zeroWhenNull((BigDecimal)((BigDecimal)((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.pack().type().eq((Object)voucherType), VoucherServiceImpl.$.status.in((Object[])VoucherStatus.getActuallyOpenStatuses())})).singleResult((Expression)VoucherServiceImpl.$.pack().amount.sum())));
            if (bigDecimal3.add(bigDecimal).compareTo(bigDecimal2) > 0) {
                CurrencyVO currencyVO = (CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)voucherType.getConfiguration().getCurrency());
                CurrencyAmountDTO currencyAmountDTO = ModelHelper.currencyAmount((CurrencyVO)currencyVO, (BigDecimal)bigDecimal3);
                CurrencyAmountDTO currencyAmountDTO2 = ModelHelper.currencyAmount((CurrencyVO)currencyVO, (BigDecimal)bigDecimal2);
                throw new MaxTotalOpenAmountException(currencyAmountDTO, currencyAmountDTO2);
            }
        }
    }

    private void checkVoucherPin(Voucher voucher, User user, String string) {
        if (!this.usePin(voucher)) {
            return;
        }
        if (StringHelper.isBlank((Object)string)) {
            throw new ValidationException(UnblockVoucherParams.PIN.getName(), this.message(GeneralKeys.Errors.REQUIRED, BankingKeys.Vouchers.PIN));
        }
        Date date = voucher.getPinBlockedUntil();
        PasswordTypeDetailedVO passwordTypeDetailedVO = this.pinType(voucher);
        if (date != null && date.getTime() > System.currentTimeMillis()) {
            throw new PasswordStatusException((PasswordTypeVO)passwordTypeDetailedVO, PasswordStatus.TEMPORARILY_BLOCKED);
        }
        if (!voucher.getPin().equalsIgnoreCase(string)) {
            boolean bl = this.failedActionHandler.recordVoucherPinFailure(voucher, Integer.valueOf(5), () -> {
                Voucher voucher2 = (Voucher)this.entityManagerHandler.refresh((IEntity)voucher);
                User user2 = null;
                if (user != null) {
                    user2 = (User)this.entityManagerHandler.refresh((IEntity)user);
                }
                this.onVoucherPinBlocked(voucher2, user2);
            });
            throw bl ? new PasswordStatusException((PasswordTypeVO)passwordTypeDetailedVO, PasswordStatus.TEMPORARILY_BLOCKED) : new InvalidPasswordException((PasswordTypeVO)passwordTypeDetailedVO);
        }
        this.failedActionHandler.clearVoucherPinFailures(voucher);
    }

    private ConfigurationAccessor configurationFor(Voucher voucher) {
        if (voucher.getOwner() != null) {
            return this.configurationHandler.getAccessor((BasicUser)voucher.getOwner());
        }
        if (voucher.getPack().isBought()) {
            return this.configurationHandler.getAccessor((BasicUser)voucher.getPack().getBuyer());
        }
        if (voucher.getActivation() != null) {
            return this.configurationHandler.getAccessor((BasicUser)voucher.getActivation().getUser());
        }
        return this.configurationHandler.getDefaultAccessor();
    }

    private DBQuery<?> createGeneralQuery(GeneralVoucherQuery generalVoucherQuery, boolean bl) {
        VoucherCustomField voucherCustomField;
        VoucherOrderBy voucherOrderBy;
        Object object;
        QVoucherTransaction qVoucherTransaction;
        QVoucherTransaction qVoucherTransaction2;
        QVoucherTransaction qVoucherTransaction3;
        Set set;
        User user;
        Set set2;
        DatePeriod datePeriod;
        DatePeriod datePeriod2;
        VoucherCreationType voucherCreationType;
        PhoneNumberDescriptor phoneNumberDescriptor;
        Collection<Object> collection;
        String string;
        Set set3;
        Set set4;
        QUser qUser = new QUser("ou");
        QGroup qGroup = new QGroup("og");
        QUser qUser2 = new QUser("bu");
        QGroup qGroup2 = new QGroup("bg");
        DBQuery dBQuery = ((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{$}).join((EntityPath)$.pack(), (Path)p)).leftJoin((EntityPath)$.owner(), (Path)qUser)).leftJoin((EntityPath)qUser.group(), (Path)qGroup)).leftJoin((EntityPath)p.buyer(), (Path)qUser2)).leftJoin((EntityPath)qUser2.group(), (Path)qGroup2)).leftFetchHint(new Path[]{$, $.owner()}).leftFetchHint(new Path[]{$, $.owner(), $.owner().image()}).leftFetchHint(new Path[]{$, $.pack()}).leftFetchHint(new Path[]{$, $.pack(), $.pack().buyer()}).leftFetchHint(new Path[]{$, $.pack(), $.pack().buyer(), $.pack().buyer().image()}).leftFetchHint(new Path[]{$, $.pack(), $.pack().buy()});
        Set set5 = this.conversionHandler.convertSet(VoucherConfiguration.class, (Iterable)generalVoucherQuery.getConfigurations());
        if (!set5.isEmpty()) {
            dBQuery.where((Predicate)p.type().configuration().in((Collection)set5));
        }
        if (!(set4 = this.conversionHandler.convertSet(VoucherType.class, (Iterable)generalVoucherQuery.getTypes())).isEmpty()) {
            dBQuery.where((Predicate)p.type().in((Collection)set4));
        }
        if (!(set3 = this.conversionHandler.convertSet(VoucherPack.class, (Iterable)generalVoucherQuery.getPacks())).isEmpty()) {
            dBQuery.where((Predicate)p.in((Collection)set3));
        }
        if (CollectionHelper.isNotEmpty((Iterable)generalVoucherQuery.getStatuses())) {
            dBQuery.where((Predicate)VoucherServiceImpl.$.status.in((Collection)generalVoucherQuery.getStatuses()));
        }
        if ((string = StringHelper.trimToNull((Object)generalVoucherQuery.getToken())) != null) {
            collection = set5;
            if (collection.isEmpty()) {
                boolean bl2;
                boolean bl3 = generalVoucherQuery.getBuyer() != null;
                boolean bl4 = bl2 = generalVoucherQuery.getTransactionUser() != null;
                if (!(this.isAdmin() || bl3 || bl2)) {
                    bl3 = true;
                }
                collection = this.resolveConfigurations(null, bl2, bl3);
            }
            phoneNumberDescriptor = this.resolvePossibleUmaskedTokens(string, (Collection<VoucherConfiguration>)collection);
            phoneNumberDescriptor.add((String)string);
            dBQuery.where((Predicate)VoucherServiceImpl.$.token.in((Collection)phoneNumberDescriptor));
        }
        if ((collection = StringHelper.trimToNull((Object)generalVoucherQuery.getEmail())) != null) {
            dBQuery.where((Predicate)VoucherServiceImpl.$.email.equalsIgnoreCase((String)((Object)collection)));
        }
        if ((phoneNumberDescriptor = this.phoneNumberHandler.parse(generalVoucherQuery.getMobilePhone(), this.getConfiguration())) != null) {
            dBQuery.where((Predicate)VoucherServiceImpl.$.mobilePhone.eq((Object)phoneNumberDescriptor.toE164()));
        }
        if (generalVoucherQuery.getPrinted() != null) {
            dBQuery.where((Predicate)VoucherServiceImpl.$.printed.eq(generalVoucherQuery.getPrinted()));
        }
        if ((voucherCreationType = generalVoucherQuery.getCreationType()) != null) {
            dBQuery.where((Predicate)VoucherServiceImpl.p.creationType.eq((Object)voucherCreationType));
        }
        if ((datePeriod2 = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)generalVoucherQuery.getCreationPeriod())) != null && !datePeriod2.isEmpty()) {
            dBQuery.where(VoucherServiceImpl.p.creationDate.period(datePeriod2));
        }
        if ((datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)generalVoucherQuery.getExpirationPeriod())) != null && !datePeriod.isEmpty()) {
            dBQuery.where(DateQueryExtensions.period((Expression)VoucherServiceImpl.$.expirationDate.coalesce(new Expression[]{VoucherServiceImpl.p.expirationDate}), (DatePeriod)datePeriod));
        }
        if (QueryHelper.useParameter((Object)generalVoucherQuery.getAmountRange())) {
            set2 = (DecimalRange)this.conversionHandler.convert(DecimalRange.class, (Object)generalVoucherQuery.getAmountRange());
            dBQuery.where(VoucherServiceImpl.p.amount.range((DecimalRange)set2));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(set2 = this.groupsHandler.flattenVOs((Collection)generalVoucherQuery.getBuyerGroups())))) {
            dBQuery.where((Predicate)qGroup2.in((Collection)set2).or((Predicate)qGroup.in((Collection)set2)));
        }
        if ((user = (User)this.conversionHandler.convert(User.class, (Object)generalVoucherQuery.getBuyer())) != null) {
            dBQuery.where((Predicate)qUser2.eq((Object)user).or((Predicate)qUser.eq((Object)user)));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(set = this.groupsHandler.flattenVOs((Collection)generalVoucherQuery.getTransactionUserGroups())))) {
            qVoucherTransaction3 = QVoucherTransaction.voucherTransaction;
            dBQuery.where((Predicate)((DBQuery)this.subQuery(new EntityPath[]{qVoucherTransaction3}).where(new Predicate[]{qVoucherTransaction3.voucher().eq((Expression)$), qVoucherTransaction3.user().group().in((Collection)set)})).exists());
        }
        if ((qVoucherTransaction3 = (User)this.conversionHandler.convert(User.class, (Object)generalVoucherQuery.getTransactionUser())) != null) {
            qVoucherTransaction2 = QVoucherTransaction.voucherTransaction;
            dBQuery.where((Predicate)((DBQuery)this.subQuery(new EntityPath[]{qVoucherTransaction2}).where(new Predicate[]{qVoucherTransaction2.voucher().eq((Expression)$), qVoucherTransaction2.user().eq((Object)qVoucherTransaction3)})).exists());
        }
        if ((qVoucherTransaction2 = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)generalVoucherQuery.getTransactionPeriod())) != null && !qVoucherTransaction2.isEmpty()) {
            qVoucherTransaction = QVoucherTransaction.voucherTransaction;
            dBQuery.where((Predicate)((DBQuery)this.subQuery(new EntityPath[]{qVoucherTransaction}).where(new Predicate[]{qVoucherTransaction.voucher().eq((Expression)$), qVoucherTransaction.transaction().date.period((DatePeriod)qVoucherTransaction2)})).exists());
        }
        if ((qVoucherTransaction = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)generalVoucherQuery.getTransactionBy())) != null) {
            object = QVoucherTransaction.voucherTransaction;
            dBQuery.where((Predicate)((DBQuery)this.subQuery(new EntityPath[]{object}).where(new Predicate[]{object.voucher().eq((Expression)$), object.by().eq((Object)qVoucherTransaction3)})).exists());
        }
        object = this.voucherCustomFieldServiceLocal.listVisible(null);
        Set set6 = generalVoucherQuery.getCustomValues();
        if (CollectionHelper.isNotEmpty((Iterable)object) && CollectionHelper.isNotEmpty((Iterable)set6)) {
            voucherOrderBy = object.iterator();
            while (voucherOrderBy.hasNext()) {
                QVoucherCustomFieldValue qVoucherCustomFieldValue;
                CustomFieldValueForSearchDTO customFieldValueForSearchDTO3;
                voucherCustomField = (VoucherCustomField)voucherOrderBy.next();
                CustomFieldValueForSearchDTO customFieldValueForSearchDTO2 = null;
                for (CustomFieldValueForSearchDTO customFieldValueForSearchDTO3 : set6) {
                    VoucherCustomField voucherCustomField2 = (VoucherCustomField)this.conversionHandler.convert(VoucherCustomField.class, (Object)customFieldValueForSearchDTO3.getField());
                    if (!voucherCustomField.equals((Object)voucherCustomField2)) continue;
                    customFieldValueForSearchDTO2 = customFieldValueForSearchDTO3;
                    break;
                }
                if (customFieldValueForSearchDTO2 == null) continue;
                if (voucherCustomField.getUsage() == VoucherCustomFieldUsage.ACTIVATION) {
                    qVoucherCustomFieldValue = new QVoucherCustomFieldValue("fv_" + voucherCustomField.getId());
                    customFieldValueForSearchDTO3 = this.customFieldValueHandler.queryFilter((EntityPath)qVoucherCustomFieldValue, (CustomField)voucherCustomField, customFieldValueForSearchDTO2);
                    if (customFieldValueForSearchDTO3 == null) continue;
                    ((DBQuery)dBQuery.from((EntityPath)qVoucherCustomFieldValue)).where(new Predicate[]{qVoucherCustomFieldValue.field().eq((Object)voucherCustomField), qVoucherCustomFieldValue.owner().eq((Expression)$), customFieldValueForSearchDTO3});
                    continue;
                }
                qVoucherCustomFieldValue = new QVoucherPackCustomFieldValue("fv_" + voucherCustomField.getId());
                customFieldValueForSearchDTO3 = this.customFieldValueHandler.queryFilter((EntityPath)qVoucherCustomFieldValue, (CustomField)voucherCustomField, customFieldValueForSearchDTO2);
                if (customFieldValueForSearchDTO3 == null) continue;
                ((DBQuery)dBQuery.from((EntityPath)qVoucherCustomFieldValue)).where(new Predicate[]{qVoucherCustomFieldValue.field().eq((Object)voucherCustomField), qVoucherCustomFieldValue.owner().eq((Expression)p), customFieldValueForSearchDTO3});
            }
        }
        if (bl) {
            voucherOrderBy = (VoucherOrderBy)ObjectHelper.defaultValue((Object)generalVoucherQuery.getOrderBy(), (Object)VoucherOrderBy.CREATION_DATE_DESC);
            voucherCustomField = ((NumberExpression)new CaseBuilder().when((Predicate)VoucherServiceImpl.$.status.eq((Object)VoucherStatus.OPEN)).then((Number)1).when((Predicate)VoucherServiceImpl.$.status.eq((Object)VoucherStatus.PENDING)).then((Object)1).when((Predicate)VoucherServiceImpl.$.status.eq((Object)VoucherStatus.EXPIRED)).then((Object)2).otherwise((Object)3)).asc();
            switch (voucherOrderBy) {
                case CREATION_DATE_DESC: {
                    dBQuery.orderBy(new OrderSpecifier[]{VoucherServiceImpl.p.creationDate.desc(), VoucherServiceImpl.p.type().name.asc()});
                    break;
                }
                case CREATION_DATE_ASC: {
                    dBQuery.orderBy(new OrderSpecifier[]{VoucherServiceImpl.p.creationDate.asc(), VoucherServiceImpl.p.type().name.asc()});
                    break;
                }
                case EXPIRATION_DATE_DESC: {
                    dBQuery.orderBy(new OrderSpecifier[]{voucherCustomField, VoucherServiceImpl.$.expirationDate.coalesce(new Expression[]{VoucherServiceImpl.p.expirationDate}).desc(), VoucherServiceImpl.p.creationDate.desc(), VoucherServiceImpl.p.type().name.asc()});
                    break;
                }
                case EXPIRATION_DATE_ASC: {
                    dBQuery.orderBy(new OrderSpecifier[]{voucherCustomField, VoucherServiceImpl.$.expirationDate.coalesce(new Expression[]{VoucherServiceImpl.p.expirationDate}).asc(), VoucherServiceImpl.p.creationDate.asc(), VoucherServiceImpl.p.type().name.asc()});
                }
            }
        }
        return dBQuery;
    }

    private VoucherPack createPack(CreateVouchersDTO createVouchersDTO, User user, Payment payment) {
        boolean bl;
        Object object;
        SessionData sessionData = this.getSessionData();
        VoucherType voucherType = (VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)createVouchersDTO.getType());
        if (!voucherType.isEnabled()) {
            throw new IllegalActionException("The voucher type is disabled");
        }
        VoucherConfiguration voucherConfiguration = voucherType.getConfiguration();
        Date date = new Date();
        VoucherPack voucherPack = new VoucherPack();
        voucherPack.setType(voucherType);
        voucherPack.setRedeemOnWeekDays(voucherType.getRedeemOnWeekDays());
        voucherPack.setCreationDate(date);
        voucherPack.setRedeemAfterDate(this.redeemAfterDate(voucherType, date));
        voucherPack.setExpirationDate(this.expiration(voucherType));
        voucherPack.setBy((BasicUser)sessionData.getLoggedUser());
        voucherPack.setBuyer(user);
        voucherPack.setBuy(payment);
        voucherPack.setCount((Integer)ObjectHelper.defaultValue((Object)createVouchersDTO.getCount(), (Object)1));
        if (voucherConfiguration.getGenerationAmount() == VoucherGenerationAmount.GENERATION) {
            voucherPack.setAmount(createVouchersDTO.getAmount());
        }
        VoucherCreationType voucherCreationType = null;
        if (createVouchersDTO instanceof GenerateVouchersDTO) {
            voucherCreationType = VoucherCreationType.GENERATED;
            if (voucherConfiguration.getGenerationStatus() != VoucherGenerationStatus.ACTIVE && (object = voucherConfiguration.getActivationInterval()) != null) {
                voucherPack.setActivationDeadline(DateHelper.add((Date)voucherPack.getCreationDate(), (ITimeInterval)object));
            }
        } else if (createVouchersDTO instanceof SendVoucherDTO) {
            object = (SendVoucherDTO)createVouchersDTO;
            voucherPack.setSendMessage(object.getMessage());
            voucherCreationType = VoucherCreationType.SENT;
        } else if (createVouchersDTO instanceof BuyVouchersDTO) {
            object = (BuyVouchersDTO)createVouchersDTO;
            voucherCreationType = VoucherCreationType.BOUGHT;
            switch (voucherType.getGift()) {
                case ALWAYS: {
                    voucherPack.setGift(Boolean.valueOf(true));
                    break;
                }
                case CHOOSE: {
                    voucherPack.setGift(Boolean.valueOf(object.isGift()));
                    break;
                }
                case NEVER: {
                    voucherPack.setGift(Boolean.valueOf(false));
                }
            }
        }
        if (voucherCreationType == null) {
            throw new IllegalActionException();
        }
        voucherPack.setCreationType(voucherCreationType);
        object = this.resolveCustomFields(voucherType, voucherCreationType, VoucherCustomFieldUsage.CREATION, false, null);
        List list = sessionData.getProducts().product().getVisibleVoucherFields();
        this.customFieldValueHandler.setCustomValues((SimpleEntity)voucherPack, (Collection)object, (Collection)list, (Collection)createVouchersDTO.getCustomValues());
        this.persist((IEntity)voucherPack);
        boolean bl2 = bl = voucherPack.isGenerated() && voucherConfiguration.getGenerationStatus() == VoucherGenerationStatus.ACTIVE || voucherPack.isBought() && voucherConfiguration.isReserveAmount() && payment.isAuthorized();
        if (bl) {
            this.accountService.reserveAmountIfNeeded(voucherPack);
        }
        this.customFieldValueHandler.processAfterSave((EntityWithCustomValues)voucherPack);
        if (payment != null) {
            payment.setBoughtVoucherPack(voucherPack);
        }
        return voucherPack;
    }

    private DBQuery<? extends Object> createQuery(BasicVoucherQuery basicVoucherQuery) {
        return this.createQuery(basicVoucherQuery, true);
    }

    private DBQuery<? extends Object> createQuery(BasicVoucherQuery basicVoucherQuery, boolean bl) {
        if (basicVoucherQuery instanceof GeneralVoucherQuery) {
            return this.createGeneralQuery((GeneralVoucherQuery)basicVoucherQuery, bl);
        }
        if (basicVoucherQuery instanceof UserVoucherQuery) {
            return this.createUserQuery((UserVoucherQuery)basicVoucherQuery, bl);
        }
        throw new IllegalActionException("Unhandled voucher query: query");
    }

    private DBQuery<?> createUserQuery(UserVoucherQuery userVoucherQuery, boolean bl) {
        DecimalRange decimalRange;
        String string;
        DBQuery dBQuery = ((DBQuery)this.from(new EntityPath[]{$}).join((EntityPath)$.pack(), (Path)p)).innerFetchHint(new Path[]{$, $.pack()});
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userVoucherQuery.getUser());
        if (user == null) {
            dBQuery.where((Predicate)VoucherServiceImpl.$.id.isNull());
        } else {
            dBQuery.where((Predicate)p.buyer().eq((Object)user).or((Predicate)$.owner().eq((Object)user)));
        }
        List<VoucherConfiguration> list = this.resolveConfigurations(user, false, true);
        if (list.isEmpty()) {
            dBQuery.where((Predicate)VoucherServiceImpl.$.id.isNull());
        } else {
            dBQuery.where((Predicate)p.type().configuration().in(list));
        }
        Set set = this.conversionHandler.convertSet(VoucherType.class, (Iterable)userVoucherQuery.getTypes());
        if (!set.isEmpty()) {
            dBQuery.where((Predicate)p.type().in((Collection)set));
        }
        if ((string = StringHelper.trimToNull((Object)userVoucherQuery.getToken())) != null) {
            decimalRange = this.resolvePossibleUmaskedTokens(string, list);
            decimalRange.add((String)string);
            dBQuery.where((Predicate)VoucherServiceImpl.$.token.in((Collection)decimalRange));
        }
        if (CollectionHelper.isNotEmpty((Iterable)userVoucherQuery.getStatuses())) {
            dBQuery.where((Predicate)VoucherServiceImpl.$.status.in((Collection)userVoucherQuery.getStatuses()));
        }
        decimalRange = (DecimalRange)this.conversionHandler.convert(DecimalRange.class, (Object)userVoucherQuery.getAmountRange());
        dBQuery.where(VoucherServiceImpl.p.amount.range(decimalRange));
        VoucherCreationType voucherCreationType = userVoucherQuery.getCreationType();
        if (voucherCreationType != null) {
            dBQuery.where((Predicate)VoucherServiceImpl.p.creationType.eq((Object)voucherCreationType));
            if (voucherCreationType == VoucherCreationType.SENT) {
                dBQuery.where((Predicate)p.buyer().eq((Object)user));
            }
        }
        DatePeriod datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)userVoucherQuery.getCreationPeriod());
        dBQuery.where(VoucherServiceImpl.p.creationDate.period(datePeriod));
        DatePeriod datePeriod2 = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)userVoucherQuery.getExpirationPeriod());
        dBQuery.where(DateQueryExtensions.period((Expression)VoucherServiceImpl.$.expirationDate.coalesce(new Expression[]{VoucherServiceImpl.p.expirationDate}), (DatePeriod)datePeriod2));
        if (bl) {
            VoucherOrderBy voucherOrderBy = (VoucherOrderBy)ObjectHelper.defaultValue((Object)userVoucherQuery.getOrderBy(), (Object)VoucherOrderBy.CREATION_DATE_DESC);
            switch (voucherOrderBy) {
                case CREATION_DATE_ASC: {
                    dBQuery.orderBy(new OrderSpecifier[]{VoucherServiceImpl.p.creationDate.asc(), VoucherServiceImpl.$.id.asc()});
                    break;
                }
                case CREATION_DATE_DESC: {
                    dBQuery.orderBy(new OrderSpecifier[]{VoucherServiceImpl.p.creationDate.desc(), VoucherServiceImpl.$.id.desc()});
                    break;
                }
                case EXPIRATION_DATE_ASC: {
                    dBQuery.orderBy(new OrderSpecifier[]{VoucherServiceImpl.$.expirationDate.coalesce(new Expression[]{VoucherServiceImpl.p.expirationDate}).asc(), VoucherServiceImpl.$.id.asc()});
                    break;
                }
                case EXPIRATION_DATE_DESC: {
                    dBQuery.orderBy(new OrderSpecifier[]{VoucherServiceImpl.$.expirationDate.coalesce(new Expression[]{VoucherServiceImpl.p.expirationDate}).asc(), VoucherServiceImpl.$.id.desc()});
                }
            }
        }
        return dBQuery;
    }

    private VoucherPackWithIdsVO createVouchers(VoucherPack voucherPack, CreateVouchersDTO createVouchersDTO, User user) {
        int n = (Integer)ObjectHelper.defaultValue((Object)voucherPack.getCount(), (Object)1);
        ArrayList<Voucher> arrayList = new ArrayList<Voucher>(n);
        VoucherExtensionPointEvent voucherExtensionPointEvent = voucherPack.getCreationType() == VoucherCreationType.GENERATED ? VoucherExtensionPointEvent.GENERATE : VoucherExtensionPointEvent.BUY;
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)voucherExtensionPointEvent, new ExtensionPointFilter(voucherPack.getConfiguration()));
        VoucherStatus voucherStatus = this.getInitialStatus(voucherPack);
        VoucherType voucherType = voucherPack.getType();
        BigDecimal bigDecimal = voucherStatus == VoucherStatus.INACTIVE ? BigDecimal.ZERO : BigDecimalHelper.zeroWhenNull((BigDecimal)voucherPack.getAmount());
        for (int i = 0; i < n; ++i) {
            Voucher voucher = (Voucher)this.conversionHandler.convertExcluding(Voucher.class, (Object)voucherPack, new Object[]{"customValues"});
            voucher.setPack(voucherPack);
            if (voucherPack.isSent()) {
                voucher.setEmail(((SendVoucherDTO)createVouchersDTO).getEmail());
                voucher.setEnableNotifications(true);
            }
            voucher.setExpirationDate(null);
            voucher.setStatus(voucherStatus);
            voucher.setToken(this.generateToken(voucherType));
            this.assign(voucher, user, true, i == 0);
            voucher.setBalance(bigDecimal);
            if (voucherType.getConfiguration().getPinUsage().isEnabled()) {
                this.generatePin(voucher);
                if (createVouchersDTO instanceof BuyVouchersDTO && ((BuyVouchersDTO)createVouchersDTO).isGift()) {
                    voucher.setStatus(VoucherStatus.BLOCKED);
                }
            }
            extensionPointAccessor.attribute("voucher", (Object)voucher);
            extensionPointAccessor.fireValidated();
            voucherPack.getVouchers().add(voucher);
            arrayList.add(voucher);
            this.entityManagerHandler.persist((IEntity)voucher);
            extensionPointAccessor.fireSaved();
        }
        voucherPack.setVoucherTokens(arrayList.stream().map(Voucher::getToken).collect(Collectors.toList()));
        VoucherPackWithIdsVO voucherPackWithIdsVO = (VoucherPackWithIdsVO)this.conversionHandler.convert(VoucherPackWithIdsVO.class, (Object)voucherPack);
        voucherPackWithIdsVO.setVoucherStatus(voucherStatus);
        voucherPackWithIdsVO.setVoucherIds(SimpleEntity.uniqueIds(arrayList));
        return voucherPackWithIdsVO;
    }

    private VoucherPackWithIdsVO doBuyOrSend(BaseBuyVouchersDTO baseBuyVouchersDTO) {
        Payment payment;
        SendVoucherDTO sendVoucherDTO;
        ValidateBuyOrSendResult validateBuyOrSendResult = this.doValidateBuyOrSend(baseBuyVouchersDTO, true);
        VoucherType voucherType = validateBuyOrSendResult.type;
        boolean bl = Boolean.TRUE.equals(baseBuyVouchersDTO.getAttribute(IGNORE_CONFIRMATION));
        if (!bl) {
            if (baseBuyVouchersDTO instanceof SendVoucherDTO) {
                sendVoucherDTO = (SendVoucherDTO)baseBuyVouchersDTO;
                payment = SendVoucherConfirmationField.confirmation((BigDecimal)baseBuyVouchersDTO.getAmount(), (String)sendVoucherDTO.getEmail(), (VoucherTypeVO)new VoucherTypeVO(voucherType.getId()));
            } else {
                payment = BuyVouchersConfirmationField.confirmation((BigDecimal)baseBuyVouchersDTO.getAmount(), (Integer)validateBuyOrSendResult.count, (VoucherTypeVO)new VoucherTypeVO(voucherType.getId()));
            }
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(baseBuyVouchersDTO.getConfirmationPassword(), (CreateDeviceConfirmationParams)payment);
        }
        payment = this.paymentService.createForVoucherBuying(voucherType, validateBuyOrSendResult.buyer, validateBuyOrSendResult.totalAmount, baseBuyVouchersDTO.getPaymentCustomValues());
        sendVoucherDTO = this.createPack((CreateVouchersDTO)baseBuyVouchersDTO, validateBuyOrSendResult.buyer, payment);
        return this.createVouchers((VoucherPack)sendVoucherDTO, (CreateVouchersDTO)baseBuyVouchersDTO, validateBuyOrSendResult.owner);
    }

    private boolean doCancel(Voucher voucher, boolean bl, boolean bl2) {
        VoucherCancelAction voucherCancelAction;
        VoucherCancelAction voucherCancelAction2 = voucherCancelAction = bl2 ? null : this.cancelAction(voucher);
        if (bl || voucherCancelAction != null) {
            ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)VoucherExtensionPointEvent.CANCEL, new ExtensionPointFilter(voucher.getConfiguration()));
            extensionPointAccessor.attribute("voucher", (Object)voucher);
            extensionPointAccessor.attribute("previousStatus", (Object)voucher.getStatus());
            extensionPointAccessor.fireValidated();
            this.accountService.dereserveAmountIfNeeded(voucher);
            if (voucherCancelAction == VoucherCancelAction.CANCEL_AND_REFUND) {
                Payment payment = this.paymentService.refund(voucher);
                voucher.setRefund(payment);
            } else if (voucherCancelAction == VoucherCancelAction.CANCEL_AND_CHARGEBACK) {
                Payment payment = (Payment)voucher.getActivation().getTransaction();
                TransferActionDTO transferActionDTO = new TransferActionDTO();
                transferActionDTO.setAttribute("skipConfirmationPassword", (Object)true);
                transferActionDTO.setTransfer(new TransferVO(payment.getTransferId()));
                this.transferService.chargeback(transferActionDTO);
            }
            voucher.setBalance(BigDecimal.ZERO);
            voucher.setStatus(VoucherStatus.CANCELED);
            extensionPointAccessor.fireSaved();
            return true;
        }
        return false;
    }

    private void doExpire(Voucher voucher, boolean bl) {
        if (!voucher.getStatus().isExpirable()) {
            throw new IllegalActionException();
        }
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)VoucherExtensionPointEvent.EXPIRE, new ExtensionPointFilter(voucher.getConfiguration()));
        extensionPointAccessor.attribute("voucher", (Object)voucher);
        extensionPointAccessor.attribute("previousStatus", (Object)voucher.getStatus());
        extensionPointAccessor.fireValidated();
        this.accountService.dereserveAmountIfNeeded(voucher);
        voucher.setStatus(bl ? VoucherStatus.ACTIVATION_EXPIRED : VoucherStatus.EXPIRED);
        extensionPointAccessor.fireSaved();
    }

    private BuyVoucherData doGetBuyOrSendData(CreateVoucherDataParams createVoucherDataParams, VoucherCreationType voucherCreationType) {
        this.validate(createVoucherDataParams);
        User user = (User)this.conversionHandler.convert(User.class, (Object)createVoucherDataParams.getUser());
        BuyVoucherData buyVoucherData = new BuyVoucherData();
        buyVoucherData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        if (createVoucherDataParams.getType() != null) {
            VoucherType voucherType2 = (VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)createVoucherDataParams.getType());
            this.checkEnabledForBuying(voucherType2);
            Account account = this.accountService.load((InternalAccountOwner)user, voucherType2.getConfiguration().getBuyType().getFrom());
            this.fill((BasicVoucherData)buyVoucherData, voucherType2);
            buyVoucherData.setType((VoucherTypeDetailedVO)this.conversionHandler.convert(VoucherTypeDetailedVO.class, (Object)voucherType2));
            buyVoucherData.setAccount(this.accountService.toAccountWithStatus(account, null, null, false));
            buyVoucherData.setConfirmationPasswordInput(this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput());
            TransferTypeVO transferTypeVO = new TransferTypeVO(voucherType2.getConfiguration().getBuyType().getId());
            PerformPaymentTypeData performPaymentTypeData = this.transactionService.getPaymentTypeData((InternalAccountOwner)user, (InternalAccountOwner)SystemAccountOwner.instance(), transferTypeVO);
            BigDecimal bigDecimal = performPaymentTypeData.getFixedAmount();
            BigDecimal bigDecimal2 = voucherType2.getFixedBuyAmount();
            if (bigDecimal != null && bigDecimal2 != null && !bigDecimal.equals(bigDecimal2)) {
                throw new ValidationException(this.message(BankingKeys.Vouchers.BUY_ERROR_INCONSISTENT_FIXED_AMOUNT, new CurrencyAmount(voucherType2.getCurrency(), bigDecimal2), new CurrencyAmount(voucherType2.getCurrency(), bigDecimal)));
            }
            boolean bl = voucherType2.getMaxTotalBuy() != null && voucherType2.getMaxTotalBuy() == 1 || voucherType2.getMaxVouchersPerBuy() != null && voucherType2.getMaxVouchersPerBuy() == 1;
            buyVoucherData.setCanBuyMultiple(!bl && bigDecimal == null);
            buyVoucherData.setFixedAmount((BigDecimal)ObjectHelper.defaultValue((Object)bigDecimal2, (Object)bigDecimal));
            if (voucherType2.getMinBuyAmount() != null || voucherType2.getMaxBuyAmount() != null) {
                buyVoucherData.setAmountRange(ModelHelper.decimalRange((BigDecimal)voucherType2.getMinBuyAmount(), (BigDecimal)voucherType2.getMaxBuyAmount()));
            }
            buyVoucherData.setPaymentCustomFields(performPaymentTypeData.getCustomFields());
            buyVoucherData.setCustomFields(this.resolveCustomFieldVOs(null, voucherType2, voucherCreationType, VoucherCustomFieldUsage.CREATION, user));
        } else {
            List list;
            if (user == null) {
                list = Collections.emptyList();
            } else {
                Set set = this.productsHandler.getAccessor((BasicUser)user).member().getVouchers().keysSet((Path)VoucherServiceImpl.pmv.enable);
                List list2 = this.accountService.listVisible((InternalAccountOwner)user);
                Set set2 = list2.stream().map(Account::getCurrency).collect(Collectors.toSet());
                set.removeIf(voucherConfiguration -> !set2.contains(voucherConfiguration.getCurrency()));
                BooleanPath booleanPath = voucherCreationType == VoucherCreationType.SENT ? VoucherServiceImpl.pv.send : VoucherServiceImpl.pv.buy;
                Set set3 = this.voucherConfigurationService.resolveVoucherConfigurationPermissions(user).keysSet((Path)booleanPath);
                Collection collection = CollectionUtils.intersection((Iterable)set, (Iterable)set3);
                list = this.voucherTypeService.listEnabledByConfiguration(collection, Boolean.valueOf(true));
                list.removeIf(voucherType -> {
                    if (!this.isBuyAllowed((VoucherType)voucherType)) {
                        return true;
                    }
                    Set set = voucherType.getBuyAllowedGroups();
                    if (CollectionHelper.isNotEmpty((Iterable)set)) {
                        return !this.groupsHandler.flatten((Collection)set).contains(user.getGroup());
                    }
                    return false;
                });
            }
            this.fillData((BasicCreateVoucherData)buyVoucherData, list);
        }
        return buyVoucherData;
    }

    private void doNotify(Voucher voucher, Supplier<String> supplier, Supplier<String> supplier2, Supplier<String> supplier3) {
        if (voucher.getEmail() != null) {
            this.mailHandler.send(null, voucher.getEmail(), supplier.get(), supplier2.get(), new FileInfo[0]);
        }
        if (voucher.getMobilePhone() != null) {
            this.sendSms(voucher, null, supplier3.get());
        }
    }

    private BuyVoucherPreviewVO doPreviewBuyOrSend(BaseBuyVouchersDTO baseBuyVouchersDTO) {
        ValidateBuyOrSendResult validateBuyOrSendResult = this.doValidateBuyOrSend(baseBuyVouchersDTO, false);
        VoucherType voucherType = validateBuyOrSendResult.type;
        baseBuyVouchersDTO.setType(new VoucherTypeVO(voucherType.getId()));
        PaymentPreviewVO paymentPreviewVO = this.paymentService.previewVoucherBuying(voucherType, validateBuyOrSendResult.buyer, validateBuyOrSendResult.totalAmount, baseBuyVouchersDTO.getPaymentCustomValues());
        BuyVoucherPreviewVO buyVoucherPreviewVO = new BuyVoucherPreviewVO();
        buyVoucherPreviewVO.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)validateBuyOrSendResult.buyer));
        buyVoucherPreviewVO.setType((VoucherTypeDetailedVO)this.conversionHandler.convert(VoucherTypeDetailedVO.class, (Object)voucherType));
        buyVoucherPreviewVO.setPaymentPreview(paymentPreviewVO);
        buyVoucherPreviewVO.setParams(baseBuyVouchersDTO);
        buyVoucherPreviewVO.setTotalAmount(validateBuyOrSendResult.totalAmount);
        buyVoucherPreviewVO.setOwner((UserVO)this.conversionHandler.convert(UserVO.class, (Object)validateBuyOrSendResult.owner));
        buyVoucherPreviewVO.setConfirmationPasswordInput(this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput());
        return buyVoucherPreviewVO;
    }

    private ValidateBuyOrSendResult doValidateBuyOrSend(BaseBuyVouchersDTO baseBuyVouchersDTO, boolean bl) {
        Comparable<Date> comparable;
        boolean bl2 = Boolean.TRUE.equals(baseBuyVouchersDTO.getAttribute(IGNORE_CONFIRMATION));
        this.validate((CreateVouchersDTO)baseBuyVouchersDTO, bl && !bl2);
        ValidateBuyOrSendResult validateBuyOrSendResult = new ValidateBuyOrSendResult();
        validateBuyOrSendResult.type = (VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)baseBuyVouchersDTO.getType());
        this.checkEnabledForBuying(validateBuyOrSendResult.type);
        validateBuyOrSendResult.buyer = (User)this.conversionHandler.convert(User.class, (Object)baseBuyVouchersDTO.getUser());
        if (!this.allowBuying(validateBuyOrSendResult.type, validateBuyOrSendResult.buyer)) {
            throw new BuyingNotAllowedForUserException();
        }
        Currency currency = validateBuyOrSendResult.type.getConfiguration().getCurrency();
        validateBuyOrSendResult.count = baseBuyVouchersDTO.getCount();
        validateBuyOrSendResult.totalAmount = BigDecimalHelper.round((BigDecimal)baseBuyVouchersDTO.getAmount().multiply(new BigDecimal(validateBuyOrSendResult.count)), (int)currency.getPrecision());
        BigDecimal bigDecimal = validateBuyOrSendResult.type.getMaxOpenAmountPerUser();
        if (BigDecimalHelper.isPositive((BigDecimal)bigDecimal)) {
            if (bl) {
                this.lockHandler.lock(LockType.VOUCHER_BUYING.key(validateBuyOrSendResult.buyer.getId()));
            }
            if (((BigDecimal)(comparable = BigDecimalHelper.zeroWhenNull((BigDecimal)((BigDecimal)((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.pack().type().eq((Object)validateBuyOrSendResult.type), $.pack().buyer().eq((Object)validateBuyOrSendResult.buyer), VoucherServiceImpl.$.status.in((Object[])VoucherStatus.getActuallyOpenStatuses())})).singleResult((Expression)VoucherServiceImpl.$.pack().amount.sum()))))).add(validateBuyOrSendResult.totalAmount).compareTo(bigDecimal) > 0) {
                CurrencyVO currencyVO = (CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)currency);
                CurrencyAmountDTO currencyAmountDTO = ModelHelper.currencyAmount((CurrencyVO)currencyVO, comparable);
                CurrencyAmountDTO currencyAmountDTO2 = ModelHelper.currencyAmount((CurrencyVO)currencyVO, (BigDecimal)bigDecimal);
                throw new BuyingMaxOpenAmountException(currencyAmountDTO, currencyAmountDTO2);
            }
        }
        this.checkMaxTotalOpenAmount(validateBuyOrSendResult.type, validateBuyOrSendResult.totalAmount);
        this.licenseHandler.checkNewVouchers(validateBuyOrSendResult.count);
        if (validateBuyOrSendResult.type.isLimitBuyAmountPerPeriod()) {
            BigDecimal bigDecimal2;
            BigDecimal bigDecimal3;
            if (bl) {
                this.lockHandler.lock(LockType.VOUCHER_TYPE.key(validateBuyOrSendResult.type.getId()));
            }
            comparable = new Date();
            boolean bl3 = false;
            TimeZone timeZone = this.configurationHandler.getAccessor(validateBuyOrSendResult.type.getNetwork()).getTimeZone();
            DatePeriod datePeriod = validateBuyOrSendResult.type.getMaxBuyAmountActualPeriod();
            if (datePeriod.getEnd().before((Date)comparable)) {
                datePeriod = DatePeriod.periodIncluding((ITimeInterval)validateBuyOrSendResult.type.getMaxBuyAmountPeriod(), (TimeZone)timeZone, (Date)comparable);
                bl3 = true;
            }
            if (bl3 && bl) {
                validateBuyOrSendResult.type.setMaxBuyAmountActualPeriod(datePeriod);
                validateBuyOrSendResult.type.setMaxBuyAmountActualSum(null);
            }
            if ((bigDecimal3 = validateBuyOrSendResult.type.getMaxBuyAmountActualSum()) == null) {
                bigDecimal3 = this.sumBuys(validateBuyOrSendResult.type, validateBuyOrSendResult.type.getMaxBuyAmountActualPeriod());
                if (bl) {
                    validateBuyOrSendResult.type.setMaxBuyAmountActualSum(bigDecimal3);
                }
            }
            if ((bigDecimal2 = validateBuyOrSendResult.type.getMaxBuyAmountPerPeriod().subtract(bigDecimal3)).compareTo(validateBuyOrSendResult.totalAmount) < 0) {
                Date date = DateHelper.add((Date)datePeriod.getEnd(), (TimeField)TimeField.MILLIS, (int)1);
                CurrencyVO currencyVO = (CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)currency);
                BigDecimal bigDecimal4 = BigDecimalHelper.round((BigDecimal)(BigDecimalHelper.isNegative((BigDecimal)bigDecimal2) ? BigDecimal.ZERO : bigDecimal2), (int)currency.getPrecision());
                throw new BuyingMaxAmountReachedForPeriodException(ModelHelper.currencyAmount((CurrencyVO)currencyVO, (BigDecimal)bigDecimal4), this.conversionHandler.toDateTime(date));
            }
            if (bl) {
                validateBuyOrSendResult.type.setMaxBuyAmountActualSum(bigDecimal3.add(validateBuyOrSendResult.totalAmount));
            }
        }
        if (baseBuyVouchersDTO instanceof SendVoucherDTO) {
            validateBuyOrSendResult.owner = this.findOwner((PrincipalType)this.principalTypeService.getEmail(), ((SendVoucherDTO)baseBuyVouchersDTO).getEmail());
        }
        return validateBuyOrSendResult;
    }

    private Date expiration(VoucherType voucherType) {
        if (voucherType.getExpirationType() == VoucherExpirationType.FIXED_DATE) {
            return voucherType.getExpirationDate();
        }
        Date date = DateHelper.add((Date)new Date(), (ITimeInterval)voucherType.getExpirationInterval());
        return voucherType.getExpirationInterval().getField().equals((Object)TimeField.HOURS) ? date : DateHelper.shiftToEnd((Date)date, (TimeZone)this.getSessionData().getConfiguration().getTimeZone());
    }

    private void fill(BasicVoucherData basicVoucherData, VoucherPack voucherPack) {
        if (!(basicVoucherData instanceof VoucherData)) {
            basicVoucherData.setType((VoucherTypeDetailedVO)this.conversionHandler.convert(VoucherTypeDetailedVO.class, (Object)voucherPack.getType()));
        }
    }

    private void fill(BasicVoucherData basicVoucherData, VoucherType voucherType) {
        if (!(basicVoucherData instanceof VoucherData)) {
            basicVoucherData.setType((VoucherTypeDetailedVO)this.conversionHandler.convert(VoucherTypeDetailedVO.class, (Object)voucherType));
            BasicCreateVoucherData basicCreateVoucherData = (BasicCreateVoucherData)basicVoucherData;
            basicCreateVoucherData.setRedeemOnWeekDays(CollectionHelper.sort((Collection)voucherType.getRedeemOnWeekDays()));
            basicCreateVoucherData.setMinimumTimeToRedeem((TimeIntervalDTO)this.conversionHandler.convert(TimeIntervalDTO.class, (Object)voucherType.getMinimumTimeToRedeem()));
            if (voucherType.getMinimumTimeToRedeem() != null) {
                basicCreateVoucherData.setRedeemAfterDate(this.conversionHandler.toDateTime(this.redeemAfterDate(voucherType, new Date())));
            }
            basicCreateVoucherData.setExpirationDate(this.conversionHandler.toDateTime(this.expiration(voucherType)));
        }
    }

    private void fill(VoucherTransactionNature voucherTransactionNature, PerformVoucherTransactionData performVoucherTransactionData, Voucher voucher, User user) {
        this.fill((BasicVoucherData)performVoucherTransactionData, voucher.getPack());
        performVoucherTransactionData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        performVoucherTransactionData.setToken(MaskHelper.applyMask((String)voucher.getConfiguration().getMask(), (String)voucher.getToken()));
        BigDecimal bigDecimal = voucher.getPack().getAmount();
        if (bigDecimal != null) {
            performVoucherTransactionData.setAmount(BigDecimalHelper.round((BigDecimal)bigDecimal, (int)voucher.getCurrency().getPrecision()));
        }
        SystemAccountOwner systemAccountOwner = voucherTransactionNature == VoucherTransactionNature.REDEEM ? SystemAccountOwner.instance() : user;
        User user2 = voucherTransactionNature == VoucherTransactionNature.REDEEM ? user : SystemAccountOwner.instance();
        PaymentTransferType paymentTransferType = voucherTransactionNature == VoucherTransactionNature.REDEEM ? voucher.getConfiguration().getRedeemType() : voucher.getConfiguration().getTopUpType();
        PerformPaymentTypeData performPaymentTypeData = this.transactionService.getPaymentTypeData((InternalAccountOwner)systemAccountOwner, (InternalAccountOwner)user2, new TransferTypeVO(paymentTransferType.getId()));
        performVoucherTransactionData.setPaymentCustomFields(performPaymentTypeData.getCustomFields());
        performVoucherTransactionData.setShouldPreview(bigDecimal == null || CollectionHelper.isNotEmpty((Iterable)performVoucherTransactionData.getPaymentCustomFields()));
    }

    private void fill(VoucherTransactionPreviewVO voucherTransactionPreviewVO, Voucher voucher, User user, BigDecimal bigDecimal, PerformVoucherTransactionDTO performVoucherTransactionDTO) {
        voucherTransactionPreviewVO.setType((VoucherTypeDetailedVO)this.conversionHandler.convert(VoucherTypeDetailedVO.class, (Object)voucher.getType()));
        voucherTransactionPreviewVO.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        String string = MaskHelper.applyMask((String)voucher.getConfiguration().getMask(), (String)voucher.getToken());
        voucherTransactionPreviewVO.setToken(string);
        voucherTransactionPreviewVO.setAmount(bigDecimal);
        performVoucherTransactionDTO.setToken(string);
        performVoucherTransactionDTO.setAmount(bigDecimal);
        this.customFieldValueHandler.resolveValues(TransactionCustomField.class, (Collection)performVoucherTransactionDTO.getPaymentCustomValues());
    }

    private void fillData(BasicCreateVoucherData basicCreateVoucherData, List<VoucherType> list) {
        List list2 = CollectionHelper.sort((Collection)list.stream().map(VoucherType::getCategory).filter(Objects::nonNull).collect(Collectors.toSet()));
        basicCreateVoucherData.setCategories(this.conversionHandler.convertList(VoucherCategoryVO.class, (Iterable)list2));
        basicCreateVoucherData.setTypes(this.conversionHandler.convertList(VoucherTypeDetailedVO.class, list));
    }

    private Voucher findForRedeeming(VoucherTransactionDataParams voucherTransactionDataParams, User user) {
        WeekDay weekDay;
        Object object;
        Object object2;
        Object object3;
        Voucher voucher;
        Validator validator = new Validator();
        validator.property((org.cyclos.model.Property)VoucherTransactionDataParams.TOKEN, BankingKeys.Vouchers.TOKEN).required();
        this.validate(validator, voucherTransactionDataParams, "findForRedeeming");
        Date date = new Date();
        String string = voucherTransactionDataParams.getToken();
        try {
            voucher = this.findByToken(string, this.voucherConfigurationService.listVisible(user, true, false));
            this.failedActionHandler.clearUserFailures(FailedAction.FAILED_VOUCHER_REDEEM, null);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            boolean bl;
            User user2 = this.getLoggedUser();
            if (user2 != null && (bl = this.failedActionHandler.recordAndBlockUserIfMaxReached(FailedAction.FAILED_VOUCHER_REDEEM, null, Integer.valueOf(20), UserAlertType.MAX_VOUCHER_REDEEM_ATTEMPTS_REACHED))) {
                throw new RedeemingUserBlockedException();
            }
            throw entityNotFoundException;
        }
        VoucherType voucherType = voucher.getType();
        VoucherPack voucherPack = voucher.getPack();
        if (!voucher.isOpen()) {
            throw new RedeemingNotAllowedForVoucherException(voucher.getStatus());
        }
        if (date.after(voucher.getExpirationDate())) {
            throw new RedeemingNotAllowedForVoucherException(VoucherStatus.EXPIRED);
        }
        VoucherRedeemRestrictTo voucherRedeemRestrictTo = voucherType.getRedeemRestrict();
        boolean bl = false;
        switch (voucherRedeemRestrictTo) {
            case ALL: {
                bl = true;
                break;
            }
            case SPECIFIC_USERS: {
                bl = voucherType.getRedeemAllowedUsers().contains(user);
                break;
            }
            case SPECIFIC_GROUPS: {
                object3 = user.getGroup();
                object2 = object3 instanceof UserGroup ? ((UserGroup)object3).getGroupSet() : null;
                object = voucherType.getRedeemAllowedGroups();
                boolean bl2 = bl = object.contains(object3) || object.contains(object2);
            }
        }
        if (!bl) {
            throw new RedeemingNotAllowedForUserException();
        }
        object3 = voucherPack.getRedeemAfterDate();
        if (date.before((Date)object3)) {
            object2 = this.conversionHandler.toDateTime((Date)object3);
            throw new RedeemingNotAllowedYetException((DateTime)object2);
        }
        object2 = voucherPack.getRedeemOnWeekDays();
        if (CollectionHelper.size((Collection)object2) > 0 && !object2.contains(weekDay = WeekDay.fromCalendar((int)((Calendar)(object = Calendar.getInstance(this.getConfiguration().getTimeZone()))).get(7)))) {
            throw new RedeemingNotAllowedTodayException(new ArrayList(object2));
        }
        return voucher;
    }

    private Voucher findForTopUp(VoucherTransactionDataParams voucherTransactionDataParams, User user) {
        Date date;
        Validator validator = new Validator();
        validator.property((org.cyclos.model.Property)VoucherTransactionDataParams.TOKEN, BankingKeys.Vouchers.TOKEN).required();
        this.validate(validator, voucherTransactionDataParams, "findForTopUp");
        Voucher voucher = this.findByToken(voucherTransactionDataParams.getToken(), this.voucherConfigurationService.listVisible(user, true, false));
        VoucherType voucherType = voucher.getType();
        VoucherConfiguration voucherConfiguration = voucher.getConfiguration();
        if (voucherConfiguration.getGenerationStatus() != VoucherGenerationStatus.INACTIVE || voucher.getStatus() == VoucherStatus.OPEN && voucherConfiguration.getGenerationAmount() != VoucherGenerationAmount.DYNAMIC) {
            throw new VoucherAlreadyActivatedException();
        }
        if (!ObjectHelper.isOneOf((Object)voucher.getStatus(), (Object[])new Object[]{VoucherStatus.INACTIVE, VoucherStatus.OPEN})) {
            throw new TopUpNotAllowedForVoucherException(voucher.getStatus());
        }
        if (voucher.getStatus() == VoucherStatus.INACTIVE && (date = DateHelper.add((Date)voucher.getPack().getCreationDate(), (ITimeInterval)voucherConfiguration.getActivationInterval())).before(new Date())) {
            throw new VoucherActivationExpiredException(this.conversionHandler.toDateTime(date));
        }
        if (voucherType.getExpirationType() == VoucherExpirationType.FIXED_DATE && (date = voucherType.getExpirationDate()).before(new Date())) {
            throw new VoucherActivationExpiredException(this.conversionHandler.toDateTime(date));
        }
        return voucher;
    }

    private User findOwner(PrincipalType principalType, String string) {
        String string2 = StringHelper.trimToNull((Object)string);
        if (string2 == null || principalType == null) {
            return null;
        }
        return (User)this.invokerHandler.runAs(SessionDataFactory.system(), () -> {
            UserLocatorVO userLocatorVO = ModelHelper.userLocator((String)string2, (boolean)false);
            try {
                LocateUserResult locateUserResult = this.userLocatorHandler.locate(userLocatorVO, Collections.emptySet(), Collections.singleton(principalType), principalType);
                BasicUser basicUser = locateUserResult.getBasicUser();
                return basicUser.isMember() && !basicUser.isOperator() && (basicUser.isActive() || basicUser.isBlocked()) ? basicUser.getUser() : null;
            }
            catch (LocateUserException locateUserException) {
                return null;
            }
        });
    }

    private Pair<CaptchaInputDTO, List<SendMedium>> forgotPinInfo(Voucher voucher) {
        if (StringHelper.areNotAllBlanks((Object[])new Object[]{voucher.getEmail(), voucher.getMobilePhone()})) {
            CaptchaInputDTO captchaInputDTO = (CaptchaInputDTO)this.conversionHandler.convert(CaptchaInputDTO.class, (Object)this.getSessionData().getConfiguration().getCaptchaConfiguration());
            ArrayList<SendMedium> arrayList = new ArrayList<SendMedium>();
            if (StringHelper.isNotBlank((Object)voucher.getEmail())) {
                arrayList.add(SendMedium.EMAIL);
            }
            if (StringHelper.isNotBlank((Object)voucher.getMobilePhone())) {
                arrayList.add(SendMedium.SMS);
            }
            return Pair.create((Object)captchaInputDTO, arrayList);
        }
        return Pair.create(null, null);
    }

    private String generatePin(Voucher voucher) {
        String string = null;
        if (StringHelper.isBlank((Object)voucher.getPin())) {
            string = StringHelper.randomNumeric((int)voucher.getConfiguration().getPinLength());
            voucher.setPin(string);
        }
        return string;
    }

    private String generateToken(VoucherType voucherType) {
        String string = voucherType.getConfiguration().getMask();
        for (int i = 0; i < 50; ++i) {
            String string2 = MaskHelper.generateValue((String)string);
            try {
                this.findByToken(string2, Collections.singleton(voucherType.getConfiguration()));
                continue;
            }
            catch (EntityNotFoundException entityNotFoundException) {
                return string2;
            }
        }
        throw new IllegalStateException("Could not generate a token value for mask " + string);
    }

    private String getAccountName(VoucherType voucherType) {
        String string = this.dataTranslationHandler.getValue((BaseEntity)voucherType, QVoucherType.voucherType.accountName);
        if (string == null) {
            string = this.dataTranslationHandler.getValue((BaseEntity)voucherType.getConfiguration(), QVoucherConfiguration.voucherConfiguration.accountName);
        }
        return string;
    }

    private String getBoughtDescription(VoucherType voucherType, String string, List<String> list) {
        String string2 = this.dataTranslationHandler.getValue((BaseEntity)voucherType, QVoucherType.voucherType.voucherTitle);
        if (string != null) {
            String string3 = StringHelper.maskDigits((String)MaskHelper.applyMask((String)voucherType.getConfiguration().getMask(), (String)((String)CollectionHelper.first(list))), (int)4);
            return this.message(BankingKeys.Vouchers.DESCRIPTION_SENT, string3, string2, string);
        }
        if (list.size() == 1) {
            String string4 = MaskHelper.applyMask((String)voucherType.getConfiguration().getMask(), (String)((String)CollectionHelper.first(list)));
            return this.message(BankingKeys.Vouchers.DESCRIPTION_BOUGHT_SINGLE, string4, string2);
        }
        return this.message(BankingKeys.Vouchers.DESCRIPTION_BOUGHT_MULTIPLE, list.size(), string2);
    }

    private VoucherStatus getBoughtVoucherStatus(VoucherPack voucherPack) {
        Payment payment = voucherPack.getBuy();
        if (payment == null) {
            throw new IllegalArgumentException("Expected voucher pack to have a buy transaction");
        }
        switch ((TransactionAuthorizationStatus)ObjectHelper.defaultValue((Object)payment.getAuthorizationStatus(), (Object)TransactionAuthorizationStatus.NA)) {
            case AUTHORIZATION_CANCELED: 
            case AUTHORIZATION_DENIED: 
            case AUTHORIZATION_EXPIRED: {
                return VoucherStatus.CANCELED;
            }
            case PENDING_AUTHORIZATION: {
                return VoucherStatus.PENDING;
            }
            case AUTHORIZED: 
            case NA: {
                if (Boolean.TRUE.equals(voucherPack.getGift()) && voucherPack.getConfiguration().getPinUsage() != VoucherPinUsage.NEVER) {
                    return VoucherStatus.BLOCKED;
                }
                return VoucherStatus.OPEN;
            }
        }
        throw new IllegalArgumentException();
    }

    private <T> T getIfSmsConfigIsEnabled(ConfigurationAccessor configurationAccessor, Supplier<T> supplier) {
        OutboundSmsConfiguration outboundSmsConfiguration = configurationAccessor.getOutboundSmsConfiguration();
        if (outboundSmsConfiguration != null && outboundSmsConfiguration.isEnabled()) {
            return supplier.get();
        }
        return null;
    }

    private <T> T getIfSmsEnabled(Voucher voucher, Function<ConfigurationAccessor, T> function) {
        if (!this.supportsNotifications(voucher) || voucher.getPack().isSent()) {
            return null;
        }
        User user = voucher.getOwnerOrBuyer();
        ConfigurationAccessor configurationAccessor = user == null ? this.getConfiguration() : this.configurationHandler.getAccessAccessor((BasicUser)user);
        return (T)this.getIfSmsConfigIsEnabled(configurationAccessor, () -> function.apply(configurationAccessor));
    }

    private VoucherStatus getInitialStatus(VoucherPack voucherPack) {
        if (voucherPack.isGenerated()) {
            return voucherPack.getType().getConfiguration().getGenerationStatus().generatedVoucherStatus();
        }
        return this.getBoughtVoucherStatus(voucherPack);
    }

    private InitialVoucherUserData getInitialUserData(UserLocatorVO userLocatorVO, BooleanPath booleanPath) {
        InitialVoucherUserData initialVoucherUserData = new InitialVoucherUserData();
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        BooleanPropertiesHolder booleanPropertiesHolder = this.voucherConfigurationService.resolveVoucherConfigurationPermissions(user);
        Set set = booleanPropertiesHolder.keysSet((Path)booleanPath);
        initialVoucherUserData.setMask(this.resolveMask(set));
        initialVoucherUserData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        return initialVoucherUserData;
    }

    private PhoneConfigurationData getPhoneConfigurationIfSupported(ConfigurationAccessor configurationAccessor) {
        return this.getIfSmsConfigIsEnabled(configurationAccessor, () -> this.configurationService.toPhoneConfiguration(configurationAccessor));
    }

    private PhoneConfigurationData getPhoneConfigurationIfSupported(Voucher voucher) {
        return this.getIfSmsEnabled(voucher, configurationAccessor -> this.configurationService.toPhoneConfiguration(configurationAccessor));
    }

    private String getRedeemDescription(VoucherType voucherType) {
        return this.message(BankingKeys.Vouchers.DESCRIPTION_REDEEM, voucherType);
    }

    private String getTopUpDescription(VoucherType voucherType) {
        return this.message(BankingKeys.Vouchers.DESCRIPTION_TOP_UP, voucherType);
    }

    private Object[] getTransactionExcludes(VoucherTransactionsVisibility voucherTransactionsVisibility) {
        if (voucherTransactionsVisibility == VoucherTransactionsVisibility.PARTIAL) {
            return new Object[]{VoucherTransactionVO.USER, VoucherTransactionVO.BY};
        }
        return ArrayUtils.EMPTY_OBJECT_ARRAY;
    }

    private User getVoucherUserToNotify(Voucher voucher) {
        if (voucher.getOwner() != null) {
            return voucher.getOwner();
        }
        if (!Boolean.TRUE.equals(voucher.getPack().getGift()) && voucher.getPack().getCreationType() == VoucherCreationType.BOUGHT) {
            return voucher.getPack().getBuyer();
        }
        return null;
    }

    private boolean hasTransactions(Voucher voucher) {
        return ((DBQuery)this.from(new EntityPath[]{t}).where((Predicate)t.voucher().eq((Object)voucher))).hasResults();
    }

    private String infoLink(Voucher voucher) {
        if (!voucher.getConfiguration().isShowPlainToken()) {
            return "";
        }
        return this.message(MessageFormat.HTML, ContentManagementKeys.Emails.VOUCHER_INFO_LINK, this.linkGeneratorHandler.voucherInfo(voucher));
    }

    private boolean isBacked(Voucher voucher) {
        VoucherPack voucherPack = voucher.getPack();
        if (voucherPack.isBought()) {
            Payment payment = voucherPack.getBuy();
            return payment != null && payment.isAuthorized();
        }
        VoucherConfiguration voucherConfiguration = voucher.getConfiguration();
        switch (voucherConfiguration.getGenerationStatus()) {
            case ACTIVE: {
                return true;
            }
            case BLOCKED: {
                return voucher.getUnblockAmountReservation() != null || voucherConfiguration.getRedeemType().getFrom().getLimitType() == AccountTypeLimitType.UNLIMITED;
            }
            case INACTIVE: {
                return voucher.getActivation() != null;
            }
        }
        throw new IllegalStateException("Unhandled generation status");
    }

    private boolean isBuyAllowed(VoucherType voucherType) {
        if (!voucherType.isAllowBuying() || !voucherType.isEnabled()) {
            return false;
        }
        Date date = voucherType.getBuyUntilDate();
        if (date != null && date.before(new Date())) {
            return false;
        }
        if (voucherType.isLimitBuyAmountPerPeriod()) {
            Date date2;
            BigDecimal bigDecimal = voucherType.getMaxBuyAmountActualSum();
            if (bigDecimal == null) {
                bigDecimal = this.sumBuys(voucherType, voucherType.getMaxBuyAmountActualPeriod());
            }
            if ((date2 = voucherType.getMaxBuyAmountActualPeriod().getEnd()).after(new Date()) && bigDecimal.compareTo(voucherType.getMaxBuyAmountPerPeriod()) >= 0) {
                return false;
            }
        }
        return true;
    }

    private boolean isTopupEnabled(User user) {
        User user2 = this.getLoggedUser();
        boolean bl = user == null || user.equals((Object)user2) ? this.voucherConfigurationService.listVisible(user).stream().anyMatch(voucherConfiguration -> voucherConfiguration.getTopUpType() != null) : CollectionUtils.intersection((Iterable)this.voucherConfigurationService.listEnabled(user), (Iterable)this.voucherConfigurationService.listVisible(user2)).stream().anyMatch(voucherConfiguration -> voucherConfiguration.getTopUpType() != null);
        return bl;
    }

    private void lockForTransaction(Voucher voucher) {
        this.lockHandler.lock(LockType.VOUCHER.key(voucher.getId()));
        this.entityManagerHandler.refresh((IEntity)voucher);
    }

    private CloseableIterator<Voucher> markEachAsPrinted(CloseableIterator<Voucher> closeableIterator) {
        return new TransformedCloseableIterator(closeableIterator, voucher -> {
            voucher.setPrinted(true);
            return voucher;
        });
    }

    private void notify(Voucher voucher, Supplier<String> supplier, Supplier<String> supplier2, Supplier<String> supplier3) {
        if (voucher.isEnableNotifications()) {
            this.doNotify(voucher, supplier, supplier2, supplier3);
        }
    }

    private void notifyOwnerOrBuyer(Voucher voucher, Consumer<AccountNotificationsHandler> consumer) {
        User user = voucher.getOwnerOrBuyer();
        if (user != null) {
            consumer.accept(this.notificationHandler.user((BasicUser)user).account());
        }
    }

    private Object ofAmount(Voucher voucher) {
        CurrencyAmount currencyAmount = voucher.getCurrencyAmount();
        return currencyAmount == null ? "" : new TranslationMessageSpecification(MessagingKeys.Notifications.OF_AMOUNT, new Object[]{currencyAmount});
    }

    private void onVoucherPinBlocked(Voucher voucher, User user) {
        if (voucher.getPinBlockedUntil() != null) {
            return;
        }
        Object object = ObjectHelper.defaultValue((Object)user, (Object)this.linkGeneratorHandler.voucherInfo(voucher));
        voucher.setPinBlockedUntil(DateHelper.add((Date)new Date(), (ITimeInterval)TimeInterval.ONE_DAY));
        if (this.supportsNotifications(voucher)) {
            Object object2 = this.ofAmount(voucher);
            this.notify(voucher, () -> this.message(ContentManagementKeys.Emails.VOUCHER_PIN_BLOCKED_SUBJECT, object2), () -> this.message(ContentManagementKeys.Emails.VOUCHER_PIN_BLOCKED_MESSAGE, object2, object), () -> this.message(MessagingKeys.Notifications.SMS_VOUCHER_PIN_BLOCKED, object2, object));
        } else if (voucher.getPack().isBought()) {
            this.notifyOwnerOrBuyer(voucher, accountNotificationsHandler -> accountNotificationsHandler.voucherPinBlocked(voucher, voucher.getCurrencyAmount(), voucher.getType(), object));
        }
    }

    private CredentialInputDTO pinInput(Voucher voucher) {
        if (!this.usePin(voucher)) {
            return null;
        }
        CredentialInputDTO credentialInputDTO = new CredentialInputDTO();
        credentialInputDTO.setPasswordType(this.pinType(voucher));
        credentialInputDTO.setAllowedCredentials(Collections.singletonList(CredentialType.PASSWORD));
        credentialInputDTO.setActiveCredentials(voucher.getPin() != null ? Collections.singletonList(CredentialType.PASSWORD) : Collections.emptyList());
        return credentialInputDTO;
    }

    private PasswordTypeDetailedVO pinType(Voucher voucher) {
        Integer n;
        String string = voucher.getPin();
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        int n2 = string.length();
        IntegerRangeDTO integerRangeDTO = ModelHelper.integerRange((Integer)(n2 < (n = voucher.getConfiguration().getPinLength()) ? n2 : n), (Integer)(n2 <= n ? n : n2));
        PasswordTypeDetailedVO passwordTypeDetailedVO = new PasswordTypeDetailedVO();
        passwordTypeDetailedVO.setName(this.message(BankingKeys.Vouchers.PIN, new Object[0]));
        passwordTypeDetailedVO.setInternalName("voucherPin");
        passwordTypeDetailedVO.setPasswordMode(PasswordMode.MANUAL);
        passwordTypeDetailedVO.setInputMethod(PasswordInputMethod.TEXT_BOX);
        passwordTypeDetailedVO.setLength(integerRangeDTO);
        passwordTypeDetailedVO.setOnlyNumeric(true);
        return passwordTypeDetailedVO;
    }

    private BigDecimal prepareRedeem(boolean bl, RedeemVoucherDTO redeemVoucherDTO, User user, Voucher voucher) {
        PasswordTypeDetailedVO passwordTypeDetailedVO;
        BigDecimal bigDecimal = voucher.getBalance();
        BigDecimal bigDecimal2 = BigDecimalHelper.round((BigDecimal)redeemVoucherDTO.getAmount(), (int)voucher.getCurrency().getPrecision());
        if (bigDecimal2 == null) {
            bigDecimal2 = bigDecimal;
        }
        boolean bl2 = !bl && this.requiresPinForRedeem(voucher);
        Validator validator = new Validator();
        if (bl2) {
            passwordTypeDetailedVO = this.pinType(voucher);
            validator.property((org.cyclos.model.Property)RedeemVoucherDTO.PIN, BankingKeys.Vouchers.PIN).required().length((IIntegerRange)passwordTypeDetailedVO.getLength()).regex("\\d+");
        }
        passwordTypeDetailedVO = validator.property((org.cyclos.model.Property)RedeemVoucherDTO.AMOUNT, BankingKeys.Vouchers.TRANSACTION_AMOUNT);
        if (voucher.getType().isAllowPartialRedeems()) {
            passwordTypeDetailedVO.positiveNonZero((HasCurrency)voucher);
        } else {
            passwordTypeDetailedVO.anyOf(new Object[]{bigDecimal});
        }
        this.validate(validator, redeemVoucherDTO, "prepareRedeem");
        if (bl2) {
            this.checkVoucherPin(voucher, user, redeemVoucherDTO.getPin());
        }
        if (!bl && bigDecimal2.compareTo(bigDecimal) > 0) {
            CurrencyAmountDTO currencyAmountDTO = voucher.getAmount() == null || voucher.getType().isHideBalanceInRedeem() ? null : (CurrencyAmountDTO)this.conversionHandler.convert(CurrencyAmountDTO.class, (Object)voucher.withCurrency(bigDecimal));
            throw new InsufficientVoucherBalanceException(currencyAmountDTO);
        }
        return bigDecimal2;
    }

    private BigDecimal prepareTopUp(boolean bl, @NotNull TopUpVoucherDTO topUpVoucherDTO, User user, Voucher voucher) {
        Object object;
        VoucherPack voucherPack = voucher.getPack();
        VoucherType voucherType = voucher.getType();
        VoucherConfiguration voucherConfiguration = voucher.getConfiguration();
        PaymentTransferType paymentTransferType = voucher.getConfiguration().getTopUpType();
        Validator validator = new Validator();
        Property property = validator.property((org.cyclos.model.Property)TopUpVoucherDTO.AMOUNT, BankingKeys.Vouchers.TRANSACTION_AMOUNT);
        BigDecimal bigDecimal = voucher.getPack().getAmount();
        if (bigDecimal == null) {
            property.required().positiveNonZero((HasCurrency)voucher).greaterEquals((Comparable)voucherType.getMinTopUpAmount()).lessEquals((Comparable)voucherType.getMaxTopUpAmount());
        } else {
            property.anyOf(new Object[]{bigDecimal});
        }
        if (!bl) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).addRequiredValidation(validator, (org.cyclos.model.Property)TopUpVoucherDTO.CONFIRMATION_PASSWORD);
        }
        if (voucher.isInactive()) {
            object = this.configurationHandler.getAccessor((BasicUser)user);
            OutboundSmsConfiguration outboundSmsConfiguration = object.getOutboundSmsConfiguration();
            boolean bl2 = outboundSmsConfiguration != null && outboundSmsConfiguration.isEnabled();
            Property property2 = validator.property((org.cyclos.model.Property)TopUpVoucherDTO.EMAIL, BankingKeys.Vouchers.EMAIL).email();
            Property property3 = validator.property((org.cyclos.model.Property)TopUpVoucherDTO.MOBILE_PHONE, BankingKeys.Vouchers.MOBILE_PHONE).phoneNumber(object, PhoneNature.MOBILE);
            boolean bl3 = StringHelper.isNotBlank((Object)topUpVoucherDTO.getEmail());
            boolean bl4 = StringHelper.isNotBlank((Object)topUpVoucherDTO.getMobilePhone());
            if (!bl2 && bl4) {
                property3.invalid();
            }
            switch (voucherConfiguration.getPinOnActivation()) {
                case SEND: {
                    if (bl2) {
                        if (bl3 || bl4) break;
                        validator.general(GeneralValidations.invalid((MessageKey)BankingKeys.Vouchers.TOP_UP_ERROR_EMAIL_OR_MOBILE_PHONE_REQUIRED, (Object[])new Object[0]));
                        break;
                    }
                    property2.required();
                    break;
                }
                case INPUT: {
                    Property property4 = validator.property((org.cyclos.model.Property)TopUpVoucherDTO.PIN, BankingKeys.Vouchers.TOP_UP_PIN).fixedLength(voucher.getConfiguration().getPinLength().intValue()).regex("\\d+");
                    Property property5 = validator.property((org.cyclos.model.Property)TopUpVoucherDTO.PIN_CONFIRMATION, BankingKeys.Vouchers.TOP_UP_PIN_CONFIRM).anyOf(new Object[]{topUpVoucherDTO.getPin()});
                    if (bl3 || bl4) break;
                    property4.required();
                    property5.required();
                    break;
                }
            }
            this.resolveCustomFields(voucherType, voucher.getPack().getCreationType(), VoucherCustomFieldUsage.ACTIVATION, true, user).forEach(voucherCustomField -> this.customFieldValueHandler.addValueValidation(validator, (CustomField)voucherCustomField, (EntityPathBase)QVoucherCustomFieldValue.voucherCustomFieldValue, Collections.singletonMap("voucher", voucher)));
        }
        paymentTransferType.getCustomFields().forEach(transactionCustomField -> this.customFieldValueHandler.addValueValidation(validator, (CustomField)transactionCustomField, (EntityPathBase)QTransactionCustomFieldValue.transactionCustomFieldValue, Collections.singletonMap("voucher", voucher), TopUpVoucherDTO.PAYMENT_CUSTOM_VALUES.getName()));
        this.validate(validator, topUpVoucherDTO, "prepareTopUp");
        object = (BigDecimal)ObjectHelper.defaultValue((Object)voucherPack.getAmount(), (Object)topUpVoucherDTO.getAmount());
        this.checkMaxTotalOpenAmount(voucherType, (BigDecimal)object);
        return object;
    }

    private Date redeemAfterDate(VoucherType voucherType, Date date) {
        Date date2;
        SessionData sessionData = this.getSessionData();
        TimeInterval timeInterval = voucherType.getMinimumTimeToRedeem();
        if (timeInterval == null || !timeInterval.isValid()) {
            date2 = date;
        } else {
            date2 = DateHelper.add((Date)date, (ITimeInterval)timeInterval);
            if (timeInterval.getField().compareTo((Enum)TimeField.HOURS) > 0) {
                date2 = DateHelper.shiftToBegin((Date)date2, (TimeZone)sessionData.getConfiguration().getTimeZone(), (boolean)true);
            }
        }
        return date2;
    }

    private void registerTransactionAuthorizationHandler(AuthorizationAction authorizationAction) {
        this.transactionAuthorizationService.registerHandler(authorizationAction, Payment.class, payment -> {
            VoucherPack voucherPack;
            CloseableIterator closeableIterator = ((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.pack().buy().eq(payment), VoucherServiceImpl.$.status.ne((Object)VoucherStatus.CANCELED)})).iterate((Expression)$);
            this.processBatch(closeableIterator, (T voucher) -> {
                switch (authorizationAction) {
                    case DENIED: 
                    case CANCELED: 
                    case EXPIRED: {
                        this.doCancel((Voucher)voucher, true, false);
                        break;
                    }
                    case AUTHORIZED: {
                        if (voucher.isPending()) {
                            voucher.setStatus(VoucherStatus.OPEN);
                            break;
                        }
                        throw new ValidationException(this.message(BankingKeys.Vouchers.ERROR_VOUCHER_EXPIRED_WHEN_AUTHORIZED, new Object[0]));
                    }
                }
            });
            if (authorizationAction == AuthorizationAction.AUTHORIZED && (voucherPack = (VoucherPack)((DBQuery)this.from(new EntityPath[]{p}).where(new Predicate[]{p.buy().eq(payment), VoucherServiceImpl.p.creationType.eq((Object)VoucherCreationType.SENT)})).singleResult((Expression)p)) != null) {
                this.sendEmail(voucherPack);
            }
        });
    }

    private boolean requiresOldPinForChange(Voucher voucher) {
        if (StringHelper.isBlank((Object)voucher.getPin()) || this.showPinOnDetails(voucher)) {
            return false;
        }
        SessionData sessionData = this.getSessionData();
        User user = sessionData.getLoggedUser();
        User user2 = voucher.getOwnerOrBuyer();
        return user2 != null && user2.equals((Object)user);
    }

    private boolean requiresPinForRedeem(Voucher voucher) {
        if (voucher.getStatus() != VoucherStatus.OPEN || StringHelper.isBlank((Object)voucher.getPin())) {
            return false;
        }
        VoucherPinUsage voucherPinUsage = (VoucherPinUsage)ObjectHelper.defaultValue((Object)voucher.getConfiguration().getPinUsage(), (Object)VoucherPinUsage.NEVER);
        switch (voucherPinUsage) {
            case NEVER: 
            case INFO: {
                return false;
            }
            case ALWAYS: {
                return true;
            }
            case SUBSEQUENT: {
                BigDecimal bigDecimal = (BigDecimal)ObjectHelper.coalesce((Object[])new BigDecimal[]{voucher.getAmount(), voucher.getPack().getAmount()});
                return bigDecimal != null && !bigDecimal.equals(voucher.getBalance());
            }
        }
        throw new IllegalStateException("Unhandled pin usage");
    }

    private List<VoucherConfiguration> resolveConfigurations(User user, boolean bl, boolean bl2) {
        List list = this.voucherConfigurationService.listVisible(user, bl, bl2);
        if (user != null) {
            List list2 = this.voucherConfigurationService.listEnabled(user);
            list.retainAll(list2);
        }
        return list;
    }

    private List<VoucherCustomField> resolveCustomFields(VoucherType voucherType, VoucherCreationType voucherCreationType, VoucherCustomFieldUsage voucherCustomFieldUsage, boolean bl, User user) {
        List<VoucherCustomField> list;
        List list2 = list = bl ? this.voucherCustomFieldServiceLocal.listRelated(voucherType, user) : new ArrayList(voucherType.getCustomFields());
        if (voucherCustomFieldUsage == VoucherCustomFieldUsage.ACTIVATION) {
            list.removeIf(voucherCustomField -> voucherCustomField.getUsage() != VoucherCustomFieldUsage.ACTIVATION);
        } else {
            list.removeIf(voucherCustomField -> voucherCustomField.getUsage() != VoucherCustomFieldUsage.CREATION || voucherCreationType.isGeneration() && !voucherCustomField.isUsedOnGeneration() || voucherCreationType.isBuy() && !voucherCustomField.isUsedOnBuying());
        }
        return list;
    }

    private List<CustomFieldDetailedVO> resolveCustomFieldVOs(Voucher voucher, VoucherType voucherType, VoucherCreationType voucherCreationType, VoucherCustomFieldUsage voucherCustomFieldUsage, User user) {
        List<VoucherCustomField> list = this.resolveCustomFields(voucherType, voucherCreationType, voucherCustomFieldUsage, true, user);
        List list2 = this.conversionHandler.convertList(CustomFieldDetailedVO.class, list);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (voucherCustomFieldUsage == VoucherCustomFieldUsage.ACTIVATION) {
            hashMap.put("voucher", voucher);
        } else {
            hashMap.put("voucherCreationType", voucherCreationType);
            hashMap.put("voucherType", voucherType);
        }
        this.customFieldValueHandler.fillValuesFromScript(VoucherCustomField.class, LoadValuesScriptFunction.ENTITY, hashMap, (Collection)list2);
        return list2;
    }

    private String resolveMask(Collection<VoucherConfiguration> collection) {
        Set set = CollectionHelper.orEmpty(collection).stream().map(VoucherConfiguration::getMask).collect(Collectors.toSet());
        return set.size() == 1 ? (String)CollectionHelper.first(set) : null;
    }

    private Set<String> resolvePossibleUmaskedTokens(String string, Collection<VoucherConfiguration> collection) {
        return collection.stream().map(VoucherConfiguration::getMask).filter(string2 -> MaskHelper.isValidMaskedValue((String)string2, (String)string)).map(string2 -> MaskHelper.removeMask((String)string2, (String)string)).collect(Collectors.toSet());
    }

    private void sendEmail(VoucherPack voucherPack) {
        Set set = voucherPack.getVouchers();
        Voucher voucher = (Voucher)CollectionHelper.first((Iterable)set);
        FileInfo fileInfo = (FileInfo)this.invokerHandler.runAs(SessionDataFactory.system(), () -> this.exportFormatService.exportSingle(this.exportFormatService.getPDF(), ExportFormatContext.VOUCHER_DETAILS, (Object)voucher));
        fileInfo.setName("voucher.pdf");
        String string = this.message(ContentManagementKeys.Emails.VOUCHER_RECEIVED_SUBJECT, voucher.getCurrencyAmount());
        TranslationMessageSpecification translationMessageSpecification = null;
        if (this.usePin(voucher)) {
            translationMessageSpecification = new TranslationMessageSpecification(ContentManagementKeys.Emails.VOUCHER_RECEIVED_MESSAGE_PIN, new Object[]{voucher.getPin()});
        }
        Object object = this.message(MessageFormat.HTML, ContentManagementKeys.Emails.VOUCHER_RECEIVED_MESSAGE, voucher.getCurrencyAmount(), voucherPack.getBuyer(), translationMessageSpecification, voucherPack.getExpirationDate());
        if (StringHelper.isNotBlank((Object)voucherPack.getSendMessage())) {
            object = (String)object + "<p>" + StringHelper.convertNewLineToBr((String)voucherPack.getSendMessage()) + "</p>";
        }
        object = (String)object + this.infoLink(voucher);
        this.mailHandler.send(null, voucher.getEmail(), string, (String)object, new FileInfo[]{fileInfo});
    }

    private List<String> sendPin(Voucher voucher, boolean bl) {
        Object object;
        String string;
        String string2 = StringHelper.isBlank((Object)voucher.getPin()) ? this.generatePin(voucher) : voucher.getPin();
        Date date = voucher.getActualExpirationDate();
        Object object2 = this.ofAmount(voucher);
        ArrayList<String> arrayList = new ArrayList<String>();
        User user = this.getVoucherUserToNotify(voucher);
        String string3 = (String)ObjectHelper.defaultValue((Object)voucher.getEmail(), (Object)(user != null ? user.getEmail() : null));
        if (string3 != null) {
            if (bl) {
                User user2 = voucher.getActivation().getUser();
                string = this.message(ContentManagementKeys.Emails.VOUCHER_ACTIVATION_SUBJECT, object2);
                object = this.message(ContentManagementKeys.Emails.VOUCHER_ACTIVATION_MESSAGE, object2, user2, string2, date);
            } else {
                string = this.message(ContentManagementKeys.Emails.VOUCHER_PIN_SUBJECT, object2);
                object = this.message(ContentManagementKeys.Emails.VOUCHER_PIN_MESSAGE, object2, string2);
            }
            object = (String)object + this.infoLink(voucher);
            this.mailHandler.send(null, string3, string, (String)object, new FileInfo[0]);
            arrayList.add(StringHelper.maskEmail((String)string3));
        }
        if (voucher.getMobilePhone() != null || user != null && user.hasMobileEnabledForSMS()) {
            string = this.message(MessagingKeys.Notifications.SMS_VOUCHER_PIN, object2, string2, date);
            object = this.sendSms(voucher, user, string);
            object.stream().map(StringHelper::maskPhone).forEach(arrayList::add);
        }
        return arrayList;
    }

    private List<String> sendSms(Voucher voucher, User user, String string) {
        if (StringHelper.isNotBlank((Object)voucher.getMobilePhone())) {
            this.outboundSmsHandler.sendToUnregistered(this.configurationFor(voucher), voucher.getMobilePhone(), string, OutboundSmsType.VOUCHER);
            return List.of(voucher.getMobilePhone());
        }
        if (user != null) {
            return this.outboundSmsHandler.send((BasicUser)user, string, OutboundSmsType.VOUCHER).stream().map(BaseSms::getPhoneNumber).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void storeNotificationSettings(Voucher voucher, SimpleChangeVoucherNotificationSettingsDTO simpleChangeVoucherNotificationSettingsDTO) {
        String string = simpleChangeVoucherNotificationSettingsDTO.getEmail();
        boolean bl = voucher.getPack().isSent() && voucher.isOpen() && string != null && !string.equals(voucher.getEmail());
        voucher.setEmail(string);
        voucher.setMobilePhone(simpleChangeVoucherNotificationSettingsDTO.getMobilePhone());
        voucher.setEnableNotifications(simpleChangeVoucherNotificationSettingsDTO.isEnableNotifications());
        if (bl) {
            this.sendEmail(voucher.getPack());
        }
    }

    private BigDecimal sumBuys(VoucherType voucherType, DatePeriod datePeriod) {
        return BigDecimalHelper.zeroWhenNull((BigDecimal)((BigDecimal)((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.pack().type().eq((Object)voucherType), VoucherServiceImpl.$.pack().buy().date.period(datePeriod)})).singleResult((Expression)VoucherServiceImpl.$.pack().buy().amount.sum())));
    }

    private boolean supportsNotifications(Voucher voucher) {
        return voucher.getConfiguration().getGenerationStatus() == VoucherGenerationStatus.INACTIVE || voucher.getPack().isSent() || Boolean.TRUE.equals(voucher.getPack().getGift());
    }

    private int transactionCount(Voucher voucher) {
        return ((DBQuery)this.from(new EntityPath[]{t}).where((Predicate)t.voucher().eq((Object)voucher))).count(VoucherServiceImpl.t.id);
    }

    private void validate(CreateVoucherDataParams createVoucherDataParams) {
        Validator validator = new Validator();
        validator.property((org.cyclos.model.Property)CreateVoucherDataParams.TYPE, BankingKeys.Vouchers.TYPE).entity(VoucherType.class, (EntityValidation)new ExpiredTypeValidation(BankingKeys.Vouchers.ERROR_TYPE_EXPIRED));
        validator.property((org.cyclos.model.Property)CreateVoucherDataParams.USER, UsersKeys.Users.USER).required();
        this.validate(validator, createVoucherDataParams, "createVoucherDataParams");
    }

    private void validate(CreateVouchersDTO createVouchersDTO, boolean bl) {
        VoucherType voucherType = (VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)createVouchersDTO.getType());
        VoucherConfiguration voucherConfiguration = voucherType.getConfiguration();
        Validator validator = new Validator();
        Property property = validator.property((org.cyclos.model.Property)CreateVouchersDTO.TYPE, BankingKeys.Vouchers.TYPE);
        property.required().entity(VoucherType.class, (EntityValidation)new ExpiredTypeValidation(BankingKeys.Vouchers.ERROR_TYPE_EXPIRED));
        validator.property((org.cyclos.model.Property)GenerateVouchersDTO.COUNT, BankingKeys.Vouchers.CREATE_COUNT).required().positiveIntegerNonZero();
        Property property2 = validator.property((org.cyclos.model.Property)CreateVouchersDTO.AMOUNT, createVouchersDTO instanceof SendVoucherDTO ? BankingKeys.Vouchers.AMOUNT : BankingKeys.Vouchers.CREATE_AMOUNT);
        property2.positiveNonZero((HasCurrency)voucherType).lessThan((Comparable)TransactionService.MAX_TRANSACTION_AMOUNT_EXCLUSIVE);
        VoucherCreationType voucherCreationType = null;
        if (createVouchersDTO instanceof GenerateVouchersDTO) {
            if (voucherConfiguration.getGenerationAmount() == VoucherGenerationAmount.GENERATION) {
                property2.required();
            }
            voucherCreationType = VoucherCreationType.GENERATED;
        } else {
            property2.required();
        }
        if (bl) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).addRequiredValidation(validator, (org.cyclos.model.Property)CreateVouchersDTO.CONFIRMATION_PASSWORD);
        }
        User user = null;
        if (createVouchersDTO instanceof BaseBuyVouchersDTO) {
            if (createVouchersDTO instanceof SendVoucherDTO) {
                validator.property((org.cyclos.model.Property)SendVoucherDTO.EMAIL, BankingKeys.Vouchers.EMAIL).email().required();
                validator.property((org.cyclos.model.Property)SendVoucherDTO.MESSAGE, BankingKeys.Vouchers.SEND_MESSAGE).maxLength(1000);
                voucherCreationType = VoucherCreationType.SENT;
            } else if (createVouchersDTO instanceof BuyVouchersDTO) {
                voucherCreationType = VoucherCreationType.BOUGHT;
            }
            validator.property((org.cyclos.model.Property)BaseBuyVouchersDTO.USER, UsersKeys.Users.USER).required();
            User user2 = user = (User)this.conversionHandler.convert(User.class, (Object)((BaseBuyVouchersDTO)createVouchersDTO).getUser());
            if (voucherType != null) {
                property.entity(VoucherType.class, (EntityValidation)new BaseEntityValidation<VoucherType>(){

                    protected boolean isValid(Object object, Object object2, VoucherType voucherType) {
                        return VoucherServiceImpl.this.isBuyAllowed(voucherType);
                    }
                });
                if (BigDecimalHelper.isPositive((BigDecimal)voucherType.getMinBuyAmount())) {
                    property2.greaterEquals((Comparable)voucherType.getMinBuyAmount());
                }
                if (BigDecimalHelper.isPositive((BigDecimal)voucherType.getMaxBuyAmount())) {
                    property2.lessEquals((Comparable)voucherType.getMaxBuyAmount());
                }
                if (voucherType.getMaxVouchersPerBuy() != null) {
                    validator.property((org.cyclos.model.Property)GenerateVouchersDTO.COUNT, BankingKeys.Vouchers.CREATE_COUNT).lessEquals((Comparable)voucherType.getMaxVouchersPerBuy());
                }
                if (voucherType.getMaxTotalBuy() != null) {
                    validator.property((org.cyclos.model.Property)GenerateVouchersDTO.COUNT, BankingKeys.Vouchers.CREATE_COUNT).add((object, object2, object3) -> {
                        int n = ((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.pack().buyer().eq((Object)user2), $.pack().type().eq((Object)voucherType)})).count(VoucherServiceImpl.$.id);
                        if (n + createVouchersDTO.getCount() > voucherType.getMaxTotalBuy()) {
                            return new ValidationError(n > 0 ? BankingKeys.Vouchers.ERROR_MAX_TOTAL_BUYINGS_EXCEEDED_BOUGHT : BankingKeys.Vouchers.ERROR_MAX_TOTAL_BUYINGS_EXCEEDED, new Object[]{voucherType.getMaxTotalBuy(), n});
                        }
                        return null;
                    });
                }
            }
        }
        this.resolveCustomFields(voucherType, voucherCreationType, VoucherCustomFieldUsage.CREATION, true, user).forEach(voucherCustomField -> this.customFieldValueHandler.addValueValidation(validator, (CustomField)voucherCustomField, (EntityPathBase)QVoucherPackCustomFieldValue.voucherPackCustomFieldValue, Collections.singletonMap("voucherType", voucherType)));
        this.validate(validator, createVouchersDTO, "createVouchersDTO");
    }

    private void validate(Voucher voucher, SimpleChangeVoucherNotificationSettingsDTO simpleChangeVoucherNotificationSettingsDTO) {
        Validator validator = new Validator();
        ConfigurationAccessor configurationAccessor = (ConfigurationAccessor)this.getIfSmsEnabled(voucher, Function.identity());
        Property property = validator.property((org.cyclos.model.Property)SimpleChangeVoucherNotificationSettingsDTO.EMAIL, BankingKeys.Vouchers.EMAIL);
        property.email();
        if (voucher.getPack().isSent() || configurationAccessor == null && simpleChangeVoucherNotificationSettingsDTO.isEnableNotifications()) {
            property.required();
        }
        if (configurationAccessor != null) {
            validator.property((org.cyclos.model.Property)SimpleChangeVoucherNotificationSettingsDTO.MOBILE_PHONE, BankingKeys.Vouchers.MOBILE_PHONE).phoneNumber(configurationAccessor, PhoneNature.MOBILE);
        }
        if (simpleChangeVoucherNotificationSettingsDTO.isEnableNotifications() && StringHelper.isBlank((Object)simpleChangeVoucherNotificationSettingsDTO.getEmail()) && StringHelper.isBlank((Object)simpleChangeVoucherNotificationSettingsDTO.getMobilePhone()) && configurationAccessor != null) {
            throw new ValidationException(this.message(BankingKeys.Vouchers.ERROR_NO_MEDIUM_DEFINED, new Object[0]));
        }
        this.validate(validator, simpleChangeVoucherNotificationSettingsDTO, "simpleChangeVoucherNotificationSettingsDTO");
    }

    private void validate(Voucher voucher, SimpleChangeVoucherPinDTO simpleChangeVoucherPinDTO, boolean bl) {
        Validator validator = new Validator();
        String string = voucher.getPin();
        if (bl && StringHelper.isNotBlank((Object)string)) {
            validator.property((org.cyclos.model.Property)ChangeVoucherPinDTO.OLD_PIN, BankingKeys.Vouchers.CHANGE_PIN_OLD_PIN).required().fixedLength(string.length());
        }
        validator.property((org.cyclos.model.Property)ChangeVoucherPinDTO.NEW_PIN, BankingKeys.Vouchers.CHANGE_PIN_NEW_PIN).required().regex("[0-9]+").fixedLength(voucher.getConfiguration().getPinLength().intValue());
        validator.property((org.cyclos.model.Property)ChangeVoucherPinDTO.CONFIRM_NEW_PIN, BankingKeys.Vouchers.CHANGE_PIN_CONFIRM_NEW_PIN).required().add((object, object2, object3) -> {
            if (!Objects.equals(simpleChangeVoucherPinDTO.getNewPin(), simpleChangeVoucherPinDTO.getConfirmNewPin())) {
                return new ValidationError(BankingKeys.Vouchers.CHANGE_PIN_ERROR_PIN_DO_NOT_MATCH);
            }
            return null;
        });
        this.validate(validator, (Object)simpleChangeVoucherPinDTO, "SimpleChangeVoucherPinDTO");
    }

    private Voucher voucherForInfo(String string) {
        if (string == null) {
            throw new EntityNotFoundException(Voucher.class);
        }
        Map<String, List<VoucherConfiguration>> map = this.voucherConfigurationService.listAll().stream().collect(Collectors.groupingBy(voucherConfiguration -> (String)ObjectHelper.defaultValue((Object)voucherConfiguration.getMask(), (Object)"")));
        Voucher voucher = null;
        for (Map.Entry<String, List<VoucherConfiguration>> entry : map.entrySet()) {
            String string2;
            String string3 = StringHelper.trimToNull((Object)entry.getKey());
            List<VoucherConfiguration> list = entry.getValue();
            try {
                string2 = StringHelper.trimToNull((Object)MaskHelper.removeAndValidateMask((String)string3, (String)string));
                if (string2 == null) {
                    throw new IllegalArgumentException();
                }
            }
            catch (Exception exception) {
                continue;
            }
            voucher = (Voucher)((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{VoucherServiceImpl.$.token.eq((Object)string2), $.pack().type().configuration().in(list)})).singleResult((Expression)$);
            if (voucher == null) continue;
            break;
        }
        if (voucher == null) {
            boolean bl = this.failedActionHandler.recordGuestFailure(FailedAction.FAILED_VOUCHER_INFO, this.getSessionData().getRemoteAddress(), null, Integer.valueOf(20), MAX_INVALID_TOKEN_BLOCK_TIME);
            if (bl) {
                throw new RemoteAddressBlockedException();
            }
            throw new EntityNotFoundException(Voucher.class, string);
        }
        if (voucher.isInactive()) {
            throw new ValidationException(this.message(BankingKeys.Vouchers.ERROR_VOUCHER_NOT_ACTIVATED, new Object[0]));
        }
        return voucher;
    }

    private /* synthetic */ Boolean lambda$cancelAction$33(Payment payment) throws Exception {
        return this.transferService.canChargeback((Transfer)payment.getTransfer());
    }

    private static /* synthetic */ boolean lambda$doGetInfo$32(List list, VoucherCustomFieldValue voucherCustomFieldValue) {
        return list.contains(voucherCustomFieldValue.getField()) && voucherCustomFieldValue.getField().isShowInVoucherInformation();
    }

    private static /* synthetic */ boolean lambda$doGetInfo$31(List list, VoucherPackCustomFieldValue voucherPackCustomFieldValue) {
        return list.contains(voucherPackCustomFieldValue.getField()) && voucherPackCustomFieldValue.getField().isShowInVoucherInformation();
    }

    private static /* synthetic */ void lambda$topUp$30(VoucherTopUp voucherTopUp, CurrencyAmount currencyAmount, User user, AccountNotificationsHandler accountNotificationsHandler) {
        accountNotificationsHandler.voucherTopUp(voucherTopUp, currencyAmount, user);
    }

    private /* synthetic */ String lambda$topUp$29(CurrencyAmount currencyAmount, Voucher voucher, User user) {
        return this.message(MessagingKeys.Notifications.SMS_VOUCHER_TOP_UP, currencyAmount, voucher.getBalance(), user);
    }

    private /* synthetic */ String lambda$topUp$28(CurrencyAmount currencyAmount, User user, Voucher voucher) {
        return this.message(ContentManagementKeys.Emails.VOUCHER_TOP_UP_MESSAGE, currencyAmount, user) + this.message(ContentManagementKeys.Emails.VOUCHER_BALANCE, voucher.getBalanceCurrencyAmount());
    }

    private /* synthetic */ String lambda$topUp$27(CurrencyAmount currencyAmount) {
        return this.message(ContentManagementKeys.Emails.VOUCHER_TOP_UP_SUBJECT, currencyAmount);
    }

    private static /* synthetic */ boolean lambda$getData$12(List list, VoucherCustomFieldValue voucherCustomFieldValue) {
        return list.contains(voucherCustomFieldValue.getField());
    }

    private static /* synthetic */ boolean lambda$getData$11(List list, VoucherPackCustomFieldValue voucherPackCustomFieldValue) {
        return list.contains(voucherPackCustomFieldValue.getField());
    }

    private static class ValidateBuyOrSendResult {
        private VoucherType type;
        private User buyer;
        private int count;
        private BigDecimal totalAmount;
        private User owner;

        private ValidateBuyOrSendResult() {
        }
    }

    private class ExpiredTypeValidation
    extends BaseEntityValidation<VoucherType> {
        private ExpiredTypeValidation(MessageKey messageKey) {
            super(messageKey, new Object[0]);
        }

        protected boolean isValid(Object object, Object object2, VoucherType voucherType) {
            return VoucherServiceImpl.this.expiration(voucherType).after(new Date());
        }
    }
}

