/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QVoucherConfiguration;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.QProductAdminVoucher;
import org.cyclos.entities.users.QProductMemberVoucher;
import org.cyclos.entities.users.QProductUserVoucher;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.CurrencyServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.banking.VoucherConfigurationServiceLocal;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.BooleanPropertiesHolderImpl;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accounttypes.AccountTypeLimitType;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.banking.transfertypes.TransferTypeNature;
import org.cyclos.model.banking.transfertypes.TransferTypeQuery;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationDTO;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationData;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationDetailedVO;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationListData;
import org.cyclos.model.banking.voucherconfigurations.VoucherGenerationAmount;
import org.cyclos.model.banking.voucherconfigurations.VoucherGenerationStatus;
import org.cyclos.model.banking.voucherconfigurations.VoucherPinOnActivation;
import org.cyclos.model.banking.voucherconfigurations.VoucherPinUsage;
import org.cyclos.model.users.products.AdminProductDTO;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoucherConfigurationServiceImpl
extends CRUDServiceImpl<VoucherConfiguration, QVoucherConfiguration, VoucherConfigurationDTO, VoucherConfigurationData, CurrencyVO>
implements VoucherConfigurationServiceLocal {
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private ProductServiceLocal productService;
    @Autowired
    private CurrencyServiceLocal currencyService;
    TransferTypeValidator systemToUserValidator = new TransferTypeValidator(TransferTypeDirection.SYSTEM_TO_USER);
    TransferTypeValidator userToSystemValidator = new TransferTypeValidator(TransferTypeDirection.USER_TO_SYSTEM);
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;

    public VoucherConfigurationServiceImpl() {
        super(VoucherConfiguration.class, QVoucherConfiguration.voucherConfiguration, VoucherConfigurationDTO.class);
    }

    public VoucherConfigurationListData getListData() throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        VoucherConfigurationListData voucherConfigurationListData = new VoucherConfigurationListData();
        if (sessionData.hasPermission(Permission.ACCOUNT_CONFIGURATION_MANAGE)) {
            voucherConfigurationListData.setCreateOnCurrencies(this.currencyService.list());
        }
        voucherConfigurationListData.setVoucherConfigurations(this.list());
        return voucherConfigurationListData;
    }

    public List<VoucherConfigurationDetailedVO> list() throws FrameworkException {
        return this.conversionHandler.convertList(VoucherConfigurationDetailedVO.class, this.listAll());
    }

    public List<VoucherConfiguration> listAll() throws FrameworkException {
        return ((DBQuery)this.from().orderBy(((QVoucherConfiguration)this.$).name.asc())).list((Expression)this.$);
    }

    public List<VoucherConfiguration> listEnabled(User user) {
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
        Set set = productsAccessor.member().getVouchers().keysSet((Path)QProductMemberVoucher.productMemberVoucher.enable);
        return CollectionHelper.sort((Collection)set);
    }

    public List<VoucherConfiguration> listVisible(User user) {
        return this.doListVisible(user, true, true, true);
    }

    public List<VoucherConfiguration> listVisible(User user, boolean bl, boolean bl2) {
        return this.doListVisible(user, bl, bl2, false);
    }

    @Override
    public VoucherConfiguration newEntity(CurrencyVO currencyVO) {
        Currency currency = (Currency)this.conversionHandler.convert(Currency.class, (Object)currencyVO);
        VoucherConfiguration voucherConfiguration = new VoucherConfiguration();
        voucherConfiguration.setCurrency(currency);
        voucherConfiguration.setMask("####-####-####-####-####");
        voucherConfiguration.setReserveAmount(true);
        voucherConfiguration.setShowPlainToken(true);
        voucherConfiguration.setShowQrCode(true);
        voucherConfiguration.setGenerationStatus(VoucherGenerationStatus.ACTIVE);
        voucherConfiguration.setGenerationAmount(VoucherGenerationAmount.GENERATION);
        voucherConfiguration.setPinUsage(VoucherPinUsage.NEVER);
        voucherConfiguration.setPinLength(Integer.valueOf(4));
        voucherConfiguration.setActivationInterval(TimeInterval.ONE_YEAR);
        return voucherConfiguration;
    }

    public BooleanPropertiesHolder<VoucherConfiguration> resolveVoucherConfigurationPermissions(User user) {
        SessionData sessionData = this.getSessionData();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        if (user == null || user.equals((Object)sessionData.getLoggedUser())) {
            return sessionData.isAdmin() ? productsAccessor.admin().getVouchers() : productsAccessor.member().getVouchers();
        }
        if (sessionData.isAdminOf((BasicUser)user)) {
            return productsAccessor.admin().getVouchers();
        }
        if (sessionData.isBrokerOf((BasicUser)user)) {
            return productsAccessor.broker().getUserVouchers();
        }
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    protected VoucherConfigurationData getData(VoucherConfiguration voucherConfiguration) {
        VoucherConfigurationData voucherConfigurationData = new VoucherConfigurationData();
        voucherConfigurationData.setDto((EntityDTO)((VoucherConfigurationDTO)this.toDTO(voucherConfiguration)));
        voucherConfigurationData.setVoucherInfoUrl(this.linkGeneratorHandler.voucherInfo());
        SessionData sessionData = this.getSessionData();
        if (sessionData.hasPermission(Permission.ACCOUNT_CONFIGURATION_MANAGE)) {
            TransferTypeQuery transferTypeQuery = new TransferTypeQuery();
            transferTypeQuery.setUnlimited();
            transferTypeQuery.setCurrency(new CurrencyVO(voucherConfiguration.getCurrency().getId()));
            transferTypeQuery.setNatures(EnumSet.of(TransferTypeNature.PAYMENT));
            transferTypeQuery.setFromNature(AccountTypeNature.SYSTEM);
            transferTypeQuery.setToNature(AccountTypeNature.USER);
            List list = this.transferTypeService.search(transferTypeQuery).getPageItems();
            voucherConfigurationData.setRedeemTypes(list);
            voucherConfigurationData.setRefundTypes(list);
            transferTypeQuery.setFromNature(AccountTypeNature.USER);
            transferTypeQuery.setToNature(AccountTypeNature.SYSTEM);
            List list2 = this.transferTypeService.search(transferTypeQuery).getPageItems();
            voucherConfigurationData.setBuyTypes(list2);
            voucherConfigurationData.setTopUpTypes(list2);
        } else {
            voucherConfigurationData.setRedeemTypes(Arrays.asList((TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)voucherConfiguration.getRedeemType())));
            voucherConfigurationData.setBuyTypes(Arrays.asList((TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)voucherConfiguration.getBuyType())));
            voucherConfigurationData.setRefundTypes(Arrays.asList((TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)voucherConfiguration.getRefundType())));
            voucherConfigurationData.setTopUpTypes(Arrays.asList((TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)voucherConfiguration.getTopUpType())));
        }
        return voucherConfigurationData;
    }

    @Override
    protected void onAfterSave(VoucherConfiguration voucherConfiguration, VoucherConfiguration voucherConfiguration2, Object object) {
        super.onAfterSave(voucherConfiguration, voucherConfiguration2, object);
        if (voucherConfiguration2 == null && this.isAdmin()) {
            AdminGroup adminGroup = (AdminGroup)this.getSessionData().getGroup();
            AdminProduct adminProduct = adminGroup.getAdminProduct();
            this.productService.createRelationship((Product)adminProduct, (Property)AdminProductDTO.ACCESSIBLE_VOUCHER_CONFIGURATIONS, (SimpleEntity)voucherConfiguration);
            Set set = adminProduct.getPermissions();
            set.add(Permission.VOUCHER_TYPES_VIEW);
            set.add(Permission.VOUCHER_TYPES_MANAGE);
            set.add(Permission.VOUCHER_TEMPLATES_VIEW);
            set.add(Permission.VOUCHER_TEMPLATES_MANAGE);
        }
    }

    @Override
    protected Object onBeforeSave(VoucherConfiguration voucherConfiguration, VoucherConfiguration voucherConfiguration2) {
        VoucherGenerationStatus voucherGenerationStatus = voucherConfiguration.getGenerationStatus();
        if (voucherGenerationStatus != VoucherGenerationStatus.INACTIVE) {
            voucherConfiguration.setTopUpType(null);
            voucherConfiguration.setGenerationAmount(VoucherGenerationAmount.GENERATION);
            voucherConfiguration.setPinOnActivation(VoucherPinOnActivation.NONE);
        }
        if (voucherConfiguration.getPinUsage() == VoucherPinUsage.NEVER) {
            voucherConfiguration.setPinOnActivation(VoucherPinOnActivation.NONE);
            voucherConfiguration.setPinLength(null);
        }
        if (voucherGenerationStatus == VoucherGenerationStatus.ACTIVE) {
            voucherConfiguration.setActivationInterval(null);
        } else {
            voucherConfiguration.setBuyType(null);
            voucherConfiguration.setRefundType(null);
            if (voucherGenerationStatus == VoucherGenerationStatus.BLOCKED) {
                voucherConfiguration.setReserveAmount(false);
            }
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QVoucherConfiguration)this.$).currency().network(), true);
    }

    @Override
    protected Validator resolveValidator(VoucherConfigurationDTO voucherConfigurationDTO) {
        VoucherGenerationAmount voucherGenerationAmount;
        VoucherGenerationStatus voucherGenerationStatus;
        VoucherConfiguration voucherConfiguration;
        if (voucherConfigurationDTO.isPersistent()) {
            voucherConfiguration = (VoucherConfiguration)this.find(voucherConfigurationDTO.getId());
            voucherGenerationStatus = voucherConfiguration.getGenerationStatus();
            voucherGenerationAmount = voucherConfiguration.getGenerationAmount();
        } else {
            voucherGenerationStatus = voucherConfigurationDTO.getGenerationStatus();
            voucherGenerationAmount = voucherConfigurationDTO.getGenerationAmount();
        }
        voucherConfiguration = new Validator();
        voucherConfiguration.property((Property)VoucherConfigurationDTO.CURRENCY, BankingKeys.VoucherConfigurations.CURRENCY).required();
        voucherConfiguration.property((Property)VoucherConfigurationDTO.REDEEM_TYPE, BankingKeys.VoucherConfigurations.REDEEM_TYPE).required().add((PropertyValidation)this.systemToUserValidator);
        voucherConfiguration.property((Property)VoucherConfigurationDTO.BUY_TYPE, BankingKeys.VoucherConfigurations.BUY_TYPE).required().add((PropertyValidation)this.userToSystemValidator);
        voucherConfiguration.property((Property)VoucherConfigurationDTO.REFUND_TYPE, BankingKeys.VoucherConfigurations.REFUND_TYPE).add((PropertyValidation)this.systemToUserValidator);
        if (voucherGenerationStatus == VoucherGenerationStatus.INACTIVE) {
            voucherConfiguration.property((Property)VoucherConfigurationDTO.TOP_UP_TYPE, BankingKeys.VoucherConfigurations.TOP_UP_TYPE).required().add((PropertyValidation)this.userToSystemValidator);
        }
        voucherConfiguration.property((Property)VoucherConfigurationDTO.MASK, BankingKeys.VoucherConfigurations.MASK).required().mask(4);
        org.cyclos.impl.utils.validation.Property property = voucherConfiguration.property((Property)VoucherConfigurationDTO.PIN_USAGE, BankingKeys.VoucherConfigurations.PIN_USAGE).required();
        voucherConfiguration.property((Property)VoucherConfigurationDTO.PIN_LENGTH, BankingKeys.VoucherConfigurations.PIN_LENGTH).between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(16));
        voucherConfiguration.property((Property)VoucherConfigurationDTO.GENERATION_STATUS, BankingKeys.VoucherConfigurations.GENERATION_STATUS).required();
        if (voucherGenerationStatus == VoucherGenerationStatus.INACTIVE) {
            voucherConfiguration.property((Property)VoucherConfigurationDTO.GENERATION_AMOUNT, BankingKeys.VoucherConfigurations.GENERATION_AMOUNT).required();
            voucherConfiguration.property((Property)VoucherConfigurationDTO.PIN_ON_ACTIVATION, BankingKeys.VoucherConfigurations.PIN_ON_ACTIVATION).required();
        } else if (voucherGenerationStatus == VoucherGenerationStatus.BLOCKED && voucherConfigurationDTO.getPinUsage() == VoucherPinUsage.NEVER) {
            property.invalid(BankingKeys.VoucherConfigurations.ERROR_NO_PIN_FOR_BLOCKED_STATUS);
        }
        if (voucherGenerationAmount == VoucherGenerationAmount.DYNAMIC && voucherConfigurationDTO.getPinUsage() == VoucherPinUsage.SUBSEQUENT) {
            property.invalid(BankingKeys.VoucherConfigurations.ERROR_SUBSEQUENT_PIN_FOR_DYNAMIC_AMOUNT);
        }
        if (voucherGenerationStatus != VoucherGenerationStatus.ACTIVE) {
            voucherConfiguration.property((Property)VoucherConfigurationDTO.ACTIVATION_INTERVAL, BankingKeys.VoucherConfigurations.ACTIVATION_INTERVAL).required().timeInterval();
        }
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)voucherConfigurationDTO.getRedeemType());
        if (voucherConfigurationDTO.isReserveAmount() && paymentTransferType != null && paymentTransferType.getFrom().getLimitType() == AccountTypeLimitType.UNLIMITED) {
            voucherConfiguration.general(GeneralValidations.invalid((ValidationError)new ValidationError(BankingKeys.VoucherConfigurations.ERROR_RESERVE_AMOUNT_FROM_UNLIMITED, new Object[]{paymentTransferType.getFrom()})));
        }
        return voucherConfiguration;
    }

    private List<VoucherConfiguration> doListVisible(User user, boolean bl, boolean bl2, boolean bl3) {
        BooleanPropertiesHolder<VoucherConfiguration> booleanPropertiesHolder = this.resolveVoucherConfigurationPermissions(user);
        HashSet hashSet = new HashSet(booleanPropertiesHolder.keysSet((Path)QProductAdminVoucher.productAdminVoucher.view));
        if (bl2) {
            hashSet.addAll(booleanPropertiesHolder.keysSet((Path)QProductUserVoucher.productUserVoucher.viewVouchers));
        }
        if (bl) {
            hashSet.addAll(booleanPropertiesHolder.keysSet((Path)QProductUserVoucher.productUserVoucher.viewTransactions));
        }
        if (bl3) {
            hashSet.addAll(booleanPropertiesHolder.keysSet((Path)QProductUserVoucher.productUserVoucher.redeem));
        }
        return CollectionHelper.sort(hashSet);
    }

    private class TransferTypeValidator
    extends BasePropertyValidation {
        private final TransferTypeDirection direction;

        public TransferTypeValidator(TransferTypeDirection transferTypeDirection) {
            this.direction = transferTypeDirection;
        }

        protected boolean isValid(Object object, Object object2, Object object3) {
            VoucherConfigurationDTO voucherConfigurationDTO = (VoucherConfigurationDTO)object;
            Currency currency = (Currency)this.getConversionHandler().convert(Currency.class, (Object)voucherConfigurationDTO.getCurrency());
            PaymentTransferType paymentTransferType = (PaymentTransferType)this.getConversionHandler().convert(PaymentTransferType.class, object3);
            return paymentTransferType.getDirection() == this.direction && (currency == null || paymentTransferType.getCurrency().equals((Object)currency));
        }
    }
}

