/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.banking.QTransferStatus;
import org.cyclos.entities.banking.QTransferStatusLog;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferStatus;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.banking.TransferStatusLog;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.banking.TransferStatusServiceLocal;
import org.cyclos.impl.search.TransferSearchHandler;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.transferstatus.ChangeTransferStatusDTO;
import org.cyclos.model.banking.transferstatus.TransferStatusDTO;
import org.cyclos.model.banking.transferstatus.TransferStatusData;
import org.cyclos.model.banking.transferstatus.TransferStatusDetailedVO;
import org.cyclos.model.banking.transferstatus.TransferStatusFlowVO;
import org.cyclos.model.banking.transferstatus.TransferStatusVO;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.TransferExtensionPointEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransferStatusServiceImpl
extends CRUDServiceImpl<TransferStatus, QTransferStatus, TransferStatusDTO, TransferStatusData, TransferStatusFlowVO>
implements TransferStatusServiceLocal {
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private TransferSearchHandler transferSearchHandler;

    public TransferStatusServiceImpl() {
        super(TransferStatus.class, QTransferStatus.transferStatus, TransferStatusDTO.class);
    }

    public void changeStatus(ChangeTransferStatusDTO changeTransferStatusDTO) throws FrameworkException {
        TransferStatusFlow transferStatusFlow;
        Transfer transfer = (Transfer)this.conversionHandler.convert(Transfer.class, (Object)changeTransferStatusDTO.getTransfer());
        TransferStatus transferStatus = (TransferStatus)this.conversionHandler.convert(TransferStatus.class, (Object)changeTransferStatusDTO.getNewStatus());
        TransferStatusFlow transferStatusFlow2 = transferStatusFlow = transferStatus == null ? null : transferStatus.getFlow();
        if (transferStatusFlow == null || !transfer.getType().getStatusFlows().contains(transferStatusFlow)) {
            throw new IllegalActionException();
        }
        List<TransferStatus> list = this.getPossibleNext(transfer, transferStatusFlow);
        if (!list.contains(transferStatus)) {
            throw new IllegalActionException();
        }
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)TransferExtensionPointEvent.CHANGE_STATUS, new ExtensionPointFilter(transfer.getType())).attribute("transfer", (Object)transfer).attribute("flow", (Object)transferStatusFlow).attribute("oldStatus", (Object)transfer.getStatus(transferStatusFlow)).attribute("newStatus", (Object)transferStatus).attribute("comments", (Object)changeTransferStatusDTO.getComments());
        extensionPointAccessor.fireValidated();
        transfer.setStatus(transferStatusFlow, transferStatus);
        TransferStatusLog transferStatusLog = new TransferStatusLog();
        transferStatusLog.setTransfer(transfer);
        transferStatusLog.setStatus(transferStatus);
        transferStatusLog.setDate(new Date());
        transferStatusLog.setComments(changeTransferStatusDTO.getComments());
        transferStatusLog.setBy(this.getLoggedBasicUser());
        this.persist((IEntity)transferStatusLog);
        extensionPointAccessor.fireSaved();
        this.transferSearchHandler.index((NetworkedEntity)transfer);
    }

    public List<TransferStatusLog> getLog(Transfer transfer, TransferStatusFlow transferStatusFlow) {
        QTransferStatusLog qTransferStatusLog = QTransferStatusLog.transferStatusLog;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qTransferStatusLog}).where(new Predicate[]{qTransferStatusLog.transfer().eq((Object)transfer), qTransferStatusLog.status().flow().eq((Object)transferStatusFlow)})).orderBy(qTransferStatusLog.date.desc())).list((Expression)qTransferStatusLog);
    }

    public List<TransferStatus> getPossibleNext(Transfer transfer, TransferStatusFlow transferStatusFlow) {
        TransferStatus transferStatus = transfer.getStatus(transferStatusFlow);
        if (transferStatus == null) {
            return null;
        }
        List<Object> list = null;
        CustomScript customScript = transferStatusFlow.getScript();
        if (customScript != null) {
            list = this.customScriptService.newAccessor(customScript, transferStatusFlow.getScriptParameters()).bind("transfer", (Object)transfer).bind("flow", (Object)transferStatusFlow).bind("status", (Object)transferStatus).runForList(TransferStatus.class);
        }
        if (list == null) {
            list = new ArrayList<TransferStatus>(transferStatus.getPossibleNext());
        }
        list.remove(transferStatus);
        Collections.sort(list);
        return list;
    }

    public List<TransferStatusDetailedVO> list(TransferStatusFlowVO transferStatusFlowVO) throws FrameworkException {
        TransferStatusFlow transferStatusFlow = (TransferStatusFlow)this.conversionHandler.convert(TransferStatusFlow.class, (Object)transferStatusFlowVO);
        return this.conversionHandler.convertList(TransferStatusDetailedVO.class, this.listByFlow(transferStatusFlow));
    }

    @Override
    public TransferStatus newEntity(TransferStatusFlowVO transferStatusFlowVO) {
        TransferStatusFlow transferStatusFlow = (TransferStatusFlow)this.conversionHandler.convert(TransferStatusFlow.class, (Object)transferStatusFlowVO);
        TransferStatus transferStatus = new TransferStatus();
        transferStatus.setFlow(transferStatusFlow);
        return transferStatus;
    }

    public void setInitialStatuses(Transfer transfer) {
        TransferType transferType = transfer.getType();
        for (TransferStatus transferStatus : transferType.getInitialStatuses()) {
            TransferStatusFlow transferStatusFlow;
            TransferStatus transferStatus2;
            if (transferStatus.equals((Object)(transferStatus2 = transfer.getStatus(transferStatusFlow = transferStatus.getFlow())))) continue;
            transfer.setStatus(transferStatusFlow, transferStatus);
            this.createLog(transfer, transferStatus);
        }
    }

    @Override
    protected TransferStatusData getData(TransferStatus transferStatus) {
        TransferStatusData transferStatusData = new TransferStatusData();
        transferStatusData.setDto((EntityDTO)((TransferStatusDTO)this.toDTO(transferStatus)));
        List<TransferStatus> list = this.listByFlow(transferStatus.getFlow());
        list.remove(transferStatus);
        transferStatusData.setPossibleNext(this.conversionHandler.convertList(TransferStatusVO.class, list));
        return transferStatusData;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QTransferStatus)this.$).flow().network());
    }

    @Override
    protected Validator resolveValidator(TransferStatusDTO transferStatusDTO) {
        Validator validator = new Validator();
        validator.property((Property)TransferStatusDTO.FLOW, BankingKeys.TransferStatus.FLOW).required();
        TransferStatusFlow transferStatusFlow = (TransferStatusFlow)this.conversionHandler.convert(TransferStatusFlow.class, (Object)transferStatusDTO.getFlow());
        if (transferStatusFlow != null) {
            List<TransferStatusDetailedVO> list = this.list(transferStatusDTO.getFlow());
            if (transferStatusDTO.isPersistent()) {
                list.remove(new TransferStatusVO(transferStatusDTO.getId()));
            }
        }
        validator.property((Property)TransferStatusDTO.POSSIBLE_NEXT, BankingKeys.TransferStatus.POSSIBLE_NEXT).noneOf(new Object[]{new TransferStatusVO(transferStatusDTO.getId())});
        return validator;
    }

    private TransferStatusLog createLog(Transfer transfer, TransferStatus transferStatus) {
        TransferStatusLog transferStatusLog = new TransferStatusLog();
        transferStatusLog.setDate(new Date());
        transferStatusLog.setBy(this.getLoggedBasicUser());
        transferStatusLog.setTransfer(transfer);
        transferStatusLog.setStatus(transferStatus);
        this.entityManagerHandler.persist((IEntity)transferStatusLog);
        return transferStatusLog;
    }

    private List<TransferStatus> listByFlow(TransferStatusFlow transferStatusFlow) {
        return ((DBQuery)((DBQuery)this.from().where((Predicate)((QTransferStatus)this.$).flow().eq((Object)transferStatusFlow))).orderBy(((QTransferStatus)this.$).name.asc())).list((Expression)this.$);
    }
}

