/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountFee;
import org.cyclos.entities.banking.AccountFeeLog;
import org.cyclos.entities.banking.AccountFeeTransfer;
import org.cyclos.entities.banking.BalanceDisposalTransfer;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.ChargebackTransfer;
import org.cyclos.entities.banking.GeneratedTransferType;
import org.cyclos.entities.banking.ImportTransaction;
import org.cyclos.entities.banking.ImportTransfer;
import org.cyclos.entities.banking.InitialCreditTransfer;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.InstallmentTransfer;
import org.cyclos.entities.banking.InternalTransaction;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.PaymentTransfer;
import org.cyclos.entities.banking.QChargebackTransfer;
import org.cyclos.entities.banking.QTransfer;
import org.cyclos.entities.banking.QTransferStatusLog;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferFee;
import org.cyclos.entities.banking.TransferFeeTransfer;
import org.cyclos.entities.banking.TransferStatus;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.banking.TransferSummary;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.UserAccountFeeLog;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.ExportFormat;
import org.cyclos.entities.system.QNetwork;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.banking.AccountFeeLogServiceLocal;
import org.cyclos.impl.banking.AccountLockKey;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.DRateTypeHandler;
import org.cyclos.impl.banking.GetTransferSummaryParameters;
import org.cyclos.impl.banking.NativeAccountStatus;
import org.cyclos.impl.banking.RateHandler;
import org.cyclos.impl.banking.TransactionNumberHandler;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.banking.TransferFeeServiceLocal;
import org.cyclos.impl.banking.TransferNotificationProcessingRecurringTask;
import org.cyclos.impl.banking.TransferServiceLocal;
import org.cyclos.impl.banking.TransferStatusServiceLocal;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockKey;
import org.cyclos.impl.search.TransferSearchHandler;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.system.ExportFormatServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.tasks.RecurringTaskHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.InsufficientBalanceException;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.UpperCreditLimitReachedException;
import org.cyclos.model.banking.accountfees.AccountFeeBalanceHandling;
import org.cyclos.model.banking.accountfees.AccountFeePaymentDirection;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.accounttypes.AccountTypeLimitType;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.TransactionData;
import org.cyclos.model.banking.transfers.ChargebackConfirmationField;
import org.cyclos.model.banking.transfers.TransferActionDTO;
import org.cyclos.model.banking.transfers.TransferData;
import org.cyclos.model.banking.transfers.TransferDetailedVO;
import org.cyclos.model.banking.transfers.TransferFlowStatusLogVO;
import org.cyclos.model.banking.transfers.TransferNature;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.banking.transferstatus.TransferStatusFlowVO;
import org.cyclos.model.banking.transferstatus.TransferStatusFlowWithStatusesVO;
import org.cyclos.model.banking.transferstatus.TransferStatusLogVO;
import org.cyclos.model.banking.transferstatus.TransferStatusVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.TransferExtensionPointEvent;
import org.cyclos.model.utils.FieldSelector;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.services.banking.TransactionService;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransferServiceImpl
extends BaseServiceImpl
implements TransferServiceLocal {
    private static String TRANSACTION = "transaction";
    private static String OPERATIONS = "operations";
    private static String STATUS_FLOWS = "statusFlows";
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private RateHandler rateHandler;
    @Autowired
    private DRateTypeHandler dRateHandler;
    @Autowired
    private LockHandler lockHandler;
    @Autowired
    private TransactionNumberHandler transactionNumberHandler;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private TransferFeeServiceLocal transferFeeService;
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;
    @Autowired
    private TransferStatusServiceLocal transferStatusService;
    @Autowired
    private CustomOperationServiceLocal customOperationService;
    @Autowired
    private ExportFormatServiceLocal exportFormatService;
    @Autowired
    private TransferSearchHandler transferSearchHandler;
    @Autowired
    private RecurringTaskHandler recurringTaskHandler;
    @Autowired
    private AccountFeeLogServiceLocal accountFeeLogService;
    @Autowired
    private VoucherServiceLocal voucherService;

    public boolean canChargeback(Transfer transfer) {
        if (transfer.getParent() != null || transfer instanceof ChargebackTransfer || transfer.getChargedBackBy() != null) {
            return false;
        }
        if (transfer.isToUser() && !this.getSessionData().manages((BasicUser)((User)transfer.getToOwner()))) {
            return false;
        }
        TransferType transferType = transfer.getType();
        TimeInterval timeInterval = transferType.getMaxChargebackTime();
        if (timeInterval != null && DateHelper.add((Date)transfer.getDate(), (ITimeInterval)timeInterval).before(new Date())) {
            return false;
        }
        try {
            this.accountService.checkActive(transfer.getFrom());
            this.accountService.checkActive(transfer.getTo());
        }
        catch (IllegalActionException illegalActionException) {
            return false;
        }
        return true;
    }

    public Long chargeback(TransferActionDTO transferActionDTO) throws FrameworkException, TransferException {
        User user;
        User user2;
        Transfer transfer = (Transfer)this.conversionHandler.convert(Transfer.class, (Object)transferActionDTO.getTransfer());
        if (!Boolean.TRUE.equals(transferActionDTO.getAttribute("skipConfirmationPassword"))) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(transferActionDTO.getConfirmationPassword(), ChargebackConfirmationField.confirmation((TransferVO)transferActionDTO.getTransfer()));
        }
        if (!this.canChargeback(transfer)) {
            throw new IllegalActionException();
        }
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)TransferExtensionPointEvent.CHARGEBACK, new ExtensionPointFilter(transfer.getType())).attribute("transfer", (Object)transfer);
        extensionPointAccessor.fireValidated();
        ChargebackTransfer chargebackTransfer = this.insertChargebackTransfer(transfer);
        if (transfer.getTransaction() instanceof Payment) {
            this.voucherService.chargeback((Payment)transfer.getTransaction());
        }
        if ((user2 = transfer.getFromUser()) != null) {
            this.notificationHandler.user((BasicUser)user2).account().paymentPerformedChargedBack((Transfer)chargebackTransfer, transfer.getCurrencyAmount(), (AccountOwner)transfer.getToOwner(), transfer.getTransactionNumber());
        }
        if ((user = transfer.getToUser()) != null) {
            this.notificationHandler.user((BasicUser)user).account().paymentReceivedChargedBack((Transfer)chargebackTransfer, transfer.getCurrencyAmount(), (AccountOwner)transfer.getFromOwner(), transfer.getTransactionNumber());
        }
        extensionPointAccessor.attribute("chargeback", (Object)chargebackTransfer).fireSaved();
        return chargebackTransfer.getId();
    }

    public FileInfo exportTransfer(ExportFormatVO exportFormatVO, TransferVO transferVO) {
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        Transfer transfer = (Transfer)this.conversionHandler.convert(Transfer.class, (Object)transferVO);
        return this.exportFormatService.exportSingle(exportFormat, ExportFormatContext.TRANS_DETAILS, (Object)transfer);
    }

    public Transfer findByTransactionNumber(String string) throws FrameworkException {
        QTransfer qTransfer = QTransfer.transfer;
        Transfer transfer = (Transfer)InvocationContext.ensure().getAttribute((Object)("transfer:" + string), () -> (Transfer)((DBQuery)this.from(new EntityPath[]{qTransfer}).where((Predicate)qTransfer.transactionNumber.equalsIgnoreCase(string))).singleResult((Expression)qTransfer));
        try {
            if (transfer == null) {
                throw new EntityNotFoundException();
            }
            this.entityManagerHandler.checkAccess((IEntity)transfer);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            throw new EntityNotFoundException(Transfer.class, string);
        }
        return transfer;
    }

    public TransferData getData(Transfer transfer, boolean bl) throws FrameworkException {
        Object object;
        Transaction transaction = transfer.getTransaction();
        TransferData transferData = new TransferData();
        FieldSelector fieldSelector = this.getSessionData().getRequestData().getFields();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!fieldSelector.includes(TransferDetailedVO.CHILDREN.getName())) {
            arrayList.add(TransferDetailedVO.CHILDREN);
        }
        if (!fieldSelector.includes(TransferDetailedVO.PARENT.getName())) {
            arrayList.add(TransferDetailedVO.PARENT);
        }
        if (!fieldSelector.includes(TransferDetailedVO.STATUSES.getName())) {
            arrayList.add(TransferDetailedVO.STATUSES);
        }
        if (!fieldSelector.includes(TransferDetailedVO.A_RATE.getName())) {
            arrayList.add(TransferDetailedVO.A_RATE);
        }
        if (!fieldSelector.includes(TransferDetailedVO.D_RATE.getName())) {
            arrayList.add(TransferDetailedVO.D_RATE);
        }
        TransferDetailedVO transferDetailedVO = (TransferDetailedVO)this.conversionHandler.convertExcluding(TransferDetailedVO.class, (Object)transfer, arrayList.toArray());
        if (bl) {
            if (fieldSelector.includes(TransferData.CONFIRMATION_PASSWORD_INPUT.getName())) {
                transferData.setConfirmationPasswordInput(this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput());
            }
            if (fieldSelector.includes(TransferData.EXPORT_FORMATS.getName())) {
                transferData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(ExportFormatContext.TRANS_DETAILS)));
            }
            if (transaction != null && fieldSelector.includes(TRANSACTION)) {
                object = this.transactionService.getData(transaction, false);
                transferData.setTransactionData((TransactionData)object);
                if (Objects.equals(transferDetailedVO.getDescription(), transaction.getDescription())) {
                    transferDetailedVO.setDescription(null);
                }
            }
        }
        transferDetailedVO.setNature(transfer.getTransferNature());
        transferData.setTransfer(transferDetailedVO);
        if (fieldSelector.includes(TransferData.CAN_CHARGEBACK.getName())) {
            transferData.setCanChargeback(this.canChargeback(transfer));
        }
        if (fieldSelector.includes(OPERATIONS)) {
            transferData.setCustomOperations(this.customOperationService.getRunnableOperationsForTransfer((TransferVO)transferDetailedVO));
        }
        if (fieldSelector.includes(STATUS_FLOWS)) {
            object = new ArrayList(transfer.getType().getStatusFlows());
            HashSet hashSet = new HashSet(this.accountService.getVisibleFlows(transfer.getFrom()));
            hashSet.addAll(this.accountService.getVisibleFlows(transfer.getTo()));
            HashSet hashSet2 = new HashSet();
            hashSet2.addAll(this.accountService.getManagedFlows(transfer.getFrom()));
            hashSet2.addAll(this.accountService.getManagedFlows(transfer.getTo()));
            if (CollectionHelper.isNotEmpty((Iterable)object)) {
                Object object2;
                List list;
                Object object3;
                Collections.sort(object);
                ArrayList<TransferFlowStatusLogVO> arrayList2 = new ArrayList<TransferFlowStatusLogVO>();
                Object object4 = object.iterator();
                while (object4.hasNext()) {
                    object3 = (TransferStatusFlow)object4.next();
                    if (!hashSet.contains(object3)) continue;
                    list = this.transferStatusService.getLog(transfer, (TransferStatusFlow)object3);
                    object2 = new TransferFlowStatusLogVO();
                    object2.setFlow((TransferStatusFlowVO)this.conversionHandler.convert(TransferStatusFlowVO.class, object3));
                    object2.setLog(this.conversionHandler.convertList(TransferStatusLogVO.class, (Iterable)list));
                    arrayList2.add((TransferFlowStatusLogVO)object2);
                }
                transferData.setStatusLog(arrayList2);
                object4 = new ArrayList();
                object3 = object.iterator();
                while (object3.hasNext()) {
                    list = (TransferStatusFlow)object3.next();
                    if (!hashSet2.contains(list)) continue;
                    object2 = this.transferStatusService.getPossibleNext(transfer, (TransferStatusFlow)list);
                    TransferStatusFlowWithStatusesVO transferStatusFlowWithStatusesVO = (TransferStatusFlowWithStatusesVO)this.conversionHandler.convertExcluding(TransferStatusFlowWithStatusesVO.class, (Object)list, new Object[]{TransferStatusFlowWithStatusesVO.STATUSES});
                    transferStatusFlowWithStatusesVO.setStatuses(this.conversionHandler.convertList(TransferStatusVO.class, (Iterable)object2));
                    object4.add(transferStatusFlowWithStatusesVO);
                }
                transferData.setManagedStatusFlows((List)object4);
            }
        }
        return transferData;
    }

    public TransferData getData(TransferVO transferVO) throws IllegalArgumentException {
        Transfer transfer = (Transfer)this.conversionHandler.convert(Transfer.class, (Object)transferVO);
        return this.getData(transfer, true);
    }

    public String getDescription(Transfer transfer) {
        String string;
        Transaction transaction = transfer.getTransaction();
        String string2 = string = transaction == null ? null : transaction.getDescription();
        if (StringHelper.isBlank((Object)string)) {
            string = this.getTranslatedName((NamedEntity)transfer.getType());
        }
        return string;
    }

    public List<Transfer> getRatedTransfers(Account account, int n) {
        Date date = this.dRateHandler.getEnableDate(account.getCurrency(), DateHelper.now());
        if (date == null || account.isTransient()) {
            return Collections.emptyList();
        }
        QTransfer qTransfer = QTransfer.transfer;
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{qTransfer}).where(new Predicate[]{qTransfer.to().eq((Object)account), qTransfer.parent().isNull()});
        QChargebackTransfer qChargebackTransfer = QChargebackTransfer.chargebackTransfer;
        DBQuery dBQuery2 = (DBQuery)this.subQuery(new EntityPath[]{qChargebackTransfer}).where((Predicate)qChargebackTransfer.id.eq((Expression)qTransfer.id));
        dBQuery.where(new Predicate[]{qTransfer.chargedBackBy().isNull(), dBQuery2.notExists()});
        Date date2 = (Date)((DBQuery)((DBQuery)dBQuery.orderBy(qTransfer.date.desc())).offset((long)(n - 1))).singleResult((Expression)qTransfer.date);
        Date date3 = DateHelper.latest((Date[])new Date[]{date, date2});
        QTransfer qTransfer2 = QTransfer.transfer;
        DBQuery dBQuery3 = (DBQuery)this.from(new EntityPath[]{qTransfer2}).where(new Predicate[]{qTransfer2.from().eq((Object)account).or((Predicate)qTransfer2.to().eq((Object)account)), qTransfer2.date.goe((Comparable)date3)});
        dBQuery3.orderBy(qTransfer2.date.asc());
        return dBQuery3.list((Expression)qTransfer2);
    }

    public List<Transfer> getTransfers(Account account, DatePeriod datePeriod, boolean bl) {
        if (account.isTransient()) {
            return Collections.emptyList();
        }
        QTransfer qTransfer = QTransfer.transfer;
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{qTransfer}).where(new Predicate[]{qTransfer.from().eq((Object)account).or((Predicate)qTransfer.to().eq((Object)account)), qTransfer.date.after((Comparable)datePeriod.getBegin()), qTransfer.date.before((Comparable)datePeriod.getEnd())});
        if (!bl) {
            QChargebackTransfer qChargebackTransfer = QChargebackTransfer.chargebackTransfer;
            DBQuery dBQuery2 = (DBQuery)this.subQuery(new EntityPath[]{qChargebackTransfer}).where((Predicate)qChargebackTransfer.id.eq((Expression)qTransfer.id));
            dBQuery.where(new Predicate[]{qTransfer.chargedBackBy().isNull(), dBQuery2.notExists()});
        }
        return ((DBQuery)dBQuery.orderBy(qTransfer.date.asc())).list((Expression)qTransfer);
    }

    public TransferSummary getTransferSummary(GetTransferSummaryParameters getTransferSummaryParameters) {
        QTransfer qTransfer = QTransfer.transfer;
        DBQuery<?> dBQuery = this.from(new EntityPath[]{qTransfer});
        if (QueryHelper.useParameter((Object)getTransferSummaryParameters.getFromAccount())) {
            dBQuery.where((Predicate)qTransfer.from().eq((Object)getTransferSummaryParameters.getFromAccount()));
        }
        if (QueryHelper.useParameter((Object)getTransferSummaryParameters.getToAccount())) {
            dBQuery.where((Predicate)qTransfer.to().eq((Object)getTransferSummaryParameters.getToAccount()));
        }
        if (QueryHelper.useParameter((Object)getTransferSummaryParameters.getTransferType())) {
            dBQuery.where((Predicate)qTransfer.type().eq((Object)getTransferSummaryParameters.getTransferType()));
        }
        if (QueryHelper.useParameter((Object)getTransferSummaryParameters.getPeriod())) {
            dBQuery.where(qTransfer.date.period(getTransferSummaryParameters.getPeriod()));
        }
        return (TransferSummary)dBQuery.singleResult((Expression)Projections.constructor(TransferSummary.class, (Expression[])new Expression[]{qTransfer.count(), qTransfer.amount.sum()}));
    }

    public AccountFeeTransfer insertAccountFeeTransfer(UserAccountFeeLog userAccountFeeLog) {
        UserAccount userAccount = this.accountFeeLogService.resolveAccount(userAccountFeeLog.getAccountFeeLog(), userAccountFeeLog.getUser());
        AccountFeeLog accountFeeLog = userAccountFeeLog.getAccountFeeLog();
        AccountFee accountFee = accountFeeLog.getAccountFee();
        GeneratedTransferType generatedTransferType = accountFee.getTransferType();
        boolean bl = accountFee.getPaymentDirection() == AccountFeePaymentDirection.TO_SYSTEM;
        UserAccount userAccount2 = bl ? userAccount : this.accountService.require((InternalAccountOwner)SystemAccountOwner.instance(), generatedTransferType.getFrom());
        UserAccount userAccount3 = bl ? this.accountService.require((InternalAccountOwner)SystemAccountOwner.instance(), generatedTransferType.getTo()) : userAccount;
        AccountFeeTransfer accountFeeTransfer = new AccountFeeTransfer();
        accountFeeTransfer.setAccountFeeLog(accountFeeLog);
        this.fill((Transfer)accountFeeTransfer, null, (TransferType)generatedTransferType, (Account)userAccount2, (Account)userAccount3, userAccountFeeLog.getAmount());
        this.insertTransferAndPayFees(accountFeeTransfer, transfer -> accountFee.getBalanceHandling() == AccountFeeBalanceHandling.FORCE_CHARGE);
        return accountFeeTransfer;
    }

    public BalanceDisposalTransfer insertBalanceDisposal(UserAccount userAccount, BigDecimal bigDecimal) {
        UserAccountType userAccountType = userAccount.getType();
        BalanceDisposalTransfer balanceDisposalTransfer = new BalanceDisposalTransfer();
        if (BigDecimalHelper.isPositive((BigDecimal)bigDecimal)) {
            GeneratedTransferType generatedTransferType = userAccountType.getDisposePositiveType();
            if (generatedTransferType == null) {
                return null;
            }
            Account account = this.accountService.require((InternalAccountOwner)SystemAccountOwner.instance(), generatedTransferType.getTo());
            this.fill((Transfer)balanceDisposalTransfer, null, (TransferType)generatedTransferType, (Account)userAccount, account, bigDecimal);
        } else if (BigDecimalHelper.isNegative((BigDecimal)bigDecimal)) {
            GeneratedTransferType generatedTransferType = userAccountType.getDisposeNegativeType();
            if (generatedTransferType == null) {
                return null;
            }
            Account account = this.accountService.require((InternalAccountOwner)SystemAccountOwner.instance(), generatedTransferType.getFrom());
            this.fill((Transfer)balanceDisposalTransfer, null, (TransferType)generatedTransferType, account, (Account)userAccount, bigDecimal.abs());
        } else {
            return null;
        }
        this.insertTransferAndPayFees(balanceDisposalTransfer);
        return balanceDisposalTransfer;
    }

    public ImportTransfer insertImportTransfer(ImportTransaction importTransaction, Set<TransferStatus> set) {
        ImportTransfer importTransfer = new ImportTransfer();
        importTransfer.setImportTransaction(importTransaction);
        this.fill((Transfer)importTransfer, null, importTransaction.getType(), importTransaction.getFromOwner(), importTransaction.getToOwner(), importTransaction.getAmount());
        importTransfer.setDate(importTransaction.getDate());
        CollectionHelper.forEach(set, transferStatus -> importTransfer.setStatus(transferStatus.getFlow(), transferStatus));
        this.accountService.removeLastClosedAccountBalances((Transfer)importTransfer);
        this.insert(importTransfer, true, importTransaction.getType());
        importTransaction.setTransfer(importTransfer);
        return importTransfer;
    }

    public InitialCreditTransfer insertInitialCreditTransfer(UserAccount userAccount, GeneratedTransferType generatedTransferType, BigDecimal bigDecimal) throws FrameworkException, TransferException {
        Account account = this.accountService.require((InternalAccountOwner)SystemAccountOwner.instance(), generatedTransferType.getFrom());
        InitialCreditTransfer initialCreditTransfer = new InitialCreditTransfer();
        this.fill((Transfer)initialCreditTransfer, null, (TransferType)generatedTransferType, account, (Account)userAccount, bigDecimal);
        this.insertTransferAndPayFees(initialCreditTransfer);
        return initialCreditTransfer;
    }

    public InstallmentTransfer insertInstallmentTransfer(Installment installment) {
        InternalTransaction internalTransaction = installment.getTransaction();
        InstallmentTransfer installmentTransfer = new InstallmentTransfer();
        installmentTransfer.setInstallment(installment);
        this.fill((Transfer)installmentTransfer, null, internalTransaction.getType(), internalTransaction.getFromOwner(), internalTransaction.getToOwner(), installment.getAmount());
        this.insertTransferAndPayFees(installmentTransfer);
        installment.setTransfer(installmentTransfer);
        return installmentTransfer;
    }

    public PaymentTransfer insertPaymentTransfer(Payment payment) throws FrameworkException, TransferException {
        if (payment.getTransfer() != null) {
            throw new IllegalActionException("This payment has a Transfer already");
        }
        PaymentTransfer paymentTransfer = new PaymentTransfer();
        paymentTransfer.setPayment(payment);
        String string = payment.getTransactionNumber();
        this.fill((Transfer)paymentTransfer, string, payment.getType(), payment.getFromOwner(), payment.getToOwner(), payment.getAmount());
        this.insertTransferAndPayFees(paymentTransfer);
        payment.setTransfer(paymentTransfer);
        String string2 = paymentTransfer.getTransactionNumber();
        if (string == null && string2 != null) {
            payment.setTransactionNumber(string2);
        }
        return paymentTransfer;
    }

    public TransferVO load(Long l) throws FrameworkException {
        return (TransferVO)this.conversionHandler.convert(TransferVO.class, (Object)this.find(Transfer.class, l));
    }

    public TransferVO loadByTransactionNumber(String string) throws FrameworkException {
        return (TransferVO)this.conversionHandler.convert(TransferVO.class, (Object)this.findByTransactionNumber(string));
    }

    public void notifyTransferReceived(Transfer transfer) {
        Transaction transaction = transfer.getTransaction();
        Object object = transfer.getParent() == null && transaction != null ? transaction.getReceiver() : transfer.getToUser();
        if (object != null) {
            this.notificationHandler.user((BasicUser)object).account().paymentReceived(transfer, transfer.getCurrencyAmount(), (AccountOwner)transfer.getFromOwner(), transaction == null ? null : transaction.getDescription(), transfer.getTransactionNumber());
        }
        this.accountService.sendStatusPushNotification(transfer.getFrom());
        this.accountService.sendStatusPushNotification(transfer.getTo());
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        Function<QTransfer, QNetwork> function = qTransfer -> qTransfer.type().from().currency().network();
        networkPathRegistry.register(function.apply(QTransfer.transfer), true);
        networkPathRegistry.register(function.apply(QTransferStatusLog.transferStatusLog.transfer()), true);
    }

    private void fill(Transfer transfer, String string, TransferType transferType, Account account, Account account2, BigDecimal bigDecimal) {
        if (!BigDecimalHelper.isPositive((BigDecimal)bigDecimal) || bigDecimal.compareTo(TransactionService.MAX_TRANSACTION_AMOUNT_EXCLUSIVE) >= 0) {
            throw new ValidationException("amount", this.message(GeneralKeys.Errors.INVALID, BankingKeys.Transactions.AMOUNT));
        }
        transfer.setDate(new Date());
        transfer.setType(transferType);
        transfer.setFrom(account);
        transfer.setTo(account2);
        transfer.setAmount(bigDecimal);
        if (string == null) {
            string = this.transactionNumberHandler.generate(transferType.getCurrency());
        }
        transfer.setTransactionNumber(string);
    }

    private void fill(Transfer transfer, String string, TransferType transferType, InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, BigDecimal bigDecimal) {
        Account account = this.accountService.require(internalAccountOwner, transferType.getFrom());
        Account account2 = this.accountService.require(internalAccountOwner2, transferType.getTo());
        this.fill(transfer, string, transferType, account, account2, bigDecimal);
    }

    private <T extends Transfer> void insert(T t, boolean bl, TransferType transferType) {
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)TransferExtensionPointEvent.CREATE, new ExtensionPointFilter(transferType)).attribute("transfer", t);
        BigDecimal bigDecimal = BigDecimalHelper.round((BigDecimal)t.getAmount(), (int)transferType.getCurrency().getPrecision());
        t.setAmount(bigDecimal);
        extensionPointAccessor.fireValidated();
        Transaction transaction = t.getTransaction();
        boolean bl2 = transaction instanceof BasePayment && ((BasePayment)transaction).getCreationType() == PaymentCreationType.IMPORT;
        boolean bl3 = transferType.isNotifyPaymentReceived() && (!bl2 || t.getTransferNature() == TransferNature.PAYMENT && ((PaymentTransfer)t).getPayment().isSendNotifications());
        t.setPendingNotification(bl3);
        this.processAndPersist(t, bl);
        if (t.getTransactionNumber() == null) {
            t.setTransactionNumber(this.transactionNumberHandler.generate(t.getCurrency()));
        }
        this.transferStatusService.setInitialStatuses(t);
        if (t.isPendingNotification()) {
            this.recurringTaskHandler.scheduleAwake(TransferNotificationProcessingRecurringTask.class);
        }
        extensionPointAccessor.fireSaved();
    }

    private ChargebackTransfer insertChargebackTransfer(Transfer transfer) {
        ChargebackTransfer chargebackTransfer = new ChargebackTransfer();
        this.fill((Transfer)chargebackTransfer, null, transfer.getType(), transfer.getTo(), transfer.getFrom(), transfer.getAmount());
        chargebackTransfer.setChargebackOf(transfer);
        this.processAndPersist((Transfer)chargebackTransfer, false);
        this.transferStatusService.setInitialStatuses((Transfer)chargebackTransfer);
        transfer.setChargedBackBy(chargebackTransfer);
        this.transferSearchHandler.index((NetworkedEntity)transfer);
        ArrayList<ChargebackTransfer> arrayList = new ArrayList<ChargebackTransfer>();
        for (Transfer transfer2 : transfer.getChildren()) {
            ChargebackTransfer chargebackTransfer2 = this.insertChargebackTransfer(transfer2);
            arrayList.add(chargebackTransfer2);
        }
        chargebackTransfer.setChildren(arrayList);
        return chargebackTransfer;
    }

    private <T extends Transfer> T insertTransferAndPayFees(T t) throws TransferException {
        return this.insertTransferAndPayFees(t, transfer -> transfer.getType().isIgnoreAccountLimits());
    }

    private <T extends Transfer> T insertTransferAndPayFees(T t, Function<Transfer, Boolean> function) throws TransferException {
        TransferType transferType = t.getType();
        ArrayList<TransferFeeTransfer> arrayList = new ArrayList<TransferFeeTransfer>();
        BigDecimal bigDecimal = t.getAmount();
        for (Object object : CollectionHelper.sort((Collection)transferType.getTransferFees())) {
            TransferFeeTransfer transferFeeTransfer = this.transferFeeService.buildTransfer(null, (TransferFee)object, t);
            if (transferFeeTransfer == null) continue;
            if (object.isDeductAmount()) {
                bigDecimal = bigDecimal.subtract(transferFeeTransfer.getAmount());
            }
            arrayList.add(transferFeeTransfer);
        }
        t.setAmount(bigDecimal);
        this.insert(t, function.apply(t), transferType);
        ArrayList arrayList2 = new ArrayList();
        for (TransferFeeTransfer transferFeeTransfer : arrayList) {
            this.insertTransferAndPayFees(transferFeeTransfer, function);
            arrayList2.add(transferFeeTransfer);
        }
        t.setChildren((List)arrayList2);
        return t;
    }

    private void processAndPersist(Transfer transfer, boolean bl) throws TransferException {
        boolean bl2;
        Object object;
        boolean bl3;
        boolean bl4;
        Account account2 = transfer.getFrom();
        Account account3 = transfer.getTo();
        if (account2.isTransient()) {
            account2 = this.accountService.require(account2.getOwner(), account2.getType());
            transfer.setFrom(account2);
        }
        boolean bl5 = bl4 = !(transfer instanceof BalanceDisposalTransfer);
        if (bl4) {
            this.accountService.checkActive(account2);
        }
        if (account3.isTransient()) {
            account3 = this.accountService.require(account3.getOwner(), account3.getType());
            transfer.setTo(account3);
        }
        if (bl4) {
            this.accountService.checkActive(account3);
        }
        if (account2.equals((Object)account3)) {
            throw new IllegalActionException("From and to account can't be the same in a transfer!");
        }
        BigDecimal bigDecimal = transfer.getAmount().abs();
        if (bigDecimal == null || BigDecimalHelper.isNegativeOrZero((BigDecimal)bigDecimal)) {
            throw new ValidationException();
        }
        TransferType transferType = transfer.getType();
        if (transferType.isIgnoreAccountLimits()) {
            bl = true;
        }
        ArrayList<BalanceUpdate> arrayList = new ArrayList<BalanceUpdate>(2);
        ArrayList<Account> arrayList2 = new ArrayList<Account>(2);
        boolean bl6 = this.rateHandler.isAnyRateEnabled(account2.getCurrency(), null);
        boolean bl7 = account2.getType().getLimitType() == AccountTypeLimitType.LIMITED;
        boolean bl8 = bl6 || !bl && bl7 && transferType.isLockFrom();
        LockKey lockKey = AccountLockKey.of(account2);
        if (bl8) {
            this.lockHandler.lock(lockKey);
            bl3 = true;
        } else {
            bl3 = this.lockHandler.tryLock(lockKey);
        }
        if (!bl3) {
            arrayList2.add(account2);
        }
        if (bl3 || bl7 && !bl) {
            BigDecimal bigDecimal2;
            object = this.accountService.getNativeAccountStatus(account2, null);
            if (!bl && bl7 && BigDecimalHelper.compareTo((BigDecimal)(bigDecimal2 = this.accountService.getCurrentAvailableBalance(account2, object)), (BigDecimal)bigDecimal) < 0) {
                throw new InsufficientBalanceException();
            }
            if (bl3) {
                bigDecimal2 = object.getBalance();
                BigDecimal bigDecimal3 = bigDecimal2.subtract(bigDecimal);
                arrayList.add(new BalanceUpdate(account2, (NativeAccountStatus)object, bigDecimal3));
            }
        }
        object = this.accountService.getUpperCreditLimit(account3, null);
        boolean bl9 = BigDecimalHelper.isPositive((BigDecimal)object);
        boolean bl10 = bl6 || !bl && bl9 && transferType.isLockTo();
        LockKey lockKey2 = AccountLockKey.of(account3);
        if (bl10) {
            this.lockHandler.lock(lockKey2);
            bl2 = true;
        } else {
            bl2 = this.lockHandler.tryLock(lockKey2);
        }
        if (!bl2) {
            arrayList2.add(account3);
        }
        if (bl2 || bl9 && !bl) {
            NativeAccountStatus nativeAccountStatus = this.accountService.getNativeAccountStatus(account3, null);
            BigDecimal bigDecimal4 = nativeAccountStatus.getBalance();
            BigDecimal bigDecimal5 = bigDecimal4.add(bigDecimal);
            if (bl9 && !bl && BigDecimalHelper.compareTo((BigDecimal)bigDecimal5, (BigDecimal)object) > 0) {
                throw new UpperCreditLimitReachedException();
            }
            if (bl2) {
                arrayList.add(new BalanceUpdate(account3, nativeAccountStatus, bigDecimal5));
            }
        }
        if (bl6) {
            this.rateHandler.applyTransfer(transfer);
        }
        this.persist((IEntity)transfer);
        arrayList.forEach(balanceUpdate -> this.accountService.updateBalance(balanceUpdate.account, balanceUpdate.newBalance, balanceUpdate.status.getDirtyTransferIds()));
        arrayList2.forEach(account -> this.accountService.makeBalanceDirty(account, transfer));
        this.transferSearchHandler.index((NetworkedEntity)transfer);
    }

    private static class BalanceUpdate {
        private final Account account;
        private final NativeAccountStatus status;
        private final BigDecimal newBalance;

        public BalanceUpdate(Account account, NativeAccountStatus nativeAccountStatus, BigDecimal bigDecimal) {
            this.account = account;
            this.status = nativeAccountStatus;
            this.newBalance = bigDecimal;
        }
    }
}

