/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import org.cyclos.entities.banking.QInstallment;
import org.cyclos.entities.banking.QInstallmentTransfer;
import org.cyclos.entities.banking.QInternalTransaction;
import org.cyclos.impl.banking.BaseTransactionQueryHandlerImpl;
import org.cyclos.impl.banking.BuildInstallmentQueryParams;
import org.cyclos.impl.banking.InstallmentQueryHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.banking.transactions.BaseInstallmentQuery;
import org.cyclos.model.banking.transactions.TransactionOrderBy;
import org.cyclos.utils.CollectionHelper;
import org.springframework.stereotype.Component;

@Component
public class InstallmentQueryHandlerImpl
extends BaseTransactionQueryHandlerImpl<BaseInstallmentQuery, BuildInstallmentQueryParams>
implements InstallmentQueryHandler {
    private final QInstallment i = QInstallment.installment;
    private final QInstallmentTransfer t = QInstallmentTransfer.installmentTransfer;

    public InstallmentQueryHandlerImpl() {
        this.tx = QInternalTransaction.internalTransaction._super;
        this.id = this.i.id;
        this.date = this.i.dueDate;
        this.amount = this.i.amount;
        this.transactionNumber = this.tx.transactionNumber;
    }

    @Override
    public DBQuery<?> build(BuildInstallmentQueryParams buildInstallmentQueryParams) {
        DBQuery<?> dBQuery = super.build(buildInstallmentQueryParams);
        BaseInstallmentQuery baseInstallmentQuery = (BaseInstallmentQuery)buildInstallmentQueryParams.getParams();
        if (CollectionHelper.isNotEmpty((Iterable)baseInstallmentQuery.getStatuses())) {
            dBQuery.where((Predicate)this.i.status.in((Collection)baseInstallmentQuery.getStatuses()));
        }
        return dBQuery;
    }

    public QInstallment getInstallmentPath() {
        return this.i;
    }

    public QInstallmentTransfer getTransferPath() {
        return this.t;
    }

    @Override
    protected TransactionOrderBy getDefaultOrder() {
        return TransactionOrderBy.DATE_ASC;
    }

    @Override
    protected DBQuery<?> initQuery(BuildInstallmentQueryParams buildInstallmentQueryParams) {
        DBQuery dBQuery = (DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{this.i}).leftJoin((EntityPath)this.i.transaction()._super, (Path)this.tx)).leftJoin((CollectionExpression)this.i.transfers, (Path)this.t)).leftJoin((EntityPath)this.tx.type(), (Path)this.tt)).leftJoin((EntityPath)this.tx.from(), (Path)this.fa)).leftJoin((EntityPath)this.fa.type(), (Path)this.fat)).leftJoin((EntityPath)this.fat.currency(), (Path)this.c)).leftJoin((EntityPath)this.fa.user(), (Path)this.fu)).leftJoin((EntityPath)this.fu.group(), (Path)this.fg)).leftJoin((EntityPath)this.tx.to(), (Path)this.ta)).leftJoin((EntityPath)this.ta.type(), (Path)this.tat)).leftJoin((EntityPath)this.ta.user(), (Path)this.tu)).leftJoin((EntityPath)this.tu.group(), (Path)this.tg);
        return dBQuery;
    }
}

