/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimeExpression;
import java.util.Collection;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.QExternalPayment;
import org.cyclos.impl.banking.ExternalPaymentServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.EntityBatchRecurringTask;
import org.cyclos.model.banking.transactions.ExternalPaymentStatus;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExpireExternalPaymentRecurringTask
extends EntityBatchRecurringTask<ExternalPayment> {
    @Autowired
    private ExternalPaymentServiceLocal externalPaymentService;

    public ExpireExternalPaymentRecurringTask() {
        super(ExternalPayment.class);
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.EXPIRE_EXTERNAL_PAYMENT;
    }

    @Override
    protected void finish(ExternalPayment externalPayment, Throwable throwable) throws Throwable {
    }

    @Override
    protected Collection<Long> nextIds() throws Throwable {
        QExternalPayment qExternalPayment = QExternalPayment.externalPayment;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qExternalPayment}).where((Predicate)qExternalPayment.status.eq((Object)ExternalPaymentStatus.PENDING.name()).and((Predicate)qExternalPayment.expirationDate.before((Expression)DateTimeExpression.currentTimestamp())))).limit(200L)).list((Expression)qExternalPayment.id);
    }

    @Override
    protected void process(ExternalPayment externalPayment) throws Throwable {
        this.externalPaymentService.expire(externalPayment);
    }
}

