/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.mysema.commons.lang.CloseableIterator;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cyclos.entities.banking.AccountFeeLog;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.AccountFeeLogServiceLocal;
import org.cyclos.impl.banking.ChargeAccountFeeBatchBackgroundTask;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.banking.accountfees.AccountFeeLogStatus;
import org.cyclos.model.banking.accountfees.UserAccountFeeStatus;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DispatchAccountFeeChargesBackgroundTask
extends AbstractBackgroundTask {
    private static final int BATCH_SIZE = 200;
    @Autowired
    private AccountFeeLogServiceLocal accountFeeLogService;
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;

    public static BackgroundTaskScheduling scheduling(AccountFeeLog accountFeeLog) {
        return new BackgroundTaskScheduling(DispatchAccountFeeChargesBackgroundTask.class, (Object)accountFeeLog.getId(), "Dispatch charges for account fee " + accountFeeLog.getAccountFee().getName() + " for " + DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(ZonedDateTime.ofInstant(accountFeeLog.getDate().toInstant(), ZoneId.systemDefault())));
    }

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.DISPATCH_ACCOUNT_FEE_CHARGES;
    }

    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        Long l = Long.parseLong(string);
        return (Long)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> this.dispatch(l));
    }

    private long dispatch(Long l) {
        AccountFeeLog accountFeeLog = (AccountFeeLog)this.rawEntityManagerHandler.find(AccountFeeLog.class, l);
        long l2 = accountFeeLog.getStatus() == AccountFeeLogStatus.PREPARING ? this.nativeQueryHandler.insertUserAccountFeeLogs(accountFeeLog) : (accountFeeLog.getStatus() == AccountFeeLogStatus.RECHARGING_FAILED ? (long)this.accountFeeLogService.countUsers(accountFeeLog, EnumSet.of(UserAccountFeeStatus.FAILED)) : 0L);
        int n = (int)Math.ceil((double)l2 * 1.0 / 200.0);
        if (n == 0) {
            this.accountFeeLogService.markFinished(accountFeeLog.getId());
        } else {
            Long l3 = this.backgroundTaskHandler.newForkJoin((long)n, String.format("accountFeeLogService.markFinished(%s)", l), new String[0]);
            if (accountFeeLog.getStatus() == AccountFeeLogStatus.PREPARING) {
                accountFeeLog.setStatus(AccountFeeLogStatus.RUNNING);
            }
            MutableInt mutableInt = new MutableInt();
            try (CloseableIterator closeableIterator = this.accountFeeLogService.getUserAFLIdsToCharge(accountFeeLog);){
                UnmodifiableIterator unmodifiableIterator = Iterators.partition((Iterator)closeableIterator, (int)200);
                unmodifiableIterator.forEachRemaining(list -> this.backgroundTaskHandler.schedule(ChargeAccountFeeBatchBackgroundTask.scheduling(accountFeeLog, mutableInt.incrementAndGet(), list, l3)));
            }
        }
        return l2;
    }
}

