/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.entities.banking.AccountFeeLog;
import org.cyclos.impl.banking.AccountFeeLogServiceLocal;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.scheduledtasks.BackgroundTaskPriority;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChargeAccountFeeBatchBackgroundTask
extends AbstractBackgroundTask {
    @Autowired
    private AccountFeeLogServiceLocal accountFeeLogService;

    public static BackgroundTaskScheduling scheduling(AccountFeeLog accountFeeLog, int n, List<Long> list, Long l) {
        String string = StringHelper.join(list, (String)",");
        return new BackgroundTaskScheduling(ChargeAccountFeeBatchBackgroundTask.class, (Object)string, "Charge batch #" + n + " (joinId=" + l + ") for account fee " + accountFeeLog.getAccountFee().getName() + " for " + DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(ZonedDateTime.ofInstant(accountFeeLog.getDate().toInstant(), ZoneId.systemDefault())), l);
    }

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.CHARGE_ACCOUNT_FEE_BATCH;
    }

    public BackgroundTaskPriority getPriority() {
        return BackgroundTaskPriority.LOW;
    }

    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        List list = StringHelper.splitTrimming((String)string, (String)",").stream().map(Long::valueOf).collect(Collectors.toList());
        this.accountFeeLogService.chargeBatch(list);
        return list.size();
    }
}

