/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.AuthorizationRole;
import org.cyclos.entities.banking.QAuthorizationRole;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.AdminProductAuthorizationRole;
import org.cyclos.entities.users.QAdminProduct;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.banking.AuthorizationLevelServiceLocal;
import org.cyclos.impl.banking.AuthorizationRoleServiceLocal;
import org.cyclos.impl.users.GroupServiceLocal;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.authorizationroles.AuthorizationRoleDTO;
import org.cyclos.model.banking.authorizationroles.AuthorizationRoleData;
import org.cyclos.model.banking.authorizationroles.AuthorizationRoleDetailedVO;
import org.cyclos.server.utils.PropertyHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthorizationRoleServiceImpl
extends CRUDServiceImpl<AuthorizationRole, QAuthorizationRole, AuthorizationRoleDTO, AuthorizationRoleData, Void>
implements AuthorizationRoleServiceLocal {
    @Autowired
    private GroupServiceLocal groupService;
    @Autowired
    private AuthorizationLevelServiceLocal authorizationLevelService;
    @Autowired
    private CacheHandler cacheHandler;

    public AuthorizationRoleServiceImpl() {
        super(AuthorizationRole.class, QAuthorizationRole.authorizationRole, AuthorizationRoleDTO.class);
    }

    public List<AuthorizationRoleDetailedVO> list() {
        return this.conversionHandler.convertList(AuthorizationRoleDetailedVO.class, this.listAll());
    }

    public List<AuthorizationRole> listAll() {
        return ((DBQuery)this.from().orderBy(((QAuthorizationRole)this.$).name.asc())).list(AuthorizationRole.class, (Expression)this.$);
    }

    @Override
    public AuthorizationRole newEntity(Void void_) {
        return new AuthorizationRole();
    }

    @Override
    protected void doRemove(AuthorizationRole authorizationRole, boolean bl) {
        if (authorizationRole.getNetwork() == null) {
            AdminProduct adminProduct = this.groupService.getSystemAdmins().getAdminProduct();
            Set set = adminProduct.getAuthorizationRoles();
            set.removeIf(adminProductAuthorizationRole -> adminProductAuthorizationRole.getAuthorizationRole().equals((Object)authorizationRole));
            if (set.isEmpty()) {
                adminProduct.getPermissions().removeAll(Arrays.asList(Permission.ADMIN_AUTHORIZATIONS_MANAGE));
            }
        }
        super.doRemove(authorizationRole, bl);
    }

    @Override
    protected AuthorizationRoleData getData(AuthorizationRole authorizationRole) {
        AuthorizationRoleData authorizationRoleData = new AuthorizationRoleData();
        authorizationRoleData.setDto((EntityDTO)((AuthorizationRoleDTO)this.toDTO(authorizationRole)));
        return authorizationRoleData;
    }

    @Override
    protected void onAfterRemove(AuthorizationRole authorizationRole) {
        this.authorizationLevelService.removeEmptyLevels();
        Long l = SimpleEntity.id((SimpleEntity)authorizationRole.getNetwork());
        String string = PropertyHelper.getGetterName((Path)QAdminProduct.adminProduct.authorizationRoles);
        this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesNetworkAndMethod(l, string));
    }

    @Override
    protected void onAfterSave(AuthorizationRole authorizationRole, AuthorizationRole authorizationRole2, Object object) {
        if (authorizationRole2 == null && authorizationRole.getNetwork() == null) {
            AdminProduct adminProduct = this.groupService.getSystemAdmins().getAdminProduct();
            AdminProductAuthorizationRole adminProductAuthorizationRole = new AdminProductAuthorizationRole();
            adminProductAuthorizationRole.setProduct(adminProduct);
            adminProductAuthorizationRole.setAuthorizationRole(authorizationRole);
            adminProductAuthorizationRole.setView(true);
            adminProductAuthorizationRole.setManage(true);
            adminProduct.getAuthorizationRoles().add(adminProductAuthorizationRole);
            adminProduct.getPermissions().addAll(Arrays.asList(Permission.ADMIN_AUTHORIZATIONS_MANAGE));
            Long l = SimpleEntity.id((SimpleEntity)authorizationRole.getNetwork());
            this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesNetwork(l));
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QAuthorizationRole)this.$).network());
    }

    @Override
    protected Validator resolveValidator(AuthorizationRoleDTO authorizationRoleDTO) {
        return new Validator();
    }
}

