/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.QAccount;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.impl.BaseGlobalHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.AccountVerificationHandler;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.search.UserSearchHandler;
import org.cyclos.impl.sql.AccountStatusUpdateResult;
import org.cyclos.impl.sql.InconsistentBalance;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.BalanceInconsistencyParameters;
import org.cyclos.impl.system.LicenseHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.banking.accounts.AccountStatusVO;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MutableObject;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccountVerificationHandlerImpl
extends BaseGlobalHandlerImpl
implements AccountVerificationHandler {
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    @Autowired
    private AlertServiceLocal alertService;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private UserSearchHandler userSearchHandler;
    @Autowired
    private JsonConverter jsonConverter;
    @Autowired
    private LicenseHandler licenseHandler;

    public List<InconsistentBalance> fixInconsistentBalances() {
        List list = this.nativeQueryHandler.fixInconsistentAccountBalances(null);
        if (!list.isEmpty()) {
            InvocationContext.ensure().addCommitListener(false, () -> this.invokerHandler.getExecutorService().submit(() -> {
                try {
                    this.clearInconsistencies(list);
                }
                catch (Exception exception) {
                    this.getLogger().warn("Error reattempting to fix balance inconsistencies", (Throwable)exception);
                }
                BalanceInconsistencyParameters balanceInconsistencyParameters = this.generateAlerts(list);
                this.notifyIssueToLicense(balanceInconsistencyParameters);
            }));
        }
        return list;
    }

    public void rebuildClosedBalances(Long ... longArray) {
        this.nativeQueryHandler.rebuildClosedAccountBalances(CollectionHelper.isEmpty((Object[])longArray) ? null : Arrays.asList(longArray));
    }

    private void clearInconsistencies(List<InconsistentBalance> list) {
        SessionData sessionData = SessionDataFactory.system();
        TransactionLevel transactionLevel = TransactionLevel.READ_WRITE;
        ArrayList<InconsistentBalance> arrayList = new ArrayList<InconsistentBalance>(list);
        int n = 0;
        while (!arrayList.isEmpty() && n++ < 10) {
            List list2 = arrayList.stream().map(InconsistentBalance::getAccountId).collect(Collectors.toList());
            List list3 = (List)this.invokerHandler.runAsInTransaction(sessionData, transactionLevel, transactionStatus -> this.nativeQueryHandler.fixInconsistentAccountBalances(list2));
            arrayList.retainAll(list3);
        }
    }

    private void createSystemAlert(List<Pair<Account, InconsistentBalance>> list) {
        String string;
        List list2 = list.stream().map(Pair::getSecond).collect(Collectors.toList());
        try {
            string = this.jsonConverter.writeValueAsString(list2);
        }
        catch (JsonGenerationException | JsonMappingException throwable) {
            throw new IllegalStateException(throwable);
        }
        this.alertService.create(SystemAlertType.ACCOUNT_BALANCE_FIXED, new Object[]{string});
    }

    private boolean createUserAlertIfNeeded(AccountStatusVO accountStatusVO) {
        BigDecimal bigDecimal;
        boolean bl;
        Account account = this.find(Account.class, accountStatusVO.getAccountId());
        BigDecimal bigDecimal2 = accountStatusVO.getCreditLimit();
        if (bigDecimal2 == null) {
            return false;
        }
        if (!BigDecimalHelper.isZero((BigDecimal)bigDecimal2)) {
            bigDecimal2 = bigDecimal2.abs().negate();
        }
        boolean bl2 = bl = (bigDecimal = accountStatusVO.getBalance()).compareTo(bigDecimal2) < 0;
        if (bl) {
            if (account instanceof UserAccount) {
                this.alertService.create(((UserAccount)account).getUser(), UserAlertType.INCONSISTENT_BALANCE_BELOW_LIMIT, new Object[]{account.getType(), new CurrencyAmount(account.getCurrency(), bigDecimal), new CurrencyAmount(account.getCurrency(), bigDecimal2)});
            } else {
                this.alertService.create(SystemAlertType.INCONSISTENT_BALANCE_BELOW_LIMIT, new Object[]{account.getType(), new CurrencyAmount(account.getCurrency(), bigDecimal), new CurrencyAmount(account.getCurrency(), bigDecimal2)});
            }
        }
        return bl;
    }

    private BalanceInconsistencyParameters generateAlerts(List<InconsistentBalance> list2) {
        MutableObject mutableObject = new MutableObject(null);
        if (!this.cyclosProperties.isLicenseIgnoreIssueReports()) {
            mutableObject.set((Object)new BalanceInconsistencyParameters());
            list2.forEach(inconsistentBalance -> ((BalanceInconsistencyParameters)mutableObject.get()).add(inconsistentBalance.getAccountId().longValue()));
        }
        Map<Long, List<InconsistentBalance>> map = list2.stream().collect(Collectors.groupingBy(InconsistentBalance::getNetworkId));
        map.forEach((l, list) -> this.generateAlerts((Long)l, (List<InconsistentBalance>)list, (BalanceInconsistencyParameters)mutableObject.get()));
        return (BalanceInconsistencyParameters)mutableObject.get();
    }

    private void generateAlerts(Long l, List<InconsistentBalance> list, BalanceInconsistencyParameters balanceInconsistencyParameters) {
        if (CollectionHelper.isEmpty(list)) {
            return;
        }
        SessionData sessionData = SessionDataFactory.system();
        TransactionLevel transactionLevel = TransactionLevel.READ_WRITE;
        QAccount qAccount = QAccount.account;
        for (List list2 : Lists.partition(list, (int)20)) {
            this.invokerHandler.runAsInTransaction(sessionData, transactionLevel, transactionStatus -> {
                Network network = l == null ? null : this.find(Network.class, l);
                List list2 = list2.stream().map(InconsistentBalance::getAccountId).collect(Collectors.toList());
                ((DBQuery)this.from(new EntityPath[]{qAccount}).where((Predicate)qAccount.id.in(list2))).list((Expression)qAccount);
                return this.invokerHandler.runAs(SessionDataFactory.system((Network)network), () -> {
                    List<Pair<Account, InconsistentBalance>> list2 = list2.stream().map(this::toPair).collect(Collectors.toList());
                    this.createSystemAlert(list2);
                    List list3 = list2.stream().map(Pair::getFirst).collect(Collectors.toList());
                    this.userSearchHandler.updateBalances(CollectionHelper.filterByType(list3.stream(), UserAccount.class).collect(Collectors.toMap(userAccount -> userAccount, this::toBalanceUpdateResult)));
                    list3.stream().map(account -> this.accountService.getAccountStatus(account, null, null)).forEach(accountStatusVO -> {
                        if (this.createUserAlertIfNeeded((AccountStatusVO)accountStatusVO) && balanceInconsistencyParameters != null) {
                            balanceInconsistencyParameters.addBelowLimit(accountStatusVO.getAccountId().longValue());
                        }
                    });
                    return null;
                });
            });
        }
    }

    private void notifyIssueToLicense(BalanceInconsistencyParameters balanceInconsistencyParameters) {
        if (balanceInconsistencyParameters != null) {
            this.invokerHandler.submitAsInParallelTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> {
                try {
                    this.licenseHandler.reportInconsistentBalance(balanceInconsistencyParameters);
                }
                catch (Exception exception) {
                    this.getLogger().warn("Error notifying the license server about balance inconsistencies: {}", (Object)exception.getMessage());
                }
            });
        }
    }

    private AccountStatusUpdateResult toBalanceUpdateResult(UserAccount userAccount) {
        AccountStatusUpdateResult accountStatusUpdateResult = new AccountStatusUpdateResult();
        accountStatusUpdateResult.setAccountId(userAccount.getId());
        accountStatusUpdateResult.setBalance(this.accountService.getBalance((Account)userAccount, null));
        accountStatusUpdateResult.setNegativeSince(userAccount.getNegativeSince());
        accountStatusUpdateResult.setNegativeSinceChanged(false);
        return accountStatusUpdateResult;
    }

    private Pair<Account, InconsistentBalance> toPair(InconsistentBalance inconsistentBalance) {
        Account account = this.find(Account.class, inconsistentBalance.getAccountId());
        return Pair.create((Object)account, (Object)inconsistentBalance);
    }
}

