/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.cyclos.entities.banking.ARateParameters;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.QARateParameters;
import org.cyclos.entities.banking.QAccountRates;
import org.cyclos.entities.banking.QRateParameters;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.utils.RatedEntity;
import org.cyclos.impl.banking.ARateTypeHandlerTestable;
import org.cyclos.impl.banking.RatesData;
import org.cyclos.impl.banking.TimeBasedRateTypeHandlerImpl;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.Property;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.currencies.CurrencyDTO;
import org.cyclos.model.banking.rates.ARateParametersDTO;
import org.cyclos.model.banking.rates.HasRates;
import org.cyclos.model.banking.rates.RateType;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.DateHelper;
import org.springframework.stereotype.Component;

@Component
public class ARateTypeHandlerImpl
extends TimeBasedRateTypeHandlerImpl<ARateParameters, ARateParametersDTO>
implements ARateTypeHandlerTestable {
    public void complete(RatesData ratesData) {
        if (ratesData.getEmissionDate() != null) {
            ratesData.setARate(this.convert(ratesData.getEmissionDate(), ratesData.getDate()));
        } else if (ratesData.getARate() != null) {
            ratesData.setEmissionDate(this.convert(ratesData.getARate(), ratesData.getDate()));
        }
    }

    public Date convert(BigDecimal bigDecimal, Date date) {
        if (bigDecimal == null) {
            return null;
        }
        Date date2 = date == null ? DateHelper.now() : date;
        return DateHelper.addDecimal((Date)date2, (TimeField)TimeField.DAYS, (double)bigDecimal.negate().doubleValue());
    }

    public void copy(HasRates hasRates, HasRates hasRates2) {
        if (hasRates != null && hasRates2 != null) {
            hasRates2.setARate(hasRates.getARate());
        }
    }

    public Date getNullSafeRawRate(RatedEntity ratedEntity, Currency currency, Date date) {
        if (ratedEntity == null || ratedEntity.getEmissionDate() == null) {
            return this.getInitValue(currency, date);
        }
        return ratedEntity.getEmissionDate();
    }

    public ARateParameters getRateParameters(Currency currency) {
        return currency.getaRateParameters();
    }

    public ARateParametersDTO getRateParametersDTO(CurrencyDTO currencyDTO) {
        return currencyDTO.getARateParameters();
    }

    public RateType getRateType() {
        return RateType.A;
    }

    public void setRate(HasRates hasRates, BigDecimal bigDecimal) {
        hasRates.setARate(bigDecimal);
    }

    public void setRawRate(RatedEntity ratedEntity, Date date) {
        ratedEntity.setEmissionDate(date);
    }

    @Override
    protected void assignEntityToCurrency(ARateParameters aRateParameters, Currency currency) {
        currency.setaRateParameters(aRateParameters);
    }

    @Override
    protected void assignValidator(Validator validator, Validator validator2) {
        BeanPropertyAccess beanPropertyAccess = new BeanPropertyAccess((Property)ARateParametersDTO.INIT_VALUE){

            public String getIdentifier() {
                return "A_INIT_VALUE";
            }
        };
        validator2.property((PropertyAccess)beanPropertyAccess, BankingKeys.Rates.A_INIT_VALUE).required().pastDate();
        validator.nested((PropertyAccess)new BeanPropertyAccess((Property)CurrencyDTO.A_RATE_PARAMETERS), validator2);
    }

    @Override
    protected BigDecimal calculateRateChange(BigDecimal bigDecimal, Date date, Date date2) {
        Date date3 = date2 == null ? DateHelper.now() : date2;
        BigDecimal bigDecimal2 = new BigDecimal(DateHelper.daysBetween((Date)date, (Date)date3));
        return bigDecimal.add(bigDecimal2);
    }

    @Override
    protected Path getAccountRatesFieldPath() {
        QAccountRates qAccountRates = QAccountRates.accountRates;
        return qAccountRates.emissionDate;
    }

    @Override
    protected ARateParameters getCurrentRateParameters(Currency currency) {
        return currency.getaRateParameters();
    }

    @Override
    protected Class<ARateParameters> getEntityClass() {
        return ARateParameters.class;
    }

    @Override
    protected List<ARateParameters> getParametersList() {
        QARateParameters qARateParameters = QARateParameters.aRateParameters;
        return this.from(new EntityPath[]{qARateParameters}).list((Expression)qARateParameters);
    }

    @Override
    protected QRateParameters getQuery() {
        return QARateParameters.aRateParameters._super._super;
    }

    @Override
    void applyTransferTypeDefaults(RatesData ratesData, TransferType transferType) {
    }
}

