/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.util.Collection;
import java.util.function.BooleanSupplier;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.AuthHandler;
import org.cyclos.impl.access.BasePermissionCheckImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.UserPermissionCheck;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionUserAccess;

public class UserPermissionCheckImpl
extends BasePermissionCheckImpl
implements UserPermissionCheck {
    private final User user;
    private final BasicUser basicUser;
    private Permission[] myPermissions;
    private BooleanSupplier myPermissionSupplier;
    private Permission[] userPermissions;

    public UserPermissionCheckImpl(boolean bl, AuthHandler authHandler, SessionData sessionData, BasicUser basicUser) {
        super(bl, authHandler, sessionData);
        if (basicUser == null) {
            throw new IllegalArgumentException("Null user passed to a permission check");
        }
        this.basicUser = basicUser;
        this.user = basicUser.getUser();
    }

    public boolean granted() {
        User user = this.sessionData.getLoggedUser();
        Permission[] permissionArray = null;
        if (user != null && user.getUser().equals((Object)this.user)) {
            if (this.myPermissions == null) {
                return this.myPermissionSupplier == null ? false : this.myPermissionSupplier.getAsBoolean();
            }
            if (this.myPermissions.length == 0) {
                return this.sessionData.getLoggedBasicUser().equals((Object)this.basicUser) || !this.sessionData.isRestrictedOperator();
            }
            permissionArray = this.myPermissions;
        } else {
            if (this.userPermissions == null) {
                return false;
            }
            if (this.userPermissions.length == 0) {
                return true;
            }
            block4: for (Permission permission : this.userPermissions) {
                PermissionUserAccess permissionUserAccess = permission.getUserAccess();
                switch (permissionUserAccess) {
                    case MANAGEMENT_ANY: 
                    case MANAGEMENT_MEMBER: {
                        if (this.sessionData.manages((BasicUser)this.user) && (permissionUserAccess != PermissionUserAccess.MANAGEMENT_MEMBER || this.user.isMember())) continue block4;
                        return false;
                    }
                    case RELATIONSHIP_ANY: 
                    case RELATIONSHIP_MEMBER: 
                    case MY_OR_RELATIONSHIP: {
                        if (this.sessionData.relatesTo((BasicUser)this.user) && (permissionUserAccess != PermissionUserAccess.MANAGEMENT_MEMBER && permissionUserAccess != PermissionUserAccess.MY_OR_RELATIONSHIP || this.user.isMember())) continue block4;
                        return false;
                    }
                    default: {
                        throw new IllegalStateException("Invalid user access on permission check");
                    }
                }
            }
            permissionArray = this.userPermissions;
        }
        return this.hasAnyPermission(permissionArray);
    }

    public UserPermissionCheck my(BooleanSupplier booleanSupplier) {
        if (this.myPermissions != null) {
            throw new IllegalStateException("The my permissions were already set. You must use only one of the my(...) methods");
        }
        this.myPermissionSupplier = booleanSupplier;
        return this;
    }

    public UserPermissionCheck my(Permission ... permissionArray) {
        if (this.myPermissionSupplier != null) {
            throw new IllegalStateException("A my boolean supplier was already set. You must use only one of the my(...) methods");
        }
        this.myPermissions = permissionArray;
        for (Permission permission : permissionArray) {
            PermissionUserAccess permissionUserAccess = permission.getUserAccess();
            if (permissionUserAccess == null || permissionUserAccess == PermissionUserAccess.MY || permissionUserAccess == PermissionUserAccess.MY_OR_RELATIONSHIP) continue;
            throw new IllegalArgumentException("Permission " + String.valueOf(permission) + " user as 'my' permission on user permission check, but it's user access is " + String.valueOf(permissionUserAccess));
        }
        return this;
    }

    public UserPermissionCheck user(Permission ... permissionArray) {
        this.userPermissions = permissionArray;
        for (Permission permission : permissionArray) {
            PermissionUserAccess permissionUserAccess = permission.getUserAccess();
            if (permissionUserAccess != PermissionUserAccess.NONE) continue;
            throw new IllegalArgumentException("Permission " + String.valueOf(permission) + " user as 'user' permission on user permission check, but it's user access is " + String.valueOf(permissionUserAccess));
        }
        return this;
    }

    public UserPermissionCheck value(Object object) {
        return (UserPermissionCheck)super.value(object);
    }

    public UserPermissionCheck values(Collection<?> collection) {
        return (UserPermissionCheck)super.values(collection);
    }
}

