/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.bastiaanjansen.otp.SecretGenerator;
import com.bastiaanjansen.otp.TOTP;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Date;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.access.OtpOwner;
import org.cyclos.entities.access.QTotpSecret;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.access.TotpSecret;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.FailedAction;
import org.cyclos.impl.access.FailedActionHandler;
import org.cyclos.impl.access.OtpHandler;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.TotpServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.InvalidTotpException;
import org.cyclos.model.access.passwords.OtpResult;
import org.cyclos.model.access.passwords.OtpType;
import org.cyclos.model.access.passwords.SendOtpParams;
import org.cyclos.model.access.totps.RemoveTotpSecretConfirmationField;
import org.cyclos.model.access.totps.RemoveTotpSecretParams;
import org.cyclos.model.access.totps.TotpSecretData;
import org.cyclos.model.access.totps.TotpSecretStatus;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.SendMedium;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TotpServiceImpl
extends BaseServiceImpl
implements TotpServiceLocal {
    private static final QTotpSecret $ = QTotpSecret.totpSecret;
    private static final int MAX_ATTEMPTS_TO_ACTIVATE_TOTP = 10;
    @Autowired
    private OtpHandler otpHandler;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private FailedActionHandler failedActionHandler;

    public void activate(@NotNull String string) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        if (basicUser == null) {
            throw new IllegalActionException("Must be logged-in to activate a TOTP");
        }
        TotpSecret totpSecret = basicUser.getTotpSecret();
        this.doCheck(totpSecret, TotpSecretStatus.PENDING, string);
        totpSecret.setActivationDate(new Date());
        Session session = sessionData.getSession();
        if (session != null && session.isPendingLoginConfirmation() && sessionData.getChannelAccessAccessor().getLoginConfirmation().isTotp()) {
            session.setPendingLoginConfirmation(false);
        }
    }

    public void check(BasicUser basicUser, String string) throws InvalidTotpException {
        try {
            this.doCheck(basicUser.getTotpSecret(), TotpSecretStatus.ACTIVE, string);
        }
        catch (InvalidTotpException invalidTotpException) {
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessAccessor(basicUser);
            Integer n = configurationAccessor.getInvalidTotpAttempts();
            if (n != null && n > 0) {
                boolean bl = this.failedActionHandler.recordAndBlockUserIfMaxReached(FailedAction.FAILED_TOTP, basicUser, n, UserAlertType.MAX_TOTP_ATTEMPTS_REACHED);
                invalidTotpException.setBlockedByTries(bl);
            }
            throw invalidTotpException;
        }
    }

    public TotpSecretData getData(BasicUserVO basicUserVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent(basicUserVO);
        boolean bl = this.configurationHandler.getAccessAccessor(basicUser).isTotpEnabled();
        if (!bl) {
            return null;
        }
        TotpSecret totpSecret = basicUser.getTotpSecret();
        TotpSecretStatus totpSecretStatus = this.getStatus(totpSecret);
        TotpSecretData totpSecretData = new TotpSecretData();
        totpSecretData.setUser((BasicUserVO)this.conversionHandler.convert(BasicUserVO.class, (Object)basicUser));
        totpSecretData.setStatus(totpSecretStatus);
        if (totpSecret != null) {
            totpSecretData.setActivationDate(this.conversionHandler.toDateTime(totpSecret.getActivationDate()));
        }
        totpSecretData.setCanRemove(totpSecretStatus != TotpSecretStatus.NEVER_CREATED);
        if (basicUser.equals((Object)this.getSessionData().getLoggedBasicUser())) {
            if (totpSecretStatus != TotpSecretStatus.ACTIVE) {
                totpSecretData.setCanActivate(true);
                totpSecretData.setSendVerificationCodeData(this.otpHandler.getSendOtpData());
            }
            if (totpSecretStatus == TotpSecretStatus.PENDING) {
                totpSecretData.setSecretUrl(this.url(totpSecret));
            }
            if (totpSecretData.isCanRemove()) {
                totpSecretData.setConfirmationCredentials(this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput());
            }
        }
        return totpSecretData;
    }

    public TotpSecretStatus getStatus(BasicUser basicUser) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessAccessor(basicUser);
        if (configurationAccessor.isTotpEnabled()) {
            return this.getStatus(basicUser.getTotpSecret());
        }
        return null;
    }

    public boolean isTotp(String string) {
        return string != null && string.startsWith("totp:");
    }

    public void remove(@NotNull RemoveTotpSecretParams removeTotpSecretParams) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent(removeTotpSecretParams.getUser());
        TotpSecretStatus totpSecretStatus = this.getStatus(basicUser);
        if (totpSecretStatus != TotpSecretStatus.ACTIVE && totpSecretStatus != TotpSecretStatus.PENDING) {
            throw new IllegalActionException("Cannot remove the TOTP secret with status " + String.valueOf(totpSecretStatus));
        }
        if (basicUser.equals((Object)this.getSessionData().getLoggedBasicUser())) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(removeTotpSecretParams.getConfirmationPassword(), RemoveTotpSecretConfirmationField.confirmation());
        }
        this.rawEntityManagerHandler.getEntityManager().remove((Object)basicUser.getTotpSecret());
        basicUser.setTotpSecret(null);
    }

    public OtpResult requestActivationCode(@NotNull SendOtpParams sendOtpParams) throws FrameworkException {
        BasicUser basicUser = this.ensureUsedAndNotActive();
        SendMedium sendMedium = sendOtpParams.getMedium();
        MobilePhone mobilePhone = sendMedium == SendMedium.SMS ? (MobilePhone)this.conversionHandler.convert(MobilePhone.class, (Object)sendOtpParams.getMobilePhone()) : null;
        return (OtpResult)this.conversionHandler.convert(OtpResult.class, (Object)this.otpHandler.sendForTotpActivation(basicUser, mobilePhone));
    }

    public String verifyActivationCode(@NotNull String string) throws FrameworkException {
        BasicUser basicUser = this.ensureUsedAndNotActive();
        try {
            boolean bl;
            this.otpHandler.verify(OtpType.TOTP_ACTIVATION, (OtpOwner)basicUser, string);
            TotpSecret totpSecret = basicUser.getTotpSecret();
            boolean bl2 = bl = totpSecret == null;
            if (bl) {
                totpSecret = new TotpSecret();
                totpSecret.setUser(basicUser);
            }
            totpSecret.setSecret(SecretGenerator.generate());
            if (bl) {
                this.rawEntityManagerHandler.getEntityManager().persist((Object)totpSecret);
            }
            return this.url(totpSecret);
        }
        catch (ValidationException validationException) {
            this.failedActionHandler.recordAndBlockUserIfMaxReached(FailedAction.FAILED_TOTP_ACTIVATION, this.getLoggedBasicUser(), Integer.valueOf(10), UserAlertType.MAX_TOTP_ACTIVATION_ATTEMPTS_REACHED);
            throw validationException;
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register($.user().network());
    }

    private void doCheck(TotpSecret totpSecret, TotpSecretStatus totpSecretStatus, String string) {
        boolean bl;
        boolean bl2 = bl = string != null && totpSecret != null && this.getStatus(totpSecret) == totpSecretStatus && this.totp(totpSecret.getSecret()).verify(string, 30);
        if (!bl) {
            throw new InvalidTotpException();
        }
    }

    private BasicUser ensureUsedAndNotActive() {
        BasicUser basicUser = this.getSessionData().getLoggedBasicUser();
        if (basicUser == null) {
            throw new IllegalActionException("Must be logged-in to activate a TOTP");
        }
        TotpSecretStatus totpSecretStatus = this.getStatus(basicUser);
        if (totpSecretStatus == null || totpSecretStatus == TotpSecretStatus.ACTIVE) {
            throw new IllegalActionException("Cannot request an activation code for a TOTP. Current status: " + String.valueOf(totpSecretStatus));
        }
        return basicUser;
    }

    private TotpSecretStatus getStatus(TotpSecret totpSecret) {
        if (totpSecret == null || totpSecret.getSecret() == null) {
            return TotpSecretStatus.NEVER_CREATED;
        }
        return totpSecret.getActivationDate() == null ? TotpSecretStatus.PENDING : TotpSecretStatus.ACTIVE;
    }

    private TOTP totp(byte[] byArray) {
        return ((TOTP.Builder)((TOTP.Builder)new TOTP.Builder(byArray).withPasswordLength(6)).withAlgorithm(ALGORITHM)).withPeriod(Duration.ofSeconds(30L)).build();
    }

    private String url(TotpSecret totpSecret) {
        BasicUser basicUser = totpSecret.getUser();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessAccessor(basicUser);
        try {
            String string = this.urlPart(configurationAccessor.getApplicationName());
            String string2 = this.urlPart(basicUser.getUsername());
            String string3 = this.totp(totpSecret.getSecret()).getURI(string, string2).toASCIIString();
            return string3.replace("%2520", "%20");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException("Error activating a TOTP", uRISyntaxException);
        }
    }

    private String urlPart(String string) {
        return URLEncoder.encode(string, StandardCharsets.UTF_8).replace("+", "%20").replace(":", "_");
    }
}

