/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import org.cyclos.entities.access.BuiltInPrincipalType;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.system.AccountNumberConfiguration;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.conversion.EntityVOConverter;
import org.cyclos.model.access.principaltypes.PrincipalTypeInputVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeNature;
import org.cyclos.model.users.phones.PhoneNature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PrincipalTypeInputVOConverter
extends EntityVOConverter<PrincipalTypeInputVO> {
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;

    public PrincipalTypeInputVOConverter() {
        super(PrincipalTypeInputVO.class);
    }

    @Override
    protected void fill(Object object, PrincipalTypeInputVO principalTypeInputVO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        PrincipalType principalType;
        if (object instanceof PrincipalType && (principalType = (PrincipalType)object).getNature() == PrincipalTypeNature.BUILT_IN) {
            BuiltInPrincipalType builtInPrincipalType = (BuiltInPrincipalType)principalType;
            ConfigurationAccessor configurationAccessor = this.getSessionData().getConfiguration();
            switch (builtInPrincipalType.getBuiltInType()) {
                case MOBILE_PHONE: {
                    principalTypeInputVO.setMobilePhoneExample(this.phoneNumberHandler.getExampleNumber(PhoneNature.MOBILE, configurationAccessor));
                    break;
                }
                case ACCOUNT_NUMBER: {
                    AccountNumberConfiguration accountNumberConfiguration = configurationAccessor.getAccountNumberConfiguration();
                    if (accountNumberConfiguration == null || !accountNumberConfiguration.isEnabled()) break;
                    principalTypeInputVO.setAccountNumberMask(accountNumberConfiguration.getMask());
                    break;
                }
            }
        }
        super.fill(object, principalTypeInputVO, objectArray, conversionContext);
    }
}

