/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.RecurringPayment;
import org.cyclos.entities.banking.RecurringPaymentOccurrence;
import org.cyclos.entities.banking.ScheduledPayment;
import org.cyclos.entities.banking.ScheduledPaymentInstallment;
import org.cyclos.entities.banking.Ticket;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.marketplace.Order;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.CustomWizard;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.DeviceConfirmation;
import org.cyclos.impl.access.DeviceConfirmationServiceLocal;
import org.cyclos.impl.access.FailedAction;
import org.cyclos.impl.access.FailedActionHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.TrustedDeviceServiceLocal;
import org.cyclos.impl.utils.BarcodeHandler;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.PushNotificationEventContext;
import org.cyclos.impl.utils.PushNotificationHandler;
import org.cyclos.impl.utils.SharedStorage;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.cluster.SharedStorageType;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.InvalidDeviceConfirmationException;
import org.cyclos.model.access.clients.AccessClientAction;
import org.cyclos.model.access.clients.AccessClientActionConfirmationField;
import org.cyclos.model.access.clients.AccessClientLocatorVO;
import org.cyclos.model.access.devices.ActivateTrustedDeviceConfirmationField;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.access.devices.DeviceConfirmationApprovalData;
import org.cyclos.model.access.devices.DeviceConfirmationBarcodeParams;
import org.cyclos.model.access.devices.DeviceConfirmationFeedbackPushNotificationData;
import org.cyclos.model.access.devices.DeviceConfirmationField;
import org.cyclos.model.access.devices.DeviceConfirmationType;
import org.cyclos.model.access.devices.DeviceConfirmationVO;
import org.cyclos.model.access.devices.InvalidDeviceConfirmationResult;
import org.cyclos.model.access.devices.TrustedDeviceAction;
import org.cyclos.model.access.devices.TrustedDeviceVO;
import org.cyclos.model.access.passwords.GenerateNewPasswordConfirmationField;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.ChangeAccountLimitsConfirmationField;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.authorizations.AuthorizationAction;
import org.cyclos.model.banking.transactions.ApproveTicketConfirmationField;
import org.cyclos.model.banking.transactions.ExternalPaymentAction;
import org.cyclos.model.banking.transactions.InstallmentVO;
import org.cyclos.model.banking.transactions.ManageExternalPaymentConfirmationField;
import org.cyclos.model.banking.transactions.ManagePaymentRequestConfirmationField;
import org.cyclos.model.banking.transactions.ManageRecurringPaymentConfirmationField;
import org.cyclos.model.banking.transactions.ManageRecurringPaymentFailedOccurrenceConfirmationField;
import org.cyclos.model.banking.transactions.ManageScheduledPaymentConfirmationField;
import org.cyclos.model.banking.transactions.ManageScheduledPaymentInstallmentConfirmationField;
import org.cyclos.model.banking.transactions.ManageTransactionAuthorizationConfirmationField;
import org.cyclos.model.banking.transactions.PaymentRequestAction;
import org.cyclos.model.banking.transactions.PerformExternalPaymentConfirmationField;
import org.cyclos.model.banking.transactions.PerformPaymentConfirmationField;
import org.cyclos.model.banking.transactions.RecurringPaymentAction;
import org.cyclos.model.banking.transactions.RecurringPaymentFailedOccurrenceAction;
import org.cyclos.model.banking.transactions.ScheduledPaymentAction;
import org.cyclos.model.banking.transactions.ScheduledPaymentInstallmentAction;
import org.cyclos.model.banking.transactions.TicketVO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transfers.ChargebackConfirmationField;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.vouchers.BuyVouchersConfirmationField;
import org.cyclos.model.banking.vouchers.GenerateVouchersConfirmationField;
import org.cyclos.model.banking.vouchers.ManageVoucherConfirmationField;
import org.cyclos.model.banking.vouchers.SendVoucherConfirmationField;
import org.cyclos.model.banking.vouchers.TopUpVoucherConfirmationField;
import org.cyclos.model.banking.vouchers.VoucherAction;
import org.cyclos.model.banking.vouchers.VoucherVO;
import org.cyclos.model.banking.vouchertypes.VoucherTypeVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.marketplace.webshoporders.AcceptOrderConfirmationField;
import org.cyclos.model.marketplace.webshoporders.OrderVO;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartCheckoutConfirmationField;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.system.images.ImageSize;
import org.cyclos.model.system.imports.ImportUserPaymentsConfirmationField;
import org.cyclos.model.system.imports.ImportUserSendVouchersConfirmationField;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.model.system.operations.CustomOperationVO;
import org.cyclos.model.system.operations.RunCustomOperationConfirmationField;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.system.wizards.RunCustomWizardConfirmationField;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.addresses.ManageAddressConfirmationField;
import org.cyclos.model.users.contactinfos.ManageContactInfoConfirmationField;
import org.cyclos.model.users.phones.ManagePhoneConfirmationField;
import org.cyclos.model.users.records.ManageRecordConfirmationField;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.PushNotificationEventType;
import org.cyclos.security.access.DeviceConfirmationServiceSecurity;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.MutableObject;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceConfirmationServiceImpl
extends BaseServiceImpl
implements DeviceConfirmationServiceLocal {
    private static int MAX_ATTEMPTS_TO_CHECK = 10;
    @Autowired
    private BarcodeHandler barcodeHandler;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private TrustedDeviceServiceLocal trustedDeviceService;
    @Autowired
    private FailedActionHandler failedActionHandler;
    @Autowired
    private PushNotificationHandler pushNotificationHandler;
    @Autowired
    private ClusterHandler clusterHandler;
    private SharedStorage<String, DeviceConfirmation> deviceConfirmations;
    @Autowired
    private DeviceConfirmationServiceSecurity deviceConfirmationServiceSecurity;

    public void approve(String string, long l, String string2) {
        Pair<DeviceConfirmation, TrustedDevice> pair = this.validateAction(string, l, string2, FilterType.PENDING_OR_APPROVED);
        DeviceConfirmation deviceConfirmation = (DeviceConfirmation)pair.getFirst();
        deviceConfirmation.setApproved(Boolean.valueOf(true));
        deviceConfirmation.setDeviceId(((TrustedDevice)pair.getSecond()).getId());
        this.updateStorage(deviceConfirmation);
        this.sendPushNotification(deviceConfirmation);
    }

    public SerializableInputStream barcode(DeviceConfirmationBarcodeParams deviceConfirmationBarcodeParams) {
        DeviceConfirmation deviceConfirmation = this.load(deviceConfirmationBarcodeParams.getConfirmationId(), FilterType.PENDING);
        return this.barcodeHandler.qrcode(deviceConfirmation.getQrContent(), (ImageSize)ObjectHelper.defaultValue((Object)deviceConfirmationBarcodeParams.getSize(), (Object)ImageSize.SMALL));
    }

    public TrustedDevice check(String string, CreateDeviceConfirmationParams createDeviceConfirmationParams) {
        DeviceConfirmation deviceConfirmation;
        BasicUser basicUser;
        InvalidDeviceConfirmationResult invalidDeviceConfirmationResult = null;
        Long l = null;
        MutableObject mutableObject = new MutableObject();
        try {
            basicUser = this.validate(createDeviceConfirmationParams, false);
            deviceConfirmation = this.load(string, FilterType.APPROVED);
            String string2 = this.generateQR(string, createDeviceConfirmationParams.getType(), (Map<DeviceConfirmationField, Object>)basicUser);
            if (!deviceConfirmation.getQrContent().equals(string2)) {
                throw new ValidationException();
            }
            l = deviceConfirmation.getDeviceId();
            mutableObject.set((Object)((DeviceConfirmationVO)this.conversionHandler.convert(DeviceConfirmationVO.class, (Object)deviceConfirmation)));
            this.remove(deviceConfirmation.getId());
        }
        catch (EntityNotFoundException | ValidationException throwable) {
            invalidDeviceConfirmationResult = InvalidDeviceConfirmationResult.INVALID_CONFIRMATION;
        }
        basicUser = DeviceConfirmationServiceLocal.getCreatorUserAttr((CreateDeviceConfirmationParams)createDeviceConfirmationParams);
        if (invalidDeviceConfirmationResult == null) {
            if (l != null) {
                deviceConfirmation = (TrustedDevice)this.rawEntityManagerHandler.find(TrustedDevice.class, l);
                this.failedActionHandler.clearUserFailures(FailedAction.FAILED_DEVICE_CONFIRMATION, basicUser);
                return deviceConfirmation;
            }
            throw new InvalidDeviceConfirmationException();
        }
        boolean bl = this.failedActionHandler.recordAndBlockUserIfMaxReached(FailedAction.FAILED_DEVICE_CONFIRMATION, basicUser, Integer.valueOf(MAX_ATTEMPTS_TO_CHECK), UserAlertType.MAX_DEVICE_CONFIRMATION_CHECK_ATTEMPTS_REACHED);
        throw new InvalidDeviceConfirmationException(bl ? InvalidDeviceConfirmationResult.MAX_CHECK_ATTEMPTS_REACHED : invalidDeviceConfirmationResult);
    }

    public DeviceConfirmationVO create(CreateDeviceConfirmationParams createDeviceConfirmationParams) {
        return this.create(createDeviceConfirmationParams, null, this.getLoggedBasicUser(), true);
    }

    public DeviceConfirmationVO create(CreateDeviceConfirmationParams createDeviceConfirmationParams, BasicUser basicUser, BasicUser basicUser2, boolean bl) {
        Map<DeviceConfirmationField, Object> map = this.validate(createDeviceConfirmationParams, bl);
        String string = UUID.randomUUID().toString();
        String string2 = this.generateQR(string, createDeviceConfirmationParams.getType(), map);
        DeviceConfirmation deviceConfirmation = new DeviceConfirmation(string, createDeviceConfirmationParams.getType(), SimpleEntity.id((SimpleEntity)basicUser2), SimpleEntity.id((SimpleEntity)basicUser), string2);
        this.updateStorage(deviceConfirmation);
        return (DeviceConfirmationVO)this.conversionHandler.convert(DeviceConfirmationVO.class, (Object)deviceConfirmation);
    }

    public DeviceConfirmation find(String string) {
        return this.load(string, null);
    }

    public DeviceConfirmationApprovalData getApprovalData(Long l) {
        SessionData sessionData = this.getSessionData();
        TrustedDevice trustedDevice = (TrustedDevice)this.rawEntityManagerHandler.find(TrustedDevice.class, l);
        ChannelConfiguration channelConfiguration = this.configurationHandler.getAccessAccessor(trustedDevice.getUser()).getChannelConfiguration(sessionData.getAccessChannel());
        DeviceConfirmationApprovalData deviceConfirmationApprovalData = new DeviceConfirmationApprovalData();
        deviceConfirmationApprovalData.setAllowGuest(!channelConfiguration.isRequireAuthenticationForDeviceConfirmation());
        return deviceConfirmationApprovalData;
    }

    public Map<MessageKey, Object> getQRFields(DeviceConfirmationType deviceConfirmationType, Map<DeviceConfirmationField, Object> map) {
        QRUtils qRUtils = QRUtils.instance(map);
        switch (deviceConfirmationType) {
            case ACCEPT_ORDER: {
                Order order = (Order)qRUtils.get((DeviceConfirmationField)AcceptOrderConfirmationField.ORDER);
                qRUtils.qrField(MarketplaceKeys.WebshopOrders.SELLER, order.getSeller()).qrField(MarketplaceKeys.WebshopOrders.NUMBER, order.getNumber()).qrField(MarketplaceKeys.WebshopOrders.PAYMENT_AMOUNT, order.getTotalAmount());
                break;
            }
            case EDIT_PROFILE: 
            case LOGIN: 
            case SECONDARY_LOGIN: 
            case IMPORT_PAYMENTS: 
            case PERSONALIZE_NFC_TAG: {
                break;
            }
            case MANAGE_TRUSTED_DEVICE: {
                qRUtils.qrFieldFrom(GeneralKeys.Ui.NAME, (DeviceConfirmationField)ActivateTrustedDeviceConfirmationField.DEVICE).qrFieldFrom(AccessKeys.Devices.ACTION, (DeviceConfirmationField)ActivateTrustedDeviceConfirmationField.ACTION);
                break;
            }
            case ACCESS_CLIENT_ACTION: {
                qRUtils.qrFieldFrom(GeneralKeys.Ui.NAME, (DeviceConfirmationField)AccessClientActionConfirmationField.CLIENT).qrFieldFrom(AccessKeys.Clients.ACTION, (DeviceConfirmationField)AccessClientActionConfirmationField.ACTION);
                break;
            }
            case MANAGE_ADDRESS: {
                qRUtils.qrFieldFrom(GeneralKeys.Ui.NAME, (DeviceConfirmationField)ManageAddressConfirmationField.NAME);
                break;
            }
            case MANAGE_AUTHORIZATION: {
                BasePayment basePayment = (BasePayment)qRUtils.get((DeviceConfirmationField)ManageTransactionAuthorizationConfirmationField.PAYMENT);
                qRUtils.qrField(BankingKeys.Accounts.FROM, basePayment.getFromOwner()).qrField(BankingKeys.Accounts.TO, basePayment.getToOwner()).qrField(BankingKeys.Transactions.AMOUNT, basePayment.getCurrencyAmount()).qrFieldFrom(BankingKeys.Transactions.ACTION, (DeviceConfirmationField)ManageTransactionAuthorizationConfirmationField.ACTION);
                break;
            }
            case MANAGE_CONTACT_INFO: {
                qRUtils.qrFieldFrom(GeneralKeys.Ui.NAME, (DeviceConfirmationField)ManageContactInfoConfirmationField.NAME);
                break;
            }
            case MANAGE_EXTERNAL_PAYMENT: {
                ExternalPayment externalPayment = (ExternalPayment)qRUtils.get((DeviceConfirmationField)ManageExternalPaymentConfirmationField.PAYMENT);
                qRUtils.qrField(BankingKeys.Accounts.FROM, externalPayment.getFromOwner()).qrField(BankingKeys.Accounts.TO, externalPayment.getToPrincipalValue()).qrField(BankingKeys.Transactions.AMOUNT, externalPayment.getCurrencyAmount()).qrFieldFrom(BankingKeys.Transactions.ACTION, (DeviceConfirmationField)ManageExternalPaymentConfirmationField.ACTION);
                break;
            }
            case MANAGE_PAYMENT_REQUEST: {
                PaymentRequest paymentRequest = (PaymentRequest)qRUtils.get((DeviceConfirmationField)ManagePaymentRequestConfirmationField.PAYMENT_REQUEST);
                qRUtils.qrField(BankingKeys.Accounts.FROM, paymentRequest.getFromOwner()).qrField(BankingKeys.Accounts.TO, paymentRequest.getToOwner()).qrField(BankingKeys.Transactions.AMOUNT, paymentRequest.getCurrencyAmount()).qrFieldFrom(BankingKeys.Transactions.ACTION, (DeviceConfirmationField)ManagePaymentRequestConfirmationField.ACTION);
                break;
            }
            case MANAGE_PHONE: {
                qRUtils.qrFieldFrom(GeneralKeys.Ui.NAME, (DeviceConfirmationField)ManagePhoneConfirmationField.NAME);
                break;
            }
            case MANAGE_RECORD: {
                qRUtils.qrFieldFrom(UsersKeys.Records.TYPE, (DeviceConfirmationField)ManageRecordConfirmationField.TYPE);
                break;
            }
            case MANAGE_SCHEDULED_PAYMENT: {
                ScheduledPayment scheduledPayment = (ScheduledPayment)qRUtils.get((DeviceConfirmationField)ManageScheduledPaymentConfirmationField.PAYMENT);
                qRUtils.qrField(BankingKeys.Accounts.FROM, scheduledPayment.getFromOwner()).qrField(BankingKeys.Accounts.TO, scheduledPayment.getToOwner()).qrField(BankingKeys.Transactions.AMOUNT, scheduledPayment.getCurrencyAmount()).qrFieldFrom(BankingKeys.Transactions.ACTION, (DeviceConfirmationField)ManageScheduledPaymentConfirmationField.ACTION);
                break;
            }
            case MANAGE_RECURRING_PAYMENT: {
                RecurringPayment recurringPayment = (RecurringPayment)qRUtils.get((DeviceConfirmationField)ManageRecurringPaymentConfirmationField.PAYMENT);
                qRUtils.qrField(BankingKeys.Accounts.FROM, recurringPayment.getFromOwner()).qrField(BankingKeys.Accounts.TO, recurringPayment.getToOwner()).qrField(BankingKeys.Transactions.AMOUNT, recurringPayment.getCurrencyAmount()).qrFieldFrom(BankingKeys.Transactions.ACTION, (DeviceConfirmationField)ManageRecurringPaymentConfirmationField.ACTION);
                break;
            }
            case MANAGE_SCHEDULED_PAYMENT_INSTALLMENT: {
                ScheduledPaymentInstallment scheduledPaymentInstallment = (ScheduledPaymentInstallment)qRUtils.get((DeviceConfirmationField)ManageScheduledPaymentInstallmentConfirmationField.INSTALLMENT);
                qRUtils.qrField(BankingKeys.Transactions.INSTALLMENT_NUMBER, scheduledPaymentInstallment.getNumber()).qrField(BankingKeys.Transactions.AMOUNT, scheduledPaymentInstallment.getCurrencyAmount()).qrFieldFrom(BankingKeys.Transactions.ACTION, (DeviceConfirmationField)ManageScheduledPaymentInstallmentConfirmationField.ACTION);
                break;
            }
            case MANAGE_RECURRING_PAYMENT_FAILED_OCCURRENCE: {
                RecurringPaymentOccurrence recurringPaymentOccurrence = (RecurringPaymentOccurrence)qRUtils.get((DeviceConfirmationField)ManageRecurringPaymentFailedOccurrenceConfirmationField.OCCURRENCE);
                qRUtils.qrField(BankingKeys.Transactions.INSTALLMENT_NUMBER, recurringPaymentOccurrence.getNumber()).qrField(BankingKeys.Transactions.AMOUNT, recurringPaymentOccurrence.getCurrencyAmount()).qrFieldFrom(BankingKeys.Transactions.ACTION, (DeviceConfirmationField)ManageRecurringPaymentFailedOccurrenceConfirmationField.ACTION);
                break;
            }
            case PERFORM_EXTERNAL_PAYMENT: {
                qRUtils.qrFieldFrom(BankingKeys.Accounts.FROM, (DeviceConfirmationField)PerformExternalPaymentConfirmationField.FROM).qrFieldFrom(BankingKeys.Accounts.TO, (DeviceConfirmationField)PerformExternalPaymentConfirmationField.TO).qrFieldFrom(BankingKeys.Transactions.AMOUNT, (DeviceConfirmationField)PerformExternalPaymentConfirmationField.AMOUNT);
                break;
            }
            case PERFORM_PAYMENT: {
                qRUtils.qrFieldFrom(BankingKeys.Accounts.FROM, (DeviceConfirmationField)PerformPaymentConfirmationField.FROM).qrFieldFrom(BankingKeys.Accounts.TO, (DeviceConfirmationField)PerformPaymentConfirmationField.TO).qrFieldFrom(BankingKeys.Transactions.AMOUNT, (DeviceConfirmationField)PerformPaymentConfirmationField.AMOUNT);
                break;
            }
            case RUN_CUSTOM_OPERATION: {
                qRUtils.qrFieldFrom(GeneralKeys.Ui.NAME, (DeviceConfirmationField)RunCustomOperationConfirmationField.OPERATION);
                break;
            }
            case RUN_CUSTOM_WIZARD: {
                qRUtils.qrFieldFrom(GeneralKeys.Ui.NAME, (DeviceConfirmationField)RunCustomWizardConfirmationField.WIZARD);
                break;
            }
            case SHOPPING_CART_CHECKOUT: {
                qRUtils.qrFieldFrom(MarketplaceKeys.WebshopOrders.SELLER, (DeviceConfirmationField)ShoppingCartCheckoutConfirmationField.SELLER).qrFieldFrom(MarketplaceKeys.WebshopOrders.PAYMENT_AMOUNT, (DeviceConfirmationField)ShoppingCartCheckoutConfirmationField.AMOUNT);
                break;
            }
            case MANAGE_VOUCHER: {
                Voucher voucher = (Voucher)qRUtils.get((DeviceConfirmationField)ManageVoucherConfirmationField.VOUCHER);
                qRUtils.qrField(BankingKeys.Vouchers.AMOUNT, voucher.getCurrencyAmount()).qrFieldFrom(BankingKeys.Transactions.ACTION, (DeviceConfirmationField)ManageVoucherConfirmationField.ACTION);
                break;
            }
            case GENERATE_VOUCHERS: {
                qRUtils.qrFieldFrom(BankingKeys.Vouchers.TYPE, (DeviceConfirmationField)GenerateVouchersConfirmationField.TYPE).qrFieldFrom(BankingKeys.Vouchers.CREATE_COUNT, (DeviceConfirmationField)GenerateVouchersConfirmationField.COUNT).qrFieldFrom(BankingKeys.Vouchers.CREATE_AMOUNT, (DeviceConfirmationField)GenerateVouchersConfirmationField.AMOUNT);
                break;
            }
            case BUY_VOUCHERS: {
                VoucherType voucherType = (VoucherType)qRUtils.get((DeviceConfirmationField)BuyVouchersConfirmationField.TYPE);
                qRUtils.qrField(BankingKeys.Vouchers.TYPE, voucherType.getVoucherTitle()).qrFieldFrom(BankingKeys.Vouchers.CREATE_COUNT, (DeviceConfirmationField)BuyVouchersConfirmationField.COUNT).qrFieldFrom(BankingKeys.Vouchers.CREATE_AMOUNT, (DeviceConfirmationField)BuyVouchersConfirmationField.AMOUNT);
                break;
            }
            case TOP_UP_VOUCHER: {
                VoucherType voucherType = (VoucherType)qRUtils.get((DeviceConfirmationField)TopUpVoucherConfirmationField.TYPE);
                qRUtils.qrField(BankingKeys.Vouchers.TYPE, voucherType.getVoucherTitle()).qrFieldFrom(BankingKeys.Vouchers.TRANSACTION_AMOUNT, (DeviceConfirmationField)TopUpVoucherConfirmationField.AMOUNT);
                break;
            }
            case SEND_VOUCHER: {
                VoucherType voucherType = (VoucherType)qRUtils.get((DeviceConfirmationField)SendVoucherConfirmationField.TYPE);
                qRUtils.qrField(BankingKeys.Vouchers.TYPE, voucherType.getVoucherTitle()).qrFieldFrom(BankingKeys.Vouchers.EMAIL, (DeviceConfirmationField)SendVoucherConfirmationField.EMAIL).qrFieldFrom(BankingKeys.Vouchers.AMOUNT, (DeviceConfirmationField)SendVoucherConfirmationField.AMOUNT);
                break;
            }
            case CHARGEBACK: {
                Transfer transfer = (Transfer)qRUtils.get((DeviceConfirmationField)ChargebackConfirmationField.TRANSFER);
                qRUtils.qrField(BankingKeys.Accounts.FROM, transfer.getFromOwner()).qrField(BankingKeys.Accounts.TO, transfer.getToOwner()).qrField(BankingKeys.Transactions.AMOUNT, transfer.getCurrencyAmount());
                break;
            }
            case CHANGE_ACCOUNT_LIMITS: {
                UserAccount userAccount = (UserAccount)qRUtils.get((DeviceConfirmationField)ChangeAccountLimitsConfirmationField.ACCOUNT);
                qRUtils.qrField(BankingKeys.Accounts.LIMIT_USER, userAccount.getUser()).qrField(BankingKeys.Accounts.TYPE, userAccount.getType());
                break;
            }
            case GENERATE_NEW_PASSWORD: {
                qRUtils.qrFieldFrom(AccessKeys.Passwords.TYPE, (DeviceConfirmationField)GenerateNewPasswordConfirmationField.TYPE);
                break;
            }
            case IMPORT_USER_PAYMENTS: {
                qRUtils.qrFieldFrom(BankingKeys.Transactions.TYPE, (DeviceConfirmationField)ImportUserPaymentsConfirmationField.TYPE);
                break;
            }
            case IMPORT_USER_SEND_VOUCHERS: {
                qRUtils.qrFieldFrom(BankingKeys.Vouchers.TYPE, (DeviceConfirmationField)ImportUserSendVouchersConfirmationField.TYPE);
                break;
            }
            case APPROVE_TICKET: {
                Ticket ticket = (Ticket)qRUtils.get((DeviceConfirmationField)ApproveTicketConfirmationField.TICKET);
                qRUtils.qrField(BankingKeys.Transactions.RECEIVER, ticket.getToOwner()).qrField(BankingKeys.Transactions.AMOUNT, ticket.getCurrencyAmount());
                break;
            }
        }
        return qRUtils.result;
    }

    @PostConstruct
    public void initialize() {
        this.deviceConfirmations = this.clusterHandler.getSharedStorage(SharedStorageType.DEVICE_CONFIRMATIONS);
    }

    public DeviceConfirmationVO load(String string) {
        return (DeviceConfirmationVO)this.conversionHandler.convert(DeviceConfirmationVO.class, (Object)this.find(string));
    }

    public void registerFeedback(String string) {
        DeviceConfirmation deviceConfirmation;
        try {
            deviceConfirmation = this.load(string, FilterType.APPROVED);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            return;
        }
        Consumer<Boolean> consumer = bl -> this.pushNotificationHandler.publish(PushNotificationEventContext.deviceConfirmationFeedback((Long)deviceConfirmation.getUserId(), (String)deviceConfirmation.getId()), null, () -> {
            DeviceConfirmationFeedbackPushNotificationData deviceConfirmationFeedbackPushNotificationData = new DeviceConfirmationFeedbackPushNotificationData();
            deviceConfirmationFeedbackPushNotificationData.setSuccessful(bl.booleanValue());
            deviceConfirmationFeedbackPushNotificationData.setDeviceConfirmation((DeviceConfirmationVO)this.conversionHandler.convert(DeviceConfirmationVO.class, (Object)deviceConfirmation));
            return deviceConfirmationFeedbackPushNotificationData;
        });
        InvocationContext invocationContext = InvocationContext.ensure();
        invocationContext.addTransactionEndListener(false, consumer::accept);
    }

    public void reject(String string, long l, String string2) {
        Pair<DeviceConfirmation, TrustedDevice> pair = this.validateAction(string, l, string2, FilterType.PENDING_OR_REJECTED);
        DeviceConfirmation deviceConfirmation = (DeviceConfirmation)pair.getFirst();
        deviceConfirmation.setApproved(Boolean.valueOf(false));
        this.removeFromStorage(string);
        this.sendPushNotification(deviceConfirmation);
    }

    public void remove(String string) {
        this.removeFromStorage(string);
    }

    public TrustedDevice validate(String string, long l, String string2) {
        Pair<DeviceConfirmation, TrustedDevice> pair = this.validateAction(string, l, string2, FilterType.PENDING);
        this.remove(string);
        return (TrustedDevice)pair.getSecond();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private String escape(String string) {
        return StringUtils.replaceEach((String)string, (String[])new String[]{"", ""}, (String[])new String[]{"\\:", "\\|"});
    }

    private String generateQR(String string, DeviceConfirmationType deviceConfirmationType, Map<DeviceConfirmationField, Object> map) {
        Locale locale = LocaleHelper.mapLocale((BuiltinLanguage)this.getConfiguration().getLanguage().getTemplate());
        String string2 = StringHelper.encodeURIComponent((String)this.message(deviceConfirmationType.getMessageKey(), new Object[0]));
        List list = this.getQRFields(deviceConfirmationType, map).entrySet().stream().map(entry -> this.escape(this.message((MessageKey)entry.getKey(), new Object[0])) + ":" + this.escape(this.getFormatter().format(entry.getValue()))).collect(Collectors.toList());
        String string3 = StringHelper.encodeURIComponent((String)StringUtils.join(list, (String)"|"));
        Object object = "confirm?id=%s&op=%s&lang=%s";
        if (StringHelper.isNotBlank((Object)string3)) {
            object = (String)object + "&fields=%s";
        }
        String string4 = String.format((String)object, string, string2, locale, string3);
        return this.linkGeneratorHandler.mobile(string4);
    }

    private Currency getCurrency(Object object) {
        if (object instanceof Currency) {
            return (Currency)object;
        }
        if (object instanceof HasCurrency) {
            return ((HasCurrency)object).getCurrency();
        }
        return null;
    }

    private DeviceConfirmation load(String string, FilterType filterType) throws EntityNotFoundException {
        if ((string = StringHelper.trimToNull((Object)StringHelper.removeStart((String)string, (String)"confirmation:"))) == null) {
            throw new EntityNotFoundException(DeviceConfirmation.class);
        }
        DeviceConfirmation deviceConfirmation = (DeviceConfirmation)this.deviceConfirmations.get((Object)string);
        if (deviceConfirmation != null && !this.deviceConfirmationServiceSecurity.isVisible(deviceConfirmation)) {
            deviceConfirmation = null;
        }
        if (deviceConfirmation != null && filterType != null) {
            switch (filterType.ordinal()) {
                case 0: {
                    break;
                }
                case 2: {
                    if (Boolean.TRUE.equals(deviceConfirmation.getApproved())) break;
                    deviceConfirmation = null;
                    break;
                }
                case 3: {
                    if (!Boolean.TRUE.equals(deviceConfirmation.getApproved())) break;
                    deviceConfirmation = null;
                    break;
                }
                case 1: {
                    if (deviceConfirmation.getApproved() == null) break;
                    deviceConfirmation = null;
                    break;
                }
                case 4: {
                    if (!Boolean.FALSE.equals(deviceConfirmation.getApproved())) break;
                    deviceConfirmation = null;
                    break;
                }
                case 5: {
                    if (!Boolean.TRUE.equals(deviceConfirmation.getApproved())) break;
                    deviceConfirmation = null;
                }
            }
        }
        if (deviceConfirmation == null) {
            throw new EntityNotFoundException(DeviceConfirmation.class, string);
        }
        return deviceConfirmation;
    }

    private void parse(DeviceConfirmationField deviceConfirmationField, Map<String, String> map, Map<DeviceConfirmationField, Object> map2, boolean bl) {
        if (map2.containsKey(deviceConfirmationField)) {
            return;
        }
        String string = map.get(deviceConfirmationField.inputFieldName());
        boolean bl2 = false;
        switch (deviceConfirmationField.type()) {
            case ACCOUNT_OWNER: {
                InternalAccountOwner internalAccountOwner = ModelHelper.accountOwner((String)string);
                if (internalAccountOwner instanceof UserLocatorVO) {
                    internalAccountOwner = (InternalAccountOwner)this.conversionHandler.convert(BasicUser.class, (Object)this.unmaskVO((UserLocatorVO)internalAccountOwner, bl));
                }
                map2.put(deviceConfirmationField, internalAccountOwner);
                bl2 = true;
                break;
            }
            case CURRENCY_AMOUNT: {
                DeviceConfirmationField deviceConfirmationField2 = deviceConfirmationField.dependOn()[0];
                this.parse(deviceConfirmationField2, map, map2, bl);
                Currency currency = this.getCurrency(map2.get(deviceConfirmationField2));
                CurrencyAmount currencyAmount = new CurrencyAmount();
                currencyAmount.setAmount(new BigDecimal(string));
                currencyAmount.setCurrency(currency);
                map2.put(deviceConfirmationField, currencyAmount);
                bl2 = true;
                break;
            }
            case PAYMENT_TYPE: {
                TransferTypeVO transferTypeVO = (TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)string);
                map2.put(deviceConfirmationField, this.conversionHandler.convert(PaymentTransferType.class, (Object)this.unmaskVO(transferTypeVO, bl)));
                bl2 = true;
                break;
            }
            case ACCESS_CLIENT: {
                AccessClientLocatorVO accessClientLocatorVO = (AccessClientLocatorVO)ModelHelper.voFromString(AccessClientLocatorVO.class, (String)string);
                map2.put(deviceConfirmationField, this.conversionHandler.convert(AccessClient.class, (Object)this.unmaskVO(accessClientLocatorVO, bl)));
                bl2 = true;
                break;
            }
            case CUSTOM_OPERATION: {
                CustomOperationVO customOperationVO = (CustomOperationVO)ModelHelper.voFromString(CustomOperationVO.class, (String)string);
                map2.put(deviceConfirmationField, this.conversionHandler.convert(CustomOperation.class, (Object)this.unmaskVO(customOperationVO, bl)));
                bl2 = true;
                break;
            }
            case CUSTOM_WIZARD: {
                CustomWizardVO customWizardVO = (CustomWizardVO)ModelHelper.voFromString(CustomWizardVO.class, (String)string);
                map2.put(deviceConfirmationField, this.conversionHandler.convert(CustomWizard.class, (Object)this.unmaskVO(customWizardVO, bl)));
                bl2 = true;
                break;
            }
            case PASSWORD_TYPE: {
                PasswordTypeVO passwordTypeVO = (PasswordTypeVO)ModelHelper.voFromString(PasswordTypeVO.class, (String)string);
                map2.put(deviceConfirmationField, this.conversionHandler.convert(PasswordType.class, (Object)this.unmaskVO(passwordTypeVO, bl)));
                bl2 = true;
                break;
            }
            case TRANSACTION: {
                map2.put(deviceConfirmationField, this.conversionHandler.convert(Transaction.class, (Object)this.unmaskVO((TransactionVO)ModelHelper.voFromString(TransactionVO.class, (String)string), bl)));
                bl2 = true;
                break;
            }
            case TICKET: {
                map2.put(deviceConfirmationField, this.conversionHandler.convert(Ticket.class, (Object)this.unmaskVO((TicketVO)ModelHelper.voFromString(TicketVO.class, (String)string), bl)));
                bl2 = true;
                break;
            }
            case TRANSFER: {
                map2.put(deviceConfirmationField, this.conversionHandler.convert(Transfer.class, (Object)this.unmaskVO((TransferVO)ModelHelper.voFromString(TransferVO.class, (String)string), bl)));
                bl2 = true;
                break;
            }
            case INSTALLMENT: {
                map2.put(deviceConfirmationField, this.conversionHandler.convert(ScheduledPaymentInstallment.class, (Object)this.unmaskVO((InstallmentVO)ModelHelper.voFromString(InstallmentVO.class, (String)string), bl)));
                bl2 = true;
                break;
            }
            case OCCURRENCE: {
                map2.put(deviceConfirmationField, this.conversionHandler.convert(RecurringPaymentOccurrence.class, (Object)this.unmaskVO((InstallmentVO)ModelHelper.voFromString(InstallmentVO.class, (String)string), bl)));
                bl2 = true;
                break;
            }
            case ACCESS_CLIENT_ACTION: {
                map2.put(deviceConfirmationField, AccessClientAction.valueOf((String)string));
                bl2 = true;
                break;
            }
            case EXTERNAL_PAYMENT_ACTION: {
                map2.put(deviceConfirmationField, ExternalPaymentAction.valueOf((String)string));
                bl2 = true;
                break;
            }
            case SCHEDULED_PAYMENT_ACTION: {
                map2.put(deviceConfirmationField, ScheduledPaymentAction.valueOf((String)string));
                bl2 = true;
                break;
            }
            case RECURRING_PAYMENT_ACTION: {
                map2.put(deviceConfirmationField, RecurringPaymentAction.valueOf((String)string));
                bl2 = true;
                break;
            }
            case PAYMENT_REQUEST_ACTION: {
                map2.put(deviceConfirmationField, PaymentRequestAction.valueOf((String)string));
                bl2 = true;
                break;
            }
            case RECURRING_PAYMENT_FAILED_OCCURRENCE_ACTION: {
                map2.put(deviceConfirmationField, RecurringPaymentFailedOccurrenceAction.valueOf((String)string));
                bl2 = true;
                break;
            }
            case SCHEDULED_PAYMENT_INSTALLMENT_ACTION: {
                map2.put(deviceConfirmationField, ScheduledPaymentInstallmentAction.valueOf((String)string));
                bl2 = true;
                break;
            }
            case AUTHORIZATION_ACTION: {
                AuthorizationAction authorizationAction = AuthorizationAction.valueOf((String)string);
                map2.put(deviceConfirmationField, this.message(authorizationAction.resolveMessageKeyForAction(), new Object[0]));
                bl2 = true;
                break;
            }
            case STRING: {
                map2.put(deviceConfirmationField, string);
                bl2 = true;
                break;
            }
            case INTEGER: {
                map2.put(deviceConfirmationField, Integer.parseInt(string));
                bl2 = true;
                break;
            }
            case ORDER: {
                map2.put(deviceConfirmationField, this.conversionHandler.convert(Order.class, (Object)this.unmaskVO((OrderVO)ModelHelper.voFromString(OrderVO.class, (String)string), bl)));
                bl2 = true;
                break;
            }
            case RECORD_TYPE: {
                RecordTypeVO recordTypeVO = (RecordTypeVO)ModelHelper.voFromString(RecordTypeVO.class, (String)string);
                map2.put(deviceConfirmationField, this.conversionHandler.convert(RecordType.class, (Object)this.unmaskVO(recordTypeVO, bl)));
                bl2 = true;
                break;
            }
            case VOUCHER: {
                map2.put(deviceConfirmationField, this.conversionHandler.convert(Voucher.class, (Object)this.unmaskVO((VoucherVO)ModelHelper.voFromString(VoucherVO.class, (String)string), bl)));
                bl2 = true;
                break;
            }
            case VOUCHER_ACTION: {
                map2.put(deviceConfirmationField, VoucherAction.valueOf((String)string));
                bl2 = true;
                break;
            }
            case VOUCHER_TYPE: {
                VoucherTypeVO voucherTypeVO = (VoucherTypeVO)ModelHelper.voFromString(VoucherTypeVO.class, (String)string);
                map2.put(deviceConfirmationField, this.conversionHandler.convert(VoucherType.class, (Object)this.unmaskVO(voucherTypeVO, bl)));
                bl2 = true;
                break;
            }
            case USER_ACCOUNT: {
                AccountVO accountVO = (AccountVO)ModelHelper.voFromString(AccountVO.class, (String)string);
                map2.put(deviceConfirmationField, this.conversionHandler.convert(UserAccount.class, (Object)this.unmaskVO(accountVO, bl)));
                bl2 = true;
                break;
            }
            case TRUSTED_DEVICE: {
                map2.put(deviceConfirmationField, this.conversionHandler.convert(TrustedDevice.class, (Object)this.unmaskVO((TrustedDeviceVO)ModelHelper.voFromString(TrustedDeviceVO.class, (String)string), bl)));
                bl2 = true;
                break;
            }
            case TRUSTED_DEVICE_ACTION: {
                map2.put(deviceConfirmationField, TrustedDeviceAction.valueOf((String)string));
                bl2 = true;
            }
        }
        if (!bl2) {
            throw new IllegalArgumentException("Invalid field: " + String.valueOf(deviceConfirmationField));
        }
    }

    private void removeFromStorage(String string) {
        InvocationContext.get().addCommitListener(false, () -> this.deviceConfirmations.remove((Object)string));
    }

    private void sendPushNotification(DeviceConfirmation deviceConfirmation) {
        Long l = (Long)ObjectHelper.coalesce((Object[])new Long[]{deviceConfirmation.getCreatorId(), deviceConfirmation.getUserId()});
        if (l != null) {
            this.pushNotificationHandler.publish(PushNotificationEventContext.user((PushNotificationEventType)PushNotificationEventType.DEVICE_CONFIRMATION, (Long)l), null, () -> (DeviceConfirmationVO)this.conversionHandler.convert(DeviceConfirmationVO.class, (Object)deviceConfirmation));
        }
    }

    private <T extends EntityVO> T unmaskVO(T t, boolean bl) {
        if (bl) {
            if (t.getId() != null) {
                t.setId(this.applicationHandler.getIdMask().remove(t.getId()));
            }
            t.properties().forEach(property -> {
                Object object = t.get(property);
                if (object instanceof EntityVO) {
                    t.set(property, (Object)this.unmaskVO((EntityVO)object, bl));
                }
            });
        }
        return t;
    }

    private void updateStorage(DeviceConfirmation deviceConfirmation) {
        InvocationContext.ensure().addTransactionEndListener(false, bl -> this.deviceConfirmations.set((Object)deviceConfirmation.getId(), (Object)deviceConfirmation));
    }

    private Map<DeviceConfirmationField, Object> validate(CreateDeviceConfirmationParams createDeviceConfirmationParams, boolean bl) {
        DeviceConfirmationType deviceConfirmationType = createDeviceConfirmationParams == null ? null : createDeviceConfirmationParams.getType();
        Map map = createDeviceConfirmationParams == null || createDeviceConfirmationParams.getFields() == null ? Collections.emptyMap() : createDeviceConfirmationParams.getFields();
        Validator validator = new Validator();
        validator.property((Property)CreateDeviceConfirmationParams.TYPE, AccessKeys.Devices.CONFIRMATION_TYPE).required();
        if (deviceConfirmationType != null) {
            validator.property((Property)CreateDeviceConfirmationParams.FIELDS, AccessKeys.Devices.CONFIRMATION_FIELDS).add((object, object2, object3) -> {
                if (deviceConfirmationType.fields().length != map.size() || Stream.of(deviceConfirmationType.fields()).anyMatch(deviceConfirmationField -> map.get(deviceConfirmationField.inputFieldName()) == null)) {
                    return ValidationErrors.invalid();
                }
                return null;
            });
        }
        this.validate(validator, createDeviceConfirmationParams, "createDeviceConfirmationParams");
        HashMap<DeviceConfirmationField, Object> hashMap = new HashMap<DeviceConfirmationField, Object>();
        map.entrySet().forEach(entry -> this.parse(createDeviceConfirmationParams.getType().findFieldByInputFieldName((String)entry.getKey()), map, hashMap, bl));
        return hashMap;
    }

    private Pair<DeviceConfirmation, TrustedDevice> validateAction(String string, long l, String string2, FilterType filterType) {
        InvalidDeviceConfirmationResult invalidDeviceConfirmationResult = null;
        try {
            DeviceConfirmation deviceConfirmation = this.load(string, filterType);
            TrustedDevice trustedDevice = this.trustedDeviceService.loadForOperate(l);
            if (deviceConfirmation.getUserId() != null && !deviceConfirmation.getUserId().equals(trustedDevice.getBasicUser().getId())) {
                throw new EntityNotFoundException(DeviceConfirmation.class);
            }
            this.validateHMAC(deviceConfirmation, trustedDevice, string2);
            return Pair.create((Object)deviceConfirmation, (Object)trustedDevice);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            invalidDeviceConfirmationResult = TrustedDevice.class.getSimpleName().equals(entityNotFoundException.getEntityType()) ? InvalidDeviceConfirmationResult.INVALID_DEVICE : InvalidDeviceConfirmationResult.INVALID_CONFIRMATION;
        }
        catch (ValidationException validationException) {
            invalidDeviceConfirmationResult = InvalidDeviceConfirmationResult.INVALID_CONFIRMATION;
        }
        throw new InvalidDeviceConfirmationException(invalidDeviceConfirmationResult);
    }

    private void validateHMAC(DeviceConfirmation deviceConfirmation, TrustedDevice trustedDevice, String string) {
        String string2 = null;
        try {
            String string3 = "HmacSHA256";
            SecretKeySpec secretKeySpec = new SecretKeySpec(trustedDevice.getKey().getBytes("UTF-8"), string3);
            Mac mac = Mac.getInstance(string3);
            mac.init(secretKeySpec);
            byte[] byArray = mac.doFinal(deviceConfirmation.getQrContent().getBytes("ASCII"));
            string2 = Hex.encodeHexString((byte[])byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (string2 == null || !string2.equals(string)) {
            throw new InvalidDeviceConfirmationException(InvalidDeviceConfirmationResult.INVALID_CONFIRMATION);
        }
    }

    private static enum FilterType {
        NONE,
        PENDING,
        APPROVED,
        REJECTED,
        PENDING_OR_APPROVED,
        PENDING_OR_REJECTED;

    }

    private static class QRUtils {
        private Map<DeviceConfirmationField, Object> canonicalValues;
        private Map<MessageKey, Object> result;

        static QRUtils instance(Map<DeviceConfirmationField, Object> map) {
            return new QRUtils(map);
        }

        QRUtils(Map<DeviceConfirmationField, Object> map) {
            this.canonicalValues = map;
            this.result = new LinkedHashMap<MessageKey, Object>();
        }

        public <T> T get(DeviceConfirmationField deviceConfirmationField) {
            return (T)this.canonicalValues.get(deviceConfirmationField);
        }

        public QRUtils qrField(MessageKey messageKey, Object object) {
            this.result.put(messageKey, object);
            return this;
        }

        public QRUtils qrFieldFrom(MessageKey messageKey, DeviceConfirmationField deviceConfirmationField) {
            this.result.put(messageKey, this.get(deviceConfirmationField));
            return this;
        }
    }
}

