/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.util.Collection;
import java.util.Collections;
import org.cyclos.impl.access.AuthHandler;
import org.cyclos.impl.access.PermissionCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.utils.CollectionHelper;

public abstract class BasePermissionCheckImpl
implements PermissionCheck {
    private Collection<?> values;
    private final boolean optionalValue;
    protected final AuthHandler authHandler;
    protected final SessionData sessionData;

    public BasePermissionCheckImpl(boolean bl, AuthHandler authHandler, SessionData sessionData) {
        this.optionalValue = bl;
        this.authHandler = authHandler;
        this.sessionData = sessionData;
    }

    public void check() throws PermissionDeniedException {
        if (!this.granted()) {
            throw new PermissionDeniedException();
        }
    }

    public PermissionCheck value(Object object) {
        if (!this.optionalValue && object == null) {
            throw new IllegalArgumentException("Null value passed to a permission check");
        }
        this.values = object == null ? null : Collections.singleton(object);
        return this;
    }

    public PermissionCheck values(Collection<?> collection) {
        if (!this.optionalValue) {
            if (CollectionHelper.isEmpty(collection)) {
                throw new IllegalArgumentException("Empty values passed to a permission check");
            }
            for (Object obj : collection) {
                if (obj != null) continue;
                throw new IllegalArgumentException("Null value passed to a permission check");
            }
        }
        this.values = collection;
        return this;
    }

    protected boolean hasAnyPermission(Permission ... permissionArray) {
        if (permissionArray != null) {
            for (Permission permission : permissionArray) {
                if (!this.hasPermission(permission)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasPermission(Permission permission) {
        boolean bl;
        boolean bl2 = bl = this.authHandler.requiresValues(permission) && (this.optionalValue && CollectionHelper.isNotEmpty(this.values) || !this.optionalValue);
        if (bl) {
            if (!this.optionalValue && CollectionHelper.isEmpty(this.values)) {
                throw new IllegalArgumentException("No value passed when checking permission " + String.valueOf(permission));
            }
            for (Object obj : this.values) {
                if (this.sessionData.hasRequiredValue(permission, obj)) continue;
                return false;
            }
        }
        return this.sessionData.hasPermission(permission);
    }
}

